/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Segment;

public class MSegmentCache {
    private static MSegmentCache sharedCache = new MSegmentCache();
    private List<Segment> segments = new ArrayList<Segment>(11);

    public static MSegmentCache getSharedInstance() {
        return sharedCache;
    }

    public static Segment getSharedSegment() {
        return MSegmentCache.getSharedInstance().getSegment();
    }

    public static void releaseSharedSegment(Segment segment) {
        MSegmentCache.getSharedInstance().releaseSegment(segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Segment getSegment() {
        MSegmentCache mSegmentCache = this;
        synchronized (mSegmentCache) {
            int size = this.segments.size();
            if (size > 0) {
                return this.segments.remove(size - 1);
            }
        }
        return new CachedSegment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSegment(Segment segment) {
        if (segment instanceof CachedSegment) {
            MSegmentCache mSegmentCache = this;
            synchronized (mSegmentCache) {
                segment.array = null;
                segment.count = 0;
                this.segments.add(segment);
            }
        }
    }

    private static class CachedSegment
    extends Segment {
        private CachedSegment() {
        }
    }
}

