/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text;

import com.mongol.swing.plaf.MRotation;
import com.mongol.swing.text.MEditorBoxView;
import com.mongol.swing.text.MLabelView;
import com.mongol.swing.text.MParagraphView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class MStyledEditorKit
extends StyledEditorKit
implements MRotation {
    private int rotate_direction = 0;
    private int rotate_hint = 0;

    public MStyledEditorKit() {
    }

    public MStyledEditorKit(int direction, int hint) {
        this.rotate_direction = direction;
        this.rotate_hint = hint;
    }

    @Override
    public ViewFactory getViewFactory() {
        return new StyledViewFactory();
    }

    @Override
    public void setRotateHint(int hint) {
        this.rotate_hint = hint;
    }

    @Override
    public int getRotateHint() {
        return this.rotate_hint;
    }

    @Override
    public void setRotateDirection(int direction) {
        this.rotate_direction = direction;
    }

    @Override
    public int getRotateDirection() {
        return this.rotate_direction;
    }

    class StyledViewFactory
    implements ViewFactory {
        StyledViewFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new MLabelView(elem, MStyledEditorKit.this.rotate_direction, MStyledEditorKit.this.rotate_hint);
                }
                if (kind.equals("paragraph")) {
                    return new MParagraphView(elem, MStyledEditorKit.this.rotate_direction, MStyledEditorKit.this.rotate_hint);
                }
                if (kind.equals("section")) {
                    return new MEditorBoxView(elem, MStyledEditorKit.this.rotate_direction, MStyledEditorKit.this.rotate_hint);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new MLabelView(elem);
        }
    }
}

