/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text;

import com.mongol.encode.MongolianConverter;
import com.mongol.encode.MongolianFontUtil;
import com.mongol.swing.MSwingUtilities;
import com.mongol.swing.text.MGlyphView;
import com.mongol.swing.text.MSegmentCache;
import com.mongol.swing.text.MWrappedPlainView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.CompositeView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;
import javax.swing.text.View;

public class MUtilities {
    static final int SPACE_ADDON = 0;
    static final int SPACE_ADDON_LEFTOVER_END = 1;
    static final int START_JUSTIFIABLE = 2;
    static final int END_JUSTIFIABLE = 3;
    private static final String sepStr = "\u3001\u3002\uff0c";
    private static final String smallStr = "\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u30a1\u30a3\u30a5\u30a7\u30a9\u30f5\u30f6\u30c3\u30e3\u30e5\u30e7";
    private static final String dangleStr = "\u3005\u30fd\u30fe\u309d\u309e\uff01\uff1f";
    private static final String rotateStr0 = "\uff1d\u2260\u2266\u2267\u2208\u220b\u2286\u2287\u2282\u2283\u222a\u2229\u2190\u2191\u2192\u2193";
    private static final String rotateStr1 = "\uff1e\u226b\u300d\u30fc\u2212\u300f\uff5d\uff09\u300b\u3011\u3015\uff3d\u3009\uff5c\u2015\u301c\uff5e\u2026\u2025\uff1a";
    private static final String rotateStr2 = "\uff1c\u226a\u300c\u300e\uff5b\uff08\u300a\u3010\u3014\uff3b\u3008";
    private static final String rotateStr3 = "1234567890^\\qwertyuiop@asdfghjklzxcvbnm #$%|QWERTYUIOPASDFGHJKLZXCVBNM_\uff87\uff8c\uff71\uff73\uff74\uff75\uff94\uff95\uff96\uff9c\uff8e\uff8d\uff80\uff83\uff72\uff7d\uff76\uff9d\uff85\uff86\uff97\uff7e\uff81\uff84\uff7c\uff8a\uff77\uff78\uff8f\uff89\uff98\uff9a\uff79\uff91\uff82\uff7b\uff7f\uff8b\uff7a\uff90\uff93\uff88\uff99\uff92\uff9b\uff66";
    private static final String rotateStr4 = "-;:],./)!\"&=+*}>?\uff9e\uff9f\uff69\uff6a\uff6b\uff6c\uff6d\uff6e\uff63\uff68\uff6f\uff61\uff64\uff65";
    private static final String rotateStr5 = "(['`~{<\uff62";

    public static JComponent getJComponent(View view) {
        Container component;
        if (view != null && (component = view.getContainer()) instanceof JComponent) {
            return (JComponent)component;
        }
        return null;
    }

    public static final int drawTabbedText(Segment s, int x, int y, Graphics g, TabExpander e, int startOffset) {
        return MUtilities.drawTabbedText(null, s, x, y, g, e, startOffset);
    }

    protected static final int drawTabbedText(View view, Segment s, int x, int y, Graphics g, TabExpander e, int startOffset) {
        return MUtilities.drawTabbedText(view, s, x, y, g, e, startOffset, null);
    }

    public static final int drawTabbedText(View view, Segment s, int x, int y, Graphics g, TabExpander e, int startOffset, int[] justificationData) {
        MWrappedPlainView plainView;
        JComponent component = MUtilities.getJComponent(view);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font font = g.getFont();
        Font alternative_font = MongolianFontUtil.getAltFont(font, "TextField.font");
        if (!MongolianFontUtil.isMongolianFont(font)) {
            Font tmpfont = font;
            font = alternative_font;
            alternative_font = tmpfont;
        }
        FontMetrics defaultMetrics = component.getFontMetrics(alternative_font);
        boolean rotate_vertical = false;
        Font rotated_font = alternative_font;
        if (view instanceof MWrappedPlainView && (plainView = (MWrappedPlainView)view).getRotateDirection() != 0) {
            rotate_vertical = true;
            AffineTransform transform = alternative_font.getTransform();
            transform.rotate(-1.5707963267948966);
            rotated_font = alternative_font.deriveFont(transform);
        }
        FontMetrics metrics = component.getFontMetrics(font);
        int nextX = x;
        MongolianConverter converter = new MongolianConverter();
        int start = s.offset;
        int count = s.count;
        String target = converter.convert(new String(s.array, start, count));
        if (start < s.offset) {
            target = target.substring(s.offset - start);
        }
        char[] txt = target.toCharArray();
        int txtOffset = 0;
        int flushLen = 0;
        int flushIndex = 0;
        int spaceAddon = 0;
        int spaceAddonLeftoverEnd = -1;
        int startJustifiableContent = 0;
        int endJustifiableContent = 0;
        if (justificationData != null) {
            int offset = -startOffset + txtOffset;
            View parent = null;
            if (view != null && (parent = view.getParent()) != null) {
                offset += parent.getStartOffset();
            }
            spaceAddon = justificationData[0];
            spaceAddonLeftoverEnd = justificationData[1] + offset;
            startJustifiableContent = justificationData[2] + offset;
            endJustifiableContent = justificationData[3] + offset;
        }
        int n = s.count;
        boolean candisplay = true;
        int i = 0;
        while (i < n && i < txt.length) {
            int dx;
            int dy;
            int k;
            if (txt[i] == '\t' || (spaceAddon != 0 || i <= spaceAddonLeftoverEnd) && txt[i] == ' ' && startJustifiableContent <= i && i <= endJustifiableContent) {
                if (flushLen > 0) {
                    if (candisplay) {
                        nextX = MSwingUtilities.drawCharsWithFont(component, g, font, txt, flushIndex, flushLen, x, y);
                    } else if (!rotate_vertical) {
                        nextX = MSwingUtilities.drawCharsWithFont(component, g, alternative_font, txt, flushIndex, flushLen, x, y - 3);
                    } else {
                        k = 0;
                        while (k < flushLen) {
                            x += alternative_font.getSize();
                            dy = (alternative_font.getSize() - defaultMetrics.charsWidth(txt, flushIndex + k, 1)) / 2;
                            dx = 2 - MUtilities.getDownIntend(txt[flushIndex + k]) * alternative_font.getSize() / 6;
                            dy += MUtilities.getRightIntend(txt[flushIndex + k]) * alternative_font.getSize() / 6;
                            if (MUtilities.isRotated(txt[flushIndex + k])) {
                                nextX = MSwingUtilities.drawCharsWithFont(component, g, rotated_font, txt, flushIndex + k, 1, x - dx, y - dy);
                                nextX = x;
                            } else {
                                nextX = MSwingUtilities.drawCharsWithFont(component, g, alternative_font, txt, flushIndex + k, 1, x, y - 3);
                            }
                            ++k;
                        }
                    }
                    flushLen = 0;
                }
                flushIndex = i + 1;
                if (txt[i] == '\t') {
                    nextX = e != null ? (int)e.nextTabStop(nextX, startOffset + i - txtOffset) : (nextX += metrics.charWidth(' '));
                } else if (txt[i] == ' ') {
                    nextX += metrics.charWidth(' ') + spaceAddon;
                    if (i <= spaceAddonLeftoverEnd) {
                        // empty if block
                    }
                }
                x = ++nextX;
            } else if (txt[i] == '\n' || txt[i] == '\r') {
                if (flushLen > 0) {
                    if (candisplay) {
                        nextX = MSwingUtilities.drawCharsWithFont(component, g, font, txt, flushIndex, flushLen, x, y);
                    } else if (!rotate_vertical) {
                        nextX = MSwingUtilities.drawCharsWithFont(component, g, alternative_font, txt, flushIndex, flushLen, x, y - 3);
                    } else {
                        k = 0;
                        while (k < flushLen) {
                            x += alternative_font.getSize();
                            dy = (alternative_font.getSize() - defaultMetrics.charsWidth(txt, flushIndex + k, 1)) / 2;
                            dx = 2 - MUtilities.getDownIntend(txt[flushIndex + k]) * alternative_font.getSize() / 6;
                            dy += MUtilities.getRightIntend(txt[flushIndex + k]) * alternative_font.getSize() / 12;
                            if (MUtilities.isRotated(txt[flushIndex + k])) {
                                nextX = MSwingUtilities.drawCharsWithFont(component, g, rotated_font, txt, flushIndex + k, 1, x - dx, y - dy);
                                nextX = x;
                            } else {
                                nextX = MSwingUtilities.drawCharsWithFont(component, g, alternative_font, txt, flushIndex + k, 1, x, y - 3);
                            }
                            ++k;
                        }
                    }
                    flushLen = 0;
                }
                flushIndex = i + 1;
                x = nextX;
            } else if (candisplay) {
                if (!font.canDisplay(txt[i])) {
                    if (flushLen > 0) {
                        nextX = MSwingUtilities.drawCharsWithFont(component, g, font, txt, flushIndex, flushLen, x, y);
                        flushLen = 0;
                    }
                    flushIndex = i;
                    x = nextX;
                    candisplay = false;
                    ++flushLen;
                } else {
                    ++flushLen;
                }
            } else {
                if (flushLen > 0) {
                    if (!rotate_vertical) {
                        nextX = MSwingUtilities.drawCharsWithFont(component, g, alternative_font, txt, flushIndex, flushLen, x, y - 3);
                    } else {
                        k = 0;
                        while (k < flushLen) {
                            x += alternative_font.getSize();
                            dy = (alternative_font.getSize() - defaultMetrics.charsWidth(txt, flushIndex + k, 1)) / 2;
                            dx = 2 - MUtilities.getDownIntend(txt[flushIndex + k]) * alternative_font.getSize() / 6;
                            dy += MUtilities.getRightIntend(txt[flushIndex + k]) * alternative_font.getSize() / 12;
                            if (MUtilities.isRotated(txt[flushIndex + k])) {
                                nextX = MSwingUtilities.drawCharsWithFont(component, g, rotated_font, txt, flushIndex + k, 1, x - dx, y - dy);
                                nextX = x;
                            } else {
                                nextX = MSwingUtilities.drawCharsWithFont(component, g, alternative_font, txt, flushIndex + k, 1, x, y - 3);
                            }
                            ++k;
                        }
                    }
                    flushLen = 0;
                }
                if (font.canDisplay(txt[i])) {
                    candisplay = true;
                }
                flushIndex = i;
                x = nextX;
                ++flushLen;
            }
            ++i;
        }
        if (flushLen > 0) {
            if (candisplay) {
                nextX = MSwingUtilities.drawCharsWithFont(component, g, font, txt, flushIndex, flushLen, x, y);
            } else if (!rotate_vertical) {
                nextX = MSwingUtilities.drawCharsWithFont(component, g, alternative_font, txt, flushIndex, flushLen, x, y - 3);
            } else {
                int k = 0;
                while (k < flushLen) {
                    x += alternative_font.getSize();
                    int dy = (alternative_font.getSize() - defaultMetrics.charsWidth(txt, flushIndex + k, 1)) / 2;
                    int dx = 2 - MUtilities.getDownIntend(txt[flushIndex + k]) * alternative_font.getSize() / 6;
                    dy += MUtilities.getRightIntend(txt[flushIndex + k]) * alternative_font.getSize() / 12;
                    if (MUtilities.isRotated(txt[flushIndex + k])) {
                        nextX = MSwingUtilities.drawCharsWithFont(component, g, rotated_font, txt, flushIndex + k, 1, x - dx, y - dy);
                        nextX = x;
                    } else {
                        nextX = MSwingUtilities.drawCharsWithFont(component, g, alternative_font, txt, flushIndex + k, 1, x, y - 3);
                    }
                    ++k;
                }
            }
        }
        return nextX;
    }

    public static final int getTabbedTextWidth(Segment s, FontMetrics metrics, int x, TabExpander e, int startOffset) {
        return MUtilities.getTabbedTextWidth(null, s, metrics, null, x, e, startOffset, null);
    }

    public static final int getTabbedTextWidth(Segment s, FontMetrics metrics, FontMetrics defaultmetrics, int x, TabExpander e, int startOffset) {
        return MUtilities.getTabbedTextWidth(null, s, metrics, defaultmetrics, x, e, startOffset, null);
    }

    public static final int getTabbedTextWidth(View view, Segment s, FontMetrics metrics, FontMetrics defaultmetrics, int x, TabExpander e, int startOffset, int[] justificationData) {
        MWrappedPlainView plainView;
        int nextX = x;
        Font font = metrics.getFont();
        if (defaultmetrics == null) {
            defaultmetrics = metrics;
        }
        boolean rotate_vertical = false;
        if (view instanceof MWrappedPlainView && (plainView = (MWrappedPlainView)view).getRotateDirection() != 0) {
            rotate_vertical = true;
        }
        MongolianConverter converter = new MongolianConverter();
        int start = s.offset;
        int count = s.count;
        String target = converter.convert(new String(s.array, start, count));
        if (start < s.offset) {
            target = target.substring(s.offset - start);
        }
        char[] txt = target.toCharArray();
        int txtOffset = 0;
        int n = s.count;
        int charCount = 0;
        int spaceAddon = 0;
        int spaceAddonLeftoverEnd = -1;
        int startJustifiableContent = 0;
        int endJustifiableContent = 0;
        if (justificationData != null) {
            int offset = -startOffset + txtOffset;
            View parent = null;
            if (view != null && (parent = view.getParent()) != null) {
                offset += parent.getStartOffset();
            }
            spaceAddon = justificationData[0];
            spaceAddonLeftoverEnd = justificationData[1] + offset;
            startJustifiableContent = justificationData[2] + offset;
            endJustifiableContent = justificationData[3] + offset;
        }
        boolean candisplay = true;
        int i = 0;
        while (i < n && i < txt.length) {
            int k;
            if (txt[i] == '\t' || (spaceAddon != 0 || i <= spaceAddonLeftoverEnd) && txt[i] == ' ' && startJustifiableContent <= i && i <= endJustifiableContent) {
                if (candisplay) {
                    nextX += metrics.charsWidth(txt, i - charCount, charCount);
                } else if (!rotate_vertical) {
                    nextX += defaultmetrics.charsWidth(txt, i - charCount, charCount);
                } else {
                    k = 0;
                    while (k < charCount) {
                        nextX = MUtilities.isRotated(txt[i - charCount + k]) ? (nextX += defaultmetrics.getFont().getSize()) : (nextX += defaultmetrics.charsWidth(txt, i - charCount + k, 1));
                        ++k;
                    }
                }
                charCount = 0;
                if (txt[i] == '\t') {
                    nextX = e != null ? (int)e.nextTabStop(nextX, startOffset + i - txtOffset) : (nextX += metrics.charWidth(' '));
                } else if (txt[i] == ' ') {
                    nextX += metrics.charWidth(' ') + spaceAddon;
                    if (i <= spaceAddonLeftoverEnd) {
                        ++nextX;
                    }
                }
            } else if (txt[i] == '\n') {
                if (candisplay) {
                    nextX += metrics.charsWidth(txt, i - charCount, charCount);
                } else if (!rotate_vertical) {
                    nextX += defaultmetrics.charsWidth(txt, i - charCount, charCount);
                } else {
                    k = 0;
                    while (k < charCount) {
                        nextX = MUtilities.isRotated(txt[i - charCount + k]) ? (nextX += defaultmetrics.getFont().getSize()) : (nextX += defaultmetrics.charsWidth(txt, i - charCount + k, 1));
                        ++k;
                    }
                }
                charCount = 0;
            } else if (candisplay) {
                if (!font.canDisplay(txt[i])) {
                    nextX += metrics.charsWidth(txt, i - charCount, charCount);
                    charCount = 0;
                    candisplay = false;
                }
                ++charCount;
            } else {
                if (font.canDisplay(txt[i])) {
                    if (!rotate_vertical) {
                        nextX += defaultmetrics.charsWidth(txt, i - charCount, charCount);
                    } else {
                        k = 0;
                        while (k < charCount) {
                            nextX = MUtilities.isRotated(txt[i - charCount + k]) ? (nextX += defaultmetrics.getFont().getSize()) : (nextX += defaultmetrics.charsWidth(txt, i - charCount + k, 1));
                            ++k;
                        }
                    }
                    charCount = 0;
                    candisplay = true;
                }
                ++charCount;
            }
            ++i;
        }
        if (candisplay) {
            nextX += metrics.charsWidth(txt, n - charCount, charCount);
        } else if (!rotate_vertical) {
            nextX += defaultmetrics.charsWidth(txt, n - charCount, charCount);
        } else {
            int k = 0;
            while (k < charCount) {
                nextX = MUtilities.isRotated(txt[n - charCount + k]) ? (nextX += defaultmetrics.getFont().getSize()) : (nextX += defaultmetrics.charsWidth(txt, n - charCount + k, 1));
                ++k;
            }
        }
        return nextX - x;
    }

    public static final int getTabbedTextOffset(Segment s, FontMetrics metrics, int x0, int x, TabExpander e, int startOffset) {
        return MUtilities.getTabbedTextOffset(s, metrics, null, x0, x, e, startOffset);
    }

    public static final int getTabbedTextOffset(Segment s, FontMetrics metrics, FontMetrics defaultmetrics, int x0, int x, TabExpander e, int startOffset) {
        return MUtilities.getTabbedTextOffset(s, metrics, defaultmetrics, x0, x, e, startOffset, true);
    }

    public static final int getTabbedTextOffset(View view, Segment s, FontMetrics metrics, FontMetrics defaultmetrics, int x0, int x, TabExpander e, int startOffset, int[] justificationData) {
        return MUtilities.getTabbedTextOffset(view, s, metrics, defaultmetrics, x0, x, e, startOffset, true, justificationData);
    }

    public static final int getTabbedTextOffset(Segment s, FontMetrics metrics, FontMetrics defaultmetrics, int x0, int x, TabExpander e, int startOffset, boolean round) {
        return MUtilities.getTabbedTextOffset(null, s, metrics, defaultmetrics, x0, x, e, startOffset, round, null);
    }

    public static final int getTabbedTextOffset(View view, Segment s, FontMetrics metrics, FontMetrics defaultmetrics, int x0, int x, TabExpander e, int startOffset, boolean round, int[] justificationData) {
        MWrappedPlainView plainView;
        if (x0 >= x) {
            return 0;
        }
        int nextX = x0;
        Font font = metrics.getFont();
        if (defaultmetrics == null) {
            defaultmetrics = metrics;
        }
        boolean rotate_vertical = false;
        if (view instanceof MWrappedPlainView && (plainView = (MWrappedPlainView)view).getRotateDirection() != 0) {
            rotate_vertical = true;
        }
        MongolianConverter converter = new MongolianConverter();
        int start = s.offset;
        int count = s.count;
        String target = converter.convert(new String(s.array, start, count));
        if (start < s.offset) {
            target = target.substring(s.offset - start);
        }
        char[] txt = target.toCharArray();
        int txtOffset = 0;
        int txtCount = s.count;
        int spaceAddon = 0;
        int spaceAddonLeftoverEnd = -1;
        int startJustifiableContent = 0;
        int endJustifiableContent = 0;
        if (justificationData != null) {
            int offset = -startOffset + txtOffset;
            View parent = null;
            if (view != null && (parent = view.getParent()) != null) {
                offset += parent.getStartOffset();
            }
            spaceAddon = justificationData[0];
            spaceAddonLeftoverEnd = justificationData[1] + offset;
            startJustifiableContent = justificationData[2] + offset;
            endJustifiableContent = justificationData[3] + offset;
        }
        int n = s.count;
        int i = 0;
        while (i < n && i < txt.length) {
            if (txt[i] == '\t' || (spaceAddon != 0 || i <= spaceAddonLeftoverEnd) && txt[i] == ' ' && startJustifiableContent <= i && i <= endJustifiableContent) {
                if (txt[i] == '\t') {
                    nextX = e != null ? (int)e.nextTabStop(nextX, startOffset + i - txtOffset) : (nextX += metrics.charWidth(' '));
                } else if (txt[i] == ' ') {
                    nextX += metrics.charWidth(' ') + spaceAddon;
                    if (i <= spaceAddonLeftoverEnd) {
                        ++nextX;
                    }
                }
            } else {
                nextX = font.canDisplay(txt[i]) ? (nextX += metrics.charWidth(txt[i])) : (!rotate_vertical ? (nextX += defaultmetrics.charWidth(txt[i])) : (MUtilities.isRotated(txt[i]) ? (nextX += defaultmetrics.getFont().getSize()) : (nextX += defaultmetrics.charWidth(txt[i]))));
            }
            if (x < nextX) {
                int offset;
                if (round) {
                    int span = x - x0;
                    offset = i + 1 - txtOffset;
                    int width = metrics.charsWidth(txt, txtOffset, offset);
                    if (span < width) {
                        while (offset > 0) {
                            int nextWidth;
                            int n2 = nextWidth = offset > 1 ? metrics.charsWidth(txt, txtOffset, offset - 1) : 0;
                            if (span >= nextWidth) {
                                if (span - nextWidth >= width - span) break;
                                --offset;
                                break;
                            }
                            width = nextWidth;
                            --offset;
                        }
                    }
                } else {
                    offset = i - txtOffset;
                    while (offset > 0 && metrics.charsWidth(txt, txtOffset, offset) > x - x0) {
                        --offset;
                    }
                }
                return offset;
            }
            ++i;
        }
        return txtCount;
    }

    public static final int getBreakLocation(Segment s, FontMetrics metrics, FontMetrics defaultmetrics, int x0, int x, TabExpander e, int startOffset) {
        char[] txt = s.array;
        int txtOffset = s.offset;
        int txtCount = s.count;
        int index = MUtilities.getTabbedTextOffset(s, metrics, defaultmetrics, x0, x, e, startOffset, false);
        if (index >= txtCount - 1) {
            return txtCount;
        }
        int i = txtOffset + index;
        while (i >= txtOffset) {
            char ch = txt[i];
            if (ch < '\u0100') {
                if (Character.isWhitespace(ch)) {
                    index = i - txtOffset + 1;
                    break;
                }
            } else if ((ch < '\u1800' || ch > '\u18aa') && ch != '\u202f') {
                BreakIterator bit = BreakIterator.getLineInstance();
                bit.setText(s);
                int breakPos = bit.preceding(i + 1);
                if (breakPos <= txtOffset) break;
                index = breakPos - txtOffset;
                break;
            }
            --i;
        }
        return index;
    }

    public static final int getRowStart(JTextComponent c, int offs) throws BadLocationException {
        Rectangle r = c.modelToView(offs);
        if (r == null) {
            return -1;
        }
        int lastOffs = offs;
        int y = r.y;
        while (r != null && y == r.y) {
            if (r.height != 0) {
                offs = lastOffs;
            }
            Rectangle rectangle = r = --lastOffs >= 0 ? c.modelToView(lastOffs) : null;
        }
        return offs;
    }

    public static final int getRowStartL2R(JTextComponent c, int offs) throws BadLocationException {
        Rectangle r = c.modelToView(offs);
        if (r == null) {
            return -1;
        }
        int lastOffs = offs;
        int x = r.x;
        while (r != null && x == r.x) {
            if (r.height != 0) {
                offs = lastOffs;
            }
            Rectangle rectangle = r = --lastOffs >= 0 ? c.modelToView(lastOffs) : null;
        }
        return offs;
    }

    public static final int getRowStartR2L(JTextComponent c, int offs) throws BadLocationException {
        Rectangle r = c.modelToView(offs);
        if (r == null) {
            return -1;
        }
        int lastOffs = offs;
        int x = r.x;
        while (r != null && x == r.x) {
            if (r.height != 0) {
                offs = lastOffs;
            }
            Rectangle rectangle = r = --lastOffs >= 0 ? c.modelToView(lastOffs) : null;
        }
        return offs;
    }

    public static final int getRowEnd(JTextComponent c, int offs) throws BadLocationException {
        Rectangle r = c.modelToView(offs);
        if (r == null) {
            return -1;
        }
        int n = c.getDocument().getLength();
        int lastOffs = offs;
        int y = r.y;
        while (r != null && y == r.y) {
            if (r.height != 0) {
                offs = lastOffs;
            }
            Rectangle rectangle = r = ++lastOffs <= n ? c.modelToView(lastOffs) : null;
        }
        return offs;
    }

    public static final int getRowEndL2R(JTextComponent c, int offs) throws BadLocationException {
        Rectangle r = c.modelToView(offs);
        if (r == null) {
            return -1;
        }
        int n = c.getDocument().getLength();
        int lastOffs = offs;
        int x = r.x;
        while (r != null && x == r.x) {
            if (r.height != 0) {
                offs = lastOffs;
            }
            Rectangle rectangle = r = ++lastOffs <= n ? c.modelToView(lastOffs) : null;
        }
        return offs;
    }

    public static final int getRowEndR2L(JTextComponent c, int offs) throws BadLocationException {
        Rectangle r = c.modelToView(offs);
        if (r == null) {
            return -1;
        }
        int n = c.getDocument().getLength();
        int lastOffs = offs;
        int x = r.x;
        while (r != null && x == r.x) {
            if (r.height != 0) {
                offs = lastOffs;
            }
            Rectangle rectangle = r = ++lastOffs <= n ? c.modelToView(lastOffs) : null;
        }
        return offs;
    }

    public static final int getPositionAbove(JTextComponent c, int offs, int x) throws BadLocationException {
        int lastOffs = MUtilities.getRowStart(c, offs) - 1;
        if (lastOffs < 0) {
            return -1;
        }
        int bestSpan = Integer.MAX_VALUE;
        int y = 0;
        Rectangle r = null;
        if (lastOffs >= 0) {
            r = c.modelToView(lastOffs);
            y = r.y;
        }
        while (r != null && y == r.y) {
            int span = Math.abs(r.x - x);
            if (span < bestSpan) {
                offs = lastOffs;
                bestSpan = span;
            }
            Rectangle rectangle = r = --lastOffs >= 0 ? c.modelToView(lastOffs) : null;
        }
        return offs;
    }

    public static final int getPositionAboveL2R(JTextComponent c, int offs, int y) throws BadLocationException {
        int lastOffs = MUtilities.getRowStartL2R(c, offs) - 1;
        if (lastOffs < 0) {
            return -1;
        }
        int bestSpan = Integer.MAX_VALUE;
        int x = 0;
        Rectangle r = null;
        if (lastOffs >= 0) {
            r = c.modelToView(lastOffs);
            x = r.x;
        }
        while (r != null && x == r.x) {
            int span = Math.abs(r.y - y);
            if (span < bestSpan) {
                offs = lastOffs;
                bestSpan = span;
            }
            Rectangle rectangle = r = --lastOffs >= 0 ? c.modelToView(lastOffs) : null;
        }
        return offs;
    }

    public static final int getPositionAboveR2L(JTextComponent c, int offs, int y) throws BadLocationException {
        int lastOffs = MUtilities.getRowStartR2L(c, offs) - 1;
        if (lastOffs < 0) {
            return -1;
        }
        int bestSpan = Integer.MAX_VALUE;
        int x = 0;
        Rectangle r = null;
        if (lastOffs >= 0) {
            r = c.modelToView(lastOffs);
            x = r.x;
        }
        while (r != null && x == r.x) {
            int span = Math.abs(r.y - y);
            if (span < bestSpan) {
                offs = lastOffs;
                bestSpan = span;
            }
            Rectangle rectangle = r = --lastOffs >= 0 ? c.modelToView(lastOffs) : null;
        }
        return offs;
    }

    public static final int getPositionBelow(JTextComponent c, int offs, int x) throws BadLocationException {
        int lastOffs = MUtilities.getRowEnd(c, offs) + 1;
        if (lastOffs <= 0) {
            return -1;
        }
        int bestSpan = Integer.MAX_VALUE;
        int n = c.getDocument().getLength();
        int y = 0;
        Rectangle r = null;
        if (lastOffs <= n) {
            r = c.modelToView(lastOffs);
            y = r.y;
        }
        while (r != null && y == r.y) {
            int span = Math.abs(x - r.x);
            if (span < bestSpan) {
                offs = lastOffs;
                bestSpan = span;
            }
            Rectangle rectangle = r = ++lastOffs <= n ? c.modelToView(lastOffs) : null;
        }
        return offs;
    }

    public static final int getPositionBelowL2R(JTextComponent c, int offs, int x) throws BadLocationException {
        int lastOffs = MUtilities.getRowEndL2R(c, offs) + 1;
        if (lastOffs <= 0) {
            return -1;
        }
        int bestSpan = Integer.MAX_VALUE;
        int n = c.getDocument().getLength();
        int y = 0;
        Rectangle r = null;
        if (lastOffs <= n) {
            r = c.modelToView(lastOffs);
            y = r.y;
        }
        while (r != null && y == r.y) {
            int span = Math.abs(x - r.x);
            if (span < bestSpan) {
                offs = lastOffs;
                bestSpan = span;
            }
            Rectangle rectangle = r = ++lastOffs <= n ? c.modelToView(lastOffs) : null;
        }
        return offs;
    }

    public static final int getPositionBelowR2L(JTextComponent c, int offs, int y) throws BadLocationException {
        int lastOffs = MUtilities.getRowEndR2L(c, offs) + 1;
        if (lastOffs <= 0) {
            return -1;
        }
        int bestSpan = Integer.MAX_VALUE;
        int n = c.getDocument().getLength();
        int x = 0;
        Rectangle r = null;
        if (lastOffs <= n) {
            r = c.modelToView(lastOffs);
            x = r.x;
        }
        while (r != null && x == r.x) {
            int span = Math.abs(y - r.y);
            if (span < bestSpan) {
                offs = lastOffs;
                bestSpan = span;
            }
            Rectangle rectangle = r = ++lastOffs <= n ? c.modelToView(lastOffs) : null;
        }
        return offs;
    }

    public static final int getWordStart(JTextComponent c, int offs) throws BadLocationException {
        Document doc = c.getDocument();
        Element line = MUtilities.getParagraphElement(c, offs);
        if (line == null) {
            throw new BadLocationException("No word at " + offs, offs);
        }
        int lineStart = line.getStartOffset();
        int lineEnd = Math.min(line.getEndOffset(), doc.getLength());
        Segment seg = MSegmentCache.getSharedSegment();
        doc.getText(lineStart, lineEnd - lineStart, seg);
        if (seg.count > 0) {
            BreakIterator words = BreakIterator.getWordInstance(c.getLocale());
            words.setText(seg);
            int wordPosition = seg.offset + offs - lineStart;
            if (wordPosition >= words.last()) {
                wordPosition = words.last() - 1;
            }
            words.following(wordPosition);
            offs = lineStart + words.previous() - seg.offset;
        }
        MSegmentCache.releaseSharedSegment(seg);
        return offs;
    }

    public static final int getWordEnd(JTextComponent c, int offs) throws BadLocationException {
        Document doc = c.getDocument();
        Element line = MUtilities.getParagraphElement(c, offs);
        if (line == null) {
            throw new BadLocationException("No word at " + offs, offs);
        }
        int lineStart = line.getStartOffset();
        int lineEnd = Math.min(line.getEndOffset(), doc.getLength());
        Segment seg = MSegmentCache.getSharedSegment();
        doc.getText(lineStart, lineEnd - lineStart, seg);
        if (seg.count > 0) {
            BreakIterator words = BreakIterator.getWordInstance(c.getLocale());
            words.setText(seg);
            int wordPosition = offs - lineStart + seg.offset;
            if (wordPosition >= words.last()) {
                wordPosition = words.last() - 1;
            }
            offs = lineStart + words.following(wordPosition) - seg.offset;
        }
        MSegmentCache.releaseSharedSegment(seg);
        return offs;
    }

    public static final int getNextWord(JTextComponent c, int offs) throws BadLocationException {
        Element line = MUtilities.getParagraphElement(c, offs);
        int nextWord = MUtilities.getNextWordInParagraph(c, line, offs, false);
        while (nextWord == -1) {
            offs = line.getEndOffset();
            line = MUtilities.getParagraphElement(c, offs);
            nextWord = MUtilities.getNextWordInParagraph(c, line, offs, true);
        }
        return nextWord;
    }

    static int getNextWordInParagraph(JTextComponent c, Element line, int offs, boolean first) throws BadLocationException {
        if (line == null) {
            throw new BadLocationException("No more words", offs);
        }
        Document doc = line.getDocument();
        int lineStart = line.getStartOffset();
        int lineEnd = Math.min(line.getEndOffset(), doc.getLength());
        if (offs >= lineEnd || offs < lineStart) {
            throw new BadLocationException("No more words", offs);
        }
        Segment seg = MSegmentCache.getSharedSegment();
        doc.getText(lineStart, lineEnd - lineStart, seg);
        BreakIterator words = BreakIterator.getWordInstance(c.getLocale());
        words.setText(seg);
        if (first && words.first() == seg.offset + offs - lineStart && !Character.isWhitespace(seg.array[words.first()])) {
            return offs;
        }
        int wordPosition = words.following(seg.offset + offs - lineStart);
        if (wordPosition == -1 || wordPosition >= seg.offset + seg.count) {
            return -1;
        }
        char ch = seg.array[wordPosition];
        if (!Character.isWhitespace(ch)) {
            return lineStart + wordPosition - seg.offset;
        }
        wordPosition = words.next();
        if (wordPosition != -1 && (offs = lineStart + wordPosition - seg.offset) != lineEnd) {
            return offs;
        }
        MSegmentCache.releaseSharedSegment(seg);
        return -1;
    }

    public static final int getPreviousWord(JTextComponent c, int offs) throws BadLocationException {
        Element line = MUtilities.getParagraphElement(c, offs);
        int prevWord = MUtilities.getPrevWordInParagraph(c, line, offs);
        while (prevWord == -1) {
            offs = line.getStartOffset() - 1;
            line = MUtilities.getParagraphElement(c, offs);
            prevWord = MUtilities.getPrevWordInParagraph(c, line, offs);
        }
        return prevWord;
    }

    static int getPrevWordInParagraph(JTextComponent c, Element line, int offs) throws BadLocationException {
        int wordPosition;
        if (line == null) {
            throw new BadLocationException("No more words", offs);
        }
        Document doc = line.getDocument();
        int lineStart = line.getStartOffset();
        int lineEnd = line.getEndOffset();
        if (offs > lineEnd || offs < lineStart) {
            throw new BadLocationException("No more words", offs);
        }
        Segment seg = MSegmentCache.getSharedSegment();
        doc.getText(lineStart, lineEnd - lineStart, seg);
        BreakIterator words = BreakIterator.getWordInstance(c.getLocale());
        words.setText(seg);
        if (words.following(seg.offset + offs - lineStart) == -1) {
            words.last();
        }
        if ((wordPosition = words.previous()) == seg.offset + offs - lineStart) {
            wordPosition = words.previous();
        }
        if (wordPosition == -1) {
            return -1;
        }
        char ch = seg.array[wordPosition];
        if (!Character.isWhitespace(ch)) {
            return lineStart + wordPosition - seg.offset;
        }
        wordPosition = words.previous();
        if (wordPosition != -1) {
            return lineStart + wordPosition - seg.offset;
        }
        MSegmentCache.releaseSharedSegment(seg);
        return -1;
    }

    public static final Element getParagraphElement(JTextComponent c, int offs) {
        int index;
        Document doc = c.getDocument();
        if (doc instanceof StyledDocument) {
            return ((StyledDocument)doc).getParagraphElement(offs);
        }
        Element map = doc.getDefaultRootElement();
        Element paragraph = map.getElement(index = map.getElementIndex(offs));
        if (offs >= paragraph.getStartOffset() && offs < paragraph.getEndOffset()) {
            return paragraph;
        }
        return null;
    }

    static boolean isComposedTextElement(Document doc, int offset) {
        Element elem = doc.getDefaultRootElement();
        while (!elem.isLeaf()) {
            elem = elem.getElement(elem.getElementIndex(offset));
        }
        return MUtilities.isComposedTextElement(elem);
    }

    static boolean isComposedTextElement(Element elem) {
        AttributeSet as = elem.getAttributes();
        return MUtilities.isComposedTextAttributeDefined(as);
    }

    static boolean isComposedTextAttributeDefined(AttributeSet as) {
        return as != null && as.isDefined(StyleConstants.ComposedTextAttribute);
    }

    static int drawComposedText(View view, AttributeSet attr, Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        Graphics2D g2d = (Graphics2D)g;
        AttributedString as = (AttributedString)attr.getAttribute(StyleConstants.ComposedTextAttribute);
        Font defaultfont = UIManager.getFont("TextField.font");
        int size = (g.getFont().getSize() + defaultfont.getSize()) / 2;
        defaultfont = defaultfont.deriveFont(0, size);
        as.addAttribute(TextAttribute.FONT, defaultfont);
        if (p0 >= p1) {
            return x;
        }
        AttributedCharacterIterator aci = as.getIterator(null, p0, p1);
        return x + (int)MSwingUtilities.drawString(MUtilities.getJComponent(view), (Graphics)g2d, aci, x, y);
    }

    public static void paintComposedText(Graphics g, Rectangle alloc, MGlyphView v) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            int p0 = v.getStartOffset();
            int p1 = v.getEndOffset();
            AttributeSet attrSet = v.getElement().getAttributes();
            AttributedString as = (AttributedString)attrSet.getAttribute(StyleConstants.ComposedTextAttribute);
            int start = v.getElement().getStartOffset();
            if (v.getRotateDirection() == 0) {
                int y = alloc.y + alloc.height - (int)v.getGlyphPainter().getDescent(v);
                int x = alloc.x;
                as.addAttribute(TextAttribute.FONT, v.getFont());
                as.addAttribute(TextAttribute.FOREGROUND, v.getForeground());
                if (StyleConstants.isBold(v.getAttributes())) {
                    as.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                }
                if (StyleConstants.isItalic(v.getAttributes())) {
                    as.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                }
                if (v.isUnderline()) {
                    as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                }
                if (v.isStrikeThrough()) {
                    as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                }
                if (v.isSuperscript()) {
                    as.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
                }
                if (v.isSubscript()) {
                    as.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
                }
                AttributedCharacterIterator aci = as.getIterator(null, p0 - start, p1 - start);
                MSwingUtilities.drawString(MUtilities.getJComponent(v), (Graphics)g2d, aci, x, y);
            } else if (v.getRotateHint() != 4) {
                int x = alloc.y;
                int y = -alloc.x - (int)v.getGlyphPainter().getDescent(v);
                as.addAttribute(TextAttribute.FONT, v.getFont());
                as.addAttribute(TextAttribute.FOREGROUND, v.getForeground());
                if (StyleConstants.isBold(v.getAttributes())) {
                    as.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                }
                if (StyleConstants.isItalic(v.getAttributes())) {
                    as.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                }
                if (v.isUnderline()) {
                    as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                }
                if (v.isStrikeThrough()) {
                    as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                }
                if (v.isSuperscript()) {
                    as.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
                }
                if (v.isSubscript()) {
                    as.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
                }
                AffineTransform transform = g2d.getTransform();
                ((Graphics2D)g).rotate(1.5707963267948966);
                AttributedCharacterIterator aci = as.getIterator(null, p0 - start, p1 - start);
                MSwingUtilities.drawString(MUtilities.getJComponent(v), (Graphics)g2d, aci, x, y);
                g2d.setTransform(transform);
            } else {
                int y = alloc.y + alloc.height - (int)v.getGlyphPainter().getDescent(v);
                int x = alloc.x;
                as.addAttribute(TextAttribute.FONT, v.getFont());
                as.addAttribute(TextAttribute.FOREGROUND, v.getForeground());
                if (StyleConstants.isBold(v.getAttributes())) {
                    as.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                }
                if (StyleConstants.isItalic(v.getAttributes())) {
                    as.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                }
                if (v.isUnderline()) {
                    as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                }
                if (v.isStrikeThrough()) {
                    as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                }
                if (v.isSuperscript()) {
                    as.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
                }
                if (v.isSubscript()) {
                    as.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
                }
                AffineTransform transform = g2d.getTransform();
                ((Graphics2D)g).rotate(1.5707963267948966);
                AttributedCharacterIterator aci = as.getIterator(null, p0 - start, p1 - start);
                MSwingUtilities.drawString(MUtilities.getJComponent(v), (Graphics)g2d, aci, x, y);
                g2d.setTransform(transform);
            }
        }
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    static int getNextVisualPositionFrom(View v, int pos, Position.Bias b, Shape alloc, int direction, Position.Bias[] biasRet) throws BadLocationException {
        int retValue;
        boolean top;
        if (v.getViewCount() == 0) {
            return pos;
        }
        boolean bl = top = direction == 1 || direction == 7;
        if (pos == -1) {
            Shape childBounds;
            int childIndex = top ? v.getViewCount() - 1 : 0;
            View child = v.getView(childIndex);
            retValue = child.getNextVisualPositionFrom(pos, b, childBounds = v.getChildAllocation(childIndex, alloc), direction, biasRet);
            if (retValue == -1 && !top && v.getViewCount() > 1) {
                child = v.getView(1);
                childBounds = v.getChildAllocation(1, alloc);
                retValue = child.getNextVisualPositionFrom(-1, biasRet[0], childBounds, direction, biasRet);
            }
        } else {
            int increment = top ? -1 : 1;
            int childIndex = b == Position.Bias.Backward && pos > 0 ? v.getViewIndex(pos - 1, Position.Bias.Forward) : v.getViewIndex(pos, Position.Bias.Forward);
            View child = v.getView(childIndex);
            Shape childBounds = v.getChildAllocation(childIndex, alloc);
            retValue = child.getNextVisualPositionFrom(pos, b, childBounds, direction, biasRet);
            if ((direction == 3 || direction == 7) && v instanceof CompositeView && MUtilities.flipEastAndWestAtEnds(pos, b)) {
                increment *= -1;
            }
            if (retValue == -1 && (childIndex += increment) >= 0 && childIndex < v.getViewCount()) {
                child = v.getView(childIndex);
                retValue = child.getNextVisualPositionFrom(-1, b, childBounds = v.getChildAllocation(childIndex, alloc), direction, biasRet);
                if (retValue == pos && biasRet[0] != b) {
                    return MUtilities.getNextVisualPositionFrom(v, pos, biasRet[0], alloc, direction, biasRet);
                }
            } else if (retValue != -1 && biasRet[0] != b && (increment == 1 && child.getEndOffset() == retValue || increment == -1 && child.getStartOffset() == retValue) && childIndex >= 0 && childIndex < v.getViewCount()) {
                child = v.getView(childIndex);
                childBounds = v.getChildAllocation(childIndex, alloc);
                Position.Bias originalBias = biasRet[0];
                int nextPos = child.getNextVisualPositionFrom(-1, b, childBounds, direction, biasRet);
                if (biasRet[0] == b) {
                    retValue = nextPos;
                } else {
                    biasRet[0] = originalBias;
                }
            }
        }
        return retValue;
    }

    protected static boolean flipEastAndWestAtEnds(int position, Position.Bias bias) {
        return false;
    }

    public static boolean isRotated(char ch) {
        if (rotateStr0.indexOf(ch) >= 0) {
            return false;
        }
        if (rotateStr1.indexOf(ch) >= 0) {
            return false;
        }
        if (rotateStr2.indexOf(ch) >= 0) {
            return false;
        }
        if (rotateStr3.indexOf(ch) >= 0) {
            return false;
        }
        if (rotateStr4.indexOf(ch) >= 0) {
            return false;
        }
        return rotateStr5.indexOf(ch) < 0;
    }

    public static int getRightIntend(char ch) {
        if (sepStr.indexOf(ch) >= 0) {
            return 4;
        }
        if (smallStr.indexOf(ch) >= 0) {
            return 1;
        }
        return 0;
    }

    public static int getDownIntend(char ch) {
        if (dangleStr.indexOf(ch) >= 0) {
            return 1;
        }
        if (sepStr.indexOf(ch) >= 0) {
            return -3;
        }
        return 0;
    }
}

