/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text.html;

import com.mongol.swing.text.html.MFormSubmitEvent;
import com.mongol.swing.text.html.MFrameSetView;
import com.mongol.swing.text.html.MHTML;
import com.mongol.swing.text.html.MHTMLDocument;
import com.mongol.swing.text.html.MHTMLEditorKit;
import com.mongol.swing.text.html.MHTMLFrameHyperlinkEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import sun.swing.text.html.FrameEditorPaneTag;

class MFrameView
extends ComponentView
implements HyperlinkListener {
    JEditorPane htmlPane;
    JScrollPane scroller;
    boolean editable;
    float width;
    float height;
    URL src;
    private boolean createdComponent;

    public MFrameView(Element elem) {
        super(elem);
    }

    @Override
    protected Component createComponent() {
        Element elem = this.getElement();
        AttributeSet attributes = elem.getAttributes();
        String srcAtt = (String)attributes.getAttribute(MHTML.Attribute.SRC);
        if (srcAtt != null && !srcAtt.equals("")) {
            try {
                Document doc;
                URL base = ((MHTMLDocument)elem.getDocument()).getBase();
                this.src = new URL(base, srcAtt);
                this.htmlPane = new FrameEditorPane();
                this.htmlPane.addHyperlinkListener(this);
                JEditorPane host = this.getHostPane();
                boolean isAutoFormSubmission = true;
                if (host != null) {
                    MHTMLEditorKit hostKit;
                    this.htmlPane.setEditable(host.isEditable());
                    String charset = (String)host.getClientProperty("charset");
                    if (charset != null) {
                        this.htmlPane.putClientProperty("charset", charset);
                    }
                    if ((hostKit = (MHTMLEditorKit)host.getEditorKit()) != null) {
                        isAutoFormSubmission = hostKit.isAutoFormSubmission();
                    }
                }
                this.htmlPane.setPage(this.src);
                MHTMLEditorKit kit = (MHTMLEditorKit)this.htmlPane.getEditorKit();
                if (kit != null) {
                    kit.setAutoFormSubmission(isAutoFormSubmission);
                }
                if ((doc = this.htmlPane.getDocument()) instanceof MHTMLDocument) {
                    ((MHTMLDocument)doc).setFrameDocumentState(true);
                }
                this.setMargin();
                this.createScrollPane();
                this.setBorder();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        this.createdComponent = true;
        return this.scroller;
    }

    JEditorPane getHostPane() {
        Container c = this.getContainer();
        while (c != null && !(c instanceof JEditorPane)) {
            c = c.getParent();
        }
        return (JEditorPane)c;
    }

    @Override
    public void setParent(View parent) {
        if (parent != null) {
            JTextComponent t = (JTextComponent)parent.getContainer();
            this.editable = t.isEditable();
        }
        super.setParent(parent);
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        Container host = this.getContainer();
        if (host != null && this.htmlPane != null && this.htmlPane.isEditable() != ((JTextComponent)host).isEditable()) {
            this.editable = ((JTextComponent)host).isEditable();
            this.htmlPane.setEditable(this.editable);
        }
        super.paint(g, allocation);
    }

    private void setMargin() {
        int margin = 0;
        Insets in = this.htmlPane.getMargin();
        boolean modified = false;
        AttributeSet attributes = this.getElement().getAttributes();
        String marginStr = (String)attributes.getAttribute(MHTML.Attribute.MARGINWIDTH);
        Insets newInsets = in != null ? new Insets(in.top, in.left, in.right, in.bottom) : new Insets(0, 0, 0, 0);
        if (marginStr != null && (margin = Integer.parseInt(marginStr)) > 0) {
            newInsets.left = margin;
            newInsets.right = margin;
            modified = true;
        }
        if ((marginStr = (String)attributes.getAttribute(MHTML.Attribute.MARGINHEIGHT)) != null && (margin = Integer.parseInt(marginStr)) > 0) {
            newInsets.top = margin;
            newInsets.bottom = margin;
            modified = true;
        }
        if (modified) {
            this.htmlPane.setMargin(newInsets);
        }
    }

    private void setBorder() {
        AttributeSet attributes = this.getElement().getAttributes();
        String frameBorder = (String)attributes.getAttribute(MHTML.Attribute.FRAMEBORDER);
        if (frameBorder != null && (frameBorder.equals("no") || frameBorder.equals("0"))) {
            this.scroller.setBorder(null);
        }
    }

    private void createScrollPane() {
        AttributeSet attributes = this.getElement().getAttributes();
        String scrolling = (String)attributes.getAttribute(MHTML.Attribute.SCROLLING);
        if (scrolling == null) {
            scrolling = "auto";
        }
        this.scroller = !scrolling.equals("no") ? (scrolling.equals("yes") ? new JScrollPane(22, 32) : new JScrollPane()) : new JScrollPane(21, 31);
        JViewport vp = this.scroller.getViewport();
        vp.add(this.htmlPane);
        vp.setBackingStoreEnabled(true);
        this.scroller.setMinimumSize(new Dimension(5, 5));
        this.scroller.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    JEditorPane getOutermostJEditorPane() {
        View parent = this.getParent();
        View frameSetView = null;
        while (parent != null) {
            if (parent instanceof MFrameSetView) {
                frameSetView = (MFrameSetView)parent;
            }
            parent = parent.getParent();
        }
        if (frameSetView != null) {
            return (JEditorPane)frameSetView.getContainer();
        }
        return null;
    }

    private boolean inNestedFrameSet() {
        MFrameSetView parent = (MFrameSetView)this.getParent();
        return parent.getParent() instanceof MFrameSetView;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent evt) {
        JEditorPane c = this.getOutermostJEditorPane();
        if (c == null) {
            return;
        }
        if (!(evt instanceof MHTMLFrameHyperlinkEvent)) {
            c.fireHyperlinkUpdate(evt);
            return;
        }
        MHTMLFrameHyperlinkEvent e = (MHTMLFrameHyperlinkEvent)evt;
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String target;
            String postTarget = target = e.getTarget();
            if (target.equals("_parent") && !this.inNestedFrameSet()) {
                target = "_top";
            }
            if (evt instanceof MFormSubmitEvent) {
                MHTMLEditorKit kit = (MHTMLEditorKit)c.getEditorKit();
                if (kit != null && kit.isAutoFormSubmission()) {
                    if (target.equals("_top")) {
                        try {
                            this.movePostData(c, postTarget);
                            c.setPage(e.getURL());
                        }
                        catch (IOException iOException) {}
                    } else {
                        MHTMLDocument doc = (MHTMLDocument)c.getDocument();
                        doc.processHTMLFrameHyperlinkEvent(e);
                    }
                } else {
                    c.fireHyperlinkUpdate(evt);
                }
                return;
            }
            if (target.equals("_top")) {
                try {
                    c.setPage(e.getURL());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!c.isEditable()) {
                c.fireHyperlinkUpdate(new MHTMLFrameHyperlinkEvent((Object)c, e.getEventType(), e.getURL(), e.getDescription(), this.getElement(), target));
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        Element elem = this.getElement();
        AttributeSet attributes = elem.getAttributes();
        URL oldPage = this.src;
        String srcAtt = (String)attributes.getAttribute(MHTML.Attribute.SRC);
        URL base = ((MHTMLDocument)elem.getDocument()).getBase();
        try {
            if (!this.createdComponent) {
                return;
            }
            Object postData = this.movePostData(this.htmlPane, null);
            this.src = new URL(base, srcAtt);
            if (oldPage.equals(this.src) && this.src.getRef() == null && postData == null) {
                return;
            }
            this.htmlPane.setPage(this.src);
            Document newDoc = this.htmlPane.getDocument();
            if (newDoc instanceof MHTMLDocument) {
                ((MHTMLDocument)newDoc).setFrameDocumentState(true);
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Object movePostData(JEditorPane targetPane, String frameName) {
        Object postData = null;
        JEditorPane p = this.getOutermostJEditorPane();
        if (p != null) {
            if (frameName == null) {
                frameName = (String)this.getElement().getAttributes().getAttribute(MHTML.Attribute.NAME);
            }
            if (frameName != null) {
                String propName = "javax.swing.JEditorPane.postdata." + frameName;
                Document d = p.getDocument();
                postData = d.getProperty(propName);
                if (postData != null) {
                    targetPane.getDocument().putProperty("javax.swing.JEditorPane.postdata", postData);
                    d.putProperty(propName, null);
                }
            }
        }
        return postData;
    }

    @Override
    public float getMinimumSpan(int axis) {
        return 5.0f;
    }

    @Override
    public float getMaximumSpan(int axis) {
        return 2.1474836E9f;
    }

    class FrameEditorPane
    extends JEditorPane
    implements FrameEditorPaneTag {
        FrameEditorPane() {
        }

        @Override
        public EditorKit getEditorKitForContentType(String type) {
            EditorKit editorKit = super.getEditorKitForContentType(type);
            JEditorPane outerMostJEditorPane = null;
            outerMostJEditorPane = MFrameView.this.getOutermostJEditorPane();
            if (outerMostJEditorPane != null) {
                EditorKit inheritedEditorKit = outerMostJEditorPane.getEditorKitForContentType(type);
                if (!editorKit.getClass().equals(inheritedEditorKit.getClass())) {
                    editorKit = (EditorKit)inheritedEditorKit.clone();
                    this.setEditorKitForContentType(type, editorKit);
                }
            }
            return editorKit;
        }

        MFrameView getFrameView() {
            return MFrameView.this;
        }
    }
}

