/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text.html;

import com.mongol.swing.text.html.MCSS;
import com.mongol.swing.text.html.MHTML;
import com.mongol.swing.text.html.MHTMLEditorKit;
import com.mongol.swing.text.html.MHTMLFrameHyperlinkEvent;
import com.mongol.swing.text.html.MMap;
import com.mongol.swing.text.html.MOption;
import com.mongol.swing.text.html.MOptionComboBoxModel;
import com.mongol.swing.text.html.MOptionListModel;
import com.mongol.swing.text.html.MStyleSheet;
import com.mongol.swing.text.html.MTextAreaDocument;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.undo.UndoableEdit;
import sun.swing.SwingUtilities2;

public class MHTMLDocument
extends DefaultStyledDocument {
    private boolean frameDocument = false;
    private boolean preservesUnknownTags = true;
    private HashMap radioButtonGroupsMap;
    static final String TokenThreshold = "token threshold";
    private static final int MaxThreshold = 10000;
    private static final int StepThreshold = 5;
    public static final String AdditionalComments = "AdditionalComments";
    static final String StyleType = "StyleType";
    URL base;
    boolean hasBaseTag = false;
    private String baseTarget = null;
    private MHTMLEditorKit.Parser parser;
    private static AttributeSet contentAttributeSet;
    static String MAP_PROPERTY;
    private static char[] NEWLINE;
    private static final String IMPLIED_CR = "CR";
    private static final String I18NProperty = "i18n";

    static {
        MAP_PROPERTY = "__MAP__";
        contentAttributeSet = new SimpleAttributeSet();
        ((MutableAttributeSet)contentAttributeSet).addAttribute(StyleConstants.NameAttribute, MHTML.Tag.CONTENT);
        NEWLINE = new char[1];
        MHTMLDocument.NEWLINE[0] = 10;
    }

    public MHTMLDocument() {
        this((AbstractDocument.Content)new GapContent(4096), new MStyleSheet());
    }

    public MHTMLDocument(MStyleSheet styles) {
        this((AbstractDocument.Content)new GapContent(4096), styles);
    }

    public MHTMLDocument(AbstractDocument.Content c, MStyleSheet styles) {
        super(c, styles);
    }

    public MHTMLEditorKit.ParserCallback getReader(int pos) {
        Object desc = this.getProperty("stream");
        if (desc instanceof URL) {
            this.setBase((URL)desc);
        }
        HTMLReader reader = new HTMLReader(pos);
        return reader;
    }

    public MHTMLEditorKit.ParserCallback getReader(int pos, int popDepth, int pushDepth, MHTML.Tag insertTag) {
        return this.getReader(pos, popDepth, pushDepth, insertTag, true);
    }

    MHTMLEditorKit.ParserCallback getReader(int pos, int popDepth, int pushDepth, MHTML.Tag insertTag, boolean insertInsertTag) {
        Object desc = this.getProperty("stream");
        if (desc instanceof URL) {
            this.setBase((URL)desc);
        }
        HTMLReader reader = new HTMLReader(pos, popDepth, pushDepth, insertTag, insertInsertTag, false, true);
        return reader;
    }

    public URL getBase() {
        return this.base;
    }

    public void setBase(URL u) {
        this.base = u;
        this.getStyleSheet().setBase(u);
    }

    @Override
    protected void insert(int offset, DefaultStyledDocument.ElementSpec[] data) throws BadLocationException {
        super.insert(offset, data);
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        if (attr == null) {
            attr = contentAttributeSet;
        } else if (attr.isDefined(StyleConstants.ComposedTextAttribute)) {
            ((MutableAttributeSet)attr).addAttributes(contentAttributeSet);
        }
        if (attr.isDefined(IMPLIED_CR)) {
            ((MutableAttributeSet)attr).removeAttribute(IMPLIED_CR);
        }
        super.insertUpdate(chng, attr);
    }

    @Override
    protected void create(DefaultStyledDocument.ElementSpec[] data) {
        super.create(data);
    }

    @Override
    public void setParagraphAttributes(int offset, int length, AttributeSet s, boolean replace) {
        try {
            this.writeLock();
            int end = Math.min(offset + length, this.getLength());
            Element e = this.getParagraphElement(offset);
            offset = e.getStartOffset();
            e = this.getParagraphElement(end);
            length = Math.max(0, e.getEndOffset() - offset);
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            AttributeSet sCopy = s.copyAttributes();
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos <= end) {
                Element paragraph = this.getParagraphElement(pos);
                lastEnd = lastEnd == paragraph.getEndOffset() ? ++lastEnd : paragraph.getEndOffset();
                MutableAttributeSet attr = (MutableAttributeSet)paragraph.getAttributes();
                changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(paragraph, sCopy, replace));
                if (replace) {
                    attr.removeAttributes(attr);
                }
                attr.addAttributes(s);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.writeUnlock();
        }
    }

    public MStyleSheet getStyleSheet() {
        return (MStyleSheet)this.getAttributeContext();
    }

    public Iterator getIterator(MHTML.Tag t) {
        if (t.isBlock()) {
            return null;
        }
        return new LeafIterator(t, this);
    }

    @Override
    protected Element createLeafElement(Element parent, AttributeSet a, int p0, int p1) {
        return new RunElement(parent, a, p0, p1);
    }

    @Override
    protected Element createBranchElement(Element parent, AttributeSet a) {
        return new BlockElement(parent, a);
    }

    @Override
    protected AbstractDocument.AbstractElement createDefaultRoot() {
        this.writeLock();
        SimpleAttributeSet a = new SimpleAttributeSet();
        a.addAttribute(StyleConstants.NameAttribute, MHTML.Tag.HTML);
        BlockElement html = new BlockElement(null, a.copyAttributes());
        a.removeAttributes(a);
        a.addAttribute(StyleConstants.NameAttribute, MHTML.Tag.BODY);
        BlockElement body = new BlockElement((Element)html, a.copyAttributes());
        a.removeAttributes(a);
        a.addAttribute(StyleConstants.NameAttribute, MHTML.Tag.P);
        this.getStyleSheet().addCSSAttributeFromHTML(a, MCSS.Attribute.MARGIN_TOP, "0");
        BlockElement paragraph = new BlockElement((Element)body, a.copyAttributes());
        a.removeAttributes(a);
        a.addAttribute(StyleConstants.NameAttribute, MHTML.Tag.CONTENT);
        RunElement brk = new RunElement((Element)paragraph, (AttributeSet)a, 0, 1);
        Element[] buff = new Element[]{brk};
        paragraph.replace(0, 0, buff);
        buff[0] = paragraph;
        body.replace(0, 0, buff);
        buff[0] = body;
        html.replace(0, 0, buff);
        this.writeUnlock();
        return html;
    }

    public void setTokenThreshold(int n) {
        this.putProperty(TokenThreshold, new Integer(n));
    }

    public int getTokenThreshold() {
        Integer i = (Integer)this.getProperty(TokenThreshold);
        if (i != null) {
            return i;
        }
        return Integer.MAX_VALUE;
    }

    public void setPreservesUnknownTags(boolean preservesTags) {
        this.preservesUnknownTags = preservesTags;
    }

    public boolean getPreservesUnknownTags() {
        return this.preservesUnknownTags;
    }

    public void processHTMLFrameHyperlinkEvent(MHTMLFrameHyperlinkEvent e) {
        String frameName = e.getTarget();
        Element element = e.getSourceElement();
        String urlStr = e.getURL().toString();
        if (frameName.equals("_self")) {
            this.updateFrame(element, urlStr);
        } else if (frameName.equals("_parent")) {
            this.updateFrameSet(element.getParentElement(), urlStr);
        } else {
            Element targetElement = this.findFrame(frameName);
            if (targetElement != null) {
                this.updateFrame(targetElement, urlStr);
            }
        }
    }

    private Element findFrame(String frameName) {
        ElementIterator it = new ElementIterator(this);
        Element next = null;
        while ((next = it.next()) != null) {
            String frameTarget;
            AttributeSet attr = next.getAttributes();
            if (MHTMLDocument.matchNameAttribute(attr, MHTML.Tag.FRAME) && (frameTarget = (String)attr.getAttribute(MHTML.Attribute.NAME)) != null && frameTarget.equals(frameName)) break;
        }
        return next;
    }

    static boolean matchNameAttribute(AttributeSet attr, MHTML.Tag tag) {
        MHTML.Tag name;
        Object o = attr.getAttribute(StyleConstants.NameAttribute);
        return o instanceof MHTML.Tag && (name = (MHTML.Tag)o) == tag;
    }

    private void updateFrameSet(Element element, String url) {
        try {
            int startOffset = element.getStartOffset();
            int endOffset = Math.min(this.getLength(), element.getEndOffset());
            String html = "<frame";
            if (url != null) {
                html = String.valueOf(html) + " src=\"" + url + "\"";
            }
            html = String.valueOf(html) + ">";
            this.installParserIfNecessary();
            this.setOuterHTML(element, html);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateFrame(Element element, String url) {
        try {
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, element.getStartOffset(), 1, DocumentEvent.EventType.CHANGE);
            AttributeSet sCopy = element.getAttributes().copyAttributes();
            MutableAttributeSet attr = (MutableAttributeSet)element.getAttributes();
            changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(element, sCopy, false));
            attr.removeAttribute(MHTML.Attribute.SRC);
            attr.addAttribute(MHTML.Attribute.SRC, url);
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.writeUnlock();
        }
    }

    boolean isFrameDocument() {
        return this.frameDocument;
    }

    void setFrameDocumentState(boolean frameDoc) {
        this.frameDocument = frameDoc;
    }

    void addMap(MMap map) {
        String name = map.getName();
        if (name != null) {
            Hashtable<String, MMap> maps = this.getProperty(MAP_PROPERTY);
            if (maps == null) {
                maps = new Hashtable<String, MMap>(11);
                this.putProperty(MAP_PROPERTY, maps);
            }
            if (maps instanceof Hashtable) {
                maps.put("#" + name, map);
            }
        }
    }

    void removeMap(MMap map) {
        Object maps;
        String name = map.getName();
        if (name != null && (maps = this.getProperty(MAP_PROPERTY)) instanceof Hashtable) {
            ((Hashtable)maps).remove("#" + name);
        }
    }

    MMap getMap(String name) {
        Object maps;
        if (name != null && (maps = this.getProperty(MAP_PROPERTY)) != null && maps instanceof Hashtable) {
            return (MMap)((Hashtable)maps).get(name);
        }
        return null;
    }

    Enumeration getMaps() {
        Object maps = this.getProperty(MAP_PROPERTY);
        if (maps instanceof Hashtable) {
            return ((Hashtable)maps).elements();
        }
        return null;
    }

    void setDefaultStyleSheetType(String contentType) {
        this.putProperty(StyleType, contentType);
    }

    String getDefaultStyleSheetType() {
        String retValue = (String)this.getProperty(StyleType);
        if (retValue == null) {
            return "text/css";
        }
        return retValue;
    }

    public void setParser(MHTMLEditorKit.Parser parser) {
        this.parser = parser;
        this.putProperty("__PARSER__", null);
    }

    public MHTMLEditorKit.Parser getParser() {
        Object p = this.getProperty("__PARSER__");
        if (p instanceof MHTMLEditorKit.Parser) {
            return (MHTMLEditorKit.Parser)p;
        }
        return this.parser;
    }

    public void setInnerHTML(Element elem, String htmlText) throws BadLocationException, IOException {
        this.verifyParser();
        if (elem != null && elem.isLeaf()) {
            throw new IllegalArgumentException("Can not set inner HTML of a leaf");
        }
        if (elem != null && htmlText != null) {
            int oldCount = elem.getElementCount();
            int insertPosition = elem.getStartOffset();
            this.insertHTML(elem, elem.getStartOffset(), htmlText, true);
            if (elem.getElementCount() > oldCount) {
                this.removeElements(elem, elem.getElementCount() - oldCount, oldCount);
            }
        }
    }

    public void setOuterHTML(Element elem, String htmlText) throws BadLocationException, IOException {
        this.verifyParser();
        if (elem != null && elem.getParentElement() != null && htmlText != null) {
            boolean wantsNewline;
            int start = elem.getStartOffset();
            int end = elem.getEndOffset();
            int startLength = this.getLength();
            boolean bl = wantsNewline = !elem.isLeaf();
            if (!(wantsNewline || end <= startLength && this.getText(end - 1, 1).charAt(0) != NEWLINE[0])) {
                wantsNewline = true;
            }
            Element parent = elem.getParentElement();
            int oldCount = parent.getElementCount();
            this.insertHTML(parent, start, htmlText, wantsNewline);
            int newLength = this.getLength();
            if (oldCount != parent.getElementCount()) {
                int removeIndex = parent.getElementIndex(start + newLength - startLength);
                this.removeElements(parent, removeIndex, 1);
            }
        }
    }

    public void insertAfterStart(Element elem, String htmlText) throws BadLocationException, IOException {
        this.verifyParser();
        if (elem != null && elem.isLeaf()) {
            throw new IllegalArgumentException("Can not insert HTML after start of a leaf");
        }
        this.insertHTML(elem, elem.getStartOffset(), htmlText, false);
    }

    public void insertBeforeEnd(Element elem, String htmlText) throws BadLocationException, IOException {
        this.verifyParser();
        if (elem != null && elem.isLeaf()) {
            throw new IllegalArgumentException("Can not set inner HTML before end of leaf");
        }
        int offset = elem.getEndOffset();
        if (elem.getElement(elem.getElementIndex(offset - 1)).isLeaf() && this.getText(offset - 1, 1).charAt(0) == NEWLINE[0]) {
            --offset;
        }
        this.insertHTML(elem, offset, htmlText, false);
    }

    public void insertBeforeStart(Element elem, String htmlText) throws BadLocationException, IOException {
        Element parent;
        this.verifyParser();
        if (elem != null && (parent = elem.getParentElement()) != null) {
            this.insertHTML(parent, elem.getStartOffset(), htmlText, false);
        }
    }

    public void insertAfterEnd(Element elem, String htmlText) throws BadLocationException, IOException {
        Element parent;
        this.verifyParser();
        if (elem != null && (parent = elem.getParentElement()) != null) {
            int offset = elem.getEndOffset();
            if (offset > this.getLength()) {
                --offset;
            } else if (elem.isLeaf() && this.getText(offset - 1, 1).charAt(0) == NEWLINE[0]) {
                --offset;
            }
            this.insertHTML(parent, offset, htmlText, false);
        }
    }

    public Element getElement(String id) {
        if (id == null) {
            return null;
        }
        return this.getElement(this.getDefaultRootElement(), MHTML.Attribute.ID, id, true);
    }

    public Element getElement(Element e, Object attribute, Object value) {
        return this.getElement(e, attribute, value, true);
    }

    private Element getElement(Element e, Object attribute, Object value, boolean searchLeafAttributes) {
        block5: {
            Enumeration<?> names;
            AttributeSet attr;
            block4: {
                attr = e.getAttributes();
                if (attr != null && attr.isDefined(attribute) && value.equals(attr.getAttribute(attribute))) {
                    return e;
                }
                if (e.isLeaf()) break block4;
                int counter = 0;
                int maxCounter = e.getElementCount();
                while (counter < maxCounter) {
                    Element retValue = this.getElement(e.getElement(counter), attribute, value, searchLeafAttributes);
                    if (retValue != null) {
                        return retValue;
                    }
                    ++counter;
                }
                break block5;
            }
            if (!searchLeafAttributes || attr == null || (names = attr.getAttributeNames()) == null) break block5;
            while (names.hasMoreElements()) {
                AttributeSet check;
                Object name = names.nextElement();
                if (!(name instanceof MHTML.Tag) || !(attr.getAttribute(name) instanceof AttributeSet) || !(check = (AttributeSet)attr.getAttribute(name)).isDefined(attribute) || !value.equals(check.getAttribute(attribute))) continue;
                return e;
            }
        }
        return null;
    }

    private void verifyParser() {
        if (this.getParser() == null) {
            throw new IllegalStateException("No HTMLEditorKit.Parser");
        }
    }

    private void installParserIfNecessary() {
        if (this.getParser() == null) {
            this.setParser(new MHTMLEditorKit().getParser());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void insertHTML(Element parent, int offset, String html, boolean wantsTrailingNewline) throws BadLocationException, IOException {
        block3: {
            if (parent == null || html == null || (parser = this.getParser()) == null) break block3;
            lastOffset = Math.max(0, offset - 1);
            charElement = this.getCharacterElement(lastOffset);
            commonParent = parent;
            pop = 0;
            push = 0;
            if (parent.getStartOffset() <= lastOffset) ** GOTO lbl16
            while (commonParent != null && commonParent.getStartOffset() > lastOffset) {
                commonParent = commonParent.getParentElement();
                ++push;
            }
            if (commonParent != null) ** GOTO lbl16
            throw new BadLocationException("No common parent", offset);
lbl-1000:
            // 1 sources

            {
                ++pop;
                charElement = charElement.getParentElement();
lbl16:
                // 3 sources

                ** while (charElement != null && charElement != commonParent)
            }
lbl17:
            // 1 sources

            if (charElement != null) {
                reader = new HTMLReader(offset, pop - 1, push, null, false, true, wantsTrailingNewline);
                parser.parse(new StringReader(html), reader, true);
                reader.flush();
            }
        }
    }

    private void removeElements(Element e, int index, int count) throws BadLocationException {
        this.writeLock();
        try {
            int start = e.getElement(index).getStartOffset();
            int end = e.getElement(index + count - 1).getEndOffset();
            if (end > this.getLength()) {
                this.removeElementsAtEnd(e, index, count, start, end);
            } else {
                this.removeElements(e, index, count, start, end);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private void removeElementsAtEnd(Element e, int index, int count, int start, int end) throws BadLocationException {
        boolean isLeaf = e.getElement(index - 1).isLeaf();
        AbstractDocument.DefaultDocumentEvent dde = new AbstractDocument.DefaultDocumentEvent(this, start - 1, end - start + 1, DocumentEvent.EventType.REMOVE);
        if (isLeaf) {
            Element endE = this.getCharacterElement(this.getLength());
            --index;
            if (endE.getParentElement() != e) {
                this.replace(dde, e, index, ++count, start, end, true, true);
            } else {
                this.replace(dde, e, index, count, start, end, true, false);
            }
        } else {
            Element newLineE = e.getElement(index - 1);
            while (!newLineE.isLeaf()) {
                newLineE = newLineE.getElement(newLineE.getElementCount() - 1);
            }
            newLineE = newLineE.getParentElement();
            this.replace(dde, e, index, count, start, end, false, false);
            this.replace(dde, newLineE, newLineE.getElementCount() - 1, 1, start, end, true, true);
        }
        this.postRemoveUpdate(dde);
        dde.end();
        this.fireRemoveUpdate(dde);
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, dde));
    }

    private void replace(AbstractDocument.DefaultDocumentEvent dde, Element e, int index, int count, int start, int end, boolean remove, boolean create) throws BadLocationException {
        UndoableEdit u;
        AttributeSet attrs = e.getElement(index).getAttributes();
        Element[] removed = new Element[count];
        int counter = 0;
        while (counter < count) {
            removed[counter] = e.getElement(counter + index);
            ++counter;
        }
        if (remove && (u = this.getContent().remove(start - 1, end - start)) != null) {
            dde.addEdit(u);
        }
        Element[] added = create ? new Element[]{this.createLeafElement(e, attrs, start - 1, start)} : new Element[]{};
        dde.addEdit(new AbstractDocument.ElementEdit(e, index, removed, added));
        ((AbstractDocument.BranchElement)e).replace(index, removed.length, added);
    }

    private void removeElements(Element e, int index, int count, int start, int end) throws BadLocationException {
        Element[] removed = new Element[count];
        Element[] added = new Element[]{};
        int counter = 0;
        while (counter < count) {
            removed[counter] = e.getElement(counter + index);
            ++counter;
        }
        AbstractDocument.DefaultDocumentEvent dde = new AbstractDocument.DefaultDocumentEvent(this, start, end - start, DocumentEvent.EventType.REMOVE);
        ((AbstractDocument.BranchElement)e).replace(index, removed.length, added);
        dde.addEdit(new AbstractDocument.ElementEdit(e, index, removed, added));
        UndoableEdit u = this.getContent().remove(start, end - start);
        if (u != null) {
            dde.addEdit(u);
        }
        this.postRemoveUpdate(dde);
        dde.end();
        this.fireRemoveUpdate(dde);
        if (u != null) {
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, dde));
        }
    }

    void obtainLock() {
        this.writeLock();
    }

    void releaseLock() {
        this.writeUnlock();
    }

    @Override
    protected void fireChangedUpdate(DocumentEvent e) {
        super.fireChangedUpdate(e);
    }

    @Override
    protected void fireUndoableEditUpdate(UndoableEditEvent e) {
        super.fireUndoableEditUpdate(e);
    }

    boolean hasBaseTag() {
        return this.hasBaseTag;
    }

    String getBaseTarget() {
        return this.baseTarget;
    }

    public class BlockElement
    extends AbstractDocument.BranchElement {
        public BlockElement(Element parent, AttributeSet a) {
            super(MHTMLDocument.this, parent, a);
        }

        @Override
        public String getName() {
            Object o = this.getAttribute(StyleConstants.NameAttribute);
            if (o != null) {
                return o.toString();
            }
            return super.getName();
        }

        @Override
        public AttributeSet getResolveParent() {
            return null;
        }
    }

    private static class FixedLengthDocument
    extends PlainDocument {
        private int maxLength;

        public FixedLengthDocument(int maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            if (str != null && str.length() + this.getLength() <= this.maxLength) {
                super.insertString(offset, str, a);
            }
        }
    }

    public class HTMLReader
    extends MHTMLEditorKit.ParserCallback {
        private boolean receivedEndHTML;
        private int flushCount;
        private boolean insertAfterImplied;
        private boolean wantsTrailingNewline;
        int threshold;
        int offset;
        boolean inParagraph = false;
        boolean impliedP = false;
        boolean inPre = false;
        boolean inTextArea = false;
        MTextAreaDocument textAreaDocument = null;
        boolean inTitle = false;
        boolean lastWasNewline = true;
        boolean emptyAnchor;
        boolean midInsert;
        boolean inBody;
        MHTML.Tag insertTag;
        boolean insertInsertTag;
        boolean foundInsertTag;
        int insertTagDepthDelta;
        int popDepth;
        int pushDepth;
        MMap lastMap;
        boolean inStyle = false;
        String defaultStyle;
        Vector styles;
        boolean inHead = false;
        boolean isStyleCSS;
        boolean emptyDocument;
        AttributeSet styleAttributes;
        MOption option;
        protected Vector<DefaultStyledDocument.ElementSpec> parseBuffer = new Vector();
        protected MutableAttributeSet charAttr = new TaggedAttributeSet();
        Stack charAttrStack = new Stack();
        Hashtable tagMap;
        int inBlock = 0;
        private MHTML.Tag nextTagAfterPImplied = null;

        public HTMLReader(int offset) {
            this(offset, 0, 0, null);
        }

        public HTMLReader(int offset, int popDepth, int pushDepth, MHTML.Tag insertTag) {
            this(offset, popDepth, pushDepth, insertTag, true, false, true);
        }

        HTMLReader(int offset, int popDepth, int pushDepth, MHTML.Tag insertTag, boolean insertInsertTag, boolean insertAfterImplied, boolean wantsTrailingNewline) {
            this.emptyDocument = MHTMLDocument.this.getLength() == 0;
            this.isStyleCSS = "text/css".equals(MHTMLDocument.this.getDefaultStyleSheetType());
            this.offset = offset;
            this.threshold = MHTMLDocument.this.getTokenThreshold();
            this.tagMap = new Hashtable(57);
            TagAction na = new TagAction();
            BlockAction ba = new BlockAction();
            ParagraphAction pa = new ParagraphAction();
            CharacterAction ca = new CharacterAction();
            SpecialAction sa = new SpecialAction();
            FormAction fa = new FormAction();
            HiddenAction ha = new HiddenAction();
            ConvertAction conv = new ConvertAction();
            this.tagMap.put(MHTML.Tag.A, new AnchorAction());
            this.tagMap.put(MHTML.Tag.ADDRESS, ca);
            this.tagMap.put(MHTML.Tag.APPLET, ha);
            this.tagMap.put(MHTML.Tag.AREA, new AreaAction());
            this.tagMap.put(MHTML.Tag.B, conv);
            this.tagMap.put(MHTML.Tag.BASE, new BaseAction());
            this.tagMap.put(MHTML.Tag.BASEFONT, ca);
            this.tagMap.put(MHTML.Tag.BIG, ca);
            this.tagMap.put(MHTML.Tag.BLOCKQUOTE, ba);
            this.tagMap.put(MHTML.Tag.BODY, ba);
            this.tagMap.put(MHTML.Tag.BR, sa);
            this.tagMap.put(MHTML.Tag.CAPTION, ba);
            this.tagMap.put(MHTML.Tag.CENTER, ba);
            this.tagMap.put(MHTML.Tag.CITE, ca);
            this.tagMap.put(MHTML.Tag.CODE, ca);
            this.tagMap.put(MHTML.Tag.DD, ba);
            this.tagMap.put(MHTML.Tag.DFN, ca);
            this.tagMap.put(MHTML.Tag.DIR, ba);
            this.tagMap.put(MHTML.Tag.DIV, ba);
            this.tagMap.put(MHTML.Tag.DL, ba);
            this.tagMap.put(MHTML.Tag.DT, pa);
            this.tagMap.put(MHTML.Tag.EM, ca);
            this.tagMap.put(MHTML.Tag.FONT, conv);
            this.tagMap.put(MHTML.Tag.FORM, new FormTagAction());
            this.tagMap.put(MHTML.Tag.FRAME, sa);
            this.tagMap.put(MHTML.Tag.FRAMESET, ba);
            this.tagMap.put(MHTML.Tag.H1, pa);
            this.tagMap.put(MHTML.Tag.H2, pa);
            this.tagMap.put(MHTML.Tag.H3, pa);
            this.tagMap.put(MHTML.Tag.H4, pa);
            this.tagMap.put(MHTML.Tag.H5, pa);
            this.tagMap.put(MHTML.Tag.H6, pa);
            this.tagMap.put(MHTML.Tag.HEAD, new HeadAction());
            this.tagMap.put(MHTML.Tag.HR, sa);
            this.tagMap.put(MHTML.Tag.HTML, ba);
            this.tagMap.put(MHTML.Tag.I, conv);
            this.tagMap.put(MHTML.Tag.IMG, sa);
            this.tagMap.put(MHTML.Tag.INPUT, fa);
            this.tagMap.put(MHTML.Tag.ISINDEX, new IsindexAction());
            this.tagMap.put(MHTML.Tag.KBD, ca);
            this.tagMap.put(MHTML.Tag.LI, ba);
            this.tagMap.put(MHTML.Tag.LINK, new LinkAction());
            this.tagMap.put(MHTML.Tag.MAP, new MapAction());
            this.tagMap.put(MHTML.Tag.MENU, ba);
            this.tagMap.put(MHTML.Tag.META, new MetaAction());
            this.tagMap.put(MHTML.Tag.NOBR, ca);
            this.tagMap.put(MHTML.Tag.NOFRAMES, ba);
            this.tagMap.put(MHTML.Tag.OBJECT, sa);
            this.tagMap.put(MHTML.Tag.OL, ba);
            this.tagMap.put(MHTML.Tag.OPTION, fa);
            this.tagMap.put(MHTML.Tag.P, pa);
            this.tagMap.put(MHTML.Tag.PARAM, new ObjectAction());
            this.tagMap.put(MHTML.Tag.PRE, new PreAction());
            this.tagMap.put(MHTML.Tag.SAMP, ca);
            this.tagMap.put(MHTML.Tag.SCRIPT, ha);
            this.tagMap.put(MHTML.Tag.SELECT, fa);
            this.tagMap.put(MHTML.Tag.SMALL, ca);
            this.tagMap.put(MHTML.Tag.SPAN, ca);
            this.tagMap.put(MHTML.Tag.STRIKE, conv);
            this.tagMap.put(MHTML.Tag.S, ca);
            this.tagMap.put(MHTML.Tag.STRONG, ca);
            this.tagMap.put(MHTML.Tag.STYLE, new StyleAction());
            this.tagMap.put(MHTML.Tag.SUB, conv);
            this.tagMap.put(MHTML.Tag.SUP, conv);
            this.tagMap.put(MHTML.Tag.TABLE, ba);
            this.tagMap.put(MHTML.Tag.TD, ba);
            this.tagMap.put(MHTML.Tag.TEXTAREA, fa);
            this.tagMap.put(MHTML.Tag.TH, ba);
            this.tagMap.put(MHTML.Tag.TITLE, new TitleAction());
            this.tagMap.put(MHTML.Tag.TR, ba);
            this.tagMap.put(MHTML.Tag.TT, ca);
            this.tagMap.put(MHTML.Tag.U, conv);
            this.tagMap.put(MHTML.Tag.UL, ba);
            this.tagMap.put(MHTML.Tag.VAR, ca);
            if (insertTag != null) {
                this.insertTag = insertTag;
                this.popDepth = popDepth;
                this.pushDepth = pushDepth;
                this.insertInsertTag = insertInsertTag;
                this.foundInsertTag = false;
            } else {
                this.foundInsertTag = true;
            }
            if (insertAfterImplied) {
                this.popDepth = popDepth;
                this.pushDepth = pushDepth;
                this.insertAfterImplied = true;
                this.foundInsertTag = false;
                this.midInsert = false;
                this.insertInsertTag = true;
                this.wantsTrailingNewline = wantsTrailingNewline;
            } else {
                boolean bl = this.midInsert = !this.emptyDocument && insertTag == null;
                if (this.midInsert) {
                    this.generateEndsSpecsForMidInsert();
                }
            }
            if (!this.emptyDocument && !this.midInsert) {
                MHTML.Tag tagToInsertInto;
                int targetOffset = Math.max(this.offset - 1, 0);
                Element elem = MHTMLDocument.this.getCharacterElement(targetOffset);
                int i = 0;
                while (i <= this.popDepth) {
                    elem = elem.getParentElement();
                    ++i;
                }
                i = 0;
                while (i < this.pushDepth) {
                    int index = elem.getElementIndex(this.offset);
                    elem = elem.getElement(index);
                    ++i;
                }
                AttributeSet attrs = elem.getAttributes();
                if (attrs != null && (tagToInsertInto = (MHTML.Tag)attrs.getAttribute(StyleConstants.NameAttribute)) != null) {
                    this.inParagraph = tagToInsertInto.isParagraph();
                }
            }
        }

        private void generateEndsSpecsForMidInsert() {
            int count = this.heightToElementWithName(MHTML.Tag.BODY, Math.max(0, this.offset - 1));
            boolean joinNext = false;
            if (count == -1 && this.offset > 0 && (count = this.heightToElementWithName(MHTML.Tag.BODY, this.offset)) != -1) {
                count = this.depthTo(this.offset - 1) - 1;
                joinNext = true;
            }
            if (count == -1) {
                throw new RuntimeException("Must insert new content into body element-");
            }
            if (count != -1) {
                try {
                    if (!joinNext && this.offset > 0 && !MHTMLDocument.this.getText(this.offset - 1, 1).equals("\n")) {
                        SimpleAttributeSet newAttrs = new SimpleAttributeSet();
                        newAttrs.addAttribute(StyleConstants.NameAttribute, MHTML.Tag.CONTENT);
                        DefaultStyledDocument.ElementSpec spec = new DefaultStyledDocument.ElementSpec(newAttrs, 3, NEWLINE, 0, 1);
                        this.parseBuffer.addElement(spec);
                    }
                }
                catch (BadLocationException newAttrs) {}
                while (count-- > 0) {
                    this.parseBuffer.addElement(new DefaultStyledDocument.ElementSpec(null, 2));
                }
                if (joinNext) {
                    DefaultStyledDocument.ElementSpec spec = new DefaultStyledDocument.ElementSpec(null, 1);
                    spec.setDirection((short)5);
                    this.parseBuffer.addElement(spec);
                }
            }
        }

        private int depthTo(int offset) {
            Element e = MHTMLDocument.this.getDefaultRootElement();
            int count = 0;
            while (!e.isLeaf()) {
                ++count;
                e = e.getElement(e.getElementIndex(offset));
            }
            return count;
        }

        private int heightToElementWithName(Object name, int offset) {
            Element e = MHTMLDocument.this.getCharacterElement(offset).getParentElement();
            int count = 0;
            while (e != null && e.getAttributes().getAttribute(StyleConstants.NameAttribute) != name) {
                ++count;
                e = e.getParentElement();
            }
            return e == null ? -1 : count;
        }

        private void adjustEndElement() {
            int length = MHTMLDocument.this.getLength();
            if (length == 0) {
                return;
            }
            MHTMLDocument.this.obtainLock();
            try {
                try {
                    Element[] pPath = this.getPathTo(length - 1);
                    int pLength = pPath.length;
                    if (pLength > 1 && pPath[1].getAttributes().getAttribute(StyleConstants.NameAttribute) == MHTML.Tag.BODY && pPath[1].getEndOffset() == length) {
                        String lastText = MHTMLDocument.this.getText(length - 1, 1);
                        AbstractDocument.DefaultDocumentEvent event = null;
                        Element[] added = new Element[]{};
                        Element[] removed = new Element[1];
                        int index = pPath[0].getElementIndex(length);
                        removed[0] = pPath[0].getElement(index);
                        ((AbstractDocument.BranchElement)pPath[0]).replace(index, 1, added);
                        AbstractDocument.ElementEdit firstEdit = new AbstractDocument.ElementEdit(pPath[0], index, removed, added);
                        SimpleAttributeSet sas = new SimpleAttributeSet();
                        sas.addAttribute(StyleConstants.NameAttribute, MHTML.Tag.CONTENT);
                        sas.addAttribute(MHTMLDocument.IMPLIED_CR, Boolean.TRUE);
                        added = new Element[]{MHTMLDocument.this.createLeafElement(pPath[pLength - 1], sas, length, length + 1)};
                        index = pPath[pLength - 1].getElementCount();
                        ((AbstractDocument.BranchElement)pPath[pLength - 1]).replace(index, 0, added);
                        event = new AbstractDocument.DefaultDocumentEvent(MHTMLDocument.this, length, 1, DocumentEvent.EventType.CHANGE);
                        event.addEdit(new AbstractDocument.ElementEdit(pPath[pLength - 1], index, new Element[0], added));
                        event.addEdit(firstEdit);
                        event.end();
                        MHTMLDocument.this.fireChangedUpdate(event);
                        MHTMLDocument.this.fireUndoableEditUpdate(new UndoableEditEvent(this, event));
                        if (lastText.equals("\n")) {
                            event = new AbstractDocument.DefaultDocumentEvent(MHTMLDocument.this, length - 1, 1, DocumentEvent.EventType.REMOVE);
                            MHTMLDocument.this.removeUpdate(event);
                            UndoableEdit u = MHTMLDocument.this.getContent().remove(length - 1, 1);
                            if (u != null) {
                                event.addEdit(u);
                            }
                            MHTMLDocument.this.postRemoveUpdate(event);
                            event.end();
                            MHTMLDocument.this.fireRemoveUpdate(event);
                            MHTMLDocument.this.fireUndoableEditUpdate(new UndoableEditEvent(this, event));
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    MHTMLDocument.this.releaseLock();
                }
            }
            finally {
                MHTMLDocument.this.releaseLock();
            }
        }

        private Element[] getPathTo(int offset) {
            Stack<Element> elements = new Stack<Element>();
            Element e = MHTMLDocument.this.getDefaultRootElement();
            while (!e.isLeaf()) {
                elements.push(e);
                e = e.getElement(e.getElementIndex(offset));
            }
            Object[] retValue = new Element[elements.size()];
            elements.copyInto(retValue);
            return retValue;
        }

        @Override
        public void flush() throws BadLocationException {
            if (this.emptyDocument && !this.insertAfterImplied) {
                if (MHTMLDocument.this.getLength() > 0 || this.parseBuffer.size() > 0) {
                    this.flushBuffer(true);
                    this.adjustEndElement();
                }
            } else {
                this.flushBuffer(true);
            }
        }

        @Override
        public void handleText(char[] data, int pos) {
            if (this.receivedEndHTML || this.midInsert && !this.inBody) {
                return;
            }
            if (MHTMLDocument.this.getProperty(MHTMLDocument.I18NProperty).equals(Boolean.FALSE)) {
                Object d = MHTMLDocument.this.getProperty(TextAttribute.RUN_DIRECTION);
                if (d != null && d.equals(TextAttribute.RUN_DIRECTION_RTL)) {
                    MHTMLDocument.this.putProperty(MHTMLDocument.I18NProperty, Boolean.TRUE);
                } else if (SwingUtilities2.isComplexLayout(data, 0, data.length)) {
                    MHTMLDocument.this.putProperty(MHTMLDocument.I18NProperty, Boolean.TRUE);
                }
            }
            if (this.inTextArea) {
                this.textAreaContent(data);
            } else if (this.inPre) {
                this.preContent(data);
            } else if (this.inTitle) {
                MHTMLDocument.this.putProperty("title", new String(data));
            } else if (this.option != null) {
                this.option.setLabel(new String(data));
            } else if (this.inStyle) {
                if (this.styles != null) {
                    this.styles.addElement(new String(data));
                }
            } else if (this.inBlock > 0) {
                if (!this.foundInsertTag && this.insertAfterImplied) {
                    this.foundInsertTag(false);
                    this.foundInsertTag = true;
                    this.impliedP = true;
                    this.inParagraph = true;
                }
                if (data.length >= 1) {
                    this.addContent(data, 0, data.length);
                }
            }
        }

        @Override
        public void handleStartTag(MHTML.Tag t, MutableAttributeSet a, int pos) {
            if (this.receivedEndHTML) {
                return;
            }
            if (this.midInsert && !this.inBody) {
                if (t == MHTML.Tag.BODY) {
                    this.inBody = true;
                    ++this.inBlock;
                }
                return;
            }
            if (!this.inBody && t == MHTML.Tag.BODY) {
                this.inBody = true;
            }
            if (this.isStyleCSS && a.isDefined(MHTML.Attribute.STYLE)) {
                String decl = (String)a.getAttribute(MHTML.Attribute.STYLE);
                a.removeAttribute(MHTML.Attribute.STYLE);
                this.styleAttributes = MHTMLDocument.this.getStyleSheet().getDeclaration(decl);
                a.addAttributes(this.styleAttributes);
            } else {
                this.styleAttributes = null;
            }
            TagAction action = (TagAction)this.tagMap.get(t);
            if (action != null) {
                action.start(t, a);
            }
        }

        @Override
        public void handleComment(char[] data, int pos) {
            TagAction action;
            if (this.receivedEndHTML) {
                this.addExternalComment(new String(data));
                return;
            }
            if (this.inStyle) {
                if (this.styles != null) {
                    this.styles.addElement(new String(data));
                }
            } else if (MHTMLDocument.this.getPreservesUnknownTags()) {
                if (this.inBlock == 0 && (this.foundInsertTag || this.insertTag != MHTML.Tag.COMMENT)) {
                    this.addExternalComment(new String(data));
                    return;
                }
                SimpleAttributeSet sas = new SimpleAttributeSet();
                sas.addAttribute(MHTML.Attribute.COMMENT, new String(data));
                this.addSpecialElement(MHTML.Tag.COMMENT, sas);
            }
            if ((action = (TagAction)this.tagMap.get(MHTML.Tag.COMMENT)) != null) {
                action.start(MHTML.Tag.COMMENT, new SimpleAttributeSet());
                action.end(MHTML.Tag.COMMENT);
            }
        }

        private void addExternalComment(String comment) {
            Vector comments = MHTMLDocument.this.getProperty(MHTMLDocument.AdditionalComments);
            if (comments != null && !(comments instanceof Vector)) {
                return;
            }
            if (comments == null) {
                comments = new Vector();
                MHTMLDocument.this.putProperty(MHTMLDocument.AdditionalComments, comments);
            }
            ((Vector)comments).addElement(comment);
        }

        @Override
        public void handleEndTag(MHTML.Tag t, int pos) {
            TagAction action;
            if (this.receivedEndHTML || this.midInsert && !this.inBody) {
                return;
            }
            if (t == MHTML.Tag.HTML) {
                this.receivedEndHTML = true;
            }
            if (t == MHTML.Tag.BODY) {
                this.inBody = false;
                if (this.midInsert) {
                    --this.inBlock;
                }
            }
            if ((action = (TagAction)this.tagMap.get(t)) != null) {
                action.end(t);
            }
        }

        @Override
        public void handleSimpleTag(MHTML.Tag t, MutableAttributeSet a, int pos) {
            if (this.receivedEndHTML || this.midInsert && !this.inBody) {
                return;
            }
            if (this.isStyleCSS && a.isDefined(MHTML.Attribute.STYLE)) {
                String decl = (String)a.getAttribute(MHTML.Attribute.STYLE);
                a.removeAttribute(MHTML.Attribute.STYLE);
                this.styleAttributes = MHTMLDocument.this.getStyleSheet().getDeclaration(decl);
                a.addAttributes(this.styleAttributes);
            } else {
                this.styleAttributes = null;
            }
            TagAction action = (TagAction)this.tagMap.get(t);
            if (action != null) {
                action.start(t, a);
                action.end(t);
            } else if (MHTMLDocument.this.getPreservesUnknownTags()) {
                this.addSpecialElement(t, a);
            }
        }

        @Override
        public void handleEndOfLineString(String eol) {
            if (this.emptyDocument && eol != null) {
                MHTMLDocument.this.putProperty("__EndOfLine__", eol);
            }
        }

        protected void registerTag(MHTML.Tag t, TagAction a) {
            this.tagMap.put(t, a);
        }

        protected void pushCharacterStyle() {
            this.charAttrStack.push(this.charAttr.copyAttributes());
        }

        protected void popCharacterStyle() {
            if (!this.charAttrStack.empty()) {
                this.charAttr = (MutableAttributeSet)this.charAttrStack.peek();
                this.charAttrStack.pop();
            }
        }

        protected void textAreaContent(char[] data) {
            try {
                this.textAreaDocument.insertString(this.textAreaDocument.getLength(), new String(data), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        protected void preContent(char[] data) {
            int last = 0;
            int i = 0;
            while (i < data.length) {
                if (data[i] == '\n') {
                    this.addContent(data, last, i - last + 1);
                    this.blockClose(MHTML.Tag.IMPLIED);
                    SimpleAttributeSet a = new SimpleAttributeSet();
                    a.addAttribute(MCSS.Attribute.WHITE_SPACE, "pre");
                    this.blockOpen(MHTML.Tag.IMPLIED, a);
                    last = i + 1;
                }
                ++i;
            }
            if (last < data.length) {
                this.addContent(data, last, data.length - last);
            }
        }

        protected void blockOpen(MHTML.Tag t, MutableAttributeSet attr) {
            if (this.impliedP) {
                this.blockClose(MHTML.Tag.IMPLIED);
            }
            ++this.inBlock;
            if (!this.canInsertTag(t, attr, true)) {
                return;
            }
            if (attr.isDefined(IMPLIED)) {
                attr.removeAttribute(IMPLIED);
            }
            this.lastWasNewline = false;
            attr.addAttribute(StyleConstants.NameAttribute, t);
            DefaultStyledDocument.ElementSpec es = new DefaultStyledDocument.ElementSpec(attr.copyAttributes(), 1);
            this.parseBuffer.addElement(es);
        }

        protected void blockClose(MHTML.Tag t) {
            DefaultStyledDocument.ElementSpec prev;
            --this.inBlock;
            if (!this.foundInsertTag) {
                return;
            }
            if (!this.lastWasNewline) {
                this.pushCharacterStyle();
                this.charAttr.addAttribute(MHTMLDocument.IMPLIED_CR, Boolean.TRUE);
                this.addContent(NEWLINE, 0, 1, true);
                this.popCharacterStyle();
                this.lastWasNewline = true;
            }
            if (this.impliedP) {
                this.impliedP = false;
                this.inParagraph = false;
                if (t != MHTML.Tag.IMPLIED) {
                    this.blockClose(MHTML.Tag.IMPLIED);
                }
            }
            DefaultStyledDocument.ElementSpec elementSpec = prev = this.parseBuffer.size() > 0 ? this.parseBuffer.lastElement() : null;
            if (prev != null && prev.getType() == 1) {
                char[] one = new char[]{' '};
                this.addContent(one, 0, 1);
            }
            DefaultStyledDocument.ElementSpec es = new DefaultStyledDocument.ElementSpec(null, 2);
            this.parseBuffer.addElement(es);
        }

        protected void addContent(char[] data, int offs, int length) {
            this.addContent(data, offs, length, true);
        }

        protected void addContent(char[] data, int offs, int length, boolean generateImpliedPIfNecessary) {
            if (!this.foundInsertTag) {
                return;
            }
            if (generateImpliedPIfNecessary && !this.inParagraph && !this.inPre) {
                this.blockOpen(MHTML.Tag.IMPLIED, new SimpleAttributeSet());
                this.inParagraph = true;
                this.impliedP = true;
            }
            this.emptyAnchor = false;
            this.charAttr.addAttribute(StyleConstants.NameAttribute, MHTML.Tag.CONTENT);
            AttributeSet a = this.charAttr.copyAttributes();
            DefaultStyledDocument.ElementSpec es = new DefaultStyledDocument.ElementSpec(a, 3, data, offs, length);
            this.parseBuffer.addElement(es);
            if (this.parseBuffer.size() > this.threshold) {
                if (this.threshold <= 10000) {
                    this.threshold *= 5;
                }
                try {
                    this.flushBuffer(false);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (length > 0) {
                this.lastWasNewline = data[offs + length - 1] == '\n';
            }
        }

        protected void addSpecialElement(MHTML.Tag t, MutableAttributeSet a) {
            if (t != MHTML.Tag.FRAME && !this.inParagraph && !this.inPre) {
                this.nextTagAfterPImplied = t;
                this.blockOpen(MHTML.Tag.IMPLIED, new SimpleAttributeSet());
                this.nextTagAfterPImplied = null;
                this.inParagraph = true;
                this.impliedP = true;
            }
            if (!this.canInsertTag(t, a, t.isBlock())) {
                return;
            }
            if (a.isDefined(IMPLIED)) {
                a.removeAttribute(IMPLIED);
            }
            this.emptyAnchor = false;
            a.addAttributes(this.charAttr);
            a.addAttribute(StyleConstants.NameAttribute, t);
            char[] one = new char[]{' '};
            DefaultStyledDocument.ElementSpec es = new DefaultStyledDocument.ElementSpec(a.copyAttributes(), 3, one, 0, 1);
            this.parseBuffer.addElement(es);
            if (t == MHTML.Tag.FRAME) {
                this.lastWasNewline = true;
            }
        }

        void flushBuffer(boolean endOfStream) throws BadLocationException {
            int oldLength = MHTMLDocument.this.getLength();
            int size = this.parseBuffer.size();
            if (endOfStream && (this.insertTag != null || this.insertAfterImplied) && size > 0) {
                this.adjustEndSpecsForPartialInsert();
                size = this.parseBuffer.size();
            }
            Object[] spec = new DefaultStyledDocument.ElementSpec[size];
            this.parseBuffer.copyInto(spec);
            if (oldLength == 0 && this.insertTag == null && !this.insertAfterImplied) {
                MHTMLDocument.this.create((DefaultStyledDocument.ElementSpec[])spec);
            } else {
                MHTMLDocument.this.insert(this.offset, (DefaultStyledDocument.ElementSpec[])spec);
            }
            this.parseBuffer.removeAllElements();
            this.offset += MHTMLDocument.this.getLength() - oldLength;
            ++this.flushCount;
        }

        private void adjustEndSpecsForPartialInsert() {
            int size = this.parseBuffer.size();
            if (this.insertTagDepthDelta < 0) {
                int removeCounter = this.insertTagDepthDelta;
                while (removeCounter < 0 && size >= 0 && this.parseBuffer.elementAt(size - 1).getType() == 2) {
                    this.parseBuffer.removeElementAt(--size);
                    ++removeCounter;
                }
            }
            if (!(this.flushCount != 0 || this.insertAfterImplied && this.wantsTrailingNewline)) {
                int index = 0;
                if (this.pushDepth > 0 && this.parseBuffer.elementAt(0).getType() == 3) {
                    ++index;
                }
                int cCount = 0;
                int cStart = index += this.popDepth + this.pushDepth;
                while (index < size && this.parseBuffer.elementAt(index).getType() == 3) {
                    ++index;
                    ++cCount;
                }
                if (cCount > 1) {
                    char[] lastText;
                    while (index < size && this.parseBuffer.elementAt(index).getType() == 2) {
                        ++index;
                    }
                    if (index == size && (lastText = this.parseBuffer.elementAt(cStart + cCount - 1).getArray()).length == 1 && lastText[0] == NEWLINE[0]) {
                        index = cStart + cCount - 1;
                        while (size > index) {
                            this.parseBuffer.removeElementAt(--size);
                        }
                    }
                }
            }
            if (this.wantsTrailingNewline) {
                int counter = this.parseBuffer.size() - 1;
                while (counter >= 0) {
                    DefaultStyledDocument.ElementSpec spec = this.parseBuffer.elementAt(counter);
                    if (spec.getType() == 3) {
                        if (spec.getArray()[spec.getLength() - 1] == '\n') break;
                        SimpleAttributeSet attrs = new SimpleAttributeSet();
                        attrs.addAttribute(StyleConstants.NameAttribute, MHTML.Tag.CONTENT);
                        this.parseBuffer.insertElementAt(new DefaultStyledDocument.ElementSpec(attrs, 3, NEWLINE, 0, 1), counter + 1);
                        break;
                    }
                    --counter;
                }
            }
        }

        void addCSSRules(String rules) {
            MStyleSheet ss = MHTMLDocument.this.getStyleSheet();
            ss.addRule(rules);
        }

        void linkCSSStyleSheet(String href) {
            URL url = null;
            try {
                url = new URL(MHTMLDocument.this.base, href);
            }
            catch (MalformedURLException mfe) {
                try {
                    url = new URL(href);
                }
                catch (MalformedURLException mfe2) {
                    url = null;
                }
            }
            if (url != null) {
                MHTMLDocument.this.getStyleSheet().importStyleSheet(url);
            }
        }

        private boolean canInsertTag(MHTML.Tag t, AttributeSet attr, boolean isBlockTag) {
            if (!this.foundInsertTag) {
                boolean nextTagIsInsertTag;
                boolean needPImplied;
                boolean bl = needPImplied = t == MHTML.Tag.IMPLIED && !this.inParagraph && !this.inPre;
                if (needPImplied && this.nextTagAfterPImplied != null ? this.insertTag != null && (!(nextTagIsInsertTag = this.isInsertTag(this.nextTagAfterPImplied)) || !this.insertInsertTag) : this.insertTag != null && !this.isInsertTag(t) || this.insertAfterImplied && (attr == null || attr.isDefined(IMPLIED) || t == MHTML.Tag.IMPLIED)) {
                    return false;
                }
                this.foundInsertTag(isBlockTag);
                if (!this.insertInsertTag) {
                    return false;
                }
            }
            return true;
        }

        private boolean isInsertTag(MHTML.Tag tag) {
            return this.insertTag == tag;
        }

        private void foundInsertTag(boolean isBlockTag) {
            this.foundInsertTag = true;
            if (!(this.insertAfterImplied || this.popDepth <= 0 && this.pushDepth <= 0)) {
                try {
                    if (this.offset == 0 || !MHTMLDocument.this.getText(this.offset - 1, 1).equals("\n")) {
                        SimpleAttributeSet newAttrs = null;
                        boolean joinP = true;
                        if (this.offset != 0) {
                            Element charElement = MHTMLDocument.this.getCharacterElement(this.offset - 1);
                            AttributeSet attrs = charElement.getAttributes();
                            if (attrs.isDefined(StyleConstants.ComposedTextAttribute)) {
                                joinP = false;
                            } else {
                                MHTML.Tag tag;
                                Object name = attrs.getAttribute(StyleConstants.NameAttribute);
                                if (name instanceof MHTML.Tag && ((tag = (MHTML.Tag)name) == MHTML.Tag.IMG || tag == MHTML.Tag.HR || tag == MHTML.Tag.COMMENT || tag instanceof MHTML.UnknownTag)) {
                                    joinP = false;
                                }
                            }
                        }
                        if (!joinP) {
                            newAttrs = new SimpleAttributeSet();
                            newAttrs.addAttribute(StyleConstants.NameAttribute, MHTML.Tag.CONTENT);
                        }
                        DefaultStyledDocument.ElementSpec es = new DefaultStyledDocument.ElementSpec(newAttrs, 3, NEWLINE, 0, NEWLINE.length);
                        if (joinP) {
                            es.setDirection((short)4);
                        }
                        this.parseBuffer.addElement(es);
                    }
                }
                catch (BadLocationException newAttrs) {
                    // empty catch block
                }
            }
            int counter = 0;
            while (counter < this.popDepth) {
                this.parseBuffer.addElement(new DefaultStyledDocument.ElementSpec(null, 2));
                ++counter;
            }
            counter = 0;
            while (counter < this.pushDepth) {
                DefaultStyledDocument.ElementSpec es = new DefaultStyledDocument.ElementSpec(null, 1);
                es.setDirection((short)5);
                this.parseBuffer.addElement(es);
                ++counter;
            }
            this.insertTagDepthDelta = this.depthTo(Math.max(0, this.offset - 1)) - this.popDepth + this.pushDepth - this.inBlock;
            if (isBlockTag) {
                ++this.insertTagDepthDelta;
            } else {
                --this.insertTagDepthDelta;
                this.inParagraph = true;
                this.lastWasNewline = false;
            }
        }

        class AnchorAction
        extends CharacterAction {
            AnchorAction() {
            }

            @Override
            public void start(MHTML.Tag t, MutableAttributeSet attr) {
                HTMLReader.this.emptyAnchor = true;
                super.start(t, attr);
            }

            @Override
            public void end(MHTML.Tag t) {
                if (HTMLReader.this.emptyAnchor) {
                    char[] one = new char[]{'\n'};
                    HTMLReader.this.addContent(one, 0, 1);
                }
                super.end(t);
            }
        }

        class AreaAction
        extends TagAction {
            AreaAction() {
            }

            @Override
            public void start(MHTML.Tag t, MutableAttributeSet a) {
                if (HTMLReader.this.lastMap != null) {
                    HTMLReader.this.lastMap.addArea(a.copyAttributes());
                }
            }

            @Override
            public void end(MHTML.Tag t) {
            }
        }

        class BaseAction
        extends TagAction {
            BaseAction() {
            }

            @Override
            public void start(MHTML.Tag t, MutableAttributeSet attr) {
                String href = (String)attr.getAttribute(MHTML.Attribute.HREF);
                if (href != null) {
                    try {
                        URL newBase = new URL(((HTMLReader)HTMLReader.this).MHTMLDocument.this.base, href);
                        MHTMLDocument.this.setBase(newBase);
                        ((HTMLReader)HTMLReader.this).MHTMLDocument.this.hasBaseTag = true;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                MHTMLDocument.this.baseTarget = (String)attr.getAttribute(MHTML.Attribute.TARGET);
            }
        }

        public class BlockAction
        extends TagAction {
            @Override
            public void start(MHTML.Tag t, MutableAttributeSet attr) {
                HTMLReader.this.blockOpen(t, attr);
            }

            @Override
            public void end(MHTML.Tag t) {
                HTMLReader.this.blockClose(t);
            }
        }

        public class CharacterAction
        extends TagAction {
            @Override
            public void start(MHTML.Tag t, MutableAttributeSet attr) {
                HTMLReader.this.pushCharacterStyle();
                if (!HTMLReader.this.foundInsertTag) {
                    boolean insert = HTMLReader.this.canInsertTag(t, attr, false);
                    if (HTMLReader.this.foundInsertTag && !HTMLReader.this.inParagraph) {
                        HTMLReader.this.impliedP = true;
                        HTMLReader.this.inParagraph = true;
                    }
                    if (!insert) {
                        return;
                    }
                }
                if (attr.isDefined(IMPLIED)) {
                    attr.removeAttribute(IMPLIED);
                }
                HTMLReader.this.charAttr.addAttribute(t, attr.copyAttributes());
                if (HTMLReader.this.styleAttributes != null) {
                    HTMLReader.this.charAttr.addAttributes(HTMLReader.this.styleAttributes);
                }
            }

            @Override
            public void end(MHTML.Tag t) {
                HTMLReader.this.popCharacterStyle();
            }
        }

        class ConvertAction
        extends TagAction {
            ConvertAction() {
            }

            @Override
            public void start(MHTML.Tag t, MutableAttributeSet attr) {
                HTMLReader.this.pushCharacterStyle();
                if (!HTMLReader.this.foundInsertTag) {
                    boolean insert = HTMLReader.this.canInsertTag(t, attr, false);
                    if (HTMLReader.this.foundInsertTag && !HTMLReader.this.inParagraph) {
                        HTMLReader.this.impliedP = true;
                        HTMLReader.this.inParagraph = true;
                    }
                    if (!insert) {
                        return;
                    }
                }
                if (attr.isDefined(IMPLIED)) {
                    attr.removeAttribute(IMPLIED);
                }
                if (HTMLReader.this.styleAttributes != null) {
                    HTMLReader.this.charAttr.addAttributes(HTMLReader.this.styleAttributes);
                }
                HTMLReader.this.charAttr.addAttribute(t, attr.copyAttributes());
                MStyleSheet sheet = MHTMLDocument.this.getStyleSheet();
                if (t == MHTML.Tag.B) {
                    sheet.addCSSAttribute(HTMLReader.this.charAttr, MCSS.Attribute.FONT_WEIGHT, "bold");
                } else if (t == MHTML.Tag.I) {
                    sheet.addCSSAttribute(HTMLReader.this.charAttr, MCSS.Attribute.FONT_STYLE, "italic");
                } else if (t == MHTML.Tag.U) {
                    Object v = HTMLReader.this.charAttr.getAttribute(MCSS.Attribute.TEXT_DECORATION);
                    String value = "underline";
                    value = v != null ? String.valueOf(value) + "," + v.toString() : value;
                    sheet.addCSSAttribute(HTMLReader.this.charAttr, MCSS.Attribute.TEXT_DECORATION, value);
                } else if (t == MHTML.Tag.STRIKE) {
                    Object v = HTMLReader.this.charAttr.getAttribute(MCSS.Attribute.TEXT_DECORATION);
                    String value = "line-through";
                    value = v != null ? String.valueOf(value) + "," + v.toString() : value;
                    sheet.addCSSAttribute(HTMLReader.this.charAttr, MCSS.Attribute.TEXT_DECORATION, value);
                } else if (t == MHTML.Tag.SUP) {
                    Object v = HTMLReader.this.charAttr.getAttribute(MCSS.Attribute.VERTICAL_ALIGN);
                    String value = "sup";
                    value = v != null ? String.valueOf(value) + "," + v.toString() : value;
                    sheet.addCSSAttribute(HTMLReader.this.charAttr, MCSS.Attribute.VERTICAL_ALIGN, value);
                } else if (t == MHTML.Tag.SUB) {
                    Object v = HTMLReader.this.charAttr.getAttribute(MCSS.Attribute.VERTICAL_ALIGN);
                    String value = "sub";
                    value = v != null ? String.valueOf(value) + "," + v.toString() : value;
                    sheet.addCSSAttribute(HTMLReader.this.charAttr, MCSS.Attribute.VERTICAL_ALIGN, value);
                } else if (t == MHTML.Tag.FONT) {
                    String size;
                    String face;
                    String color = (String)attr.getAttribute(MHTML.Attribute.COLOR);
                    if (color != null) {
                        sheet.addCSSAttribute(HTMLReader.this.charAttr, MCSS.Attribute.COLOR, color);
                    }
                    if ((face = (String)attr.getAttribute(MHTML.Attribute.FACE)) != null) {
                        sheet.addCSSAttribute(HTMLReader.this.charAttr, MCSS.Attribute.FONT_FAMILY, face);
                    }
                    if ((size = (String)attr.getAttribute(MHTML.Attribute.SIZE)) != null) {
                        sheet.addCSSAttributeFromHTML(HTMLReader.this.charAttr, MCSS.Attribute.FONT_SIZE, size);
                    }
                }
            }

            @Override
            public void end(MHTML.Tag t) {
                HTMLReader.this.popCharacterStyle();
            }
        }

        public class FormAction
        extends SpecialAction {
            Object selectModel;
            int optionCount;

            @Override
            public void start(MHTML.Tag t, MutableAttributeSet attr) {
                if (t == MHTML.Tag.INPUT) {
                    String type = (String)attr.getAttribute(MHTML.Attribute.TYPE);
                    if (type == null) {
                        type = "text";
                        attr.addAttribute(MHTML.Attribute.TYPE, "text");
                    }
                    this.setModel(type, attr);
                } else if (t == MHTML.Tag.TEXTAREA) {
                    HTMLReader.this.inTextArea = true;
                    HTMLReader.this.textAreaDocument = new MTextAreaDocument();
                    attr.addAttribute(StyleConstants.ModelAttribute, HTMLReader.this.textAreaDocument);
                } else if (t == MHTML.Tag.SELECT) {
                    boolean multiple;
                    int size = MHTML.getIntegerAttributeValue(attr, MHTML.Attribute.SIZE, 1);
                    boolean bl = multiple = (String)attr.getAttribute(MHTML.Attribute.MULTIPLE) != null;
                    if (size > 1 || multiple) {
                        MOptionListModel m = new MOptionListModel();
                        if (multiple) {
                            m.setSelectionMode(2);
                        }
                        this.selectModel = m;
                    } else {
                        this.selectModel = new MOptionComboBoxModel();
                    }
                    attr.addAttribute(StyleConstants.ModelAttribute, this.selectModel);
                }
                if (t == MHTML.Tag.OPTION) {
                    HTMLReader.this.option = new MOption(attr);
                    if (this.selectModel instanceof MOptionListModel) {
                        MOptionListModel m = (MOptionListModel)this.selectModel;
                        m.addElement(HTMLReader.this.option);
                        if (HTMLReader.this.option.isSelected()) {
                            m.addSelectionInterval(this.optionCount, this.optionCount);
                            m.setInitialSelection(this.optionCount);
                        }
                    } else if (this.selectModel instanceof MOptionComboBoxModel) {
                        MOptionComboBoxModel m = (MOptionComboBoxModel)this.selectModel;
                        m.addElement(HTMLReader.this.option);
                        if (HTMLReader.this.option.isSelected()) {
                            m.setSelectedItem(HTMLReader.this.option);
                            m.setInitialSelection(HTMLReader.this.option);
                        }
                    }
                    ++this.optionCount;
                } else {
                    super.start(t, attr);
                }
            }

            @Override
            public void end(MHTML.Tag t) {
                if (t == MHTML.Tag.OPTION) {
                    HTMLReader.this.option = null;
                } else {
                    if (t == MHTML.Tag.SELECT) {
                        this.selectModel = null;
                        this.optionCount = 0;
                    } else if (t == MHTML.Tag.TEXTAREA) {
                        HTMLReader.this.inTextArea = false;
                        HTMLReader.this.textAreaDocument.storeInitialText();
                    }
                    super.end(t);
                }
            }

            void setModel(String type, MutableAttributeSet attr) {
                if (type.equals("submit") || type.equals("reset") || type.equals("image")) {
                    attr.addAttribute(StyleConstants.ModelAttribute, new DefaultButtonModel());
                } else if (type.equals("text") || type.equals("password")) {
                    int maxLength = MHTML.getIntegerAttributeValue(attr, MHTML.Attribute.MAXLENGTH, -1);
                    PlainDocument doc = maxLength > 0 ? new FixedLengthDocument(maxLength) : new PlainDocument();
                    String value = (String)attr.getAttribute(MHTML.Attribute.VALUE);
                    try {
                        doc.insertString(0, value, null);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    attr.addAttribute(StyleConstants.ModelAttribute, doc);
                } else if (type.equals("file")) {
                    attr.addAttribute(StyleConstants.ModelAttribute, new PlainDocument());
                } else if (type.equals("checkbox") || type.equals("radio")) {
                    JToggleButton.ToggleButtonModel model = new JToggleButton.ToggleButtonModel();
                    if (type.equals("radio")) {
                        ButtonGroup radioButtonGroup;
                        String name = (String)attr.getAttribute(MHTML.Attribute.NAME);
                        if (MHTMLDocument.this.radioButtonGroupsMap == null) {
                            MHTMLDocument.this.radioButtonGroupsMap = new HashMap();
                        }
                        if ((radioButtonGroup = (ButtonGroup)MHTMLDocument.this.radioButtonGroupsMap.get(name)) == null) {
                            radioButtonGroup = new ButtonGroup();
                            MHTMLDocument.this.radioButtonGroupsMap.put(name, radioButtonGroup);
                        }
                        model.setGroup(radioButtonGroup);
                    }
                    boolean checked = attr.getAttribute(MHTML.Attribute.CHECKED) != null;
                    model.setSelected(checked);
                    attr.addAttribute(StyleConstants.ModelAttribute, model);
                }
            }
        }

        private class FormTagAction
        extends BlockAction {
            private FormTagAction() {
            }

            @Override
            public void start(MHTML.Tag t, MutableAttributeSet attr) {
                super.start(t, attr);
                MHTMLDocument.this.radioButtonGroupsMap = new HashMap();
            }

            @Override
            public void end(MHTML.Tag t) {
                super.end(t);
                MHTMLDocument.this.radioButtonGroupsMap = null;
            }
        }

        class HeadAction
        extends BlockAction {
            HeadAction() {
            }

            @Override
            public void start(MHTML.Tag t, MutableAttributeSet a) {
                HTMLReader.this.inHead = true;
                if (HTMLReader.this.insertTag == null && !HTMLReader.this.insertAfterImplied || HTMLReader.this.insertTag == MHTML.Tag.HEAD || HTMLReader.this.insertAfterImplied && (HTMLReader.this.foundInsertTag || !a.isDefined(IMPLIED))) {
                    super.start(t, a);
                }
            }

            @Override
            public void end(MHTML.Tag t) {
                HTMLReader.this.inStyle = false;
                HTMLReader.this.inHead = false;
                if (HTMLReader.this.styles != null) {
                    boolean isDefaultCSS = HTMLReader.this.isStyleCSS;
                    int counter = 0;
                    int maxCounter = HTMLReader.this.styles.size();
                    while (counter < maxCounter) {
                        String type;
                        Object value = HTMLReader.this.styles.elementAt(counter);
                        if (value == MHTML.Tag.LINK) {
                            this.handleLink((AttributeSet)HTMLReader.this.styles.elementAt(++counter));
                            ++counter;
                            continue;
                        }
                        boolean isCSS = (type = (String)HTMLReader.this.styles.elementAt(++counter)) == null ? isDefaultCSS : type.equals("text/css");
                        while (++counter < maxCounter && HTMLReader.this.styles.elementAt(counter) instanceof String) {
                            if (!isCSS) continue;
                            HTMLReader.this.addCSSRules((String)HTMLReader.this.styles.elementAt(counter));
                        }
                    }
                }
                if (HTMLReader.this.insertTag == null && !HTMLReader.this.insertAfterImplied || HTMLReader.this.insertTag == MHTML.Tag.HEAD || HTMLReader.this.insertAfterImplied && HTMLReader.this.foundInsertTag) {
                    super.end(t);
                }
            }

            boolean isEmpty(MHTML.Tag t) {
                return false;
            }

            private void handleLink(AttributeSet attr) {
                String type = (String)attr.getAttribute(MHTML.Attribute.TYPE);
                if (type == null) {
                    type = MHTMLDocument.this.getDefaultStyleSheetType();
                }
                if (type.equals("text/css")) {
                    String rel = (String)attr.getAttribute(MHTML.Attribute.REL);
                    String title = (String)attr.getAttribute(MHTML.Attribute.TITLE);
                    String media = (String)attr.getAttribute(MHTML.Attribute.MEDIA);
                    media = media == null ? "all" : media.toLowerCase();
                    if (rel != null) {
                        rel = rel.toLowerCase();
                        if ((media.indexOf("all") != -1 || media.indexOf("screen") != -1) && (rel.equals("stylesheet") || rel.equals("alternate stylesheet") && title.equals(HTMLReader.this.defaultStyle))) {
                            HTMLReader.this.linkCSSStyleSheet((String)attr.getAttribute(MHTML.Attribute.HREF));
                        }
                    }
                }
            }
        }

        public class HiddenAction
        extends TagAction {
            @Override
            public void start(MHTML.Tag t, MutableAttributeSet a) {
                HTMLReader.this.addSpecialElement(t, a);
            }

            @Override
            public void end(MHTML.Tag t) {
                if (!this.isEmpty(t)) {
                    SimpleAttributeSet a = new SimpleAttributeSet();
                    a.addAttribute(MHTML.Attribute.ENDTAG, "true");
                    HTMLReader.this.addSpecialElement(t, a);
                }
            }

            boolean isEmpty(MHTML.Tag t) {
                return t != MHTML.Tag.APPLET && t != MHTML.Tag.SCRIPT;
            }
        }

        public class IsindexAction
        extends TagAction {
            @Override
            public void start(MHTML.Tag t, MutableAttributeSet a) {
                HTMLReader.this.blockOpen(MHTML.Tag.IMPLIED, new SimpleAttributeSet());
                HTMLReader.this.addSpecialElement(t, a);
                HTMLReader.this.blockClose(MHTML.Tag.IMPLIED);
            }
        }

        class LinkAction
        extends HiddenAction {
            LinkAction() {
            }

            @Override
            public void start(MHTML.Tag t, MutableAttributeSet a) {
                String rel = (String)a.getAttribute(MHTML.Attribute.REL);
                if (rel != null && ((rel = rel.toLowerCase()).equals("stylesheet") || rel.equals("alternate stylesheet"))) {
                    if (HTMLReader.this.styles == null) {
                        HTMLReader.this.styles = new Vector(3);
                    }
                    HTMLReader.this.styles.addElement(t);
                    HTMLReader.this.styles.addElement(a.copyAttributes());
                }
                super.start(t, a);
            }
        }

        class MapAction
        extends TagAction {
            MapAction() {
            }

            @Override
            public void start(MHTML.Tag t, MutableAttributeSet a) {
                HTMLReader.this.lastMap = new MMap((String)a.getAttribute(MHTML.Attribute.NAME));
                MHTMLDocument.this.addMap(HTMLReader.this.lastMap);
            }

            @Override
            public void end(MHTML.Tag t) {
            }
        }

        class MetaAction
        extends HiddenAction {
            MetaAction() {
            }

            @Override
            public void start(MHTML.Tag t, MutableAttributeSet a) {
                Object equiv = a.getAttribute(MHTML.Attribute.HTTPEQUIV);
                if (equiv != null) {
                    if ((equiv = ((String)equiv).toLowerCase()).equals("content-style-type")) {
                        String value = (String)a.getAttribute(MHTML.Attribute.CONTENT);
                        MHTMLDocument.this.setDefaultStyleSheetType(value);
                        HTMLReader.this.isStyleCSS = "text/css".equals(MHTMLDocument.this.getDefaultStyleSheetType());
                    } else if (equiv.equals("default-style")) {
                        HTMLReader.this.defaultStyle = (String)a.getAttribute(MHTML.Attribute.CONTENT);
                    }
                }
                super.start(t, a);
            }

            @Override
            boolean isEmpty(MHTML.Tag t) {
                return true;
            }
        }

        class ObjectAction
        extends SpecialAction {
            ObjectAction() {
            }

            @Override
            public void start(MHTML.Tag t, MutableAttributeSet a) {
                if (t == MHTML.Tag.PARAM) {
                    this.addParameter(a);
                } else {
                    super.start(t, a);
                }
            }

            @Override
            public void end(MHTML.Tag t) {
                if (t != MHTML.Tag.PARAM) {
                    super.end(t);
                }
            }

            void addParameter(AttributeSet a) {
                String name = (String)a.getAttribute(MHTML.Attribute.NAME);
                String value = (String)a.getAttribute(MHTML.Attribute.VALUE);
                if (name != null && value != null) {
                    DefaultStyledDocument.ElementSpec objSpec = HTMLReader.this.parseBuffer.lastElement();
                    MutableAttributeSet objAttr = (MutableAttributeSet)objSpec.getAttributes();
                    objAttr.addAttribute(name, value);
                }
            }
        }

        public class ParagraphAction
        extends BlockAction {
            @Override
            public void start(MHTML.Tag t, MutableAttributeSet a) {
                super.start(t, a);
                HTMLReader.this.inParagraph = true;
            }

            @Override
            public void end(MHTML.Tag t) {
                super.end(t);
                HTMLReader.this.inParagraph = false;
            }
        }

        public class PreAction
        extends BlockAction {
            @Override
            public void start(MHTML.Tag t, MutableAttributeSet attr) {
                HTMLReader.this.inPre = true;
                HTMLReader.this.blockOpen(t, attr);
                attr.addAttribute(MCSS.Attribute.WHITE_SPACE, "pre");
                HTMLReader.this.blockOpen(MHTML.Tag.IMPLIED, attr);
            }

            @Override
            public void end(MHTML.Tag t) {
                HTMLReader.this.blockClose(MHTML.Tag.IMPLIED);
                HTMLReader.this.inPre = false;
                HTMLReader.this.blockClose(t);
            }
        }

        public class SpecialAction
        extends TagAction {
            @Override
            public void start(MHTML.Tag t, MutableAttributeSet a) {
                HTMLReader.this.addSpecialElement(t, a);
            }
        }

        class StyleAction
        extends TagAction {
            StyleAction() {
            }

            @Override
            public void start(MHTML.Tag t, MutableAttributeSet a) {
                if (HTMLReader.this.inHead) {
                    if (HTMLReader.this.styles == null) {
                        HTMLReader.this.styles = new Vector(3);
                    }
                    HTMLReader.this.styles.addElement(t);
                    HTMLReader.this.styles.addElement(a.getAttribute(MHTML.Attribute.TYPE));
                    HTMLReader.this.inStyle = true;
                }
            }

            @Override
            public void end(MHTML.Tag t) {
                HTMLReader.this.inStyle = false;
            }

            boolean isEmpty(MHTML.Tag t) {
                return false;
            }
        }

        public class TagAction {
            public void start(MHTML.Tag t, MutableAttributeSet a) {
            }

            public void end(MHTML.Tag t) {
            }
        }

        class TitleAction
        extends HiddenAction {
            TitleAction() {
            }

            @Override
            public void start(MHTML.Tag t, MutableAttributeSet attr) {
                HTMLReader.this.inTitle = true;
                super.start(t, attr);
            }

            @Override
            public void end(MHTML.Tag t) {
                HTMLReader.this.inTitle = false;
                super.end(t);
            }

            @Override
            boolean isEmpty(MHTML.Tag t) {
                return false;
            }
        }
    }

    public static abstract class Iterator {
        public abstract AttributeSet getAttributes();

        public abstract int getStartOffset();

        public abstract int getEndOffset();

        public abstract void next();

        public abstract boolean isValid();

        public abstract MHTML.Tag getTag();
    }

    static class LeafIterator
    extends Iterator {
        private int endOffset;
        private MHTML.Tag tag;
        private ElementIterator pos;

        LeafIterator(MHTML.Tag t, Document doc) {
            this.tag = t;
            this.pos = new ElementIterator(doc);
            this.endOffset = 0;
            this.next();
        }

        @Override
        public AttributeSet getAttributes() {
            Element elem = this.pos.current();
            if (elem != null) {
                AttributeSet a = (AttributeSet)elem.getAttributes().getAttribute(this.tag);
                if (a == null) {
                    a = elem.getAttributes();
                }
                return a;
            }
            return null;
        }

        @Override
        public int getStartOffset() {
            Element elem = this.pos.current();
            if (elem != null) {
                return elem.getStartOffset();
            }
            return -1;
        }

        @Override
        public int getEndOffset() {
            return this.endOffset;
        }

        @Override
        public void next() {
            this.nextLeaf(this.pos);
            while (this.isValid()) {
                AttributeSet a;
                Element elem = this.pos.current();
                if (elem.getStartOffset() >= this.endOffset && ((a = this.pos.current().getAttributes()).isDefined(this.tag) || a.getAttribute(StyleConstants.NameAttribute) == this.tag)) {
                    this.setEndOffset();
                    break;
                }
                this.nextLeaf(this.pos);
            }
        }

        @Override
        public MHTML.Tag getTag() {
            return this.tag;
        }

        @Override
        public boolean isValid() {
            return this.pos.current() != null;
        }

        void nextLeaf(ElementIterator iter) {
            iter.next();
            while (iter.current() != null) {
                Element e = iter.current();
                if (e.isLeaf()) break;
                iter.next();
            }
        }

        void setEndOffset() {
            AttributeSet a0 = this.getAttributes();
            this.endOffset = this.pos.current().getEndOffset();
            ElementIterator fwd = (ElementIterator)this.pos.clone();
            this.nextLeaf(fwd);
            while (fwd.current() != null) {
                Element e = fwd.current();
                AttributeSet a1 = (AttributeSet)e.getAttributes().getAttribute(this.tag);
                if (a1 == null || !a1.equals(a0)) break;
                this.endOffset = e.getEndOffset();
                this.nextLeaf(fwd);
            }
        }
    }

    public class RunElement
    extends AbstractDocument.LeafElement {
        public RunElement(Element parent, AttributeSet a, int offs0, int offs1) {
            super(MHTMLDocument.this, parent, a, offs0, offs1);
        }

        @Override
        public String getName() {
            Object o = this.getAttribute(StyleConstants.NameAttribute);
            if (o != null) {
                return o.toString();
            }
            return super.getName();
        }

        @Override
        public AttributeSet getResolveParent() {
            return null;
        }
    }

    static class TaggedAttributeSet
    extends SimpleAttributeSet {
        TaggedAttributeSet() {
        }
    }
}

