/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text.html;

import com.mongol.swing.text.MEditorBoxView;
import com.mongol.swing.text.MLabelView;
import com.mongol.swing.text.html.IsindexView;
import com.mongol.swing.text.html.MAccessibleHTML;
import com.mongol.swing.text.html.MBRView;
import com.mongol.swing.text.html.MBlockView;
import com.mongol.swing.text.html.MCSS;
import com.mongol.swing.text.html.MCommentView;
import com.mongol.swing.text.html.MFormView;
import com.mongol.swing.text.html.MFrameSetView;
import com.mongol.swing.text.html.MFrameView;
import com.mongol.swing.text.html.MHRuleView;
import com.mongol.swing.text.html.MHTML;
import com.mongol.swing.text.html.MHTMLDocument;
import com.mongol.swing.text.html.MHTMLFrameHyperlinkEvent;
import com.mongol.swing.text.html.MHTMLWriter;
import com.mongol.swing.text.html.MHiddenTagView;
import com.mongol.swing.text.html.MImageView;
import com.mongol.swing.text.html.MInlineView;
import com.mongol.swing.text.html.MLineView;
import com.mongol.swing.text.html.MListView;
import com.mongol.swing.text.html.MMap;
import com.mongol.swing.text.html.MMinimalHTMLWriter;
import com.mongol.swing.text.html.MNoFramesView;
import com.mongol.swing.text.html.MObjectView;
import com.mongol.swing.text.html.MParagraphView;
import com.mongol.swing.text.html.MResourceLoader;
import com.mongol.swing.text.html.MStyleSheet;
import com.mongol.swing.text.html.MTableView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.SizeRequirements;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Highlighter;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class MHTMLEditorKit
extends StyledEditorKit
implements Accessible {
    private JEditorPane theEditor;
    public static final String DEFAULT_CSS = "default.css";
    private AccessibleContext accessibleContext;
    private static final Cursor MoveCursor = Cursor.getPredefinedCursor(12);
    private static final Cursor DefaultCursor = Cursor.getPredefinedCursor(0);
    private static final ViewFactory defaultFactory = new MHTMLFactory();
    MutableAttributeSet input;
    private static MStyleSheet defaultStyles = null;
    private LinkController linkHandler = new LinkController();
    private static Parser defaultParser = null;
    private Cursor defaultCursor = DefaultCursor;
    private Cursor linkCursor = MoveCursor;
    private boolean isAutoFormSubmission = true;
    public static final String BOLD_ACTION = "html-bold-action";
    public static final String ITALIC_ACTION = "html-italic-action";
    public static final String PARA_INDENT_LEFT = "html-para-indent-left";
    public static final String PARA_INDENT_RIGHT = "html-para-indent-right";
    public static final String FONT_CHANGE_BIGGER = "html-font-bigger";
    public static final String FONT_CHANGE_SMALLER = "html-font-smaller";
    public static final String COLOR_ACTION = "html-color-action";
    public static final String LOGICAL_STYLE_ACTION = "html-logical-style-action";
    public static final String IMG_ALIGN_TOP = "html-image-align-top";
    public static final String IMG_ALIGN_MIDDLE = "html-image-align-middle";
    public static final String IMG_ALIGN_BOTTOM = "html-image-align-bottom";
    public static final String IMG_BORDER = "html-image-border";
    private static final String INSERT_TABLE_HTML = "<table border=1><tr><td></td></tr></table>";
    private static final String INSERT_UL_HTML = "<ul><li></li></ul>";
    private static final String INSERT_OL_HTML = "<ol><li></li></ol>";
    private static final String INSERT_HR_HTML = "<hr>";
    private static final String INSERT_PRE_HTML = "<pre></pre>";
    private static NavigateLinkAction nextLinkAction = new NavigateLinkAction("next-link-action");
    private static NavigateLinkAction previousLinkAction = new NavigateLinkAction("previous-link-action");
    private static ActivateLinkAction activateLinkAction = new ActivateLinkAction("activate-link-action");
    private static final Action[] defaultActions = new Action[]{new InsertHTMLTextAction("InsertTable", "<table border=1><tr><td></td></tr></table>", MHTML.Tag.BODY, MHTML.Tag.TABLE), new InsertHTMLTextAction("InsertTableRow", "<table border=1><tr><td></td></tr></table>", MHTML.Tag.TABLE, MHTML.Tag.TR, MHTML.Tag.BODY, MHTML.Tag.TABLE), new InsertHTMLTextAction("InsertTableDataCell", "<table border=1><tr><td></td></tr></table>", MHTML.Tag.TR, MHTML.Tag.TD, MHTML.Tag.BODY, MHTML.Tag.TABLE), new InsertHTMLTextAction("InsertUnorderedList", "<ul><li></li></ul>", MHTML.Tag.BODY, MHTML.Tag.UL), new InsertHTMLTextAction("InsertUnorderedListItem", "<ul><li></li></ul>", MHTML.Tag.UL, MHTML.Tag.LI, MHTML.Tag.BODY, MHTML.Tag.UL), new InsertHTMLTextAction("InsertOrderedList", "<ol><li></li></ol>", MHTML.Tag.BODY, MHTML.Tag.OL), new InsertHTMLTextAction("InsertOrderedListItem", "<ol><li></li></ol>", MHTML.Tag.OL, MHTML.Tag.LI, MHTML.Tag.BODY, MHTML.Tag.OL), new InsertHRAction(), new InsertHTMLTextAction("InsertPre", "<pre></pre>", MHTML.Tag.BODY, MHTML.Tag.PRE), nextLinkAction, previousLinkAction, activateLinkAction, new BeginAction("caret-begin", false), new BeginAction("selection-begin", true)};

    @Override
    public String getContentType() {
        return "text/html";
    }

    @Override
    public ViewFactory getViewFactory() {
        return defaultFactory;
    }

    @Override
    public Document createDefaultDocument() {
        MStyleSheet styles = this.getStyleSheet();
        MStyleSheet ss = new MStyleSheet();
        ss.addStyleSheet(styles);
        MHTMLDocument doc = new MHTMLDocument(ss);
        doc.setParser(this.getParser());
        doc.setAsynchronousLoadPriority(4);
        doc.setTokenThreshold(100);
        return doc;
    }

    @Override
    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        if (doc instanceof MHTMLDocument) {
            MHTMLDocument hdoc = (MHTMLDocument)doc;
            Parser p = this.getParser();
            if (p == null) {
                throw new IOException("Can't load parser");
            }
            if (pos > doc.getLength()) {
                throw new BadLocationException("Invalid location", pos);
            }
            ParserCallback receiver = hdoc.getReader(pos);
            Boolean ignoreCharset = (Boolean)doc.getProperty("IgnoreCharsetDirective");
            p.parse(in, receiver, ignoreCharset == null ? false : ignoreCharset);
            receiver.flush();
        } else {
            super.read(in, doc, pos);
        }
    }

    public void insertHTML(MHTMLDocument doc, int offset, String html, int popDepth, int pushDepth, MHTML.Tag insertTag) throws BadLocationException, IOException {
        Parser p = this.getParser();
        if (p == null) {
            throw new IOException("Can't load parser");
        }
        if (offset > doc.getLength()) {
            throw new BadLocationException("Invalid location", offset);
        }
        ParserCallback receiver = doc.getReader(offset, popDepth, pushDepth, insertTag);
        Boolean ignoreCharset = (Boolean)doc.getProperty("IgnoreCharsetDirective");
        p.parse(new StringReader(html), receiver, ignoreCharset == null ? false : ignoreCharset);
        receiver.flush();
    }

    @Override
    public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
        if (doc instanceof MHTMLDocument) {
            MHTMLWriter w = new MHTMLWriter(out, (MHTMLDocument)doc, pos, len);
            w.write();
        } else if (doc instanceof StyledDocument) {
            MMinimalHTMLWriter w = new MMinimalHTMLWriter(out, (StyledDocument)doc, pos, len);
            w.write();
        } else {
            super.write(out, doc, pos, len);
        }
    }

    @Override
    public void install(JEditorPane c) {
        c.addMouseListener(this.linkHandler);
        c.addMouseMotionListener(this.linkHandler);
        c.addCaretListener(nextLinkAction);
        super.install(c);
        this.theEditor = c;
    }

    @Override
    public void deinstall(JEditorPane c) {
        c.removeMouseListener(this.linkHandler);
        c.removeMouseMotionListener(this.linkHandler);
        c.removeCaretListener(nextLinkAction);
        super.deinstall(c);
        this.theEditor = null;
    }

    public void setStyleSheet(MStyleSheet s) {
        defaultStyles = s;
    }

    public MStyleSheet getStyleSheet() {
        if (defaultStyles == null) {
            defaultStyles = new MStyleSheet();
            try {
                InputStream is = MHTMLEditorKit.getResourceAsStream(DEFAULT_CSS);
                BufferedReader r = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
                defaultStyles.loadRules(r, null);
                ((Reader)r).close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultStyles;
    }

    static InputStream getResourceAsStream(String name) {
        try {
            return MResourceLoader.getResourceAsStream(name);
        }
        catch (Throwable e) {
            return MHTMLEditorKit.class.getResourceAsStream(name);
        }
    }

    @Override
    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    @Override
    protected void createInputAttributes(Element element, MutableAttributeSet set) {
        set.removeAttributes(set);
        set.addAttributes(element.getAttributes());
        set.removeAttribute(StyleConstants.ComposedTextAttribute);
        Object o = set.getAttribute(StyleConstants.NameAttribute);
        if (o instanceof MHTML.Tag) {
            MHTML.Tag tag = (MHTML.Tag)o;
            if (tag == MHTML.Tag.IMG) {
                set.removeAttribute(MHTML.Attribute.SRC);
                set.removeAttribute(MHTML.Attribute.HEIGHT);
                set.removeAttribute(MHTML.Attribute.WIDTH);
                set.addAttribute(StyleConstants.NameAttribute, MHTML.Tag.CONTENT);
            } else if (tag == MHTML.Tag.HR || tag == MHTML.Tag.BR) {
                set.addAttribute(StyleConstants.NameAttribute, MHTML.Tag.CONTENT);
            } else if (tag == MHTML.Tag.COMMENT) {
                set.addAttribute(StyleConstants.NameAttribute, MHTML.Tag.CONTENT);
                set.removeAttribute(MHTML.Attribute.COMMENT);
            } else if (tag == MHTML.Tag.INPUT) {
                set.addAttribute(StyleConstants.NameAttribute, MHTML.Tag.CONTENT);
                set.removeAttribute(MHTML.Tag.INPUT);
            } else if (tag instanceof MHTML.UnknownTag) {
                set.addAttribute(StyleConstants.NameAttribute, MHTML.Tag.CONTENT);
                set.removeAttribute(MHTML.Attribute.ENDTAG);
            }
        }
    }

    @Override
    public MutableAttributeSet getInputAttributes() {
        if (this.input == null) {
            this.input = this.getStyleSheet().addStyle(null, null);
        }
        return this.input;
    }

    public void setDefaultCursor(Cursor cursor) {
        this.defaultCursor = cursor;
    }

    public Cursor getDefaultCursor() {
        return this.defaultCursor;
    }

    public void setLinkCursor(Cursor cursor) {
        this.linkCursor = cursor;
    }

    public Cursor getLinkCursor() {
        return this.linkCursor;
    }

    public boolean isAutoFormSubmission() {
        return this.isAutoFormSubmission;
    }

    public void setAutoFormSubmission(boolean isAuto) {
        this.isAutoFormSubmission = isAuto;
    }

    @Override
    public Object clone() {
        MHTMLEditorKit o = (MHTMLEditorKit)super.clone();
        if (o != null) {
            o.input = null;
            o.linkHandler = new LinkController();
        }
        return o;
    }

    protected Parser getParser() {
        if (defaultParser == null) {
            try {
                Class<?> c = Class.forName("javax.swing.text.html.parser.ParserDelegator");
                defaultParser = (Parser)c.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultParser;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.theEditor == null) {
            return null;
        }
        if (this.accessibleContext == null) {
            MAccessibleHTML a = new MAccessibleHTML(this.theEditor);
            this.accessibleContext = a.getAccessibleContext();
        }
        return this.accessibleContext;
    }

    private static Object getAttrValue(AttributeSet attr, MHTML.Attribute key) {
        Enumeration<?> names = attr.getAttributeNames();
        while (names.hasMoreElements()) {
            Object nextKey = names.nextElement();
            Object nextVal = attr.getAttribute(nextKey);
            if (nextVal instanceof AttributeSet) {
                Object value = MHTMLEditorKit.getAttrValue((AttributeSet)nextVal, key);
                if (value == null) continue;
                return value;
            }
            if (nextKey != key) continue;
            return nextVal;
        }
        return null;
    }

    private static int getBodyElementStart(JTextComponent comp) {
        Element rootElement = comp.getDocument().getRootElements()[0];
        int i = 0;
        while (i < rootElement.getElementCount()) {
            Element currElement = rootElement.getElement(i);
            if ("body".equals(currElement.getName())) {
                return currElement.getStartOffset();
            }
            ++i;
        }
        return 0;
    }

    static class ActivateLinkAction
    extends TextAction {
        public ActivateLinkAction(String actionName) {
            super(actionName);
        }

        private void activateLink(String href, MHTMLDocument doc, JEditorPane editor, int offset) {
            try {
                URL page = (URL)doc.getProperty("stream");
                URL url = new URL(page, href);
                HyperlinkEvent linkEvent = new HyperlinkEvent(editor, HyperlinkEvent.EventType.ACTIVATED, url, url.toExternalForm(), doc.getCharacterElement(offset));
                editor.fireHyperlinkUpdate(linkEvent);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }

        private void doObjectAction(JEditorPane editor, Element elem) {
            AccessibleAction aa;
            AccessibleContext ac;
            Component comp;
            View view = this.getView(editor, elem);
            if (view != null && view instanceof MObjectView && (comp = ((MObjectView)view).getComponent()) != null && comp instanceof Accessible && (ac = ((Accessible)((Object)comp)).getAccessibleContext()) != null && (aa = ac.getAccessibleAction()) != null) {
                aa.doAccessibleAction(0);
            }
        }

        private View getRootView(JEditorPane editor) {
            return editor.getUI().getRootView(editor);
        }

        private View getView(JEditorPane editor, Element elem) {
            Object lock = this.lock(editor);
            try {
                View rootView = this.getRootView(editor);
                int start = elem.getStartOffset();
                if (rootView != null) {
                    View view = this.getView(rootView, elem, start);
                    return view;
                }
                return null;
            }
            finally {
                this.unlock(lock);
            }
        }

        private View getView(View parent, Element elem, int start) {
            if (parent.getElement() == elem) {
                return parent;
            }
            int index = parent.getViewIndex(start, Position.Bias.Forward);
            if (index != -1 && index < parent.getViewCount()) {
                return this.getView(parent.getView(index), elem, start);
            }
            return null;
        }

        private Object lock(JEditorPane editor) {
            Document document = editor.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
                return document;
            }
            return null;
        }

        private void unlock(Object key) {
            if (key != null) {
                ((AbstractDocument)key).readUnlock();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent c = this.getTextComponent(e);
            if (c.isEditable() || !(c instanceof JEditorPane)) {
                return;
            }
            JEditorPane editor = (JEditorPane)c;
            Document d = editor.getDocument();
            if (d == null || !(d instanceof MHTMLDocument)) {
                return;
            }
            MHTMLDocument doc = (MHTMLDocument)d;
            ElementIterator ei = new ElementIterator(doc);
            int currentOffset = editor.getCaretPosition();
            Object urlString = null;
            Object objString = null;
            Element currentElement = null;
            while ((currentElement = ei.next()) != null) {
                Object obj;
                String name = currentElement.getName();
                AttributeSet attr = currentElement.getAttributes();
                Object href = MHTMLEditorKit.getAttrValue(attr, MHTML.Attribute.HREF);
                if (href != null) {
                    if (currentOffset < currentElement.getStartOffset() || currentOffset > currentElement.getEndOffset()) continue;
                    this.activateLink((String)href, doc, editor, currentOffset);
                    return;
                }
                if (!name.equals(MHTML.Tag.OBJECT.toString()) || (obj = MHTMLEditorKit.getAttrValue(attr, MHTML.Attribute.CLASSID)) == null || currentOffset < currentElement.getStartOffset() || currentOffset > currentElement.getEndOffset()) continue;
                this.doObjectAction(editor, currentElement);
                return;
            }
        }
    }

    static class BeginAction
    extends TextAction {
        private boolean select;

        BeginAction(String nm, boolean select) {
            super(nm);
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            int bodyStart = MHTMLEditorKit.getBodyElementStart(target);
            if (target != null) {
                if (this.select) {
                    target.moveCaretPosition(bodyStart);
                } else {
                    target.setCaretPosition(bodyStart);
                }
            }
        }
    }

    public static abstract class HTMLTextAction
    extends StyledEditorKit.StyledTextAction {
        public HTMLTextAction(String name) {
            super(name);
        }

        protected MHTMLDocument getHTMLDocument(JEditorPane e) {
            Document d = e.getDocument();
            if (d instanceof MHTMLDocument) {
                return (MHTMLDocument)d;
            }
            throw new IllegalArgumentException("document must be HTMLDocument");
        }

        protected MHTMLEditorKit getHTMLEditorKit(JEditorPane e) {
            EditorKit k = e.getEditorKit();
            if (k instanceof MHTMLEditorKit) {
                return (MHTMLEditorKit)k;
            }
            throw new IllegalArgumentException("EditorKit must be HTMLEditorKit");
        }

        protected Element[] getElementsAt(MHTMLDocument doc, int offset) {
            return this.getElementsAt(doc.getDefaultRootElement(), offset, 0);
        }

        private Element[] getElementsAt(Element parent, int offset, int depth) {
            if (parent.isLeaf()) {
                Element[] retValue = new Element[depth + 1];
                retValue[depth] = parent;
                return retValue;
            }
            Element[] retValue = this.getElementsAt(parent.getElement(parent.getElementIndex(offset)), offset, depth + 1);
            retValue[depth] = parent;
            return retValue;
        }

        protected int elementCountToTag(MHTMLDocument doc, int offset, MHTML.Tag tag) {
            int depth = -1;
            Element e = doc.getCharacterElement(offset);
            while (e != null && e.getAttributes().getAttribute(StyleConstants.NameAttribute) != tag) {
                e = e.getParentElement();
                ++depth;
            }
            if (e == null) {
                return -1;
            }
            return depth;
        }

        protected Element findElementMatchingTag(MHTMLDocument doc, int offset, MHTML.Tag tag) {
            Element e = doc.getDefaultRootElement();
            Element lastMatch = null;
            while (e != null) {
                if (e.getAttributes().getAttribute(StyleConstants.NameAttribute) == tag) {
                    lastMatch = e;
                }
                e = e.getElement(e.getElementIndex(offset));
            }
            return lastMatch;
        }
    }

    static class InsertHRAction
    extends InsertHTMLTextAction {
        InsertHRAction() {
            super("InsertHR", MHTMLEditorKit.INSERT_HR_HTML, null, MHTML.Tag.IMPLIED, null, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int offset;
            MHTMLDocument doc;
            Element paragraph;
            JEditorPane editor = this.getEditor(ae);
            if (editor != null && (paragraph = (doc = this.getHTMLDocument(editor)).getParagraphElement(offset = editor.getSelectionStart())).getParentElement() != null) {
                this.parentTag = (MHTML.Tag)paragraph.getParentElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
                super.actionPerformed(ae);
            }
        }
    }

    public static class InsertHTMLTextAction
    extends HTMLTextAction {
        protected String html;
        protected MHTML.Tag parentTag;
        protected MHTML.Tag addTag;
        protected MHTML.Tag alternateParentTag;
        protected MHTML.Tag alternateAddTag;
        boolean adjustSelection;

        public InsertHTMLTextAction(String name, String html, MHTML.Tag parentTag, MHTML.Tag addTag) {
            this(name, html, parentTag, addTag, null, null);
        }

        public InsertHTMLTextAction(String name, String html, MHTML.Tag parentTag, MHTML.Tag addTag, MHTML.Tag alternateParentTag, MHTML.Tag alternateAddTag) {
            this(name, html, parentTag, addTag, alternateParentTag, alternateAddTag, true);
        }

        InsertHTMLTextAction(String name, String html, MHTML.Tag parentTag, MHTML.Tag addTag, MHTML.Tag alternateParentTag, MHTML.Tag alternateAddTag, boolean adjustSelection) {
            super(name);
            this.html = html;
            this.parentTag = parentTag;
            this.addTag = addTag;
            this.alternateParentTag = alternateParentTag;
            this.alternateAddTag = alternateAddTag;
            this.adjustSelection = adjustSelection;
        }

        protected void insertHTML(JEditorPane editor, MHTMLDocument doc, int offset, String html, int popDepth, int pushDepth, MHTML.Tag addTag) {
            try {
                this.getHTMLEditorKit(editor).insertHTML(doc, offset, html, popDepth, pushDepth, addTag);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to insert: " + ioe);
            }
            catch (BadLocationException ble) {
                throw new RuntimeException("Unable to insert: " + ble);
            }
        }

        protected void insertAtBoundary(JEditorPane editor, MHTMLDocument doc, int offset, Element insertElement, String html, MHTML.Tag parentTag, MHTML.Tag addTag) {
            this.insertAtBoundry(editor, doc, offset, insertElement, html, parentTag, addTag);
        }

        @Deprecated
        protected void insertAtBoundry(JEditorPane editor, MHTMLDocument doc, int offset, Element insertElement, String html, MHTML.Tag parentTag, MHTML.Tag addTag) {
            Element commonParent;
            Element e;
            boolean isFirst;
            boolean bl = isFirst = offset == 0;
            if (offset > 0 || insertElement == null) {
                e = doc.getDefaultRootElement();
                while (e != null && e.getStartOffset() != offset && !e.isLeaf()) {
                    e = e.getElement(e.getElementIndex(offset));
                }
                commonParent = e != null ? e.getParentElement() : null;
            } else {
                commonParent = insertElement;
            }
            if (commonParent != null) {
                int pops = 0;
                int pushes = 0;
                if (isFirst && insertElement != null) {
                    e = commonParent;
                    while (e != null && !e.isLeaf()) {
                        e = e.getElement(e.getElementIndex(offset));
                        ++pops;
                    }
                } else {
                    e = commonParent;
                    --offset;
                    while (e != null && !e.isLeaf()) {
                        e = e.getElement(e.getElementIndex(offset));
                        ++pops;
                    }
                    e = commonParent;
                    ++offset;
                    while (e != null && e != insertElement) {
                        e = e.getElement(e.getElementIndex(offset));
                        ++pushes;
                    }
                }
                pops = Math.max(0, pops - 1);
                this.insertHTML(editor, doc, offset, html, pops, pushes, addTag);
            }
        }

        boolean insertIntoTag(JEditorPane editor, MHTMLDocument doc, int offset, MHTML.Tag tag, MHTML.Tag addTag) {
            int depth;
            Element e = this.findElementMatchingTag(doc, offset, tag);
            if (e != null && e.getStartOffset() == offset) {
                this.insertAtBoundary(editor, doc, offset, e, this.html, tag, addTag);
                return true;
            }
            if (offset > 0 && (depth = this.elementCountToTag(doc, offset - 1, tag)) != -1) {
                this.insertHTML(editor, doc, offset, this.html, depth, 0, addTag);
                return true;
            }
            return false;
        }

        void adjustSelection(JEditorPane pane, MHTMLDocument doc, int startOffset, int oldLength) {
            int newLength = doc.getLength();
            if (newLength != oldLength && startOffset < newLength) {
                if (startOffset > 0) {
                    String text;
                    try {
                        text = doc.getText(startOffset - 1, 1);
                    }
                    catch (BadLocationException ble) {
                        text = null;
                    }
                    if (text != null && text.length() > 0 && text.charAt(0) == '\n') {
                        pane.select(startOffset, startOffset);
                    } else {
                        pane.select(startOffset + 1, startOffset + 1);
                    }
                } else {
                    pane.select(1, 1);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor != null) {
                MHTMLDocument doc = this.getHTMLDocument(editor);
                int offset = editor.getSelectionStart();
                int length = doc.getLength();
                boolean inserted = !this.insertIntoTag(editor, doc, offset, this.parentTag, this.addTag) && this.alternateParentTag != null ? this.insertIntoTag(editor, doc, offset, this.alternateParentTag, this.alternateAddTag) : true;
                if (this.adjustSelection && inserted) {
                    this.adjustSelection(editor, doc, offset, length);
                }
            }
        }
    }

    public static class LinkController
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        private Element curElem = null;
        private boolean curElemImage = false;
        private String href = null;
        private transient Position.Bias[] bias = new Position.Bias[1];
        private int curOffset;

        @Override
        public void mouseClicked(MouseEvent e) {
            Point pt;
            int pos;
            JEditorPane editor = (JEditorPane)e.getSource();
            if (!editor.isEditable() && SwingUtilities.isLeftMouseButton(e) && (pos = editor.viewToModel(pt = new Point(e.getX(), e.getY()))) >= 0) {
                this.activateLink(pos, editor, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JEditorPane editor = (JEditorPane)e.getSource();
            MHTMLEditorKit kit = (MHTMLEditorKit)editor.getEditorKit();
            boolean adjustCursor = true;
            Cursor newCursor = kit.getDefaultCursor();
            if (!editor.isEditable()) {
                Point pt = new Point(e.getX(), e.getY());
                int pos = editor.getUI().viewToModel(editor, pt, this.bias);
                if (this.bias[0] == Position.Bias.Backward && pos > 0) {
                    --pos;
                }
                if (pos >= 0 && editor.getDocument() instanceof MHTMLDocument) {
                    MHTMLDocument hdoc = (MHTMLDocument)editor.getDocument();
                    Element elem = hdoc.getCharacterElement(pos);
                    if (!this.doesElementContainLocation(editor, elem, pos, e.getX(), e.getY())) {
                        elem = null;
                    }
                    if (this.curElem != elem || this.curElemImage) {
                        Element lastElem = this.curElem;
                        this.curElem = elem;
                        String href = null;
                        this.curElemImage = false;
                        if (elem != null) {
                            AttributeSet a = elem.getAttributes();
                            AttributeSet anchor = (AttributeSet)a.getAttribute(MHTML.Tag.A);
                            if (anchor == null) {
                                boolean bl = this.curElemImage = a.getAttribute(StyleConstants.NameAttribute) == MHTML.Tag.IMG;
                                if (this.curElemImage) {
                                    href = this.getMapHREF(editor, hdoc, elem, a, pos, e.getX(), e.getY());
                                }
                            } else {
                                href = (String)anchor.getAttribute(MHTML.Attribute.HREF);
                            }
                        }
                        if (href != this.href) {
                            this.fireEvents(editor, hdoc, href, lastElem);
                            this.href = href;
                            if (href != null) {
                                newCursor = kit.getLinkCursor();
                            }
                        } else {
                            adjustCursor = false;
                        }
                    } else {
                        adjustCursor = false;
                    }
                    this.curOffset = pos;
                }
            }
            if (adjustCursor && editor.getCursor() != newCursor) {
                editor.setCursor(newCursor);
            }
        }

        private String getMapHREF(JEditorPane html, MHTMLDocument hdoc, Element elem, AttributeSet attr, int offset, int x, int y) {
            MMap m;
            Object useMap = attr.getAttribute(MHTML.Attribute.USEMAP);
            if (useMap != null && useMap instanceof String && (m = hdoc.getMap((String)useMap)) != null && offset < hdoc.getLength()) {
                AttributeSet area;
                Rectangle bounds;
                TextUI ui = html.getUI();
                try {
                    Rectangle lBounds = ui.modelToView(html, offset, Position.Bias.Forward);
                    Rectangle rBounds = ui.modelToView(html, offset + 1, Position.Bias.Backward);
                    bounds = lBounds.getBounds();
                    bounds.add(rBounds instanceof Rectangle ? rBounds : rBounds.getBounds());
                }
                catch (BadLocationException ble) {
                    bounds = null;
                }
                if (bounds != null && (area = m.getArea(x - bounds.x, y - bounds.y, bounds.width, bounds.height)) != null) {
                    return (String)area.getAttribute(MHTML.Attribute.HREF);
                }
            }
            return null;
        }

        private boolean doesElementContainLocation(JEditorPane editor, Element e, int offset, int x, int y) {
            if (e != null && offset > 0 && e.getStartOffset() == offset) {
                Rectangle s1;
                TextUI ui;
                block5: {
                    ui = editor.getUI();
                    s1 = ui.modelToView(editor, offset, Position.Bias.Forward);
                    if (s1 != null) break block5;
                    return false;
                }
                try {
                    Rectangle r1 = s1 instanceof Rectangle ? s1 : s1.getBounds();
                    Rectangle s2 = ui.modelToView(editor, e.getEndOffset(), Position.Bias.Backward);
                    if (s2 != null) {
                        Rectangle r2 = s2 instanceof Rectangle ? s2 : s2.getBounds();
                        r1.add(r2);
                    }
                    return r1.contains(x, y);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return true;
        }

        protected void activateLink(int pos, JEditorPane editor) {
            this.activateLink(pos, editor, -1, -1);
        }

        void activateLink(int pos, JEditorPane html, int x, int y) {
            Document doc = html.getDocument();
            if (doc instanceof MHTMLDocument) {
                MHTMLDocument hdoc = (MHTMLDocument)doc;
                Element e = hdoc.getCharacterElement(pos);
                AttributeSet a = e.getAttributes();
                AttributeSet anchor = (AttributeSet)a.getAttribute(MHTML.Tag.A);
                HyperlinkEvent linkEvent = null;
                this.href = anchor == null ? this.getMapHREF(html, hdoc, e, a, pos, x, y) : (String)anchor.getAttribute(MHTML.Attribute.HREF);
                if (this.href != null) {
                    linkEvent = this.createHyperlinkEvent(html, hdoc, this.href, anchor, e);
                }
                if (linkEvent != null) {
                    html.fireHyperlinkUpdate(linkEvent);
                }
            }
        }

        HyperlinkEvent createHyperlinkEvent(JEditorPane html, MHTMLDocument hdoc, String href, AttributeSet anchor, Element element) {
            URL u;
            try {
                URL base = hdoc.getBase();
                u = new URL(base, href);
                if (href != null && "file".equals(u.getProtocol()) && href.startsWith("#")) {
                    String baseFile = base.getFile();
                    String newFile = u.getFile();
                    if (baseFile != null && newFile != null && !newFile.startsWith(baseFile)) {
                        u = new URL(base, String.valueOf(baseFile) + href);
                    }
                }
            }
            catch (MalformedURLException m) {
                u = null;
            }
            HyperlinkEvent linkEvent = null;
            if (!hdoc.isFrameDocument()) {
                linkEvent = new HyperlinkEvent(html, HyperlinkEvent.EventType.ACTIVATED, u, href, element);
            } else {
                String target;
                String string = target = anchor != null ? (String)anchor.getAttribute(MHTML.Attribute.TARGET) : null;
                if (target == null || target.equals("")) {
                    target = hdoc.getBaseTarget();
                }
                if (target == null || target.equals("")) {
                    target = "_self";
                }
                linkEvent = new MHTMLFrameHyperlinkEvent((Object)html, HyperlinkEvent.EventType.ACTIVATED, u, href, element, target);
            }
            return linkEvent;
        }

        void fireEvents(JEditorPane editor, MHTMLDocument doc, String href, Element lastElem) {
            URL u;
            if (this.href != null) {
                try {
                    u = new URL(doc.getBase(), this.href);
                }
                catch (MalformedURLException m) {
                    u = null;
                }
                HyperlinkEvent exit = new HyperlinkEvent(editor, HyperlinkEvent.EventType.EXITED, u, this.href, lastElem);
                editor.fireHyperlinkUpdate(exit);
            }
            if (href != null) {
                try {
                    u = new URL(doc.getBase(), href);
                }
                catch (MalformedURLException m) {
                    u = null;
                }
                HyperlinkEvent entered = new HyperlinkEvent(editor, HyperlinkEvent.EventType.ENTERED, u, href, this.curElem);
                editor.fireHyperlinkUpdate(entered);
            }
        }
    }

    public static class MHTMLFactory
    implements ViewFactory {
        @Override
        public View create(Element elem) {
            String nm;
            Object o;
            AttributeSet attrs = elem.getAttributes();
            Object elementName = attrs.getAttribute("$ename");
            Object object = o = elementName != null ? null : attrs.getAttribute(StyleConstants.NameAttribute);
            if (o instanceof MHTML.Tag) {
                MHTML.Tag kind = (MHTML.Tag)o;
                if (kind == MHTML.Tag.CONTENT) {
                    return new MInlineView(elem);
                }
                if (kind == MHTML.Tag.IMPLIED) {
                    String ws = (String)elem.getAttributes().getAttribute(MCSS.Attribute.WHITE_SPACE);
                    if (ws != null && ws.equals("pre")) {
                        return new MLineView(elem);
                    }
                    return new MParagraphView(elem);
                }
                if (kind == MHTML.Tag.P || kind == MHTML.Tag.H1 || kind == MHTML.Tag.H2 || kind == MHTML.Tag.H3 || kind == MHTML.Tag.H4 || kind == MHTML.Tag.H5 || kind == MHTML.Tag.H6 || kind == MHTML.Tag.DT) {
                    return new MParagraphView(elem);
                }
                if (kind == MHTML.Tag.MENU || kind == MHTML.Tag.DIR || kind == MHTML.Tag.UL || kind == MHTML.Tag.OL) {
                    return new MListView(elem);
                }
                if (kind == MHTML.Tag.BODY) {
                    return new MBodyBlockView(elem);
                }
                if (kind == MHTML.Tag.HTML) {
                    return new MBlockView(elem, 1);
                }
                if (kind == MHTML.Tag.LI || kind == MHTML.Tag.CENTER || kind == MHTML.Tag.DL || kind == MHTML.Tag.DD || kind == MHTML.Tag.DIV || kind == MHTML.Tag.BLOCKQUOTE || kind == MHTML.Tag.PRE || kind == MHTML.Tag.FORM) {
                    return new MBlockView(elem, 1);
                }
                if (kind == MHTML.Tag.NOFRAMES) {
                    return new MNoFramesView(elem, 1);
                }
                if (kind == MHTML.Tag.IMG) {
                    return new MImageView(elem);
                }
                if (kind == MHTML.Tag.ISINDEX) {
                    return new IsindexView(elem);
                }
                if (kind == MHTML.Tag.HR) {
                    return new MHRuleView(elem);
                }
                if (kind == MHTML.Tag.BR) {
                    return new MBRView(elem);
                }
                if (kind == MHTML.Tag.TABLE) {
                    return new MTableView(elem);
                }
                if (kind == MHTML.Tag.INPUT || kind == MHTML.Tag.SELECT || kind == MHTML.Tag.TEXTAREA) {
                    return new MFormView(elem);
                }
                if (kind == MHTML.Tag.OBJECT) {
                    return new MObjectView(elem);
                }
                if (kind == MHTML.Tag.FRAMESET) {
                    if (elem.getAttributes().isDefined(MHTML.Attribute.ROWS)) {
                        return new MFrameSetView(elem, 1);
                    }
                    if (elem.getAttributes().isDefined(MHTML.Attribute.COLS)) {
                        return new MFrameSetView(elem, 0);
                    }
                    throw new RuntimeException("Can't build a" + kind + ", " + elem + ":" + "no ROWS or COLS defined.");
                }
                if (kind == MHTML.Tag.FRAME) {
                    return new MFrameView(elem);
                }
                if (kind instanceof MHTML.UnknownTag) {
                    return new MHiddenTagView(elem);
                }
                if (kind == MHTML.Tag.COMMENT) {
                    return new MCommentView(elem);
                }
                if (kind == MHTML.Tag.HEAD) {
                    return new MBlockView(elem, 0){

                        @Override
                        public float getPreferredSpan(int axis) {
                            return 0.0f;
                        }

                        @Override
                        public float getMinimumSpan(int axis) {
                            return 0.0f;
                        }

                        @Override
                        public float getMaximumSpan(int axis) {
                            return 0.0f;
                        }

                        @Override
                        protected void loadChildren(ViewFactory f) {
                        }

                        @Override
                        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
                            return a;
                        }

                        @Override
                        public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) {
                            return this.getElement().getEndOffset();
                        }
                    };
                }
                if (kind == MHTML.Tag.TITLE || kind == MHTML.Tag.META || kind == MHTML.Tag.LINK || kind == MHTML.Tag.STYLE || kind == MHTML.Tag.SCRIPT || kind == MHTML.Tag.AREA || kind == MHTML.Tag.MAP || kind == MHTML.Tag.PARAM || kind == MHTML.Tag.APPLET) {
                    return new MHiddenTagView(elem);
                }
            }
            String string = nm = elementName != null ? (String)elementName : elem.getName();
            if (nm != null) {
                if (nm.equals("content")) {
                    return new MLabelView(elem);
                }
                if (nm.equals("paragraph")) {
                    return new MParagraphView(elem);
                }
                if (nm.equals("section")) {
                    return new MEditorBoxView(elem, 1);
                }
                if (nm.equals("component")) {
                    return new ComponentView(elem);
                }
                if (nm.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new MLabelView(elem);
        }

        public static class MBodyBlockView
        extends MBlockView
        implements ComponentListener {
            private Reference cachedViewPort = null;
            private boolean isListening = false;
            private int viewVisibleWidth = Integer.MAX_VALUE;
            private int componentVisibleWidth = Integer.MAX_VALUE;

            public MBodyBlockView(Element elem) {
                super(elem, 1);
            }

            @Override
            protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
                r = super.calculateMajorAxisRequirements(axis, r);
                r.maximum = Integer.MAX_VALUE;
                return r;
            }

            @Override
            protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
                Container parentContainer;
                Container container = this.getContainer();
                if (container != null && container instanceof JEditorPane && (parentContainer = container.getParent()) != null && parentContainer instanceof JViewport) {
                    JViewport viewPort = (JViewport)parentContainer;
                    if (this.cachedViewPort != null) {
                        Object cachedObject = this.cachedViewPort.get();
                        if (cachedObject != null) {
                            if (cachedObject != viewPort) {
                                ((JComponent)cachedObject).removeComponentListener(this);
                            }
                        } else {
                            this.cachedViewPort = null;
                        }
                    }
                    if (this.cachedViewPort == null) {
                        viewPort.addComponentListener(this);
                        this.cachedViewPort = new WeakReference<JViewport>(viewPort);
                    }
                    this.componentVisibleWidth = viewPort.getExtentSize().width;
                    if (this.componentVisibleWidth > 0) {
                        Insets insets = container.getInsets();
                        this.viewVisibleWidth = this.componentVisibleWidth - insets.left - this.getLeftInset();
                        targetSpan = Math.min(targetSpan, this.viewVisibleWidth);
                    }
                } else if (this.cachedViewPort != null) {
                    Object cachedObject = this.cachedViewPort.get();
                    if (cachedObject != null) {
                        ((JComponent)cachedObject).removeComponentListener(this);
                    }
                    this.cachedViewPort = null;
                }
                super.layoutMinorAxis(targetSpan, axis, offsets, spans);
            }

            @Override
            public void setParent(View parent) {
                if (parent == null && this.cachedViewPort != null) {
                    Object cachedObject = this.cachedViewPort.get();
                    if (cachedObject != null) {
                        ((JComponent)cachedObject).removeComponentListener(this);
                    }
                    this.cachedViewPort = null;
                }
                super.setParent(parent);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Document doc;
                if (!(e.getSource() instanceof JViewport)) {
                    return;
                }
                JViewport viewPort = (JViewport)e.getSource();
                if (this.componentVisibleWidth != viewPort.getExtentSize().width && (doc = this.getDocument()) instanceof AbstractDocument) {
                    AbstractDocument document = (AbstractDocument)this.getDocument();
                    document.readLock();
                    try {
                        this.layoutChanged(0);
                        this.preferenceChanged(null, true, true);
                    }
                    finally {
                        document.readUnlock();
                    }
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        }
    }

    static class NavigateLinkAction
    extends TextAction
    implements CaretListener {
        private static int prevHypertextOffset = -1;
        private static boolean foundLink = false;
        private static FocusHighlightPainter focusPainter = new FocusHighlightPainter(null);
        private Object selectionTag;
        private boolean focusBack = false;

        public NavigateLinkAction(String actionName) {
            super(actionName);
            if ("previous-link-action".equals(actionName)) {
                this.focusBack = true;
            }
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            if (foundLink) {
                foundLink = false;
                Object src = e.getSource();
                if (src instanceof JTextComponent) {
                    ((JTextComponent)src).getAccessibleContext().firePropertyChange("AccessibleHypertextOffset", new Integer(prevHypertextOffset), new Integer(e.getDot()));
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent comp = this.getTextComponent(e);
            if (comp == null || comp.isEditable()) {
                return;
            }
            Document doc = comp.getDocument();
            if (doc == null) {
                return;
            }
            ElementIterator ei = new ElementIterator(doc);
            int currentOffset = comp.getCaretPosition();
            int prevStartOffset = -1;
            int prevEndOffset = -1;
            Element nextElement = null;
            while ((nextElement = ei.next()) != null) {
                String name = nextElement.getName();
                AttributeSet attr = nextElement.getAttributes();
                Object href = MHTMLEditorKit.getAttrValue(attr, MHTML.Attribute.HREF);
                if (!name.equals(MHTML.Tag.OBJECT.toString()) && href == null) continue;
                int elementOffset = nextElement.getStartOffset();
                if (this.focusBack) {
                    if (elementOffset >= currentOffset && prevStartOffset >= 0) {
                        foundLink = true;
                        comp.setCaretPosition(prevStartOffset);
                        this.moveCaretPosition(comp, prevStartOffset, prevEndOffset);
                        prevHypertextOffset = prevStartOffset;
                        return;
                    }
                } else if (elementOffset > currentOffset) {
                    foundLink = true;
                    comp.setCaretPosition(elementOffset);
                    this.moveCaretPosition(comp, elementOffset, nextElement.getEndOffset());
                    prevHypertextOffset = elementOffset;
                    return;
                }
                prevStartOffset = nextElement.getStartOffset();
                prevEndOffset = nextElement.getEndOffset();
            }
            if (this.focusBack && prevStartOffset >= 0) {
                foundLink = true;
                comp.setCaretPosition(prevStartOffset);
                this.moveCaretPosition(comp, prevStartOffset, prevEndOffset);
                prevHypertextOffset = prevStartOffset;
                return;
            }
        }

        private void moveCaretPosition(JTextComponent comp, int mark, int dot) {
            Highlighter h = comp.getHighlighter();
            if (h != null) {
                int p0 = Math.min(dot, mark);
                int p1 = Math.max(dot, mark);
                try {
                    if (this.selectionTag != null) {
                        h.changeHighlight(this.selectionTag, p0, p1);
                    } else {
                        FocusHighlightPainter p = focusPainter;
                        this.selectionTag = h.addHighlight(p0, p1, p);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        static class FocusHighlightPainter
        extends DefaultHighlighter.DefaultHighlightPainter {
            FocusHighlightPainter(Color color) {
                super(color);
            }

            @Override
            public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
                Color color = this.getColor();
                if (color == null) {
                    g.setColor(c.getSelectionColor());
                } else {
                    g.setColor(color);
                }
                if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                    Rectangle alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
                    g.drawRect(alloc.x, alloc.y, alloc.width - 1, alloc.height);
                    return alloc;
                }
                try {
                    Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                    Rectangle r = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                    g.drawRect(r.x, r.y, r.width - 1, r.height);
                    return r;
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
        }
    }

    public static abstract class Parser {
        public abstract void parse(Reader var1, ParserCallback var2, boolean var3) throws IOException;
    }

    public static class ParserCallback {
        public static final Object IMPLIED = "_implied_";

        public void flush() throws BadLocationException {
        }

        public void handleText(char[] data, int pos) {
        }

        public void handleComment(char[] data, int pos) {
        }

        public void handleStartTag(MHTML.Tag t, MutableAttributeSet a, int pos) {
        }

        public void handleEndTag(MHTML.Tag t, int pos) {
        }

        public void handleSimpleTag(MHTML.Tag t, MutableAttributeSet a, int pos) {
        }

        public void handleError(String errorMsg, int pos) {
        }

        public void handleEndOfLineString(String eol) {
        }
    }
}

