/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text.html;

import com.mongol.swing.text.html.MCSS;
import com.mongol.swing.text.html.MHTML;
import com.mongol.swing.text.html.MHTMLDocument;
import com.mongol.swing.text.html.MMap;
import com.mongol.swing.text.html.MOption;
import com.mongol.swing.text.html.MOptionComboBoxModel;
import com.mongol.swing.text.html.MOptionListModel;
import com.mongol.swing.text.html.MStyleSheet;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.text.AbstractWriter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class MHTMLWriter
extends AbstractWriter {
    private Stack blockElementStack = new Stack();
    private boolean inContent = false;
    private boolean inPre = false;
    private int preEndOffset;
    private boolean inTextArea = false;
    private boolean newlineOutputed = false;
    private boolean completeDoc;
    private Vector tags = new Vector(10);
    private Vector tagValues = new Vector(10);
    private Segment segment;
    private Vector tagsToRemove = new Vector(10);
    private boolean wroteHead;
    private boolean replaceEntities;
    private char[] tempChars;
    private boolean indentNext = false;
    private boolean writeCSS = false;
    private MutableAttributeSet convAttr = new SimpleAttributeSet();
    private MutableAttributeSet oConvAttr = new SimpleAttributeSet();
    private boolean indented = false;

    public MHTMLWriter(Writer w, MHTMLDocument doc) {
        this(w, doc, 0, doc.getLength());
    }

    public MHTMLWriter(Writer w, MHTMLDocument doc, int pos, int len) {
        super(w, doc, pos, len);
        this.completeDoc = pos == 0 && len == doc.getLength();
        this.setLineLength(80);
    }

    @Override
    public void write() throws IOException, BadLocationException {
        ElementIterator it = this.getElementIterator();
        Element current = null;
        Element next = null;
        this.wroteHead = false;
        this.setCurrentLineLength(0);
        this.replaceEntities = false;
        this.setCanWrapLines(false);
        if (this.segment == null) {
            this.segment = new Segment();
        }
        this.inPre = false;
        boolean forcedBody = false;
        while ((next = it.next()) != null) {
            if (!this.inRange(next)) {
                if (!this.completeDoc || next.getAttributes().getAttribute(StyleConstants.NameAttribute) != MHTML.Tag.BODY) continue;
                forcedBody = true;
            }
            if (current != null) {
                Element top;
                if (this.indentNeedsIncrementing(current, next)) {
                    this.incrIndent();
                } else if (current.getParentElement() != next.getParentElement()) {
                    top = (Element)this.blockElementStack.peek();
                    while (top != next.getParentElement()) {
                        this.blockElementStack.pop();
                        if (!this.synthesizedElement(top)) {
                            AttributeSet attrs = top.getAttributes();
                            if (!this.matchNameAttribute(attrs, MHTML.Tag.PRE) && !this.isFormElementWithContent(attrs)) {
                                this.decrIndent();
                            }
                            this.endTag(top);
                        }
                        top = (Element)this.blockElementStack.peek();
                    }
                } else if (current.getParentElement() == next.getParentElement() && (top = (Element)this.blockElementStack.peek()) == current) {
                    this.blockElementStack.pop();
                    this.endTag(top);
                }
            }
            if (!next.isLeaf() || this.isFormElementWithContent(next.getAttributes())) {
                this.blockElementStack.push(next);
                this.startTag(next);
            } else {
                this.emptyTag(next);
            }
            current = next;
        }
        this.closeOutUnwantedEmbeddedTags(null);
        if (forcedBody) {
            this.blockElementStack.pop();
            this.endTag(current);
        }
        while (!this.blockElementStack.empty()) {
            current = (Element)this.blockElementStack.pop();
            if (this.synthesizedElement(current)) continue;
            AttributeSet attrs = current.getAttributes();
            if (!this.matchNameAttribute(attrs, MHTML.Tag.PRE) && !this.isFormElementWithContent(attrs)) {
                this.decrIndent();
            }
            this.endTag(current);
        }
        if (this.completeDoc) {
            this.writeAdditionalComments();
        }
        this.segment.array = null;
    }

    @Override
    protected void writeAttributes(AttributeSet attr) throws IOException {
        this.convAttr.removeAttributes(this.convAttr);
        MHTMLWriter.convertToHTML32(attr, this.convAttr);
        Enumeration<?> names = this.convAttr.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            if (name instanceof MHTML.Tag || name instanceof StyleConstants || name == MHTML.Attribute.ENDTAG) continue;
            this.write(" " + name + "=\"" + this.convAttr.getAttribute(name) + "\"");
        }
    }

    protected void emptyTag(Element elem) throws BadLocationException, IOException {
        if (!this.inContent && !this.inPre) {
            this.indentSmart();
        }
        AttributeSet attr = elem.getAttributes();
        this.closeOutUnwantedEmbeddedTags(attr);
        this.writeEmbeddedTags(attr);
        if (this.matchNameAttribute(attr, MHTML.Tag.CONTENT)) {
            this.inContent = true;
            this.text(elem);
        } else if (this.matchNameAttribute(attr, MHTML.Tag.COMMENT)) {
            this.comment(elem);
        } else {
            boolean isBlock = this.isBlockTag(elem.getAttributes());
            if (this.inContent && isBlock) {
                this.writeLineSeparator();
                this.indentSmart();
            }
            Object nameTag = attr != null ? attr.getAttribute(StyleConstants.NameAttribute) : null;
            Object endTag = attr != null ? attr.getAttribute(MHTML.Attribute.ENDTAG) : null;
            boolean outputEndTag = false;
            if (nameTag != null && endTag != null && endTag instanceof String && ((String)endTag).equals("true")) {
                outputEndTag = true;
            }
            if (this.completeDoc && this.matchNameAttribute(attr, MHTML.Tag.HEAD)) {
                if (outputEndTag) {
                    this.writeStyles(((MHTMLDocument)this.getDocument()).getStyleSheet());
                }
                this.wroteHead = true;
            }
            this.write('<');
            if (outputEndTag) {
                this.write('/');
            }
            this.write(elem.getName());
            this.writeAttributes(attr);
            this.write('>');
            if (this.matchNameAttribute(attr, MHTML.Tag.TITLE) && !outputEndTag) {
                Document doc = elem.getDocument();
                String title = (String)doc.getProperty("title");
                this.write(title);
            } else if (!this.inContent || isBlock) {
                this.writeLineSeparator();
                if (isBlock && this.inContent) {
                    this.indentSmart();
                }
            }
        }
    }

    protected boolean isBlockTag(AttributeSet attr) {
        Object o = attr.getAttribute(StyleConstants.NameAttribute);
        if (o instanceof MHTML.Tag) {
            MHTML.Tag name = (MHTML.Tag)o;
            return name.isBlock();
        }
        return false;
    }

    protected void startTag(Element elem) throws IOException, BadLocationException {
        if (this.synthesizedElement(elem)) {
            return;
        }
        AttributeSet attr = elem.getAttributes();
        Object nameAttribute = attr.getAttribute(StyleConstants.NameAttribute);
        MHTML.Tag name = nameAttribute instanceof MHTML.Tag ? (MHTML.Tag)nameAttribute : null;
        if (name == MHTML.Tag.PRE) {
            this.inPre = true;
            this.preEndOffset = elem.getEndOffset();
        }
        this.closeOutUnwantedEmbeddedTags(attr);
        if (this.inContent) {
            this.writeLineSeparator();
            this.inContent = false;
            this.newlineOutputed = false;
        }
        if (this.completeDoc && name == MHTML.Tag.BODY && !this.wroteHead) {
            this.wroteHead = true;
            this.indentSmart();
            this.write("<head>");
            this.writeLineSeparator();
            this.incrIndent();
            this.writeStyles(((MHTMLDocument)this.getDocument()).getStyleSheet());
            this.decrIndent();
            this.writeLineSeparator();
            this.indentSmart();
            this.write("</head>");
            this.writeLineSeparator();
        }
        this.indentSmart();
        this.write('<');
        this.write(elem.getName());
        this.writeAttributes(attr);
        this.write('>');
        if (name != MHTML.Tag.PRE) {
            this.writeLineSeparator();
        }
        if (name == MHTML.Tag.TEXTAREA) {
            this.textAreaContent(elem.getAttributes());
        } else if (name == MHTML.Tag.SELECT) {
            this.selectContent(elem.getAttributes());
        } else if (this.completeDoc && name == MHTML.Tag.BODY) {
            this.writeMaps(((MHTMLDocument)this.getDocument()).getMaps());
        } else if (name == MHTML.Tag.HEAD) {
            MHTMLDocument document = (MHTMLDocument)this.getDocument();
            this.wroteHead = true;
            this.incrIndent();
            this.writeStyles(document.getStyleSheet());
            if (document.hasBaseTag()) {
                this.indentSmart();
                this.write("<base href=\"" + document.getBase() + "\">");
                this.writeLineSeparator();
            }
            this.decrIndent();
        }
    }

    protected void textAreaContent(AttributeSet attr) throws BadLocationException, IOException {
        Document doc = (Document)attr.getAttribute(StyleConstants.ModelAttribute);
        if (doc != null && doc.getLength() > 0) {
            if (this.segment == null) {
                this.segment = new Segment();
            }
            doc.getText(0, doc.getLength(), this.segment);
            if (this.segment.count > 0) {
                this.inTextArea = true;
                this.incrIndent();
                this.indentSmart();
                this.setCanWrapLines(true);
                this.replaceEntities = true;
                this.write(this.segment.array, this.segment.offset, this.segment.count);
                this.replaceEntities = false;
                this.setCanWrapLines(false);
                this.writeLineSeparator();
                this.inTextArea = false;
                this.decrIndent();
            }
        }
    }

    @Override
    protected void text(Element elem) throws BadLocationException, IOException {
        int end;
        int start = Math.max(this.getStartOffset(), elem.getStartOffset());
        if (start < (end = Math.min(this.getEndOffset(), elem.getEndOffset()))) {
            if (this.segment == null) {
                this.segment = new Segment();
            }
            this.getDocument().getText(start, end - start, this.segment);
            this.newlineOutputed = false;
            if (this.segment.count > 0) {
                if (this.segment.array[this.segment.offset + this.segment.count - 1] == '\n') {
                    this.newlineOutputed = true;
                }
                if (this.inPre && end == this.preEndOffset) {
                    if (this.segment.count > 1) {
                        --this.segment.count;
                    } else {
                        return;
                    }
                }
                this.replaceEntities = true;
                this.setCanWrapLines(!this.inPre);
                this.write(this.segment.array, this.segment.offset, this.segment.count);
                this.setCanWrapLines(false);
                this.replaceEntities = false;
            }
        }
    }

    protected void selectContent(AttributeSet attr) throws IOException {
        Object model = attr.getAttribute(StyleConstants.ModelAttribute);
        this.incrIndent();
        if (model instanceof MOptionListModel) {
            MOptionListModel listModel = (MOptionListModel)model;
            int size = listModel.getSize();
            int i = 0;
            while (i < size) {
                MOption option = (MOption)listModel.getElementAt(i);
                this.writeOption(option);
                ++i;
            }
        } else if (model instanceof MOptionComboBoxModel) {
            MOptionComboBoxModel comboBoxModel = (MOptionComboBoxModel)model;
            int size = comboBoxModel.getSize();
            int i = 0;
            while (i < size) {
                MOption option = (MOption)comboBoxModel.getElementAt(i);
                this.writeOption(option);
                ++i;
            }
        }
        this.decrIndent();
    }

    protected void writeOption(MOption option) throws IOException {
        this.indentSmart();
        this.write('<');
        this.write("option");
        Object value = option.getAttributes().getAttribute(MHTML.Attribute.VALUE);
        if (value != null) {
            this.write(" value=" + value);
        }
        if (option.isSelected()) {
            this.write(" selected");
        }
        this.write('>');
        if (option.getLabel() != null) {
            this.write(option.getLabel());
        }
        this.writeLineSeparator();
    }

    protected void endTag(Element elem) throws IOException {
        if (this.synthesizedElement(elem)) {
            return;
        }
        this.closeOutUnwantedEmbeddedTags(elem.getAttributes());
        if (this.inContent) {
            if (!this.newlineOutputed && !this.inPre) {
                this.writeLineSeparator();
            }
            this.newlineOutputed = false;
            this.inContent = false;
        }
        if (!this.inPre) {
            this.indentSmart();
        }
        if (this.matchNameAttribute(elem.getAttributes(), MHTML.Tag.PRE)) {
            this.inPre = false;
        }
        this.write('<');
        this.write('/');
        this.write(elem.getName());
        this.write('>');
        this.writeLineSeparator();
    }

    protected void comment(Element elem) throws BadLocationException, IOException {
        AttributeSet as = elem.getAttributes();
        if (this.matchNameAttribute(as, MHTML.Tag.COMMENT)) {
            Object comment = as.getAttribute(MHTML.Attribute.COMMENT);
            if (comment instanceof String) {
                this.writeComment((String)comment);
            } else {
                this.writeComment(null);
            }
        }
    }

    void writeComment(String string) throws IOException {
        this.write("<!--");
        if (string != null) {
            this.write(string);
        }
        this.write("-->");
        this.writeLineSeparator();
        this.indentSmart();
    }

    void writeAdditionalComments() throws IOException {
        Object comments = this.getDocument().getProperty("AdditionalComments");
        if (comments instanceof Vector) {
            Vector v = (Vector)comments;
            int counter = 0;
            int maxCounter = v.size();
            while (counter < maxCounter) {
                this.writeComment(v.elementAt(counter).toString());
                ++counter;
            }
        }
    }

    protected boolean synthesizedElement(Element elem) {
        return this.matchNameAttribute(elem.getAttributes(), MHTML.Tag.IMPLIED);
    }

    protected boolean matchNameAttribute(AttributeSet attr, MHTML.Tag tag) {
        MHTML.Tag name;
        Object o = attr.getAttribute(StyleConstants.NameAttribute);
        return o instanceof MHTML.Tag && (name = (MHTML.Tag)o) == tag;
    }

    protected void writeEmbeddedTags(AttributeSet attr) throws IOException {
        attr = this.convertToHTML(attr, this.oConvAttr);
        Enumeration<?> names = attr.getAttributeNames();
        while (names.hasMoreElements()) {
            MHTML.Tag tag;
            Object name = names.nextElement();
            if (!(name instanceof MHTML.Tag) || (tag = (MHTML.Tag)name) == MHTML.Tag.FORM || this.tags.contains(tag)) continue;
            this.write('<');
            this.write(tag.toString());
            Object o = attr.getAttribute(tag);
            if (o != null && o instanceof AttributeSet) {
                this.writeAttributes((AttributeSet)o);
            }
            this.write('>');
            this.tags.addElement(tag);
            this.tagValues.addElement(o);
        }
    }

    private boolean noMatchForTagInAttributes(AttributeSet attr, MHTML.Tag t, Object tagValue) {
        if (attr != null && attr.isDefined(t)) {
            Object newValue = attr.getAttribute(t);
            if (tagValue == null ? newValue == null : newValue != null && tagValue.equals(newValue)) {
                return false;
            }
        }
        return true;
    }

    protected void closeOutUnwantedEmbeddedTags(AttributeSet attr) throws IOException {
        MHTML.Tag t;
        this.tagsToRemove.removeAllElements();
        attr = this.convertToHTML(attr, null);
        int firstIndex = -1;
        int size = this.tags.size();
        int i = size - 1;
        while (i >= 0) {
            t = (MHTML.Tag)this.tags.elementAt(i);
            Object tValue = this.tagValues.elementAt(i);
            if (attr == null || this.noMatchForTagInAttributes(attr, t, tValue)) {
                firstIndex = i;
                this.tagsToRemove.addElement(t);
            }
            --i;
        }
        if (firstIndex != -1) {
            boolean removeAll = size - firstIndex == this.tagsToRemove.size();
            int i2 = size - 1;
            while (i2 >= firstIndex) {
                t = (MHTML.Tag)this.tags.elementAt(i2);
                if (removeAll || this.tagsToRemove.contains(t)) {
                    this.tags.removeElementAt(i2);
                    this.tagValues.removeElementAt(i2);
                }
                this.write('<');
                this.write('/');
                this.write(t.toString());
                this.write('>');
                --i2;
            }
            size = this.tags.size();
            i2 = firstIndex;
            while (i2 < size) {
                t = (MHTML.Tag)this.tags.elementAt(i2);
                this.write('<');
                this.write(t.toString());
                Object o = this.tagValues.elementAt(i2);
                if (o != null && o instanceof AttributeSet) {
                    this.writeAttributes((AttributeSet)o);
                }
                this.write('>');
                ++i2;
            }
        }
    }

    private boolean isFormElementWithContent(AttributeSet attr) {
        return this.matchNameAttribute(attr, MHTML.Tag.TEXTAREA) || this.matchNameAttribute(attr, MHTML.Tag.SELECT);
    }

    private boolean indentNeedsIncrementing(Element current, Element next) {
        if (next.getParentElement() == current && !this.inPre) {
            if (this.indentNext) {
                this.indentNext = false;
                return true;
            }
            if (this.synthesizedElement(next)) {
                this.indentNext = true;
            } else if (!this.synthesizedElement(current)) {
                return true;
            }
        }
        return false;
    }

    void writeMaps(Enumeration maps) throws IOException {
        if (maps != null) {
            while (maps.hasMoreElements()) {
                MMap map = (MMap)maps.nextElement();
                String name = map.getName();
                this.incrIndent();
                this.indentSmart();
                this.write("<map");
                if (name != null) {
                    this.write(" name=\"");
                    this.write(name);
                    this.write("\">");
                } else {
                    this.write('>');
                }
                this.writeLineSeparator();
                this.incrIndent();
                AttributeSet[] areas = map.getAreas();
                if (areas != null) {
                    int counter = 0;
                    int maxCounter = areas.length;
                    while (counter < maxCounter) {
                        this.indentSmart();
                        this.write("<area");
                        this.writeAttributes(areas[counter]);
                        this.write("></area>");
                        this.writeLineSeparator();
                        ++counter;
                    }
                }
                this.decrIndent();
                this.indentSmart();
                this.write("</map>");
                this.writeLineSeparator();
                this.decrIndent();
            }
        }
    }

    void writeStyles(MStyleSheet sheet) throws IOException {
        Enumeration<?> styles;
        if (sheet != null && (styles = sheet.getStyleNames()) != null) {
            boolean outputStyle = false;
            while (styles.hasMoreElements()) {
                String name = (String)styles.nextElement();
                if ("default".equals(name) || !this.writeStyle(name, sheet.getStyle(name), outputStyle)) continue;
                outputStyle = true;
            }
            if (outputStyle) {
                this.writeStyleEndTag();
            }
        }
    }

    boolean writeStyle(String name, Style style, boolean outputStyle) throws IOException {
        boolean didOutputStyle = false;
        Enumeration<?> attributes = style.getAttributeNames();
        if (attributes != null) {
            while (attributes.hasMoreElements()) {
                String value;
                Object attribute = attributes.nextElement();
                if (!(attribute instanceof MCSS.Attribute) || (value = style.getAttribute(attribute).toString()) == null) continue;
                if (!outputStyle) {
                    this.writeStyleStartTag();
                    outputStyle = true;
                }
                if (!didOutputStyle) {
                    didOutputStyle = true;
                    this.indentSmart();
                    this.write(name);
                    this.write(" {");
                } else {
                    this.write(";");
                }
                this.write(' ');
                this.write(attribute.toString());
                this.write(": ");
                this.write(value);
            }
        }
        if (didOutputStyle) {
            this.write(" }");
            this.writeLineSeparator();
        }
        return didOutputStyle;
    }

    void writeStyleStartTag() throws IOException {
        this.indentSmart();
        this.write("<style type=\"text/css\">");
        this.incrIndent();
        this.writeLineSeparator();
        this.indentSmart();
        this.write("<!--");
        this.incrIndent();
        this.writeLineSeparator();
    }

    void writeStyleEndTag() throws IOException {
        this.decrIndent();
        this.indentSmart();
        this.write("-->");
        this.writeLineSeparator();
        this.decrIndent();
        this.indentSmart();
        this.write("</style>");
        this.writeLineSeparator();
        this.indentSmart();
    }

    AttributeSet convertToHTML(AttributeSet from, MutableAttributeSet to) {
        if (to == null) {
            to = this.convAttr;
        }
        to.removeAttributes(to);
        if (this.writeCSS) {
            MHTMLWriter.convertToHTML40(from, to);
        } else {
            MHTMLWriter.convertToHTML32(from, to);
        }
        return to;
    }

    private static void convertToHTML32(AttributeSet from, MutableAttributeSet to) {
        if (from == null) {
            return;
        }
        Enumeration<?> keys = from.getAttributeNames();
        String value = "";
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (key instanceof MCSS.Attribute) {
                if (key == MCSS.Attribute.FONT_FAMILY || key == MCSS.Attribute.FONT_SIZE || key == MCSS.Attribute.COLOR) {
                    MHTMLWriter.createFontAttribute((MCSS.Attribute)key, from, to);
                    continue;
                }
                if (key == MCSS.Attribute.FONT_WEIGHT) {
                    MCSS.FontWeight weightValue = (MCSS.FontWeight)from.getAttribute(MCSS.Attribute.FONT_WEIGHT);
                    if (weightValue == null || weightValue.getValue() <= 400) continue;
                    MHTMLWriter.addAttribute(to, MHTML.Tag.B, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (key == MCSS.Attribute.FONT_STYLE) {
                    String s = from.getAttribute(key).toString();
                    if (s.indexOf("italic") < 0) continue;
                    MHTMLWriter.addAttribute(to, MHTML.Tag.I, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (key == MCSS.Attribute.TEXT_DECORATION) {
                    String decor = from.getAttribute(key).toString();
                    if (decor.indexOf("underline") >= 0) {
                        MHTMLWriter.addAttribute(to, MHTML.Tag.U, SimpleAttributeSet.EMPTY);
                    }
                    if (decor.indexOf("line-through") < 0) continue;
                    MHTMLWriter.addAttribute(to, MHTML.Tag.STRIKE, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (key == MCSS.Attribute.VERTICAL_ALIGN) {
                    String vAlign = from.getAttribute(key).toString();
                    if (vAlign.indexOf("sup") >= 0) {
                        MHTMLWriter.addAttribute(to, MHTML.Tag.SUP, SimpleAttributeSet.EMPTY);
                    }
                    if (vAlign.indexOf("sub") < 0) continue;
                    MHTMLWriter.addAttribute(to, MHTML.Tag.SUB, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (key == MCSS.Attribute.TEXT_ALIGN) {
                    MHTMLWriter.addAttribute(to, MHTML.Attribute.ALIGN, from.getAttribute(key).toString());
                    continue;
                }
                if (value.length() > 0) {
                    value = String.valueOf(value) + "; ";
                }
                value = String.valueOf(value) + key + ": " + from.getAttribute(key);
                continue;
            }
            Object attr = from.getAttribute(key);
            if (attr instanceof AttributeSet) {
                attr = ((AttributeSet)attr).copyAttributes();
            }
            MHTMLWriter.addAttribute(to, key, attr);
        }
        if (value.length() > 0) {
            to.addAttribute(MHTML.Attribute.STYLE, value);
        }
    }

    private static void addAttribute(MutableAttributeSet to, Object key, Object value) {
        Object attr = to.getAttribute(key);
        if (attr == null || attr == SimpleAttributeSet.EMPTY) {
            to.addAttribute(key, value);
        } else if (attr instanceof MutableAttributeSet && value instanceof AttributeSet) {
            ((MutableAttributeSet)attr).addAttributes((AttributeSet)value);
        }
    }

    private static void createFontAttribute(MCSS.Attribute a, AttributeSet from, MutableAttributeSet to) {
        MutableAttributeSet fontAttr = (MutableAttributeSet)to.getAttribute(MHTML.Tag.FONT);
        if (fontAttr == null) {
            fontAttr = new SimpleAttributeSet();
            to.addAttribute(MHTML.Tag.FONT, fontAttr);
        }
        String htmlValue = from.getAttribute(a).toString();
        if (a == MCSS.Attribute.FONT_FAMILY) {
            fontAttr.addAttribute(MHTML.Attribute.FACE, htmlValue);
        } else if (a == MCSS.Attribute.FONT_SIZE) {
            fontAttr.addAttribute(MHTML.Attribute.SIZE, htmlValue);
        } else if (a == MCSS.Attribute.COLOR) {
            fontAttr.addAttribute(MHTML.Attribute.COLOR, htmlValue);
        }
    }

    private static void convertToHTML40(AttributeSet from, MutableAttributeSet to) {
        Enumeration<?> keys = from.getAttributeNames();
        String value = "";
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (key instanceof MCSS.Attribute) {
                value = String.valueOf(value) + " " + key + "=" + from.getAttribute(key) + ";";
                continue;
            }
            to.addAttribute(key, from.getAttribute(key));
        }
        if (value.length() > 0) {
            to.addAttribute(MHTML.Attribute.STYLE, value);
        }
    }

    @Override
    protected void writeLineSeparator() throws IOException {
        boolean oldReplace = this.replaceEntities;
        this.replaceEntities = false;
        super.writeLineSeparator();
        this.replaceEntities = oldReplace;
        this.indented = false;
    }

    @Override
    protected void output(char[] chars, int start, int length) throws IOException {
        if (!this.replaceEntities) {
            super.output(chars, start, length);
            return;
        }
        int last = start;
        length += start;
        int counter = start;
        while (counter < length) {
            switch (chars[counter]) {
                case '<': {
                    if (counter > last) {
                        super.output(chars, last, counter - last);
                    }
                    last = counter + 1;
                    this.output("&lt;");
                    break;
                }
                case '>': {
                    if (counter > last) {
                        super.output(chars, last, counter - last);
                    }
                    last = counter + 1;
                    this.output("&gt;");
                    break;
                }
                case '&': {
                    if (counter > last) {
                        super.output(chars, last, counter - last);
                    }
                    last = counter + 1;
                    this.output("&amp;");
                    break;
                }
                case '\"': {
                    if (counter > last) {
                        super.output(chars, last, counter - last);
                    }
                    last = counter + 1;
                    this.output("&quot;");
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    if (chars[counter] >= ' ' && chars[counter] <= '\u007f') break;
                    if (counter > last) {
                        super.output(chars, last, counter - last);
                    }
                    last = counter + 1;
                    this.output("&#");
                    this.output(String.valueOf((int)chars[counter]));
                    this.output(";");
                }
            }
            ++counter;
        }
        if (last < length) {
            super.output(chars, last, length - last);
        }
    }

    private void output(String string) throws IOException {
        int length = string.length();
        if (this.tempChars == null || this.tempChars.length < length) {
            this.tempChars = new char[length];
        }
        string.getChars(0, length, this.tempChars, 0);
        super.output(this.tempChars, 0, length);
    }

    private void indentSmart() throws IOException {
        if (!this.indented) {
            this.indent();
            this.indented = true;
        }
    }
}

