/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text.html;

import com.mongol.swing.text.html.MHTML;
import java.awt.Polygon;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.text.AttributeSet;

class MMap
implements Serializable {
    private String name;
    private Vector areaAttributes;
    private Vector areas;

    public MMap() {
    }

    public MMap(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addArea(AttributeSet as) {
        if (as == null) {
            return;
        }
        if (this.areaAttributes == null) {
            this.areaAttributes = new Vector(2);
        }
        this.areaAttributes.addElement(as.copyAttributes());
    }

    public void removeArea(AttributeSet as) {
        if (as != null && this.areaAttributes != null) {
            int numAreas = this.areas != null ? this.areas.size() : 0;
            int counter = this.areaAttributes.size() - 1;
            while (counter >= 0) {
                if (((AttributeSet)this.areaAttributes.elementAt(counter)).isEqual(as)) {
                    this.areaAttributes.removeElementAt(counter);
                    if (counter < numAreas) {
                        this.areas.removeElementAt(counter);
                    }
                }
                --counter;
            }
        }
    }

    public AttributeSet[] getAreas() {
        int numAttributes;
        int n = numAttributes = this.areaAttributes != null ? this.areaAttributes.size() : 0;
        if (numAttributes != 0) {
            Object[] retValue = new AttributeSet[numAttributes];
            this.areaAttributes.copyInto(retValue);
            return retValue;
        }
        return null;
    }

    public AttributeSet getArea(int x, int y, int width, int height) {
        int numAttributes;
        int n = numAttributes = this.areaAttributes != null ? this.areaAttributes.size() : 0;
        if (numAttributes > 0) {
            int numAreas;
            int n2 = numAreas = this.areas != null ? this.areas.size() : 0;
            if (this.areas == null) {
                this.areas = new Vector(numAttributes);
            }
            int counter = 0;
            while (counter < numAttributes) {
                RegionContainment rc;
                if (counter >= numAreas) {
                    this.areas.addElement(this.createRegionContainment((AttributeSet)this.areaAttributes.elementAt(counter)));
                }
                if ((rc = (RegionContainment)this.areas.elementAt(counter)) != null && rc.contains(x, y, width, height)) {
                    return (AttributeSet)this.areaAttributes.elementAt(counter);
                }
                ++counter;
            }
        }
        return null;
    }

    protected RegionContainment createRegionContainment(AttributeSet attributes) {
        Object shape = attributes.getAttribute(MHTML.Attribute.SHAPE);
        if (shape == null) {
            shape = "rect";
        }
        if (shape instanceof String) {
            String shapeString = ((String)shape).toLowerCase();
            RegionContainment rc = null;
            try {
                if (shapeString.equals("rect")) {
                    rc = new RectangleRegionContainment(attributes);
                } else if (shapeString.equals("circle")) {
                    rc = new CircleRegionContainment(attributes);
                } else if (shapeString.equals("poly")) {
                    rc = new PolygonRegionContainment(attributes);
                } else if (shapeString.equals("default")) {
                    rc = DefaultRegionContainment.sharedInstance();
                }
            }
            catch (RuntimeException re) {
                rc = null;
            }
            return rc;
        }
        return null;
    }

    protected static int[] extractCoords(Object stringCoords) {
        if (stringCoords == null || !(stringCoords instanceof String)) {
            return null;
        }
        StringTokenizer st = new StringTokenizer((String)stringCoords, ", \t\n\r");
        int[] retValue = null;
        int numCoords = 0;
        while (st.hasMoreElements()) {
            int scale;
            String token = st.nextToken();
            if (token.endsWith("%")) {
                scale = -1;
                token = token.substring(0, token.length() - 1);
            } else {
                scale = 1;
            }
            try {
                int intValue = Integer.parseInt(token);
                if (retValue == null) {
                    retValue = new int[4];
                } else if (numCoords == retValue.length) {
                    int[] temp = new int[retValue.length * 2];
                    System.arraycopy(retValue, 0, temp, 0, retValue.length);
                    retValue = temp;
                }
                retValue[numCoords++] = intValue * scale;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        if (numCoords > 0 && numCoords != retValue.length) {
            int[] temp = new int[numCoords];
            System.arraycopy(retValue, 0, temp, 0, numCoords);
            retValue = temp;
        }
        return retValue;
    }

    static class CircleRegionContainment
    implements RegionContainment {
        int x;
        int y;
        int radiusSquared;
        float[] percentValues;
        int lastWidth;
        int lastHeight;

        public CircleRegionContainment(AttributeSet as) {
            int[] coords = MMap.extractCoords(as.getAttribute(MHTML.Attribute.COORDS));
            if (coords == null || coords.length != 3) {
                throw new RuntimeException("Unable to parse circular area");
            }
            this.x = coords[0];
            this.y = coords[1];
            this.radiusSquared = coords[2] * coords[2];
            if (coords[0] < 0 || coords[1] < 0 || coords[2] < 0) {
                this.lastHeight = -1;
                this.lastWidth = -1;
                this.percentValues = new float[3];
                int counter = 0;
                while (counter < 3) {
                    this.percentValues[counter] = coords[counter] < 0 ? (float)coords[counter] / -100.0f : -1.0f;
                    ++counter;
                }
            } else {
                this.percentValues = null;
            }
        }

        @Override
        public boolean contains(int x, int y, int width, int height) {
            if (this.percentValues != null && (this.lastWidth != width || this.lastHeight != height)) {
                int newRad = Math.min(width, height) / 2;
                this.lastWidth = width;
                this.lastHeight = height;
                if (this.percentValues[0] != -1.0f) {
                    this.x = (int)(this.percentValues[0] * (float)width);
                }
                if (this.percentValues[1] != -1.0f) {
                    this.y = (int)(this.percentValues[1] * (float)height);
                }
                if (this.percentValues[2] != -1.0f) {
                    this.radiusSquared = (int)(this.percentValues[2] * (float)Math.min(width, height));
                    this.radiusSquared *= this.radiusSquared;
                }
            }
            return (x - this.x) * (x - this.x) + (y - this.y) * (y - this.y) <= this.radiusSquared;
        }
    }

    static class DefaultRegionContainment
    implements RegionContainment {
        static DefaultRegionContainment si = null;

        DefaultRegionContainment() {
        }

        public static DefaultRegionContainment sharedInstance() {
            if (si == null) {
                si = new DefaultRegionContainment();
            }
            return si;
        }

        @Override
        public boolean contains(int x, int y, int width, int height) {
            return x <= width && x >= 0 && y >= 0 && y <= width;
        }
    }

    static class PolygonRegionContainment
    extends Polygon
    implements RegionContainment {
        float[] percentValues;
        int[] percentIndexs;
        int lastWidth;
        int lastHeight;

        public PolygonRegionContainment(AttributeSet as) {
            int[] coords = MMap.extractCoords(as.getAttribute(MHTML.Attribute.COORDS));
            if (coords == null || coords.length == 0 || coords.length % 2 != 0) {
                throw new RuntimeException("Unable to parse polygon area");
            }
            int numPercents = 0;
            this.lastHeight = -1;
            this.lastWidth = -1;
            int counter = coords.length - 1;
            while (counter >= 0) {
                if (coords[counter] < 0) {
                    ++numPercents;
                }
                --counter;
            }
            if (numPercents > 0) {
                this.percentIndexs = new int[numPercents];
                this.percentValues = new float[numPercents];
                counter = coords.length - 1;
                int pCounter = 0;
                while (counter >= 0) {
                    if (coords[counter] < 0) {
                        this.percentValues[pCounter] = (float)coords[counter] / -100.0f;
                        this.percentIndexs[pCounter] = counter;
                        ++pCounter;
                    }
                    --counter;
                }
            } else {
                this.percentIndexs = null;
                this.percentValues = null;
            }
            this.npoints = coords.length / 2;
            this.xpoints = new int[this.npoints];
            this.ypoints = new int[this.npoints];
            counter = 0;
            while (counter < this.npoints) {
                this.xpoints[counter] = coords[counter + counter];
                this.ypoints[counter] = coords[counter + counter + 1];
                ++counter;
            }
        }

        @Override
        public boolean contains(int x, int y, int width, int height) {
            if (this.percentValues == null || this.lastWidth == width && this.lastHeight == height) {
                return this.contains(x, y);
            }
            this.bounds = null;
            this.lastWidth = width;
            this.lastHeight = height;
            float fWidth = width;
            float fHeight = height;
            int counter = this.percentValues.length - 1;
            while (counter >= 0) {
                if (this.percentIndexs[counter] % 2 == 0) {
                    this.xpoints[this.percentIndexs[counter] / 2] = (int)(this.percentValues[counter] * fWidth);
                } else {
                    this.ypoints[this.percentIndexs[counter] / 2] = (int)(this.percentValues[counter] * fHeight);
                }
                --counter;
            }
            return this.contains(x, y);
        }
    }

    static class RectangleRegionContainment
    implements RegionContainment {
        float[] percents;
        int lastWidth;
        int lastHeight;
        int x0;
        int y0;
        int x1;
        int y1;

        public RectangleRegionContainment(AttributeSet as) {
            int[] coords = MMap.extractCoords(as.getAttribute(MHTML.Attribute.COORDS));
            this.percents = null;
            if (coords == null || coords.length != 4) {
                throw new RuntimeException("Unable to parse rectangular area");
            }
            this.x0 = coords[0];
            this.y0 = coords[1];
            this.x1 = coords[2];
            this.y1 = coords[3];
            if (this.x0 < 0 || this.y0 < 0 || this.x1 < 0 || this.y1 < 0) {
                this.percents = new float[4];
                this.lastHeight = -1;
                this.lastWidth = -1;
                int counter = 0;
                while (counter < 4) {
                    this.percents[counter] = coords[counter] < 0 ? (float)Math.abs(coords[counter]) / 100.0f : -1.0f;
                    ++counter;
                }
            }
        }

        @Override
        public boolean contains(int x, int y, int width, int height) {
            if (this.percents == null) {
                return this.contains(x, y);
            }
            if (this.lastWidth != width || this.lastHeight != height) {
                this.lastWidth = width;
                this.lastHeight = height;
                if (this.percents[0] != -1.0f) {
                    this.x0 = (int)(this.percents[0] * (float)width);
                }
                if (this.percents[1] != -1.0f) {
                    this.y0 = (int)(this.percents[1] * (float)height);
                }
                if (this.percents[2] != -1.0f) {
                    this.x1 = (int)(this.percents[2] * (float)width);
                }
                if (this.percents[3] != -1.0f) {
                    this.y1 = (int)(this.percents[3] * (float)height);
                }
            }
            return this.contains(x, y);
        }

        public boolean contains(int x, int y) {
            return x >= this.x0 && x <= this.x1 && y >= this.y0 && y <= this.y1;
        }
    }

    static interface RegionContainment {
        public boolean contains(int var1, int var2, int var3, int var4);
    }
}

