/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text.html;

import com.mongol.swing.text.html.MHTML;
import java.awt.Color;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.swing.JLabel;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;

public class MObjectView
extends ComponentView {
    public MObjectView(Element elem) {
        super(elem);
    }

    @Override
    protected Component createComponent() {
        AttributeSet attr = this.getElement().getAttributes();
        String classname = (String)attr.getAttribute(MHTML.Attribute.CLASSID);
        try {
            Class<?> c = Class.forName(classname, true, Thread.currentThread().getContextClassLoader());
            Object o = c.newInstance();
            if (o instanceof Component) {
                Component comp = (Component)o;
                this.setParameters(comp, attr);
                return comp;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.getUnloadableRepresentation();
    }

    Component getUnloadableRepresentation() {
        JLabel comp = new JLabel("??");
        ((Component)comp).setForeground(Color.red);
        return comp;
    }

    private Class getClass(String classname) throws ClassNotFoundException {
        Class<?> docClass = this.getDocument().getClass();
        ClassLoader loader = docClass.getClassLoader();
        Class<?> klass = loader != null ? loader.loadClass(classname) : Class.forName(classname);
        return klass;
    }

    private void setParameters(Component comp, AttributeSet attr) {
        BeanInfo bi;
        Class<?> k = comp.getClass();
        try {
            bi = Introspector.getBeanInfo(k);
        }
        catch (IntrospectionException ex) {
            System.err.println("introspector failed, ex: " + ex);
            return;
        }
        PropertyDescriptor[] props = bi.getPropertyDescriptors();
        int i = 0;
        while (i < props.length) {
            Object v = attr.getAttribute(props[i].getName());
            if (v instanceof String) {
                String value = (String)v;
                Method writer = props[i].getWriteMethod();
                if (writer == null) {
                    return;
                }
                Class<?>[] params = writer.getParameterTypes();
                if (params.length != 1) {
                    return;
                }
                Object[] args = new Object[]{value};
                try {
                    writer.invoke((Object)comp, args);
                }
                catch (Exception ex) {
                    System.err.println("Invocation failed");
                }
            }
            ++i;
        }
    }
}

