/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text.html;

import com.mongol.swing.text.MBoxView;
import com.mongol.swing.text.html.MBlockView;
import com.mongol.swing.text.html.MCSS;
import com.mongol.swing.text.html.MHTML;
import com.mongol.swing.text.html.MHTMLDocument;
import com.mongol.swing.text.html.MStyleSheet;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.ParagraphView;

public class MTableView
extends MBoxView
implements ViewFactory {
    private AttributeSet attr;
    private MStyleSheet.BoxPainter painter;
    private int cellSpacing;
    private int borderWidth;
    private int captionIndex = -1;
    private boolean relativeCells;
    private boolean multiRowCells;
    int[] columnSpans;
    int[] columnOffsets;
    SizeRequirements totalColumnRequirements;
    SizeRequirements[] columnRequirements;
    RowIterator rowIterator = new RowIterator();
    ColumnIterator colIterator = new ColumnIterator();
    Vector rows = new Vector();
    boolean skipComments = false;
    boolean gridValid = false;
    private static final BitSet EMPTY = new BitSet();

    public MTableView(Element elem) {
        super(elem, 1);
        this.totalColumnRequirements = new SizeRequirements();
    }

    protected RowView createTableRow(Element elem) {
        Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (o == MHTML.Tag.TR) {
            return new RowView(elem);
        }
        return null;
    }

    public int getColumnCount() {
        return this.columnSpans.length;
    }

    public int getColumnSpan(int col) {
        if (col < this.columnSpans.length) {
            return this.columnSpans[col];
        }
        return 0;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getMultiRowSpan(int row0, int row1) {
        RowView rv0 = this.getRow(row0);
        RowView rv1 = this.getRow(row1);
        if (rv0 != null && rv1 != null) {
            int index0 = rv0.viewIndex;
            int index1 = rv1.viewIndex;
            int span = this.getOffset(1, index1) - this.getOffset(1, index0) + this.getSpan(1, index1);
            return span;
        }
        return 0;
    }

    public int getRowSpan(int row) {
        RowView rv = this.getRow(row);
        if (rv != null) {
            return this.getSpan(1, rv.viewIndex);
        }
        return 0;
    }

    RowView getRow(int row) {
        if (row < this.rows.size()) {
            return (RowView)this.rows.elementAt(row);
        }
        return null;
    }

    @Override
    protected View getViewAtPoint(int x, int y, Rectangle alloc) {
        int n = this.getViewCount();
        View v = null;
        Rectangle allocation = new Rectangle();
        int i = 0;
        while (i < n) {
            allocation.setBounds(alloc);
            this.childAllocation(i, allocation);
            v = this.getView(i);
            if (v instanceof RowView && (v = ((RowView)v).findViewAtPoint(x, y, allocation)) != null) {
                alloc.setBounds(allocation);
                return v;
            }
            ++i;
        }
        return super.getViewAtPoint(x, y, alloc);
    }

    protected int getColumnsOccupied(View v) {
        String s;
        AttributeSet a = v.getElement().getAttributes();
        if (a.isDefined(MHTML.Attribute.COLSPAN) && (s = (String)a.getAttribute(MHTML.Attribute.COLSPAN)) != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    protected int getRowsOccupied(View v) {
        String s;
        AttributeSet a = v.getElement().getAttributes();
        if (a.isDefined(MHTML.Attribute.ROWSPAN) && (s = (String)a.getAttribute(MHTML.Attribute.ROWSPAN)) != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    protected void invalidateGrid() {
        this.gridValid = false;
    }

    protected MStyleSheet getStyleSheet() {
        MHTMLDocument doc = (MHTMLDocument)this.getDocument();
        return doc.getStyleSheet();
    }

    void updateInsets() {
        short top = (short)this.painter.getInset(1, this);
        short bottom = (short)this.painter.getInset(3, this);
        if (this.captionIndex != -1) {
            View caption = this.getView(this.captionIndex);
            short h = (short)caption.getPreferredSpan(1);
            AttributeSet a = caption.getAttributes();
            Object align = a.getAttribute(MCSS.Attribute.CAPTION_SIDE);
            if (align != null && align.equals("bottom")) {
                bottom = (short)(bottom + h);
            } else {
                top = (short)(top + h);
            }
        }
        this.setInsets(top, (short)this.painter.getInset(2, this), bottom, (short)this.painter.getInset(4, this));
    }

    protected void setPropertiesFromAttributes() {
        MStyleSheet sheet = this.getStyleSheet();
        this.attr = sheet.getViewAttributes(this);
        this.painter = sheet.getBoxPainter(this.attr);
        if (this.attr != null) {
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
            MCSS.LengthValue lv = (MCSS.LengthValue)this.attr.getAttribute(MCSS.Attribute.BORDER_SPACING);
            this.cellSpacing = lv != null ? (int)lv.getValue() : 0;
            lv = (MCSS.LengthValue)this.attr.getAttribute(MCSS.Attribute.BORDER_TOP_WIDTH);
            this.borderWidth = lv != null ? (int)lv.getValue() : 0;
        }
    }

    void updateGrid() {
        if (!this.gridValid) {
            this.relativeCells = false;
            this.multiRowCells = false;
            this.captionIndex = -1;
            this.rows.removeAllElements();
            int n = this.getViewCount();
            int i = 0;
            while (i < n) {
                View v = this.getView(i);
                if (v instanceof RowView) {
                    this.rows.addElement(v);
                    RowView rv = (RowView)v;
                    rv.clearFilledColumns();
                    rv.rowIndex = this.rows.size() - 1;
                    rv.viewIndex = i;
                } else {
                    MHTML.Tag kind;
                    Object o = v.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
                    if (o instanceof MHTML.Tag && (kind = (MHTML.Tag)o) == MHTML.Tag.CAPTION) {
                        this.captionIndex = i;
                    }
                }
                ++i;
            }
            int maxColumns = 0;
            int nrows = this.rows.size();
            int row = 0;
            while (row < nrows) {
                RowView rv = this.getRow(row);
                int col = 0;
                int cell = 0;
                while (cell < rv.getViewCount()) {
                    int colSpan;
                    AttributeSet a;
                    MCSS.LengthValue lv;
                    View cv = rv.getView(cell);
                    if (!this.relativeCells && (lv = (MCSS.LengthValue)(a = cv.getAttributes()).getAttribute(MCSS.Attribute.WIDTH)) != null && lv.isPercentage()) {
                        this.relativeCells = true;
                    }
                    while (rv.isFilled(col)) {
                        ++col;
                    }
                    int rowSpan = this.getRowsOccupied(cv);
                    if (rowSpan > 1) {
                        this.multiRowCells = true;
                    }
                    if ((colSpan = this.getColumnsOccupied(cv)) > 1 || rowSpan > 1) {
                        int rowLimit = row + rowSpan;
                        int colLimit = col + colSpan;
                        int i2 = row;
                        while (i2 < rowLimit) {
                            int j = col;
                            while (j < colLimit) {
                                if (i2 != row || j != col) {
                                    this.addFill(i2, j);
                                }
                                ++j;
                            }
                            ++i2;
                        }
                        if (colSpan > 1) {
                            col += colSpan - 1;
                        }
                    }
                    ++cell;
                    ++col;
                }
                maxColumns = Math.max(maxColumns, col);
                ++row;
            }
            this.columnSpans = new int[maxColumns];
            this.columnOffsets = new int[maxColumns];
            this.columnRequirements = new SizeRequirements[maxColumns];
            int i3 = 0;
            while (i3 < maxColumns) {
                this.columnRequirements[i3] = new SizeRequirements();
                this.columnRequirements[i3].maximum = Integer.MAX_VALUE;
                ++i3;
            }
            this.gridValid = true;
        }
    }

    void addFill(int row, int col) {
        RowView rv = this.getRow(row);
        if (rv != null) {
            rv.fillColumn(col);
        }
    }

    protected void layoutColumns(int targetSpan, int[] offsets, int[] spans, SizeRequirements[] reqs) {
        Arrays.fill(offsets, 0);
        Arrays.fill(spans, 0);
        this.colIterator.setLayoutArrays(offsets, spans, targetSpan);
        MCSS.calculateTiledLayout(this.colIterator, targetSpan);
    }

    /*
     * Unable to fully structure code
     */
    void calculateColumnRequirements(int axis) {
        block12: {
            var5_2 = this.columnRequirements;
            var4_4 = this.columnRequirements.length;
            var3_5 = 0;
            while (var3_5 < var4_4) {
                req = var5_2[var3_5];
                req.minimum = 0;
                req.preferred = 0;
                req.maximum = 0x7FFFFFFF;
                ++var3_5;
            }
            host = this.getContainer();
            if (host != null) {
                this.skipComments = host instanceof JTextComponent != false ? ((JTextComponent)host).isEditable() == false : true;
            }
            hasMultiColumn = false;
            nrows = this.getRowCount();
            i = 0;
            while (i < nrows) {
                row = this.getRow(i);
                col = 0;
                ncells = row.getViewCount();
                cell = 0;
                while (cell < ncells) {
                    block11: {
                        cv = row.getView(cell);
                        if (!this.skipComments || cv instanceof CellView) ** GOTO lbl27
                        break block11;
lbl-1000:
                        // 1 sources

                        {
                            ++col;
lbl27:
                            // 2 sources

                            ** while (row.isFilled((int)col))
                        }
lbl28:
                        // 1 sources

                        rowSpan = this.getRowsOccupied(cv);
                        colSpan = this.getColumnsOccupied(cv);
                        if (colSpan == 1) {
                            this.checkSingleColumnCell(axis, col, cv);
                        } else {
                            hasMultiColumn = true;
                            col += colSpan - 1;
                        }
                        ++col;
                    }
                    ++cell;
                }
                ++i;
            }
            if (!hasMultiColumn) break block12;
            i = 0;
            while (i < nrows) {
                row = this.getRow(i);
                col = 0;
                ncells = row.getViewCount();
                cell = 0;
                while (cell < ncells) {
                    block13: {
                        cv = row.getView(cell);
                        if (!this.skipComments || cv instanceof CellView) ** GOTO lbl53
                        break block13;
lbl-1000:
                        // 1 sources

                        {
                            ++col;
lbl53:
                            // 2 sources

                            ** while (row.isFilled((int)col))
                        }
lbl54:
                        // 1 sources

                        colSpan = this.getColumnsOccupied(cv);
                        if (colSpan > 1) {
                            this.checkMultiColumnCell(axis, col, colSpan, cv);
                            col += colSpan - 1;
                        }
                        ++col;
                    }
                    ++cell;
                }
                ++i;
            }
        }
    }

    void checkSingleColumnCell(int axis, int col, View v) {
        SizeRequirements req = this.columnRequirements[col];
        req.minimum = Math.max((int)v.getMinimumSpan(axis), req.minimum);
        req.preferred = Math.max((int)v.getPreferredSpan(axis), req.preferred);
    }

    void checkMultiColumnCell(int axis, int col, int ncols, View v) {
        int cpref;
        long min = 0L;
        long pref = 0L;
        long max = 0L;
        int i = 0;
        while (i < ncols) {
            SizeRequirements req = this.columnRequirements[col + i];
            min += (long)req.minimum;
            pref += (long)req.preferred;
            max += (long)req.maximum;
            ++i;
        }
        int cmin = (int)v.getMinimumSpan(axis);
        if ((long)cmin > min) {
            SizeRequirements[] reqs = new SizeRequirements[ncols];
            int i2 = 0;
            while (i2 < ncols) {
                reqs[i2] = this.columnRequirements[col + i2];
                ++i2;
            }
            int[] spans = new int[ncols];
            int[] offsets = new int[ncols];
            SizeRequirements.calculateTiledPositions(cmin, null, reqs, offsets, spans);
            int i3 = 0;
            while (i3 < ncols) {
                SizeRequirements req = reqs[i3];
                req.minimum = Math.max(spans[i3], req.minimum);
                req.preferred = Math.max(req.minimum, req.preferred);
                req.maximum = Math.max(req.preferred, req.maximum);
                ++i3;
            }
        }
        if ((long)(cpref = (int)v.getPreferredSpan(axis)) > pref) {
            SizeRequirements[] reqs = new SizeRequirements[ncols];
            int i4 = 0;
            while (i4 < ncols) {
                reqs[i4] = this.columnRequirements[col + i4];
                ++i4;
            }
            int[] spans = new int[ncols];
            int[] offsets = new int[ncols];
            SizeRequirements.calculateTiledPositions(cpref, null, reqs, offsets, spans);
            int i5 = 0;
            while (i5 < ncols) {
                SizeRequirements req = reqs[i5];
                req.preferred = Math.max(spans[i5], req.preferred);
                req.maximum = Math.max(req.preferred, req.maximum);
                ++i5;
            }
        }
    }

    @Override
    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        String ta;
        this.updateGrid();
        this.calculateColumnRequirements(axis);
        if (r == null) {
            r = new SizeRequirements();
        }
        long min = 0L;
        long pref = 0L;
        int n = this.columnRequirements.length;
        int i = 0;
        while (i < n) {
            SizeRequirements req = this.columnRequirements[i];
            min += (long)req.minimum;
            pref += (long)req.preferred;
            ++i;
        }
        int adjust = (n + 1) * this.cellSpacing + 2 * this.borderWidth;
        r.minimum = (int)(min += (long)adjust);
        r.preferred = (int)(pref += (long)adjust);
        r.maximum = (int)pref;
        AttributeSet attr = this.getAttributes();
        MCSS.LengthValue cssWidth = (MCSS.LengthValue)attr.getAttribute(MCSS.Attribute.WIDTH);
        if (MBlockView.spanSetFromAttributes(axis, r, cssWidth, null) && r.minimum < (int)min) {
            r.minimum = r.preferred = (int)min;
            r.maximum = r.preferred;
        }
        this.totalColumnRequirements.minimum = r.minimum;
        this.totalColumnRequirements.preferred = r.preferred;
        this.totalColumnRequirements.maximum = r.maximum;
        Object o = attr.getAttribute(MCSS.Attribute.TEXT_ALIGN);
        r.alignment = o != null ? ((ta = o.toString()).equals("left") ? 0.0f : (ta.equals("center") ? 0.5f : (ta.equals("right") ? 1.0f : 0.0f))) : 0.0f;
        return r;
    }

    @Override
    protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
        this.updateInsets();
        this.rowIterator.updateAdjustments();
        r = MCSS.calculateTiledRequirements(this.rowIterator, r);
        r.maximum = r.preferred;
        return r;
    }

    @Override
    protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        this.updateGrid();
        int n = this.getRowCount();
        int i = 0;
        while (i < n) {
            RowView row = this.getRow(i);
            row.layoutChanged(axis);
            ++i;
        }
        this.layoutColumns(targetSpan, this.columnOffsets, this.columnSpans, this.columnRequirements);
        super.layoutMinorAxis(targetSpan, axis, offsets, spans);
    }

    @Override
    protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        this.rowIterator.setLayoutArrays(offsets, spans);
        MCSS.calculateTiledLayout(this.rowIterator, targetSpan);
        if (this.captionIndex != -1) {
            int h;
            View caption = this.getView(this.captionIndex);
            spans[this.captionIndex] = h = (int)caption.getPreferredSpan(1);
            short boxBottom = (short)this.painter.getInset(3, this);
            offsets[this.captionIndex] = boxBottom != this.getBottomInset() ? targetSpan + boxBottom : (int)(-this.getTopInset());
        }
    }

    @Override
    protected View getViewAtPosition(int pos, Rectangle a) {
        int n = this.getViewCount();
        int i = 0;
        while (i < n) {
            View v = this.getView(i);
            int p0 = v.getStartOffset();
            int p1 = v.getEndOffset();
            if (pos >= p0 && pos < p1) {
                if (a != null) {
                    this.childAllocation(i, a);
                }
                return v;
            }
            ++i;
        }
        if (pos == this.getEndOffset()) {
            View v = this.getView(n - 1);
            if (a != null) {
                this.childAllocation(n - 1, a);
            }
            return v;
        }
        return null;
    }

    @Override
    public AttributeSet getAttributes() {
        if (this.attr == null) {
            MStyleSheet sheet = this.getStyleSheet();
            this.attr = sheet.getViewAttributes(this);
        }
        return this.attr;
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        Rectangle a = allocation.getBounds();
        this.setSize(a.width, a.height);
        if (this.captionIndex != -1) {
            short top = (short)this.painter.getInset(1, this);
            short bottom = (short)this.painter.getInset(3, this);
            if (top != this.getTopInset()) {
                int h = this.getTopInset() - top;
                a.y += h;
                a.height -= h;
            } else {
                a.height -= this.getBottomInset() - bottom;
            }
        }
        this.painter.paint(g, a.x, a.y, a.width, a.height, this);
        int n = this.getViewCount();
        int i = 0;
        while (i < n) {
            View v = this.getView(i);
            v.paint(g, this.getChildAllocation(i, allocation));
            ++i;
        }
    }

    @Override
    public void setParent(View parent) {
        super.setParent(parent);
        if (parent != null) {
            this.setPropertiesFromAttributes();
        }
    }

    @Override
    public ViewFactory getViewFactory() {
        return this;
    }

    @Override
    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.insertUpdate(e, a, this);
    }

    @Override
    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.removeUpdate(e, a, this);
    }

    @Override
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.changedUpdate(e, a, this);
    }

    @Override
    protected void forwardUpdate(DocumentEvent.ElementChange ec, DocumentEvent e, Shape a, ViewFactory f) {
        Container c;
        super.forwardUpdate(ec, e, a, f);
        if (a != null && (c = this.getContainer()) != null) {
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            c.repaint(alloc.x, alloc.y, alloc.width, alloc.height);
        }
    }

    @Override
    public void replace(int offset, int length, View[] views) {
        super.replace(offset, length, views);
        this.invalidateGrid();
    }

    @Override
    public View create(Element elem) {
        ViewFactory f;
        View p;
        Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (o instanceof MHTML.Tag) {
            MHTML.Tag kind = (MHTML.Tag)o;
            if (kind == MHTML.Tag.TR) {
                return this.createTableRow(elem);
            }
            if (kind == MHTML.Tag.TD || kind == MHTML.Tag.TH) {
                return new CellView(elem);
            }
            if (kind == MHTML.Tag.CAPTION) {
                return new ParagraphView(elem);
            }
        }
        if ((p = this.getParent()) != null && (f = p.getViewFactory()) != null) {
            return f.create(elem);
        }
        return null;
    }

    class CellView
    extends MBlockView {
        public CellView(Element elem) {
            super(elem, 1);
        }

        @Override
        protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            super.layoutMajorAxis(targetSpan, axis, offsets, spans);
            int used = 0;
            int n = spans.length;
            int i = 0;
            while (i < n) {
                used += spans[i];
                ++i;
            }
            int adjust = 0;
            if (used < targetSpan) {
                String valign = (String)this.getElement().getAttributes().getAttribute(MHTML.Attribute.VALIGN);
                if (valign == null) {
                    AttributeSet rowAttr = this.getElement().getParentElement().getAttributes();
                    valign = (String)rowAttr.getAttribute(MHTML.Attribute.VALIGN);
                }
                if (valign == null || valign.equals("middle")) {
                    adjust = (targetSpan - used) / 2;
                } else if (valign.equals("bottom")) {
                    adjust = targetSpan - used;
                }
            }
            if (adjust != 0) {
                int i2 = 0;
                while (i2 < n) {
                    int n2 = i2++;
                    offsets[n2] = offsets[n2] + adjust;
                }
            }
        }

        @Override
        protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
            SizeRequirements req = super.calculateMajorAxisRequirements(axis, r);
            req.maximum = Integer.MAX_VALUE;
            return req;
        }

        @Override
        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
            SizeRequirements rv = super.calculateMinorAxisRequirements(axis, r);
            int n = this.getViewCount();
            int min = 0;
            int i = 0;
            while (i < n) {
                View v = this.getView(i);
                min = Math.max((int)v.getMinimumSpan(axis), min);
                ++i;
            }
            rv.minimum = Math.min(rv.minimum, min);
            return rv;
        }
    }

    class ColumnIterator
    implements MCSS.LayoutIterator {
        private int col;
        private int[] percentages;
        private int[] adjustmentWeights;
        private int[] offsets;
        private int[] spans;

        ColumnIterator() {
        }

        void disablePercentages() {
            this.percentages = null;
        }

        private void updatePercentagesAndAdjustmentWeights(int span) {
            this.adjustmentWeights = new int[MTableView.this.columnRequirements.length];
            int i = 0;
            while (i < MTableView.this.columnRequirements.length) {
                this.adjustmentWeights[i] = 0;
                ++i;
            }
            this.percentages = (int[])(MTableView.this.relativeCells ? new int[MTableView.this.columnRequirements.length] : null);
            int nrows = MTableView.this.getRowCount();
            int rowIndex = 0;
            while (rowIndex < nrows) {
                RowView row = MTableView.this.getRow(rowIndex);
                int col = 0;
                int ncells = row.getViewCount();
                int cell = 0;
                while (cell < ncells) {
                    View cv = row.getView(cell);
                    while (row.isFilled(col)) {
                        ++col;
                    }
                    int rowSpan = MTableView.this.getRowsOccupied(cv);
                    int colSpan = MTableView.this.getColumnsOccupied(cv);
                    AttributeSet a = cv.getAttributes();
                    MCSS.LengthValue lv = (MCSS.LengthValue)a.getAttribute(MCSS.Attribute.WIDTH);
                    if (lv != null) {
                        int len = (int)(lv.getValue(span) / (float)colSpan + 0.5f);
                        int i2 = 0;
                        while (i2 < colSpan) {
                            if (lv.isPercentage()) {
                                this.percentages[col + i2] = Math.max(this.percentages[col + i2], len);
                                this.adjustmentWeights[col + i2] = Math.max(this.adjustmentWeights[col + i2], 2);
                            } else {
                                this.adjustmentWeights[col + i2] = Math.max(this.adjustmentWeights[col + i2], 1);
                            }
                            ++i2;
                        }
                    }
                    col += colSpan - 1;
                    ++cell;
                    ++col;
                }
                ++rowIndex;
            }
        }

        public void setLayoutArrays(int[] offsets, int[] spans, int targetSpan) {
            this.offsets = offsets;
            this.spans = spans;
            this.updatePercentagesAndAdjustmentWeights(targetSpan);
        }

        @Override
        public int getCount() {
            return MTableView.this.columnRequirements.length;
        }

        @Override
        public void setIndex(int i) {
            this.col = i;
        }

        @Override
        public void setOffset(int offs) {
            this.offsets[this.col] = offs;
        }

        @Override
        public int getOffset() {
            return this.offsets[this.col];
        }

        @Override
        public void setSpan(int span) {
            this.spans[this.col] = span;
        }

        @Override
        public int getSpan() {
            return this.spans[this.col];
        }

        @Override
        public float getMinimumSpan(float parentSpan) {
            return MTableView.this.columnRequirements[this.col].minimum;
        }

        @Override
        public float getPreferredSpan(float parentSpan) {
            if (this.percentages != null && this.percentages[this.col] != 0) {
                return Math.max(this.percentages[this.col], MTableView.this.columnRequirements[this.col].minimum);
            }
            return MTableView.this.columnRequirements[this.col].preferred;
        }

        @Override
        public float getMaximumSpan(float parentSpan) {
            return MTableView.this.columnRequirements[this.col].maximum;
        }

        @Override
        public float getBorderWidth() {
            return MTableView.this.borderWidth;
        }

        @Override
        public float getLeadingCollapseSpan() {
            return MTableView.this.cellSpacing;
        }

        @Override
        public float getTrailingCollapseSpan() {
            return MTableView.this.cellSpacing;
        }

        @Override
        public int getAdjustmentWeight() {
            return this.adjustmentWeights[this.col];
        }
    }

    class RowIterator
    implements MCSS.LayoutIterator {
        private int row;
        private int[] adjustments;
        private int[] offsets;
        private int[] spans;

        RowIterator() {
        }

        void updateAdjustments() {
            int axis = 1;
            if (MTableView.this.multiRowCells) {
                int n = MTableView.this.getRowCount();
                this.adjustments = new int[n];
                int i = 0;
                while (i < n) {
                    RowView rv = MTableView.this.getRow(i);
                    if (rv.multiRowCells) {
                        int ncells = rv.getViewCount();
                        int j = 0;
                        while (j < ncells) {
                            View v = rv.getView(j);
                            int nrows = MTableView.this.getRowsOccupied(v);
                            if (nrows > 1) {
                                int spanNeeded = (int)v.getPreferredSpan(axis);
                                this.adjustMultiRowSpan(spanNeeded, nrows, i);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            } else {
                this.adjustments = null;
            }
        }

        void adjustMultiRowSpan(int spanNeeded, int nrows, int rowIndex) {
            if (rowIndex + nrows > this.getCount() && (nrows = this.getCount() - rowIndex) < 1) {
                return;
            }
            int span = 0;
            int i = 0;
            while (i < nrows) {
                RowView rv = MTableView.this.getRow(rowIndex + i);
                span = (int)((float)span + rv.getPreferredSpan(1));
                ++i;
            }
            if (spanNeeded > span) {
                int adjust = spanNeeded - span;
                int rowAdjust = adjust / nrows;
                int firstAdjust = rowAdjust + (adjust - rowAdjust * nrows);
                RowView rv = MTableView.this.getRow(rowIndex);
                this.adjustments[rowIndex] = Math.max(this.adjustments[rowIndex], firstAdjust);
                int i2 = 1;
                while (i2 < nrows) {
                    this.adjustments[rowIndex + i2] = Math.max(this.adjustments[rowIndex + i2], rowAdjust);
                    ++i2;
                }
            }
        }

        void setLayoutArrays(int[] offsets, int[] spans) {
            this.offsets = offsets;
            this.spans = spans;
        }

        @Override
        public void setOffset(int offs) {
            RowView rv = MTableView.this.getRow(this.row);
            if (rv != null) {
                this.offsets[rv.viewIndex] = offs;
            }
        }

        @Override
        public int getOffset() {
            RowView rv = MTableView.this.getRow(this.row);
            if (rv != null) {
                return this.offsets[rv.viewIndex];
            }
            return 0;
        }

        @Override
        public void setSpan(int span) {
            RowView rv = MTableView.this.getRow(this.row);
            if (rv != null) {
                this.spans[rv.viewIndex] = span;
            }
        }

        @Override
        public int getSpan() {
            RowView rv = MTableView.this.getRow(this.row);
            if (rv != null) {
                return this.spans[rv.viewIndex];
            }
            return 0;
        }

        @Override
        public int getCount() {
            return MTableView.this.rows.size();
        }

        @Override
        public void setIndex(int i) {
            this.row = i;
        }

        @Override
        public float getMinimumSpan(float parentSpan) {
            return this.getPreferredSpan(parentSpan);
        }

        @Override
        public float getPreferredSpan(float parentSpan) {
            RowView rv = MTableView.this.getRow(this.row);
            if (rv != null) {
                int adjust = this.adjustments != null ? this.adjustments[this.row] : 0;
                return rv.getPreferredSpan(MTableView.this.getAxis()) + (float)adjust;
            }
            return 0.0f;
        }

        @Override
        public float getMaximumSpan(float parentSpan) {
            return this.getPreferredSpan(parentSpan);
        }

        @Override
        public float getBorderWidth() {
            return MTableView.this.borderWidth;
        }

        @Override
        public float getLeadingCollapseSpan() {
            return MTableView.this.cellSpacing;
        }

        @Override
        public float getTrailingCollapseSpan() {
            return MTableView.this.cellSpacing;
        }

        @Override
        public int getAdjustmentWeight() {
            return 0;
        }
    }

    public class RowView
    extends BoxView {
        private MStyleSheet.BoxPainter painter;
        private AttributeSet attr;
        BitSet fillColumns;
        int rowIndex;
        int viewIndex;
        boolean multiRowCells;

        public RowView(Element elem) {
            super(elem, 0);
            this.fillColumns = new BitSet();
            this.setPropertiesFromAttributes();
        }

        void clearFilledColumns() {
            this.fillColumns.and(EMPTY);
        }

        void fillColumn(int col) {
            this.fillColumns.set(col);
        }

        boolean isFilled(int col) {
            return this.fillColumns.get(col);
        }

        int getColumnCount() {
            int nfill = 0;
            int n = this.fillColumns.size();
            int i = 0;
            while (i < n) {
                if (this.fillColumns.get(i)) {
                    ++nfill;
                }
                ++i;
            }
            return this.getViewCount() + nfill;
        }

        @Override
        public AttributeSet getAttributes() {
            return this.attr;
        }

        View findViewAtPoint(int x, int y, Rectangle alloc) {
            int n = this.getViewCount();
            int i = 0;
            while (i < n) {
                if (this.getChildAllocation(i, alloc).contains(x, y)) {
                    this.childAllocation(i, alloc);
                    return this.getView(i);
                }
                ++i;
            }
            return null;
        }

        protected MStyleSheet getStyleSheet() {
            MHTMLDocument doc = (MHTMLDocument)this.getDocument();
            return doc.getStyleSheet();
        }

        @Override
        public void preferenceChanged(View child, boolean width, boolean height) {
            super.preferenceChanged(child, width, height);
            if (MTableView.this.multiRowCells && height) {
                int i = this.rowIndex - 1;
                while (i >= 0) {
                    RowView rv = MTableView.this.getRow(i);
                    if (rv.multiRowCells) {
                        rv.preferenceChanged(null, false, true);
                        break;
                    }
                    --i;
                }
            }
        }

        @Override
        protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
            SizeRequirements req = new SizeRequirements();
            req.minimum = MTableView.this.totalColumnRequirements.minimum;
            req.maximum = MTableView.this.totalColumnRequirements.maximum;
            req.preferred = MTableView.this.totalColumnRequirements.preferred;
            req.alignment = 0.0f;
            return req;
        }

        @Override
        public float getMinimumSpan(int axis) {
            float value = axis == 0 ? (float)(MTableView.this.totalColumnRequirements.minimum + this.getLeftInset() + this.getRightInset()) : super.getMinimumSpan(axis);
            return value;
        }

        @Override
        public float getMaximumSpan(int axis) {
            float value = axis == 0 ? 2.1474836E9f : super.getMaximumSpan(axis);
            return value;
        }

        @Override
        public float getPreferredSpan(int axis) {
            float value = axis == 0 ? (float)(MTableView.this.totalColumnRequirements.preferred + this.getLeftInset() + this.getRightInset()) : super.getPreferredSpan(axis);
            return value;
        }

        @Override
        public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            super.changedUpdate(e, a, f);
            int pos = e.getOffset();
            if (pos <= this.getStartOffset() && pos + e.getLength() >= this.getEndOffset()) {
                this.setPropertiesFromAttributes();
            }
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
            Rectangle a = (Rectangle)allocation;
            this.painter.paint(g, a.x, a.y, a.width, a.height, this);
            super.paint(g, a);
        }

        @Override
        public void replace(int offset, int length, View[] views) {
            super.replace(offset, length, views);
            MTableView.this.invalidateGrid();
        }

        @Override
        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
            long min = 0L;
            long pref = 0L;
            long max = 0L;
            this.multiRowCells = false;
            int n = this.getViewCount();
            int i = 0;
            while (i < n) {
                View v = this.getView(i);
                if (MTableView.this.getRowsOccupied(v) > 1) {
                    this.multiRowCells = true;
                    max = Math.max((long)((int)v.getMaximumSpan(axis)), max);
                } else {
                    min = Math.max((long)((int)v.getMinimumSpan(axis)), min);
                    pref = Math.max((long)((int)v.getPreferredSpan(axis)), pref);
                    max = Math.max((long)((int)v.getMaximumSpan(axis)), max);
                }
                ++i;
            }
            if (r == null) {
                r = new SizeRequirements();
                r.alignment = 0.5f;
            }
            r.preferred = (int)pref;
            r.minimum = (int)min;
            r.maximum = (int)max;
            return r;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            col = 0;
            ncells = this.getViewCount();
            cell = 0;
            while (cell < ncells) {
                block5: {
                    cv = this.getView(cell);
                    if (!MTableView.this.skipComments || cv instanceof CellView) ** GOTO lbl9
                    break block5;
lbl-1000:
                    // 1 sources

                    {
                        ++col;
lbl9:
                        // 2 sources

                        ** while (this.isFilled((int)col))
                    }
lbl10:
                    // 1 sources

                    colSpan = MTableView.this.getColumnsOccupied(cv);
                    spans[cell] = MTableView.this.columnSpans[col];
                    offsets[cell] = MTableView.this.columnOffsets[col];
                    if (colSpan > 1) {
                        n = MTableView.this.columnSpans.length;
                        j = 1;
                        while (j < colSpan) {
                            if (col + j < n) {
                                v0 = cell;
                                spans[v0] = spans[v0] + MTableView.this.columnSpans[col + j];
                                v1 = cell;
                                spans[v1] = spans[v1] + MTableView.access$2(MTableView.this);
                            }
                            ++j;
                        }
                        col += colSpan - 1;
                    }
                    ++col;
                }
                ++cell;
            }
        }

        @Override
        protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            super.layoutMinorAxis(targetSpan, axis, offsets, spans);
            int col = 0;
            int ncells = this.getViewCount();
            int cell = 0;
            while (cell < ncells) {
                View cv = this.getView(cell);
                while (this.isFilled(col)) {
                    ++col;
                }
                int colSpan = MTableView.this.getColumnsOccupied(cv);
                int rowSpan = MTableView.this.getRowsOccupied(cv);
                if (rowSpan > 1) {
                    int row0 = this.rowIndex;
                    int row1 = Math.min(this.rowIndex + rowSpan - 1, MTableView.this.getRowCount() - 1);
                    spans[cell] = MTableView.this.getMultiRowSpan(row0, row1);
                }
                if (colSpan > 1) {
                    col += colSpan - 1;
                }
                ++cell;
                ++col;
            }
        }

        @Override
        public int getResizeWeight(int axis) {
            return 1;
        }

        @Override
        protected View getViewAtPosition(int pos, Rectangle a) {
            int n = this.getViewCount();
            int i = 0;
            while (i < n) {
                View v = this.getView(i);
                int p0 = v.getStartOffset();
                int p1 = v.getEndOffset();
                if (pos >= p0 && pos < p1) {
                    if (a != null) {
                        this.childAllocation(i, a);
                    }
                    return v;
                }
                ++i;
            }
            if (pos == this.getEndOffset()) {
                View v = this.getView(n - 1);
                if (a != null) {
                    this.childAllocation(n - 1, a);
                }
                return v;
            }
            return null;
        }

        void setPropertiesFromAttributes() {
            MStyleSheet sheet = this.getStyleSheet();
            this.attr = sheet.getViewAttributes(this);
            this.painter = sheet.getBoxPainter(this.attr);
        }
    }
}

