<?php
class items_cateModel extends RelationModel
{
	protected $_link = array(
        'items' => array(
        	'mapping_type'  => HAS_MANY,
        	'class_name'    => 'items',
        	'foreign_key'   => 'cid',
	),
        'items_tags' => array(
        	'mapping_type'  => MANY_TO_MANY,
        	'class_name'    => 'items_tags',
        	'foreign_key'   => 'cate_id',
        	'relation_foreign_key'=>'tag_id',
            'relation_table' => 'items_tags_cate',
            'auto_prefix' => true
	)
	);

	public function get_tags_ids($cate_id)
	{
		$list = $this->relation('items_tags')->where("id=".$cate_id)->find();
		$ids = array();
		foreach($list['items_tags'] as $tag)
		{
			$ids[] = $tag['id'];
		}
		return $ids;
	}

	public function get_cid_by_tags($tags)
	{
		$tags = array_unique($tags);
		$items_tags_mod = D('items_tags');
		foreach ($tags as $tag) {
			$re = $items_tags_mod->field(C('DB_PREFIX')."items_tags.id,".C('DB_PREFIX')."items_tags.name,itc.cate_id")->JOIN("LEFT JOIN ".C('DB_PREFIX')."items_tags_cate as itc ON itc.tag_id=".C('DB_PREFIX')."items_tags.id")->where(C('DB_PREFIX')."items_tags.name='".$tag."'")->find();
			if ($re) {
				return $re['cate_id'];
			}
		}
		return 0;
	}
	function get_list(){
		$res = $this->order('ordid ASC')->select();
		$cate_list = array();
		foreach ($res as $val) {
			if ($val['pid'] == 0) {
				$cate_list['parent'][$val['id']] = $val;
			} else {
				$cate_list['sub'][$val['pid']][] = $val;
			}
		}
		return $cate_list;
	}
}