<?php
/**
 * TOP API: taobao.hotel.type.add request
 *
 * @author auto create
 * @since 1.0, 2012-02-07 12:35:56
 */
class HotelTypeAddRequest
{
	/**
	 * 酒店id。必须为数字
	 **/
	private $hid;

	/**
	 * 房型名称。长度不能超过30
	 **/
	private $name;

	private $apiParas = array();

	public function setHid($hid)
	{
		$this->hid = $hid;
		$this->apiParas["hid"] = $hid;
	}

	public function getHid()
	{
		return $this->hid;
	}

	public function setName($name)
	{
		$this->name = $name;
		$this->apiParas["name"] = $name;
	}

	public function getName()
	{
		return $this->name;
	}

	public function getApiMethodName()
	{
		return "taobao.hotel.type.add";
	}

	public function getApiParas()
	{
		return $this->apiParas;
	}

	public function check()
	{

		RequestCheckUtil::checkNotNull($this->hid,"hid");
		RequestCheckUtil::checkMinValue($this->hid,0,"hid");
		RequestCheckUtil::checkNotNull($this->name,"name");
		RequestCheckUtil::checkMaxLength($this->name,30,"name");
	}
}
