<?php
/**
 * TOP API: taobao.wlb.inventory.detail.get request
 *
 * @author auto create
 * @since 1.0, 2012-02-07 12:35:56
 */
class WlbInventoryDetailGetRequest
{
	/**
	 * 库存类型列表，值包括：
	 VENDIBLE--可销售库存
	 FREEZE--冻结库存
	 ONWAY--在途库存
	 DEFECT--残次品库存
	 ENGINE_DAMAGE--机损
	 BOX_DAMAGE--箱损
	 **/
	private $inventoryTypeList;

	/**
	 * 商品ID
	 **/
	private $itemId;

	/**
	 * 仓库编码
	 **/
	private $storeCode;

	private $apiParas = array();

	public function setInventoryTypeList($inventoryTypeList)
	{
		$this->inventoryTypeList = $inventoryTypeList;
		$this->apiParas["inventory_type_list"] = $inventoryTypeList;
	}

	public function getInventoryTypeList()
	{
		return $this->inventoryTypeList;
	}

	public function setItemId($itemId)
	{
		$this->itemId = $itemId;
		$this->apiParas["item_id"] = $itemId;
	}

	public function getItemId()
	{
		return $this->itemId;
	}

	public function setStoreCode($storeCode)
	{
		$this->storeCode = $storeCode;
		$this->apiParas["store_code"] = $storeCode;
	}

	public function getStoreCode()
	{
		return $this->storeCode;
	}

	public function getApiMethodName()
	{
		return "taobao.wlb.inventory.detail.get";
	}

	public function getApiParas()
	{
		return $this->apiParas;
	}

	public function check()
	{

		RequestCheckUtil::checkMaxListSize($this->inventoryTypeList,20,"inventoryTypeList");
		RequestCheckUtil::checkNotNull($this->itemId,"itemId");
	}
}
