<?php
/**
 * TOP API: taobao.wlb.subscription.query request
 *
 * @author auto create
 * @since 1.0, 2012-02-07 12:35:56
 */
class WlbSubscriptionQueryRequest
{
	/**
	 * 当前页
	 **/
	private $pageNo;

	/**
	 * 分页记录个数，如果用户输入的记录数大于50，则一页显示50条记录
	 **/
	private $pageSize;

	/**
	 * 状态
	 AUDITING 1-待审核;
	 CANCEL 2-撤销 ;
	 CHECKED 3-审核通过 ;
	 FAILED 4-审核未通过 ;
	 SYNCHRONIZING 5-同步中;
	 只允许输入上面指定的值，且可以为空，为空时查询所有状态。若输错了，则按AUDITING处理。
	 **/
	private $status;

	private $apiParas = array();

	public function setPageNo($pageNo)
	{
		$this->pageNo = $pageNo;
		$this->apiParas["page_no"] = $pageNo;
	}

	public function getPageNo()
	{
		return $this->pageNo;
	}

	public function setPageSize($pageSize)
	{
		$this->pageSize = $pageSize;
		$this->apiParas["page_size"] = $pageSize;
	}

	public function getPageSize()
	{
		return $this->pageSize;
	}

	public function setStatus($status)
	{
		$this->status = $status;
		$this->apiParas["status"] = $status;
	}

	public function getStatus()
	{
		return $this->status;
	}

	public function getApiMethodName()
	{
		return "taobao.wlb.subscription.query";
	}

	public function getApiParas()
	{
		return $this->apiParas;
	}

	public function check()
	{

	}
}
