
-- Std Library ver 7.0

local type = _G.type;
local assert =  _G.assert;
local setmetatable =  _G.setmetatable;
local _IMPORTDIR = _G._IMPORTDIR;
local string = _G.string;
local _NULL = _NULL;


namespace("std"); 

local win = _G.win
	
dofile =  function(f)  
	f = win.path(f, _G._LASDIR , win.getExeDir(),_IMPORTDIR );
	_G.dofile(f)
        return f;	
end;
		
loadfile =  function(f)  
	f = win.path(f, _G._LASDIR , win.getExeDir(),_IMPORTDIR  );
	return _G.loadfile(f),f;  
end;

dump = function(las)
	local func,f = loadfile(las);
	local bin = string.dump(func);
	string.save(bin,f);
end;

function import2(lib,url)	
    re,msg = _G.pcall(import,lib);
    if( re == false ) then
        win.messagePrint("downloading '"..lib..".dll'")
        win.createDir(_IMPORTDIR)
        local str = _G.web.getURL(url,"","",_IMPORTDIR..lib..".dll")
        if(str) then 
            win.messagePrint("download '"..lib.."'  complete "); 
        else 
            win.messagePrint("download '"..lib.."' failed !");
            return false;
        end;
    end;
    _G.import(lib) 
    return true;
end;

namespace("std.table",_G.table); 
new = function(t)
	local obj =  {} 
	if(t)then 
		assert(type(t)=="table","class("..type(t)..") ! parameter is not a table",2);
		setmetatable(obj, t ) 
		t.__index = t; 
	end;
	
	return obj
end;

copy = function(t)
	assert(type(t)=="table","class("..type(t)..") ! parameter is not a table",2);
	local obj =  {};
		
	local n = table.getn(t); 
	table.setn(obj,n )
			
	for k,v in pairs(t) do  
		obj[k] = v;
	end;
		
	local obj_meta = getmetatable(t);
	setmetatable(obj,obj_meta);
	return obj;
end;

namespace( "std" ); 
function class(t)
	local class_template = t or {};

	function class_template:new(...)
		local o = table.new(self);
		if(o.__new)then o:__new(_G.unpack(arg)) end;
		return o;
	end;

	local tab_meta = {}
	setmetatable(class_template, tab_meta)
	tab_meta.__call = class_template.new;
	return class_template;
end;



namespace("std.string",_G.string); 
local math = _G.math;
random = function( n,str )
    str = str or  "ABCDEFGHIJKLMNUVWXYZabcdefghijklmnuvwxyz123456789"
    local tab = {};
    local j = 0;
    local l = #str;
    
    math.randomseed(_G.os.tick());

    local step = 1;
    if( byte( str, 1 )>0x80)then
        step = 2;
    end;

	for i=1,n,step do
		j =math.random(1,l); 
       
		if( step==2 ) then 
			j = math.floor((j/2)) * 2 -1;
			if(j<1)then j = 1 end; 
			tab[i] = byte( str, j )
			tab[i+1] = byte( str, j+1 );
		else 
			tab[i] = byte( str, j ) 
		end;
	end;
	return char( _G.unpack(tab) );
end;

local dll = _G.dll;
getGUID = function()
	local GUID = {
	    Data1=0;
	    Data2=0;
	    Data3=0;
	    Data4="00000000"; --char[]
	 "IData1"; "NData2"; "NData3"; "sData4" 
	}
	
	UuidCreate = dll.open("rpcrt4.dll", "UuidCreate", "I(P)")
	UuidToString  = dll.open("rpcrt4.dll", "UuidToString", "I(P,P)")
	RpcStringFree  = dll.open("rpcrt4.dll", "RpcStringFree", "I(p)")
	
	UuidCreate(GUID); 
	local lpsz = 0; 
	local re,_,lpsz = UuidToString(GUID,lpsz);
	local str = c(lpsz);
	RpcStringFree(lpsz);
	
	return str;
end;


namespace("std.win",_G.win);

function gfind(cls)
     local after = _NULL 
     local cls = cls;
     local title = title local iter = function ()
          after = findX(_NULL,after,cls,"")
          if(not after)then 
               return nil;
          else 
               return after,getString(after);
          end
     end
     return iter; 
end



namespace("_G")
	

_DLCTL_DLIMAGES                 = 0x00000010 
_DLCTL_VIDEOS                   = 0x00000020 
_DLCTL_BGSOUNDS                 = 0x00000040 
_DLCTL_NO_SCRIPTS               = 0x00000080 
_DLCTL_NO_JAVA                  = 0x00000100 
_DLCTL_NO_RUNACTIVEXCTLS        = 0x00000200 
_DLCTL_NO_DLACTIVEXCTLS         = 0x00000400 
_DLCTL_DOWNLOADONLY             = 0x00000800 
_DLCTL_NO_FRAMEDOWNLOAD         = 0x00001000 
_DLCTL_RESYNCHRONIZE            = 0x00002000 
_DLCTL_PRAGMA_NO_CACHE          = 0x00004000 
_DLCTL_NO_BEHAVIORS             = 0x00008000 
_DLCTL_NO_METACHARSET           = 0x00010000
_DLCTL_URL_ENCODING_DISABLE_UTF8= 0x00020000 
_DLCTL_URL_ENCODING_ENABLE_UTF8 = 0x00040000 
_DLCTL_NOFRAMES                 = 0x00080000 
_DLCTL_FORCEOFFLINE             = 0x10000000 
_DLCTL_NO_CLIENTPULL            = 0x20000000 
_DLCTL_SILENT                   = 0x40000000 
_DLCTL_OFFLINEIFNOTCONNECTED    = 0x80000000 
_DLCTL_OFFLINE                  = 0x80000000 

_MIX_COPY = 0;
_MIX_MASK = 1;
_MIX_DSTMASK = 2;
_MIX_SRCMASK = 3;
_MIX_SRCMASK2 = 4;
_MIX_DSTBLEND = 5;
_MIX_SCREEN = 6;
_MIX_ADD = 7;
_MIX_SUB = 8;
_MIX_AND = 9;
_MIX_XOR = 10;
_MIX_OR = 11;

-- img:mix(img2,_MIX_COPY,1,1);

_SW_HIDE           = 0
_SW_NORMAL         = 1
_SW_SHOWMINIMIZED  = 2
_SW_MAXIMIZE       = 3
_SW_SHOWNOACTIVATE = 4
_SW_SHOW           = 5
_SW_MINIMIZE       = 6
_SW_SHOWMINNOACTIVE= 7
_SW_SHOWNA         = 8
_SW_RESTORE        = 9
_SW_SHOWDEFAULT    = 10
_SW_MAX            = 11

-- win.exec("c:\\t.exe"," /k:v","",_SW_SHOW)
-- win.show(hwnd,_SW_MAX);
-- wb:show(_SW_MAX);

--type ڴ
_MEM_MAPPED        = 0x40000  
_MEM_PRIVATE       = 0x20000 
_MEM_MAPPED        = 0x40000

--protect ҳ
_PAGE_NOACCESS    = 0x01     
_PAGE_READONLY    = 0x02     
_PAGE_READWRITE   = 0x04     
_PAGE_WRITECOPY   = 0x08     
_PAGE_EXECUTE     = 0x10     
_PAGE_EXECUTE_READ= 0x20     
_PAGE_EXECUTE_READWRITE = 0x40     
_PAGE_EXECUTE_WRITECOPY = 0x80     
_PAGE_GUARD       = 0x100     
_PAGE_NOCACHE     = 0x200     
_PAGE_WRITECOMBINE= 0x400 

-- size,base,protect,type = mem.query(base + size,_PAGE_READWRITE,_MEM_PRIVATE);

_CP_ACP       = 0      --default to ANSI code page
_CP_OEMCP     = 1      --default to OEM  code page
_CP_MACCP     = 2       --default to MAC  code page
_CP_THREAD_ACP= 3  --current thread's ANSI code page
_CP_SYMBOL    = 42     --SYMBOL translations
_CP_UTF7      = 65000   --UTF-7 translation
_CP_UTF8      = 65001   --UTF-8 translation
_CP_CHS       = 936
_CP_CHT       = 950

--str  = string.toUnicode(str,950);
--str  = string.fromUnicode(str,936);

_S_OK = 0;
_S_FALSE = 1;

_FATTR_READONLY           =0x00000001  
_FATTR_HIDDEN             =0x00000002  
_FATTR_SYSTEM             =0x00000004  
_FATTR_DIRECTORY          =0x00000010  
_FATTR_ARCHIVE            =0x00000020  
_FATTR_DEVICE             =0x00000040  
_FATTR_NORMAL             =0x00000080  
_FATTR_TEMPORARY          =0x00000100  
_FATTR_SPARSE_FILE        =0x00000200  
_FATTR_REPARSE_POINT      =0x00000400  
_FATTR_COMPRESSED         =0x00000800  
_FATTR_OFFLINE            =0x00001000  
_FATTR_NOT_CONTENT_INDEXED=0x00002000  
_FATTR_ENCRYPTED          =0x00004000  

-- if(win.getf("c:\\test.txt") & _FATTR_HIDDEN ==_FATTR_HIDDEN ) then print("hide file") end;
-- win.setf("c:\\test.txt",_FATTR_HIDDEN);

class = std.class;
import2 = std.import2;

string.random = std.string.random;
string.getGUID = std.string.getGUID;
win.gfind = std.win.gfind;


--[[ samples 
import("std"); 

win.consoleOpen()
	
cls2 = std.class();
	function cls2:__new(a,b) win.messageBox(a,b) end;
	function cls2:__call() win.messageBox(type(self)) end;
	cls2.property = "TEST!"
 
namespace("cls",std.class);
	local win =  _G.win;
	function __new(self,a,b) win.messageBox(a,b) end;
	function __call(self) win.messageBox(_G.type(self)) end;
	property = "TEST!"
	function func2(self)  
		win.messageBox("func2",self.property)	 
	end;
namespace( "_G" ); 

temp2 = cls:new("test","temp2 constructor"); 
temp2.property = "temp2"
temp2:func2();

temp3 = cls("hello","temp3 constructor"); 
temp3(); 

for hwnd,title in std.win.gfind("#32770") do
	print(hwnd,title)
end;

print( std.string.getGUID() );
print( std.string.random(10) );

std.dump( "std.LAS" );
std.import2("comx","http://www.ecranesoft.com/ape/import/comx/comx.dll")
--]]


