import sims.sim_info
import injector

@injector.inject_to(sims.sim_info.SimInfo, "_set_fit_fat")
def my_set_fit_fat(original, self):
    # backup fat
    physique = [x for x in self.physique.split(',')]
    heavy = physique[sims.sim_info.SimInfo.BodyBlendTypes.BODYBLENDTYPE_HEAVY]
    lean = physique[sims.sim_info.SimInfo.BodyBlendTypes.BODYBLENDTYPE_LEAN]
    
    # call original
    original(self)
    
    # rollback fat
    physique = [x for x in self.physique.split(',')]
    physique[sims.sim_info.SimInfo.BodyBlendTypes.BODYBLENDTYPE_HEAVY] = heavy
    physique[sims.sim_info.SimInfo.BodyBlendTypes.BODYBLENDTYPE_LEAN] = lean
    physique = ','.join([x for x in physique])
    self.physique = physique
