/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.SwingUtilities3;
import java.awt.Component;
import java.awt.Container;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import sun.awt.AppContext;
import sun.awt.EventQueueDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingUtilities3 {
    private static final Object DELEGATE_REPAINT_MANAGER_KEY = new Object();
    private static final Map<Container, Boolean> vsyncedMap = Collections.synchronizedMap(new WeakHashMap());

    public static void setDelegateRepaintManager(JComponent jComponent, RepaintManager repaintManager) {
        AppContext.getAppContext().put(DELEGATE_REPAINT_MANAGER_KEY, Boolean.TRUE);
        jComponent.putClientProperty(DELEGATE_REPAINT_MANAGER_KEY, repaintManager);
    }

    public static void setVsyncRequested(Container container, boolean bl) {
        assert (SwingUtilities.getRoot(container) == container);
        if (bl) {
            vsyncedMap.put(container, Boolean.TRUE);
        } else {
            vsyncedMap.remove(container);
        }
    }

    public static boolean isVsyncRequested(Container container) {
        assert (SwingUtilities.getRoot(container) == container);
        return Boolean.TRUE == vsyncedMap.get(container);
    }

    public static RepaintManager getDelegateRepaintManager(Component component) {
        RepaintManager repaintManager = null;
        if (Boolean.TRUE == AppContext.getAppContext().get(DELEGATE_REPAINT_MANAGER_KEY)) {
            while (repaintManager == null && component != null) {
                while (component != null && !(component instanceof JComponent)) {
                    component = component.getParent();
                }
                if (component == null) continue;
                repaintManager = (RepaintManager)((JComponent)component).getClientProperty(DELEGATE_REPAINT_MANAGER_KEY);
                component = component.getParent();
            }
        }
        return repaintManager;
    }

    public static void setEventQueueDelegate(Map<String, Map<String, Object>> map) {
        EventQueueDelegate.setDelegate((EventQueueDelegate.Delegate)new EventQueueDelegateFromMap(map));
    }
}

