/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.ByteBuffer;
import java.util.Map;
import sun.misc.SharedSecrets;
import sun.reflect.ConstantPool;
import sun.reflect.MethodAccessor;
import sun.reflect.Reflection;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.ExceptionProxy;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.MethodRepository;
import sun.reflect.generics.scope.MethodScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Method
extends AccessibleObject
implements GenericDeclaration,
Member {
    private Class clazz;
    private int slot;
    private String name;
    private Class returnType;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;
    private int modifiers;
    private transient String signature;
    private transient MethodRepository genericInfo;
    private byte[] annotations;
    private byte[] parameterAnnotations;
    private byte[] annotationDefault;
    private volatile MethodAccessor methodAccessor;
    private Method root;
    private Class securityCheckCache;
    private Class securityCheckTargetClassCache;
    private static final int LANGUAGE_MODIFIERS = 1343;
    private transient Map<Class, Annotation> declaredAnnotations;

    private String getGenericSignature() {
        return this.signature;
    }

    private GenericsFactory getFactory() {
        return CoreReflectionFactory.make(this, MethodScope.make(this));
    }

    private MethodRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = MethodRepository.make(this.getGenericSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    Method(Class clazz, String string, Class[] classArray, Class clazz2, Class[] classArray2, int n, int n2, String string2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.clazz = clazz;
        this.name = string;
        this.parameterTypes = classArray;
        this.returnType = clazz2;
        this.exceptionTypes = classArray2;
        this.modifiers = n;
        this.slot = n2;
        this.signature = string2;
        this.annotations = byArray;
        this.parameterAnnotations = byArray2;
        this.annotationDefault = byArray3;
    }

    Method copy() {
        Method method = new Method(this.clazz, this.name, this.parameterTypes, this.returnType, this.exceptionTypes, this.modifiers, this.slot, this.signature, this.annotations, this.parameterAnnotations, this.annotationDefault);
        method.root = this;
        method.methodAccessor = this.methodAccessor;
        return method;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public TypeVariable<Method>[] getTypeParameters() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getTypeParameters();
        }
        return new TypeVariable[0];
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Type getGenericReturnType() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getReturnType();
        }
        return this.getReturnType();
    }

    public Class<?>[] getParameterTypes() {
        return (Class[])this.parameterTypes.clone();
    }

    public Type[] getGenericParameterTypes() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getParameterTypes();
        }
        return this.getParameterTypes();
    }

    public Class<?>[] getExceptionTypes() {
        return (Class[])this.exceptionTypes.clone();
    }

    public Type[] getGenericExceptionTypes() {
        Type[] typeArray;
        if (this.getGenericSignature() != null && (typeArray = this.getGenericInfo().getExceptionTypes()).length > 0) {
            return typeArray;
        }
        return this.getExceptionTypes();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Method) {
            Method method = (Method)object;
            if (this.getDeclaringClass() == method.getDeclaringClass() && this.getName() == method.getName()) {
                if (!this.returnType.equals(method.getReturnType())) {
                    return false;
                }
                Class[] classArray = this.parameterTypes;
                Class[] classArray2 = method.parameterTypes;
                if (classArray.length == classArray2.length) {
                    for (int i = 0; i < classArray.length; ++i) {
                        if (classArray[i] == classArray2[i]) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.getModifiers() & 0x53F;
            if (n != 0) {
                stringBuffer.append(Modifier.toString(n) + " ");
            }
            stringBuffer.append(Field.getTypeName(this.getReturnType()) + " ");
            stringBuffer.append(Field.getTypeName(this.getDeclaringClass()) + ".");
            stringBuffer.append(this.getName() + "(");
            Class[] classArray = this.parameterTypes;
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append(Field.getTypeName(classArray[i]));
                if (i >= classArray.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
            Class[] classArray2 = this.exceptionTypes;
            if (classArray2.length > 0) {
                stringBuffer.append(" throws ");
                for (int i = 0; i < classArray2.length; ++i) {
                    stringBuffer.append(classArray2[i].getName());
                    if (i >= classArray2.length - 1) continue;
                    stringBuffer.append(",");
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    public String toGenericString() {
        try {
            TypeVariable<Method>[] typeVariableArray;
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.getModifiers() & 0x53F;
            if (n != 0) {
                stringBuilder.append(Modifier.toString(n) + " ");
            }
            if ((typeVariableArray = this.getTypeParameters()).length > 0) {
                boolean bl = true;
                stringBuilder.append("<");
                for (TypeVariable<Method> typeVariable : typeVariableArray) {
                    if (!bl) {
                        stringBuilder.append(",");
                    }
                    if (typeVariable instanceof Class) {
                        stringBuilder.append(((Class)((Object)typeVariable)).getName());
                    } else {
                        stringBuilder.append(typeVariable.toString());
                    }
                    bl = false;
                }
                stringBuilder.append("> ");
            }
            Type type = this.getGenericReturnType();
            stringBuilder.append((type instanceof Class ? Field.getTypeName((Class)type) : type.toString()) + " ");
            stringBuilder.append(Field.getTypeName(this.getDeclaringClass()) + ".");
            stringBuilder.append(this.getName() + "(");
            Type[] typeArray = this.getGenericParameterTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                stringBuilder.append(typeArray[i] instanceof Class ? Field.getTypeName((Class)typeArray[i]) : typeArray[i].toString());
                if (i >= typeArray.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append(")");
            Type[] typeArray2 = this.getGenericExceptionTypes();
            if (typeArray2.length > 0) {
                stringBuilder.append(" throws ");
                for (int i = 0; i < typeArray2.length; ++i) {
                    stringBuilder.append(typeArray2[i] instanceof Class ? ((Class)typeArray2[i]).getName() : typeArray2[i].toString());
                    if (i >= typeArray2.length - 1) continue;
                    stringBuilder.append(",");
                }
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object object, Object ... objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            boolean bl;
            Class clazz = Reflection.getCallerClass(1);
            Class<?> clazz2 = object == null || !Modifier.isProtected(this.modifiers) ? this.clazz : object.getClass();
            Method method = this;
            synchronized (method) {
                bl = this.securityCheckCache == clazz && this.securityCheckTargetClassCache == clazz2;
            }
            if (!bl) {
                Reflection.ensureMemberAccess(clazz, this.clazz, object, this.modifiers);
                method = this;
                synchronized (method) {
                    this.securityCheckCache = clazz;
                    this.securityCheckTargetClassCache = clazz2;
                }
            }
        }
        if (this.methodAccessor == null) {
            this.acquireMethodAccessor();
        }
        return this.methodAccessor.invoke(object, objectArray);
    }

    public boolean isBridge() {
        return (this.getModifiers() & 0x40) != 0;
    }

    public boolean isVarArgs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    private void acquireMethodAccessor() {
        MethodAccessor methodAccessor = null;
        if (this.root != null) {
            methodAccessor = this.root.getMethodAccessor();
        }
        if (methodAccessor != null) {
            this.methodAccessor = methodAccessor;
            return;
        }
        methodAccessor = reflectionFactory.newMethodAccessor(this);
        this.setMethodAccessor(methodAccessor);
    }

    MethodAccessor getMethodAccessor() {
        return this.methodAccessor;
    }

    void setMethodAccessor(MethodAccessor methodAccessor) {
        this.methodAccessor = methodAccessor;
        if (this.root != null) {
            this.root.setMethodAccessor(methodAccessor);
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return (T)this.declaredAnnotations().get(clazz);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return AnnotationParser.toArray(this.declaredAnnotations());
    }

    private synchronized Map<Class, Annotation> declaredAnnotations() {
        if (this.declaredAnnotations == null) {
            this.declaredAnnotations = AnnotationParser.parseAnnotations((byte[])this.annotations, (ConstantPool)SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        }
        return this.declaredAnnotations;
    }

    public Object getDefaultValue() {
        if (this.annotationDefault == null) {
            return null;
        }
        Class<?> clazz = AnnotationType.invocationHandlerReturnType(this.getReturnType());
        Object object = AnnotationParser.parseMemberValue(clazz, (ByteBuffer)ByteBuffer.wrap(this.annotationDefault), (ConstantPool)SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        if (object instanceof ExceptionProxy) {
            throw new AnnotationFormatError("Invalid default: " + this);
        }
        return object;
    }

    public Annotation[][] getParameterAnnotations() {
        int n = this.parameterTypes.length;
        if (this.parameterAnnotations == null) {
            return new Annotation[n][0];
        }
        Annotation[][] annotationArray = AnnotationParser.parseParameterAnnotations((byte[])this.parameterAnnotations, (ConstantPool)SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        if (annotationArray.length != n) {
            throw new AnnotationFormatError("Parameter annotations don't match number of parameters");
        }
        return annotationArray;
    }
}

