/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import sun.dc.pr.PRException;
import sun.dc.pr.Rasterizer;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.CompositePipe;
import sun.java2d.pipe.DuctusRenderer;
import sun.java2d.pipe.ParallelogramPipe;
import sun.java2d.pipe.ShapeDrawPipe;

public class DuctusShapeRenderer
implements ShapeDrawPipe,
ParallelogramPipe {
    CompositePipe outpipe;

    public DuctusShapeRenderer(CompositePipe compositePipe) {
        this.outpipe = compositePipe;
    }

    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        BasicStroke basicStroke;
        if (sunGraphics2D.stroke instanceof BasicStroke) {
            basicStroke = (BasicStroke)sunGraphics2D.stroke;
        } else {
            shape = sunGraphics2D.stroke.createStrokedShape(shape);
            basicStroke = null;
        }
        this.renderPath(sunGraphics2D, shape, basicStroke);
    }

    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        this.renderPath(sunGraphics2D, shape, null);
    }

    private static Rectangle2D computeBBox(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9 = d8 = d;
        double d10 = d7 = d2;
        if (d3 < 0.0) {
            d9 += d3;
        } else {
            d8 += d3;
        }
        if (d4 < 0.0) {
            d10 += d4;
        } else {
            d7 += d4;
        }
        if (d5 < 0.0) {
            d9 += d5;
        } else {
            d8 += d5;
        }
        if (d6 < 0.0) {
            d10 += d6;
        } else {
            d7 += d6;
        }
        return new Rectangle2D.Double(d9, d10, d8 - d9, d7 - d10);
    }

    public void fillParallelogram(SunGraphics2D sunGraphics2D, double d, double d2, double d3, double d4, double d5, double d6) {
        Rasterizer rasterizer = DuctusRenderer.createPgramRasterizer(d, d2, d3, d4, d5, d6, 0.0, 0.0);
        this.renderTiles(sunGraphics2D, DuctusShapeRenderer.computeBBox(d, d2, d3, d4, d5, d6), rasterizer);
    }

    public void drawParallelogram(SunGraphics2D sunGraphics2D, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        Rasterizer rasterizer = DuctusRenderer.createPgramRasterizer(d, d2, d3, d4, d5, d6, d7, d8);
        this.renderTiles(sunGraphics2D, DuctusShapeRenderer.computeBBox(d, d2, d3, d4, d5, d6), rasterizer);
    }

    public void renderPath(SunGraphics2D sunGraphics2D, Shape shape, BasicStroke basicStroke) {
        PathIterator pathIterator = shape.getPathIterator(sunGraphics2D.transform);
        boolean bl = basicStroke != null && sunGraphics2D.strokeHint != 2;
        boolean bl2 = sunGraphics2D.strokeState <= 1;
        Rasterizer rasterizer = DuctusRenderer.createShapeRasterizer(pathIterator, sunGraphics2D.transform, basicStroke, bl2, bl, 0.5f);
        this.renderTiles(sunGraphics2D, shape, rasterizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void renderTiles(SunGraphics2D sunGraphics2D, Shape shape, Rasterizer rasterizer) {
        Object object = null;
        byte[] byArray = null;
        try {
            int[] nArray = new int[4];
            rasterizer.getAlphaBox(nArray);
            Rectangle rectangle = new Rectangle(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
            sunGraphics2D.getCompClip().clipBoxToBounds(nArray);
            if (nArray[0] >= nArray[2] || nArray[1] >= nArray[3]) {
                return;
            }
            rasterizer.setOutputArea((float)nArray[0], (float)nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
            object = this.outpipe.startSequence(sunGraphics2D, shape, rectangle, nArray);
            int n = Rasterizer.TILE_SIZE;
            byArray = DuctusRenderer.getAlphaTile();
            for (int i = nArray[1]; i < nArray[3]; i += n) {
                for (int j = nArray[0]; j < nArray[2]; j += n) {
                    byte[] byArray2;
                    int n2 = Math.min(n, nArray[2] - j);
                    int n3 = Math.min(n, nArray[3] - i);
                    int n4 = rasterizer.getTileState();
                    if (n4 == 0 || !this.outpipe.needTile(object, j, i, n2, n3)) {
                        rasterizer.nextTile();
                        this.outpipe.skipTile(object, j, i);
                        continue;
                    }
                    if (n4 == 2) {
                        byArray2 = byArray;
                        DuctusRenderer.getAlpha(rasterizer, byArray, 1, n, 0);
                    } else {
                        byArray2 = null;
                        rasterizer.nextTile();
                    }
                    this.outpipe.renderPathTile(object, byArray2, 0, n, j, i, n2, n3);
                }
            }
            DuctusRenderer.dropRasterizer(rasterizer);
            if (object != null) {
                this.outpipe.endSequence(object);
            }
            if (byArray == null) return;
        }
        catch (PRException pRException) {
            pRException.printStackTrace();
            return;
        }
        finally {
            DuctusRenderer.dropRasterizer(rasterizer);
            if (object != null) {
                this.outpipe.endSequence(object);
            }
            if (byArray != null) {
                DuctusRenderer.dropAlphaTile(byArray);
            }
        }
        DuctusRenderer.dropAlphaTile(byArray);
        return;
    }
}

