/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.Unicode;

class UTF_8
extends Unicode {
    public UTF_8() {
        super("UTF-8", StandardCharsets.aliases_UTF_8);
    }

    public String historicalName() {
        return "UTF8";
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder((Charset)this, null);
    }

    static final void updatePositions(Buffer buffer, int n, Buffer buffer2, int n2) {
        buffer.position(n - buffer.arrayOffset());
        buffer2.position(n2 - buffer2.arrayOffset());
    }

    private static class Decoder
    extends CharsetDecoder {
        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        private static boolean isNotContinuation(int n) {
            return (n & 0xC0) != 128;
        }

        private static final boolean isMalformed2(int n, int n2) {
            return (n & 0x1E) == 0 || (n2 & 0xC0) != 128;
        }

        private static boolean isMalformed3(int n, int n2, int n3) {
            return n == -32 && (n2 & 0xE0) == 128 || (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128;
        }

        private static final boolean isMalformed4(int n, int n2, int n3) {
            return (n & 0xC0) != 128 || (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128;
        }

        private static CoderResult lookupN(ByteBuffer byteBuffer, int n) {
            for (int i = 1; i < n; ++i) {
                if (!Decoder.isNotContinuation(byteBuffer.get())) continue;
                return CoderResult.malformedForLength(i);
            }
            return CoderResult.malformedForLength(n);
        }

        private static CoderResult malformedN(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 1: {
                    byte by = byteBuffer.get();
                    if (by >> 2 == -2) {
                        if (byteBuffer.remaining() < 4) {
                            return CoderResult.UNDERFLOW;
                        }
                        return Decoder.lookupN(byteBuffer, 5);
                    }
                    if (by >> 1 == -2) {
                        if (byteBuffer.remaining() < 5) {
                            return CoderResult.UNDERFLOW;
                        }
                        return Decoder.lookupN(byteBuffer, 6);
                    }
                    return CoderResult.malformedForLength(1);
                }
                case 2: {
                    return CoderResult.malformedForLength(1);
                }
                case 3: {
                    byte by = byteBuffer.get();
                    byte by2 = byteBuffer.get();
                    return CoderResult.malformedForLength(by == -32 && (by2 & 0xE0) == 128 || Decoder.isNotContinuation(by2) ? 1 : 2);
                }
                case 4: {
                    int n2 = byteBuffer.get() & 0xFF;
                    int n3 = byteBuffer.get() & 0xFF;
                    if (n2 > 244 || n2 == 240 && (n3 < 144 || n3 > 191) || n2 == 244 && (n3 & 0xF0) != 128 || Decoder.isNotContinuation(n3)) {
                        return CoderResult.malformedForLength(1);
                    }
                    if (Decoder.isNotContinuation(byteBuffer.get())) {
                        return CoderResult.malformedForLength(2);
                    }
                    return CoderResult.malformedForLength(3);
                }
            }
            assert (false);
            return null;
        }

        private static CoderResult malformed(ByteBuffer byteBuffer, int n, CharBuffer charBuffer, int n2, int n3) {
            byteBuffer.position(n - byteBuffer.arrayOffset());
            CoderResult coderResult = Decoder.malformedN(byteBuffer, n3);
            UTF_8.updatePositions(byteBuffer, n, charBuffer, n2);
            return coderResult;
        }

        private static CoderResult malformed(ByteBuffer byteBuffer, int n, int n2) {
            byteBuffer.position(n);
            CoderResult coderResult = Decoder.malformedN(byteBuffer, n2);
            byteBuffer.position(n);
            return coderResult;
        }

        private static CoderResult xflow(Buffer buffer, int n, int n2, Buffer buffer2, int n3, int n4) {
            UTF_8.updatePositions(buffer, n, buffer2, n3);
            return n4 == 0 || n2 - n < n4 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
        }

        private static CoderResult xflow(Buffer buffer, int n, int n2) {
            CoderResult coderResult = n2 == 0 || buffer.remaining() < n2 - 1 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
            buffer.position(n);
            return coderResult;
        }

        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            int n5 = n3 + Math.min(n2 - n, n4 - n3);
            while (n3 < n5 && byArray[n] >= 0) {
                cArray[n3++] = (char)byArray[n++];
            }
            while (n < n2) {
                byte by;
                byte by2;
                byte by3 = byArray[n];
                if (by3 >= 0) {
                    if (n3 >= n4) {
                        return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 1);
                    }
                    cArray[n3++] = (char)by3;
                    ++n;
                    continue;
                }
                if (by3 >> 5 == -2) {
                    if (n2 - n < 2 || n3 >= n4) {
                        return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 2);
                    }
                    by2 = byArray[n + 1];
                    if (Decoder.isMalformed2(by3, by2)) {
                        return Decoder.malformed(byteBuffer, n, charBuffer, n3, 2);
                    }
                    cArray[n3++] = (char)(by3 << 6 ^ by2 ^ 0xF80);
                    n += 2;
                    continue;
                }
                if (by3 >> 4 == -2) {
                    if (n2 - n < 3 || n3 >= n4) {
                        return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 3);
                    }
                    by2 = byArray[n + 1];
                    by = byArray[n + 2];
                    if (Decoder.isMalformed3(by3, by2, by)) {
                        return Decoder.malformed(byteBuffer, n, charBuffer, n3, 3);
                    }
                    cArray[n3++] = (char)(by3 << 12 ^ by2 << 6 ^ by ^ 0x1F80);
                    n += 3;
                    continue;
                }
                if (by3 >> 3 == -2) {
                    if (n2 - n < 4 || n4 - n3 < 2) {
                        return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 4);
                    }
                    by2 = byArray[n + 1];
                    by = byArray[n + 2];
                    byte by4 = byArray[n + 3];
                    int n6 = (by3 & 7) << 18 | (by2 & 0x3F) << 12 | (by & 0x3F) << 6 | by4 & 0x3F;
                    if (Decoder.isMalformed4(by2, by, by4) || !Surrogate.neededFor(n6)) {
                        return Decoder.malformed(byteBuffer, n, charBuffer, n3, 4);
                    }
                    cArray[n3++] = Surrogate.high(n6);
                    cArray[n3++] = Surrogate.low(n6);
                    n += 4;
                    continue;
                }
                return Decoder.malformed(byteBuffer, n, charBuffer, n3, 1);
            }
            return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 0);
        }

        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            int n2 = byteBuffer.limit();
            while (n < n2) {
                byte by;
                byte by2;
                byte by3 = byteBuffer.get();
                if (by3 >= 0) {
                    if (charBuffer.remaining() < 1) {
                        return Decoder.xflow(byteBuffer, n, 1);
                    }
                    charBuffer.put((char)by3);
                    ++n;
                    continue;
                }
                if (by3 >> 5 == -2) {
                    if (n2 - n < 2 || charBuffer.remaining() < 1) {
                        return Decoder.xflow(byteBuffer, n, 2);
                    }
                    by2 = byteBuffer.get();
                    if (Decoder.isMalformed2(by3, by2)) {
                        return Decoder.malformed(byteBuffer, n, 2);
                    }
                    charBuffer.put((char)(by3 << 6 ^ by2 ^ 0xF80));
                    n += 2;
                    continue;
                }
                if (by3 >> 4 == -2) {
                    if (n2 - n < 3 || charBuffer.remaining() < 1) {
                        return Decoder.xflow(byteBuffer, n, 3);
                    }
                    by2 = byteBuffer.get();
                    if (Decoder.isMalformed3(by3, by2, by = byteBuffer.get())) {
                        return Decoder.malformed(byteBuffer, n, 3);
                    }
                    charBuffer.put((char)(by3 << 12 ^ by2 << 6 ^ by ^ 0x1F80));
                    n += 3;
                    continue;
                }
                if (by3 >> 3 == -2) {
                    if (n2 - n < 4 || charBuffer.remaining() < 2) {
                        return Decoder.xflow(byteBuffer, n, 4);
                    }
                    by2 = byteBuffer.get();
                    by = byteBuffer.get();
                    byte by4 = byteBuffer.get();
                    int n3 = (by3 & 7) << 18 | (by2 & 0x3F) << 12 | (by & 0x3F) << 6 | by4 & 0x3F;
                    if (Decoder.isMalformed4(by2, by, by4) || !Surrogate.neededFor(n3)) {
                        return Decoder.malformed(byteBuffer, n, 4);
                    }
                    charBuffer.put(Surrogate.high(n3));
                    charBuffer.put(Surrogate.low(n3));
                    n += 4;
                    continue;
                }
                return Decoder.malformed(byteBuffer, n, 1);
            }
            return Decoder.xflow(byteBuffer, n, 0);
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }
    }

    private static final class Encoder
    extends CharsetEncoder {
        private Surrogate.Parser sgp;

        private Encoder(Charset cs) {
            super(cs, 1.1f, 3.0f);
        }

        @Override
        public boolean canEncode(char c) {
            return !Character.isSurrogate((char)c);
        }

        @Override
        public boolean isLegalReplacement(byte[] repl) {
            return repl.length == 1 && repl[0] >= 0 || super.isLegalReplacement(repl);
        }

        private static CoderResult overflow(CharBuffer src, int sp, ByteBuffer dst, int dp) {
            UTF_8.updatePositions(src, sp, dst, dp);
            return CoderResult.OVERFLOW;
        }

        private static CoderResult overflow(CharBuffer src, int mark) {
            src.position(mark);
            return CoderResult.OVERFLOW;
        }

        private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            char[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            int n = JLA.encodeASCII(sa, sp, da, dp, Math.min(sl - sp, dl - dp));
            dp += n;
            if ((sp += n) < sl) {
                return this.encodeArrayLoopSlow(src, sa, sp, sl, dst, da, dp, dl);
            }
            UTF_8.updatePositions(src, sp, dst, dp);
            return CoderResult.UNDERFLOW;
        }

        private CoderResult encodeArrayLoopSlow(CharBuffer src, char[] sa, int sp, int sl, ByteBuffer dst, byte[] da, int dp, int dl) {
            while (sp < sl) {
                char c = sa[sp];
                if (c < '\u0080') {
                    if (dp >= dl) {
                        return Encoder.overflow(src, sp, dst, dp);
                    }
                    da[dp++] = (byte)c;
                } else if (c < '\u0800') {
                    if (dl - dp < 2) {
                        return Encoder.overflow(src, sp, dst, dp);
                    }
                    da[dp++] = (byte)(0xC0 | c >> 6);
                    da[dp++] = (byte)(0x80 | c & 0x3F);
                } else if (Character.isSurrogate((char)c)) {
                    int uc;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((uc = this.sgp.parse(c, sa, sp, sl)) < 0) {
                        UTF_8.updatePositions(src, sp, dst, dp);
                        return this.sgp.error();
                    }
                    if (dl - dp < 4) {
                        return Encoder.overflow(src, sp, dst, dp);
                    }
                    da[dp++] = (byte)(0xF0 | uc >> 18);
                    da[dp++] = (byte)(0x80 | uc >> 12 & 0x3F);
                    da[dp++] = (byte)(0x80 | uc >> 6 & 0x3F);
                    da[dp++] = (byte)(0x80 | uc & 0x3F);
                    ++sp;
                } else {
                    if (dl - dp < 3) {
                        return Encoder.overflow(src, sp, dst, dp);
                    }
                    da[dp++] = (byte)(0xE0 | c >> 12);
                    da[dp++] = (byte)(0x80 | c >> 6 & 0x3F);
                    da[dp++] = (byte)(0x80 | c & 0x3F);
                }
                ++sp;
            }
            UTF_8.updatePositions(src, sp, dst, dp);
            return CoderResult.UNDERFLOW;
        }

        private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            int mark = src.position();
            while (src.hasRemaining()) {
                char c = src.get();
                if (c < '\u0080') {
                    if (!dst.hasRemaining()) {
                        return Encoder.overflow(src, mark);
                    }
                    dst.put((byte)c);
                } else if (c < '\u0800') {
                    if (dst.remaining() < 2) {
                        return Encoder.overflow(src, mark);
                    }
                    dst.put((byte)(0xC0 | c >> 6));
                    dst.put((byte)(0x80 | c & 0x3F));
                } else if (Character.isSurrogate((char)c)) {
                    int uc;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((uc = this.sgp.parse(c, src)) < 0) {
                        src.position(mark);
                        return this.sgp.error();
                    }
                    if (dst.remaining() < 4) {
                        return Encoder.overflow(src, mark);
                    }
                    dst.put((byte)(0xF0 | uc >> 18));
                    dst.put((byte)(0x80 | uc >> 12 & 0x3F));
                    dst.put((byte)(0x80 | uc >> 6 & 0x3F));
                    dst.put((byte)(0x80 | uc & 0x3F));
                    ++mark;
                } else {
                    if (dst.remaining() < 3) {
                        return Encoder.overflow(src, mark);
                    }
                    dst.put((byte)(0xE0 | c >> 12));
                    dst.put((byte)(0x80 | c >> 6 & 0x3F));
                    dst.put((byte)(0x80 | c & 0x3F));
                }
                ++mark;
            }
            src.position(mark);
            return CoderResult.UNDERFLOW;
        }

        @Override
        protected final CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }
    }
}

