/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import sun.security.action.GetPropertyAction;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.TzIDOldMapping;
import sun.util.calendar.ZoneInfoFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoneInfo
extends TimeZone {
    private static final int UTC_TIME = 0;
    private static final int STANDARD_TIME = 1;
    private static final int WALL_TIME = 2;
    private static final long OFFSET_MASK = 15L;
    private static final long DST_MASK = 240L;
    private static final int DST_NSHIFT = 4;
    private static final long ABBR_MASK = 3840L;
    private static final int TRANSITION_NSHIFT = 12;
    static final boolean USE_OLDMAPPING;
    static final String[] conflictingIDs;
    private static final CalendarSystem gcal;
    private int rawOffset;
    private int rawOffsetDiff = 0;
    private int checksum;
    private int dstSavings;
    private long[] transitions;
    private int[] offsets;
    private int[] simpleTimeZoneParams;
    private boolean willGMTOffsetChange = false;
    private transient boolean dirty = false;
    private static final long serialVersionUID = 2653134537216586139L;
    private transient SimpleTimeZone lastRule;
    private static volatile SoftReference<Map<String, String>> aliasTable;

    public ZoneInfo() {
    }

    public ZoneInfo(String string, int n) {
        this(string, n, 0, 0, null, null, null, false);
    }

    ZoneInfo(String string, int n, int n2, int n3, long[] lArray, int[] nArray, int[] nArray2, boolean bl) {
        this.setID(string);
        this.rawOffset = n;
        this.dstSavings = n2;
        this.checksum = n3;
        this.transitions = lArray;
        this.offsets = nArray;
        this.simpleTimeZoneParams = nArray2;
        this.willGMTOffsetChange = bl;
    }

    @Override
    public int getOffset(long l) {
        return this.getOffsets(l, null, 0);
    }

    public int getOffsets(long l, int[] nArray) {
        return this.getOffsets(l, nArray, 0);
    }

    public int getOffsetsByStandard(long l, int[] nArray) {
        return this.getOffsets(l, nArray, 1);
    }

    public int getOffsetsByWall(long l, int[] nArray) {
        return this.getOffsets(l, nArray, 2);
    }

    private int getOffsets(long l, int[] nArray, int n) {
        if (this.transitions == null) {
            int n2 = this.getLastRawOffset();
            if (nArray != null) {
                nArray[0] = n2;
                nArray[1] = 0;
            }
            return n2;
        }
        int n3 = this.getTransitionIndex(l -= (long)this.rawOffsetDiff, n);
        if (n3 < 0) {
            int n4 = this.getLastRawOffset();
            if (nArray != null) {
                nArray[0] = n4;
                nArray[1] = 0;
            }
            return n4;
        }
        if (n3 < this.transitions.length) {
            long l2 = this.transitions[n3];
            int n5 = this.offsets[(int)(l2 & 0xFL)] + this.rawOffsetDiff;
            if (nArray != null) {
                int n6 = (int)(l2 >>> 4 & 0xFL);
                int n7 = n6 == 0 ? 0 : this.offsets[n6];
                nArray[0] = n5 - n7;
                nArray[1] = n7;
            }
            return n5;
        }
        SimpleTimeZone simpleTimeZone = this.getLastRule();
        if (simpleTimeZone != null) {
            int n8;
            int n9 = simpleTimeZone.getRawOffset();
            long l3 = l;
            if (n != 0) {
                l3 -= (long)this.rawOffset;
            }
            int n10 = n8 = simpleTimeZone.inDaylightTime(new Date(l3)) ? simpleTimeZone.getDSTSavings() : 0;
            if (nArray != null) {
                nArray[0] = n9;
                nArray[1] = n8;
            }
            return n9 + n8;
        }
        int n11 = this.getLastRawOffset();
        if (nArray != null) {
            nArray[0] = n11;
            nArray[1] = 0;
        }
        return n11;
    }

    private final int getTransitionIndex(long l, int n) {
        int n2 = 0;
        int n3 = this.transitions.length - 1;
        while (n2 <= n3) {
            int n4;
            int n5 = (n2 + n3) / 2;
            long l2 = this.transitions[n5];
            long l3 = l2 >> 12;
            if (n != 0) {
                l3 += (long)this.offsets[(int)(l2 & 0xFL)];
            }
            if (n == 1 && (n4 = (int)(l2 >>> 4 & 0xFL)) != 0) {
                l3 -= (long)this.offsets[n4];
            }
            if (l3 < l) {
                n2 = n5 + 1;
                continue;
            }
            if (l3 > l) {
                n3 = n5 - 1;
                continue;
            }
            return n5;
        }
        if (n2 >= this.transitions.length) {
            return n2;
        }
        return n2 - 1;
    }

    @Override
    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n6 < 0 || n6 >= 86400000) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            n2 = 1 - n2;
        } else if (n != 1) {
            throw new IllegalArgumentException();
        }
        CalendarDate calendarDate = gcal.newCalendarDate(null);
        calendarDate.setDate(n2, n3 + 1, n4);
        if (!gcal.validate(calendarDate)) {
            throw new IllegalArgumentException();
        }
        if (n5 < 1 || n5 > 7) {
            throw new IllegalArgumentException();
        }
        if (this.transitions == null) {
            return this.getLastRawOffset();
        }
        long l = gcal.getTime(calendarDate) + (long)n6;
        return this.getOffsets(l -= (long)this.rawOffset, null, 0);
    }

    @Override
    public synchronized void setRawOffset(int n) {
        if (n == this.rawOffset + this.rawOffsetDiff) {
            return;
        }
        this.rawOffsetDiff = n - this.rawOffset;
        if (this.lastRule != null) {
            this.lastRule.setRawOffset(n);
        }
        this.dirty = true;
    }

    @Override
    public int getRawOffset() {
        if (!this.willGMTOffsetChange) {
            return this.rawOffset + this.rawOffsetDiff;
        }
        int[] nArray = new int[2];
        this.getOffsets(System.currentTimeMillis(), nArray, 0);
        return nArray[0];
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private int getLastRawOffset() {
        return this.rawOffset + this.rawOffsetDiff;
    }

    @Override
    public boolean useDaylightTime() {
        return this.simpleTimeZoneParams != null;
    }

    @Override
    public boolean inDaylightTime(Date date) {
        if (date == null) {
            throw new NullPointerException();
        }
        if (this.transitions == null) {
            return false;
        }
        long l = date.getTime() - (long)this.rawOffsetDiff;
        int n = this.getTransitionIndex(l, 0);
        if (n < 0) {
            return false;
        }
        if (n < this.transitions.length) {
            return (this.transitions[n] & 0xF0L) != 0L;
        }
        SimpleTimeZone simpleTimeZone = this.getLastRule();
        if (simpleTimeZone != null) {
            return simpleTimeZone.inDaylightTime(date);
        }
        return false;
    }

    @Override
    public int getDSTSavings() {
        return this.dstSavings;
    }

    public String toString() {
        return this.getClass().getName() + "[id=\"" + this.getID() + "\"" + ",offset=" + this.getLastRawOffset() + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylightTime() + ",transitions=" + (this.transitions != null ? this.transitions.length : 0) + ",lastRule=" + (this.lastRule == null ? this.getLastRuleInstance() : this.lastRule) + "]";
    }

    public static String[] getAvailableIDs() {
        Object object;
        Object object2 = ZoneInfoFile.getZoneIDs();
        List<String> list = ZoneInfoFile.getExcludedZones();
        if (list != null) {
            object = new ArrayList(object2.size() + list.size());
            object.addAll(object2);
            object.addAll(list);
            object2 = object;
        }
        object = new String[object2.size()];
        return object2.toArray((T[])object);
    }

    public static String[] getAvailableIDs(int n) {
        List<String> list;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list2 = ZoneInfoFile.getZoneIDs();
        int[] nArray = ZoneInfoFile.getRawOffsets();
        block0: for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            object = ZoneInfoFile.getRawOffsetIndices();
            for (int j = 0; j < ((Object)object).length; ++j) {
                if (object[j] != i) continue;
                arrayList.add(list2.get(j++));
                while (j < ((Object)object).length && object[j] == i) {
                    arrayList.add(list2.get(j++));
                }
                break block0;
            }
        }
        if ((list = ZoneInfoFile.getExcludedZones()) != null) {
            object = list.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                TimeZone timeZone = ZoneInfo.getTimeZone(string);
                if (timeZone == null || timeZone.getRawOffset() != n) continue;
                arrayList.add(string);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static TimeZone getTimeZone(String object) {
        Object object2;
        String string = null;
        if (USE_OLDMAPPING && (object2 = (String)TzIDOldMapping.MAP.get(object)) != null) {
            string = object;
            object = object2;
        }
        if ((object2 = ZoneInfoFile.getZoneInfo((String)object)) == null) {
            try {
                Map<String, String> map = ZoneInfo.getAliasTable();
                String string2 = object;
                while ((string2 = map.get(string2)) != null) {
                    object2 = ZoneInfoFile.getZoneInfo(string2);
                    if (object2 == null) continue;
                    ((TimeZone)object2).setID((String)object);
                    object2 = ZoneInfoFile.addToCache((String)object, (ZoneInfo)object2);
                    object2 = (ZoneInfo)((ZoneInfo)object2).clone();
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string != null && object2 != null) {
            ((TimeZone)object2).setID(string);
        }
        return object2;
    }

    private synchronized SimpleTimeZone getLastRule() {
        if (this.lastRule == null) {
            this.lastRule = this.getLastRuleInstance();
        }
        return this.lastRule;
    }

    public SimpleTimeZone getLastRuleInstance() {
        if (this.simpleTimeZoneParams == null) {
            return null;
        }
        if (this.simpleTimeZoneParams.length == 10) {
            return new SimpleTimeZone(this.getLastRawOffset(), this.getID(), this.simpleTimeZoneParams[0], this.simpleTimeZoneParams[1], this.simpleTimeZoneParams[2], this.simpleTimeZoneParams[3], this.simpleTimeZoneParams[4], this.simpleTimeZoneParams[5], this.simpleTimeZoneParams[6], this.simpleTimeZoneParams[7], this.simpleTimeZoneParams[8], this.simpleTimeZoneParams[9], this.dstSavings);
        }
        return new SimpleTimeZone(this.getLastRawOffset(), this.getID(), this.simpleTimeZoneParams[0], this.simpleTimeZoneParams[1], this.simpleTimeZoneParams[2], this.simpleTimeZoneParams[3], this.simpleTimeZoneParams[4], this.simpleTimeZoneParams[5], this.simpleTimeZoneParams[6], this.simpleTimeZoneParams[7], this.dstSavings);
    }

    @Override
    public Object clone() {
        ZoneInfo zoneInfo = (ZoneInfo)super.clone();
        zoneInfo.lastRule = null;
        return zoneInfo;
    }

    public int hashCode() {
        return this.getLastRawOffset() ^ this.checksum;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ZoneInfo)) {
            return false;
        }
        ZoneInfo zoneInfo = (ZoneInfo)object;
        return this.getID().equals(zoneInfo.getID()) && this.getLastRawOffset() == zoneInfo.getLastRawOffset() && this.checksum == zoneInfo.checksum;
    }

    @Override
    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (timeZone == null) {
            return false;
        }
        if (!(timeZone instanceof ZoneInfo)) {
            if (this.getRawOffset() != timeZone.getRawOffset()) {
                return false;
            }
            return this.transitions == null && !this.useDaylightTime() && !timeZone.useDaylightTime();
        }
        if (this.getLastRawOffset() != ((ZoneInfo)timeZone).getLastRawOffset()) {
            return false;
        }
        return this.checksum == ((ZoneInfo)timeZone).checksum;
    }

    static Map<String, String> getCachedAliasTable() {
        Map<String, String> map = null;
        SoftReference<Map<String, String>> softReference = aliasTable;
        if (softReference != null) {
            map = softReference.get();
        }
        return map;
    }

    public static synchronized Map<String, String> getAliasTable() {
        Map<String, String> map = ZoneInfo.getCachedAliasTable();
        if (map == null && (map = ZoneInfoFile.getZoneAliases()) != null) {
            if (!USE_OLDMAPPING) {
                for (String string : conflictingIDs) {
                    map.remove(string);
                }
            }
            aliasTable = new SoftReference<Map<String, String>>(map);
        }
        return map;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.dirty = true;
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.timezone.ids.oldmapping", "false")).toLowerCase(Locale.ROOT);
        USE_OLDMAPPING = string.equals("yes") || string.equals("true");
        conflictingIDs = new String[]{"EST", "MST", "HST"};
        gcal = CalendarSystem.getGregorianCalendar();
    }
}

