/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.binding;

import java.util.HashSet;
import java.util.Set;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.binding.MapperProxy;
import org.apache.ibatis.builder.annotation.MapperAnnotationBuilder;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperRegistry {
    private Configuration config;
    private Set<Class> knownMappers = new HashSet<Class>();

    public MapperRegistry(Configuration config) {
        this.config = config;
    }

    public <T> T getMapper(Class<T> type, SqlSession sqlSession) {
        if (!this.knownMappers.contains(type)) {
            throw new BindingException("Type " + type + " is not known to the MapperRegistry.");
        }
        try {
            return MapperProxy.newMapperProxy(type, sqlSession);
        }
        catch (Exception e) {
            throw new BindingException("Error getting mapper instance. Cause: " + e, e);
        }
    }

    public boolean hasMapper(Class type) {
        return this.knownMappers.contains(type);
    }

    public void addMapper(Class type) {
        if (type.isInterface()) {
            if (this.knownMappers.contains(type)) {
                throw new BindingException("Type " + type + " is already known to the MapperRegistry.");
            }
            this.knownMappers.add(type);
            MapperAnnotationBuilder parser = new MapperAnnotationBuilder(this.config, type);
            parser.parse();
        }
    }
}

