/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.resultset;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.loader.ResultLoader;
import org.apache.ibatis.executor.loader.ResultLoaderMap;
import org.apache.ibatis.executor.loader.ResultObjectProxy;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.result.DefaultResultContext;
import org.apache.ibatis.executor.result.DefaultResultHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.Discriminator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastResultSetHandler
implements ResultSetHandler {
    protected final Executor executor;
    protected final Configuration configuration;
    protected final MappedStatement mappedStatement;
    protected final RowBounds rowBounds;
    protected final ParameterHandler parameterHandler;
    protected final ResultHandler resultHandler;
    protected final BoundSql boundSql;
    protected final TypeHandlerRegistry typeHandlerRegistry;
    protected final ObjectFactory objectFactory;

    public FastResultSetHandler(Executor executor, MappedStatement mappedStatement, ParameterHandler parameterHandler, ResultHandler resultHandler, BoundSql boundSql, RowBounds rowBounds) {
        this.executor = executor;
        this.configuration = mappedStatement.getConfiguration();
        this.mappedStatement = mappedStatement;
        this.rowBounds = rowBounds;
        this.parameterHandler = parameterHandler;
        this.boundSql = boundSql;
        this.typeHandlerRegistry = this.configuration.getTypeHandlerRegistry();
        this.objectFactory = this.configuration.getObjectFactory();
        this.resultHandler = resultHandler;
    }

    @Override
    public void handleOutputParameters(CallableStatement cs) throws SQLException {
        Object parameterObject = this.parameterHandler.getParameterObject();
        MetaObject metaParam = this.configuration.newMetaObject(parameterObject);
        List<ParameterMapping> parameterMappings = this.boundSql.getParameterMappings();
        for (int i = 0; i < parameterMappings.size(); ++i) {
            ParameterMapping parameterMapping = parameterMappings.get(i);
            if (parameterMapping.getMode() != ParameterMode.OUT && parameterMapping.getMode() != ParameterMode.INOUT) continue;
            if ("java.sql.ResultSet".equalsIgnoreCase(parameterMapping.getJavaType().getName())) {
                this.handleRefCursorOutputParameter(cs, parameterMapping, i, metaParam);
                continue;
            }
            TypeHandler typeHandler = parameterMapping.getTypeHandler();
            if (typeHandler == null) {
                throw new ExecutorException("Type handler was null on parameter mapping for property " + parameterMapping.getProperty() + ".  " + "It was either not specified and/or could not be found for the javaType / jdbcType combination specified.");
            }
            metaParam.setValue(parameterMapping.getProperty(), typeHandler.getResult(cs, i + 1));
        }
    }

    protected void handleRefCursorOutputParameter(CallableStatement cs, ParameterMapping parameterMapping, int parameterMappingIndex, MetaObject metaParam) throws SQLException {
        ResultSet rs = (ResultSet)cs.getObject(parameterMappingIndex + 1);
        String resultMapId = parameterMapping.getResultMapId();
        if (resultMapId == null) {
            throw new ExecutorException("Parameter requires ResultMap for output types of java.sql.ResultSet");
        }
        ResultMap resultMap = this.configuration.getResultMap(resultMapId);
        DefaultResultHandler resultHandler = new DefaultResultHandler();
        this.handleRowValues(rs, resultMap, resultHandler, new RowBounds());
        metaParam.setValue(parameterMapping.getProperty(), resultHandler.getResultList());
        rs.close();
    }

    @Override
    public List handleResultSets(Statement stmt) throws SQLException {
        ArrayList multipleResults = new ArrayList();
        List<ResultMap> resultMaps = this.mappedStatement.getResultMaps();
        int resultMapCount = resultMaps.size();
        ResultSet rs = stmt.getResultSet();
        this.validateResultMapsCount(rs, resultMapCount);
        for (int resultSetCount = 0; rs != null && resultMapCount > resultSetCount; ++resultSetCount) {
            ResultMap resultMap = resultMaps.get(resultSetCount);
            this.handleResultSet(rs, resultMap, multipleResults);
            rs = this.getNextResultSet(stmt);
            this.cleanUpAfterHandlingResultSet();
        }
        return this.collapseSingleResultList(multipleResults);
    }

    protected void cleanUpAfterHandlingResultSet() {
    }

    protected void validateResultMapsCount(ResultSet rs, int resultMapCount) {
        if (rs != null && resultMapCount < 1) {
            throw new ExecutorException("A query was run and no Result Maps were found for the Mapped Statement '" + this.mappedStatement.getId() + "'.  It's likely that neither a Result Type nor a Result Map was specified.");
        }
    }

    protected void handleResultSet(ResultSet rs, ResultMap resultMap, List multipleResults) throws SQLException {
        if (this.resultHandler == null) {
            DefaultResultHandler defaultResultHandler = new DefaultResultHandler();
            this.handleRowValues(rs, resultMap, defaultResultHandler, this.rowBounds);
            multipleResults.add(defaultResultHandler.getResultList());
        } else {
            this.handleRowValues(rs, resultMap, this.resultHandler, this.rowBounds);
        }
    }

    protected List collapseSingleResultList(List multipleResults) {
        if (multipleResults.size() == 1) {
            return (List)multipleResults.get(0);
        }
        return multipleResults;
    }

    protected void handleRowValues(ResultSet rs, ResultMap resultMap, ResultHandler resultHandler, RowBounds rowBounds) throws SQLException {
        DefaultResultContext resultContext = new DefaultResultContext();
        this.skipRows(rs, rowBounds);
        while (this.shouldProcessMoreRows(rs, resultContext, rowBounds)) {
            ResultMap discriminatedResultMap = this.resolveDiscriminatedResultMap(rs, resultMap);
            Object rowValue = this.getRowValue(rs, discriminatedResultMap, null);
            resultContext.nextResultObject(rowValue);
            resultHandler.handleResult(resultContext);
        }
    }

    protected boolean shouldProcessMoreRows(ResultSet rs, ResultContext context, RowBounds rowBounds) throws SQLException {
        return rs.next() && context.getResultCount() < rowBounds.getLimit() && !context.isStopped();
    }

    protected void skipRows(ResultSet rs, RowBounds rowBounds) throws SQLException {
        if (rs.getType() != 1003) {
            if (rowBounds.getOffset() != 0) {
                rs.absolute(rowBounds.getOffset());
            }
        } else {
            for (int i = 0; i < rowBounds.getOffset(); ++i) {
                rs.next();
            }
        }
    }

    protected ResultSet getNextResultSet(Statement stmt) throws SQLException {
        try {
            if (stmt.getConnection().getMetaData().supportsMultipleResultSets() && (stmt.getMoreResults() || stmt.getUpdateCount() != -1)) {
                return stmt.getResultSet();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected Object getRowValue(ResultSet rs, ResultMap resultMap, CacheKey rowKey) throws SQLException {
        ArrayList<String> mappedColumnNames = new ArrayList<String>();
        ArrayList<String> unmappedColumnNames = new ArrayList<String>();
        ResultLoaderMap lazyLoader = this.instantiateResultLoaderMap();
        Object resultObject = this.createResultObject(rs, resultMap, lazyLoader);
        if (resultObject != null && !this.typeHandlerRegistry.hasTypeHandler(resultMap.getType())) {
            boolean foundValues;
            MetaObject metaObject = this.configuration.newMetaObject(resultObject);
            this.loadMappedAndUnmappedColumnNames(rs, resultMap, mappedColumnNames, unmappedColumnNames);
            boolean bl = foundValues = resultMap.getConstructorResultMappings().size() > 0;
            if (!AutoMappingBehavior.NONE.equals((Object)this.configuration.getAutoMappingBehavior())) {
                foundValues = this.applyAutomaticMappings(rs, unmappedColumnNames, metaObject) || foundValues;
            }
            foundValues = this.applyPropertyMappings(rs, resultMap, mappedColumnNames, metaObject, lazyLoader) || foundValues;
            resultObject = foundValues ? resultObject : null;
            return resultObject;
        }
        return resultObject;
    }

    protected ResultLoaderMap instantiateResultLoaderMap() {
        if (this.configuration.isLazyLoadingEnabled()) {
            return new ResultLoaderMap();
        }
        return null;
    }

    protected boolean applyPropertyMappings(ResultSet rs, ResultMap resultMap, List<String> mappedColumnNames, MetaObject metaObject, ResultLoaderMap lazyLoader) throws SQLException {
        boolean foundValues = false;
        List<ResultMapping> propertyMappings = resultMap.getPropertyResultMappings();
        for (ResultMapping propertyMapping : propertyMappings) {
            Object value;
            String column = propertyMapping.getColumn();
            if (!propertyMapping.isCompositeResult() && (column == null || !mappedColumnNames.contains(column.toUpperCase(Locale.ENGLISH))) || (value = this.getPropertyMappingValue(rs, metaObject, propertyMapping, lazyLoader)) == null) continue;
            String property = propertyMapping.getProperty();
            metaObject.setValue(property, value);
            foundValues = true;
        }
        return foundValues;
    }

    protected Object getPropertyMappingValue(ResultSet rs, MetaObject metaResultObject, ResultMapping propertyMapping, ResultLoaderMap lazyLoader) throws SQLException {
        TypeHandler typeHandler = propertyMapping.getTypeHandler();
        if (propertyMapping.getNestedQueryId() != null) {
            return this.getNestedQueryMappingValue(rs, metaResultObject, propertyMapping, lazyLoader);
        }
        if (typeHandler != null) {
            String column = propertyMapping.getColumn();
            return typeHandler.getResult(rs, column);
        }
        return null;
    }

    protected boolean applyAutomaticMappings(ResultSet rs, List<String> unmappedColumnNames, MetaObject metaObject) throws SQLException {
        boolean foundValues = false;
        for (String columnName : unmappedColumnNames) {
            TypeHandler typeHandler;
            Object value;
            Class propertyType;
            String property = metaObject.findProperty(columnName);
            if (property == null || !this.typeHandlerRegistry.hasTypeHandler(propertyType = metaObject.getSetterType(property)) || (value = (typeHandler = this.typeHandlerRegistry.getTypeHandler(propertyType)).getResult(rs, columnName)) == null) continue;
            metaObject.setValue(property, value);
            foundValues = true;
        }
        return foundValues;
    }

    protected void loadMappedAndUnmappedColumnNames(ResultSet rs, ResultMap resultMap, List<String> mappedColumnNames, List<String> unmappedColumnNames) throws SQLException {
        mappedColumnNames.clear();
        unmappedColumnNames.clear();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        Set<String> mappedColumns = resultMap.getMappedColumns();
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = this.configuration.isUseColumnLabel() ? rsmd.getColumnLabel(i) : rsmd.getColumnName(i);
            String upperColumnName = columnName.toUpperCase(Locale.ENGLISH);
            if (mappedColumns.contains(upperColumnName)) {
                mappedColumnNames.add(upperColumnName);
                mappedColumnNames.add(columnName);
                continue;
            }
            unmappedColumnNames.add(upperColumnName);
            unmappedColumnNames.add(columnName);
        }
    }

    protected Object createResultObject(ResultSet rs, ResultMap resultMap, ResultLoaderMap lazyLoader) throws SQLException {
        Object resultObject = this.createResultObject(rs, resultMap);
        if (resultObject != null && this.configuration.isLazyLoadingEnabled()) {
            return ResultObjectProxy.createProxy(resultObject, lazyLoader, this.configuration.isAggressiveLazyLoading());
        }
        return resultObject;
    }

    protected Object createResultObject(ResultSet rs, ResultMap resultMap) throws SQLException {
        Class resultType = resultMap.getType();
        List<ResultMapping> constructorMappings = resultMap.getConstructorResultMappings();
        if (this.typeHandlerRegistry.hasTypeHandler(resultType)) {
            return this.createPrimitiveResultObject(rs, resultMap);
        }
        if (constructorMappings.size() > 0) {
            return this.createParameterizedResultObject(rs, resultType, constructorMappings);
        }
        return this.objectFactory.create(resultType);
    }

    protected Object createParameterizedResultObject(ResultSet rs, Class resultType, List<ResultMapping> constructorMappings) throws SQLException {
        boolean foundValues = false;
        ArrayList<Class> parameterTypes = new ArrayList<Class>();
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        for (ResultMapping constructorMapping : constructorMappings) {
            Class parameterType = constructorMapping.getJavaType();
            TypeHandler typeHandler = constructorMapping.getTypeHandler();
            String column = constructorMapping.getColumn();
            Object value = typeHandler.getResult(rs, column);
            parameterTypes.add(parameterType);
            parameterValues.add(value);
            foundValues = value != null || foundValues;
        }
        return foundValues ? this.objectFactory.create(resultType, parameterTypes, parameterValues) : null;
    }

    protected Object createPrimitiveResultObject(ResultSet rs, ResultMap resultMap) throws SQLException {
        String columnName;
        Class resultType = resultMap.getType();
        if (resultMap.getResultMappings().size() > 0) {
            List<ResultMapping> resultMappingList = resultMap.getResultMappings();
            ResultMapping mapping = resultMappingList.get(0);
            columnName = mapping.getColumn();
        } else {
            ResultSetMetaData rsmd = rs.getMetaData();
            columnName = this.configuration.isUseColumnLabel() ? rsmd.getColumnLabel(1) : rsmd.getColumnName(1);
        }
        TypeHandler typeHandler = this.typeHandlerRegistry.getTypeHandler(resultType);
        return typeHandler.getResult(rs, columnName);
    }

    protected Object getNestedQueryMappingValue(ResultSet rs, MetaObject metaResultObject, ResultMapping propertyMapping, ResultLoaderMap lazyLoader) throws SQLException {
        String nestedQueryId = propertyMapping.getNestedQueryId();
        String property = propertyMapping.getProperty();
        MappedStatement nestedQuery = this.configuration.getMappedStatement(nestedQueryId);
        Class nestedQueryParameterType = nestedQuery.getParameterMap().getType();
        Object nestedQueryParameterObject = this.prepareParameterForNestedQuery(rs, propertyMapping, nestedQueryParameterType);
        Object value = null;
        if (nestedQueryParameterObject != null) {
            CacheKey key = this.executor.createCacheKey(nestedQuery, nestedQueryParameterObject, RowBounds.DEFAULT);
            if (this.executor.isCached(nestedQuery, key)) {
                this.executor.deferLoad(nestedQuery, metaResultObject, property, key);
            } else {
                ResultLoader resultLoader = new ResultLoader(this.configuration, this.executor, nestedQuery, nestedQueryParameterObject, propertyMapping.getJavaType());
                if (this.configuration.isLazyLoadingEnabled()) {
                    lazyLoader.addLoader(property, metaResultObject, resultLoader);
                } else {
                    value = resultLoader.loadResult();
                }
            }
        }
        return value;
    }

    protected Object prepareParameterForNestedQuery(ResultSet rs, ResultMapping resultMapping, Class parameterType) throws SQLException {
        if (resultMapping.isCompositeResult()) {
            return this.prepareCompositeKeyParameter(rs, resultMapping, parameterType);
        }
        return this.prepareSimpleKeyParameter(rs, resultMapping, parameterType);
    }

    protected Object prepareSimpleKeyParameter(ResultSet rs, ResultMapping resultMapping, Class parameterType) throws SQLException {
        TypeHandler typeHandler = this.typeHandlerRegistry.hasTypeHandler(parameterType) ? this.typeHandlerRegistry.getTypeHandler(parameterType) : this.typeHandlerRegistry.getUnkownTypeHandler();
        return typeHandler.getResult(rs, resultMapping.getColumn());
    }

    protected Object prepareCompositeKeyParameter(ResultSet rs, ResultMapping resultMapping, Class parameterType) throws SQLException {
        Object parameterObject = this.instantiateParameterObject(parameterType);
        MetaObject metaObject = this.configuration.newMetaObject(parameterObject);
        for (ResultMapping innerResultMapping : resultMapping.getComposites()) {
            Class propType = metaObject.getSetterType(innerResultMapping.getProperty());
            TypeHandler typeHandler = this.typeHandlerRegistry.getTypeHandler(propType);
            Object propValue = typeHandler.getResult(rs, innerResultMapping.getColumn());
            metaObject.setValue(innerResultMapping.getProperty(), propValue);
        }
        return parameterObject;
    }

    protected Object instantiateParameterObject(Class parameterType) {
        if (parameterType == null) {
            return new HashMap();
        }
        return this.objectFactory.create(parameterType);
    }

    public ResultMap resolveDiscriminatedResultMap(ResultSet rs, ResultMap resultMap) throws SQLException {
        Object value;
        String discriminatedMapId;
        HashSet<String> pastDiscriminators = new HashSet<String>();
        Discriminator discriminator = resultMap.getDiscriminator();
        while (discriminator != null && this.configuration.hasResultMap(discriminatedMapId = discriminator.getMapIdFor(String.valueOf(value = this.getDiscriminatorValue(rs, discriminator))))) {
            resultMap = this.configuration.getResultMap(discriminatedMapId);
            Discriminator lastDiscriminator = discriminator;
            discriminator = resultMap.getDiscriminator();
            if (discriminator != lastDiscriminator && pastDiscriminators.add(discriminatedMapId)) continue;
            break;
        }
        return resultMap;
    }

    protected Object getDiscriminatorValue(ResultSet rs, Discriminator discriminator) throws SQLException {
        ResultMapping resultMapping = discriminator.getResultMapping();
        TypeHandler typeHandler = resultMapping.getTypeHandler();
        if (typeHandler != null) {
            return typeHandler.getResult(rs, resultMapping.getColumn());
        }
        throw new ExecutorException("No type handler could be found to map the property '" + resultMapping.getProperty() + "' to the column '" + resultMapping.getColumn() + "'.  One or both of the types, or the combination of types is not supported.");
    }
}

