/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.Null;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlRunner {
    public static final int NO_GENERATED_KEY = -2147482647;
    private Connection connection;
    private TypeHandlerRegistry typeHandlerRegistry;
    private boolean useGeneratedKeySupport;

    public SqlRunner(Connection connection) {
        this.connection = connection;
        this.typeHandlerRegistry = new TypeHandlerRegistry();
    }

    public void setUseGeneratedKeySupport(boolean useGeneratedKeySupport) {
        this.useGeneratedKeySupport = useGeneratedKeySupport;
    }

    public Map<String, Object> selectOne(String sql, Object ... args) throws SQLException {
        List<Map<String, Object>> results = this.selectAll(sql, args);
        if (results.size() != 1) {
            throw new SQLException("Statement returned " + results.size() + " results where exactly one (1) was expected.");
        }
        return results.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> selectAll(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            this.setParameters(ps, args);
            ResultSet rs = ps.executeQuery();
            List<Map<String, Object>> list = this.getResults(rs);
            return list;
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException e) {}
        }
    }

    /*
     * Exception decompiling
     */
    public int insert(String sql, Object ... args) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            this.setParameters(ps, args);
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException e) {}
        }
    }

    public int delete(String sql, Object ... args) throws SQLException {
        return this.update(sql, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String sql) throws SQLException {
        Statement stmt = this.connection.createStatement();
        try {
            stmt.execute(sql);
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void closeConnection() {
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void setParameters(PreparedStatement ps, Object ... args) throws SQLException {
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            if (args[i] == null) {
                throw new SQLException("SqlRunner requires an instance of Null to represent typed null values for JDBC compatibility");
            }
            if (args[i] instanceof Null) {
                ((Null)((Object)args[i])).getTypeHandler().setParameter(ps, i + 1, null, ((Null)((Object)args[i])).getJdbcType());
                continue;
            }
            TypeHandler typeHandler = this.typeHandlerRegistry.getTypeHandler(args[i].getClass());
            if (typeHandler == null) {
                throw new SQLException("SqlRunner could not find a TypeHandler instance for " + args[i].getClass());
            }
            typeHandler.setParameter(ps, i + 1, args[i], null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getResults(ResultSet rs) throws SQLException {
        try {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<TypeHandler> typeHandlers = new ArrayList<TypeHandler>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int n = rsmd.getColumnCount();
            for (int i = 0; i < n; ++i) {
                columns.add(rsmd.getColumnLabel(i + 1));
                try {
                    Class type = Resources.classForName(rsmd.getColumnClassName(i + 1));
                    TypeHandler typeHandler = this.typeHandlerRegistry.getTypeHandler(type);
                    if (typeHandler == null) {
                        typeHandler = this.typeHandlerRegistry.getTypeHandler(Object.class);
                    }
                    typeHandlers.add(typeHandler);
                    continue;
                }
                catch (Exception e) {
                    typeHandlers.add(this.typeHandlerRegistry.getTypeHandler(Object.class));
                }
            }
            while (rs.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                int n2 = columns.size();
                for (int i = 0; i < n2; ++i) {
                    String name = (String)columns.get(i);
                    TypeHandler handler = (TypeHandler)typeHandlers.get(i);
                    row.put(name.toUpperCase(Locale.ENGLISH), handler.getResult(rs, name));
                }
                list.add(row);
            }
            ArrayList<Map<String, Object>> arrayList = list;
            return arrayList;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

