/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.metadata;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.ibatis.metadata.Table;

public class Database {
    private String catalog;
    private String schema;
    private Map tables = new HashMap();

    public Database(String catalog, String schema) {
        this.catalog = catalog;
        this.schema = schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void addTable(Table table) {
        this.tables.put(table.getName().toUpperCase(Locale.ENGLISH), table);
    }

    public Table getTable(String name) {
        return (Table)this.tables.get(name.toUpperCase(Locale.ENGLISH));
    }

    public String[] getTableNames() {
        return this.tables.keySet().toArray(new String[this.tables.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Database database = (Database)o;
        if (this.catalog != null ? !this.catalog.equals(database.catalog) : database.catalog != null) {
            return false;
        }
        return !(this.schema != null ? !this.schema.equals(database.schema) : database.schema != null);
    }

    public int hashCode() {
        int result = this.catalog != null ? this.catalog.hashCode() : 0;
        result = 29 * result + (this.schema != null ? this.schema.hashCode() : 0);
        return result;
    }
}

