/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.metadata;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.ibatis.metadata.Column;

public class Table {
    private String name;
    private String catalog;
    private String schema;
    private Map columns = new HashMap();
    private Column primaryKey;

    public Table(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void addColumn(Column col) {
        this.columns.put(col.getName().toUpperCase(Locale.ENGLISH), col);
    }

    public Column getColumn(String name) {
        return (Column)this.columns.get(name.toUpperCase(Locale.ENGLISH));
    }

    public String[] getColumnNames() {
        return this.columns.keySet().toArray(new String[this.columns.size()]);
    }

    public void setPrimaryKey(Column column) {
        this.primaryKey = column;
    }

    public Column getPrimaryKey() {
        return this.primaryKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return !(this.name != null ? !this.name.equals(table.name) : table.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

