/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.internal.util.StringUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interface
extends JavaElement
implements CompilationUnit {
    private Set<FullyQualifiedJavaType> importedTypes;
    private FullyQualifiedJavaType type;
    private Set<FullyQualifiedJavaType> superInterfaceTypes;
    private List<Method> methods;
    private List<String> fileCommentLines;

    public Interface(FullyQualifiedJavaType type) {
        this.type = type;
        this.superInterfaceTypes = new LinkedHashSet<FullyQualifiedJavaType>();
        this.methods = new ArrayList<Method>();
        this.importedTypes = new TreeSet<FullyQualifiedJavaType>();
        this.fileCommentLines = new ArrayList<String>();
    }

    public Interface(String type) {
        this(new FullyQualifiedJavaType(type));
    }

    @Override
    public Set<FullyQualifiedJavaType> getImportedTypes() {
        return Collections.unmodifiableSet(this.importedTypes);
    }

    @Override
    public void addImportedType(FullyQualifiedJavaType importedType) {
        if (importedType.isExplicitlyImported() && !importedType.getPackageName().equals(this.type.getPackageName())) {
            this.importedTypes.add(importedType);
        }
    }

    @Override
    public String getFormattedContent() {
        StringBuilder sb = new StringBuilder();
        for (String commentLine : this.fileCommentLines) {
            sb.append(commentLine);
            OutputUtilities.newLine(sb);
        }
        if (StringUtility.stringHasValue(this.getType().getPackageName())) {
            sb.append("package ");
            sb.append(this.getType().getPackageName());
            sb.append(';');
            OutputUtilities.newLine(sb);
            OutputUtilities.newLine(sb);
        }
        Set<String> importStrings = OutputUtilities.calculateImports(this.importedTypes);
        for (String importString : importStrings) {
            sb.append(importString);
            OutputUtilities.newLine(sb);
        }
        if (importStrings.size() > 0) {
            OutputUtilities.newLine(sb);
        }
        int indentLevel = 0;
        this.addFormattedJavadoc(sb, indentLevel);
        this.addFormattedAnnotations(sb, indentLevel);
        sb.append(this.getVisibility().getValue());
        if (this.isStatic()) {
            sb.append("static ");
        }
        if (this.isFinal()) {
            sb.append("final ");
        }
        sb.append("interface ");
        sb.append(this.getType().getShortName());
        if (this.getSuperInterfaceTypes().size() > 0) {
            sb.append(" extends ");
            boolean comma = false;
            for (FullyQualifiedJavaType fqjt : this.getSuperInterfaceTypes()) {
                if (comma) {
                    sb.append(", ");
                } else {
                    comma = true;
                }
                sb.append(fqjt.getShortName());
            }
        }
        sb.append(" {");
        ++indentLevel;
        Iterator<Method> mtdIter = this.getMethods().iterator();
        while (mtdIter.hasNext()) {
            OutputUtilities.newLine(sb);
            Method method = mtdIter.next();
            sb.append(method.getFormattedContent(indentLevel, true));
            if (!mtdIter.hasNext()) continue;
            OutputUtilities.newLine(sb);
        }
        OutputUtilities.newLine(sb);
        OutputUtilities.javaIndent(sb, --indentLevel);
        sb.append('}');
        return sb.toString();
    }

    public void addSuperInterface(FullyQualifiedJavaType superInterface) {
        this.superInterfaceTypes.add(superInterface);
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public void addMethod(Method method) {
        this.methods.add(method);
    }

    @Override
    public FullyQualifiedJavaType getType() {
        return this.type;
    }

    @Override
    public FullyQualifiedJavaType getSuperClass() {
        return null;
    }

    @Override
    public Set<FullyQualifiedJavaType> getSuperInterfaceTypes() {
        return this.superInterfaceTypes;
    }

    @Override
    public boolean isJavaInterface() {
        return true;
    }

    @Override
    public boolean isJavaEnumeration() {
        return false;
    }

    @Override
    public void addFileCommentLine(String commentLine) {
        this.fileCommentLines.add(commentLine);
    }

    @Override
    public List<String> getFileCommentLines() {
        return this.fileCommentLines;
    }

    @Override
    public void addImportedTypes(Set<FullyQualifiedJavaType> importedTypes) {
        this.importedTypes.addAll(importedTypes);
    }
}

