/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.java;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.java.JavaVisibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaElement {
    private List<String> javaDocLines = new ArrayList<String>();
    private JavaVisibility visibility;
    private boolean isStatic;
    private boolean isFinal;
    private List<String> annotations = new ArrayList<String>();

    public List<String> getJavaDocLines() {
        return this.javaDocLines;
    }

    public void addJavaDocLine(String javaDocLine) {
        this.javaDocLines.add(javaDocLine);
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(String annotation) {
        this.annotations.add(annotation);
    }

    public JavaVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(JavaVisibility visibility) {
        this.visibility = visibility;
    }

    public void addSuppressTypeWarningsAnnotation() {
        this.addAnnotation("@SuppressWarnings(\"unchecked\")");
    }

    public void addFormattedJavadoc(StringBuilder sb, int indentLevel) {
        for (String javaDocLine : this.javaDocLines) {
            OutputUtilities.javaIndent(sb, indentLevel);
            sb.append(javaDocLine);
            OutputUtilities.newLine(sb);
        }
    }

    public void addFormattedAnnotations(StringBuilder sb, int indentLevel) {
        for (String annotation : this.annotations) {
            OutputUtilities.javaIndent(sb, indentLevel);
            sb.append(annotation);
            OutputUtilities.newLine(sb);
        }
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }
}

