/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.internal.util.StringUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopLevelClass
extends InnerClass
implements CompilationUnit {
    private Set<FullyQualifiedJavaType> importedTypes = new TreeSet<FullyQualifiedJavaType>();
    private List<String> fileCommentLines = new ArrayList<String>();

    public TopLevelClass(FullyQualifiedJavaType type) {
        super(type);
    }

    public TopLevelClass(String typeName) {
        this(new FullyQualifiedJavaType(typeName));
    }

    @Override
    public Set<FullyQualifiedJavaType> getImportedTypes() {
        return Collections.unmodifiableSet(this.importedTypes);
    }

    @Override
    public void addImportedType(FullyQualifiedJavaType importedType) {
        if (importedType != null && importedType.isExplicitlyImported() && !importedType.getPackageName().equals(this.getType().getPackageName())) {
            this.importedTypes.add(importedType);
        }
    }

    @Override
    public String getFormattedContent() {
        StringBuilder sb = new StringBuilder();
        for (String fileCommentLine : this.fileCommentLines) {
            sb.append(fileCommentLine);
            OutputUtilities.newLine(sb);
        }
        if (StringUtility.stringHasValue(this.getType().getPackageName())) {
            sb.append("package ");
            sb.append(this.getType().getPackageName());
            sb.append(';');
            OutputUtilities.newLine(sb);
            OutputUtilities.newLine(sb);
        }
        Set<String> importStrings = OutputUtilities.calculateImports(this.importedTypes);
        for (String importString : importStrings) {
            sb.append(importString);
            OutputUtilities.newLine(sb);
        }
        if (importStrings.size() > 0) {
            OutputUtilities.newLine(sb);
        }
        sb.append(super.getFormattedContent(0));
        return sb.toString();
    }

    @Override
    public boolean isJavaInterface() {
        return false;
    }

    @Override
    public boolean isJavaEnumeration() {
        return false;
    }

    @Override
    public void addFileCommentLine(String commentLine) {
        this.fileCommentLines.add(commentLine);
    }

    @Override
    public List<String> getFileCommentLines() {
        return this.fileCommentLines;
    }

    @Override
    public void addImportedTypes(Set<FullyQualifiedJavaType> importedTypes) {
        this.importedTypes.addAll(importedTypes);
    }
}

