/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.config;

import java.util.List;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.internal.db.DatabaseDialects;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedKey {
    private String column;
    private String configuredSqlStatement;
    private String runtimeSqlStatement;
    private boolean isIdentity;
    private String type;

    public GeneratedKey(String column, String configuredSqlStatement, boolean isIdentity, String type) {
        this.column = column;
        this.type = type;
        this.isIdentity = isIdentity;
        this.configuredSqlStatement = configuredSqlStatement;
        DatabaseDialects dialect = DatabaseDialects.getDatabaseDialect(configuredSqlStatement);
        this.runtimeSqlStatement = dialect == null ? configuredSqlStatement : dialect.getIdentityRetrievalStatement();
    }

    public String getColumn() {
        return this.column;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public String getRuntimeSqlStatement() {
        return this.runtimeSqlStatement;
    }

    public String getType() {
        return this.type;
    }

    public boolean isBeforeInsert() {
        boolean rc = StringUtility.stringHasValue(this.type) ? true : !this.isIdentity;
        return rc;
    }

    public XmlElement toXmlElement() {
        XmlElement xmlElement = new XmlElement("generatedKey");
        xmlElement.addAttribute(new Attribute("column", this.column));
        xmlElement.addAttribute(new Attribute("sqlStatement", this.configuredSqlStatement));
        xmlElement.addAttribute(new Attribute("type", this.type));
        xmlElement.addAttribute(new Attribute("identity", this.isIdentity ? "true" : "false"));
        return xmlElement;
    }

    public void validate(List<String> errors, String tableName) {
        if (!StringUtility.stringHasValue(this.runtimeSqlStatement)) {
            errors.add(Messages.getString("ValidationError.7", tableName));
        }
        if (StringUtility.stringHasValue(this.type) && !"pre".equals(this.type) && !"post".equals(this.type)) {
            errors.add(Messages.getString("ValidationError.15", tableName));
        }
    }
}

