/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.internal;

import java.util.List;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.JavaTypeResolver;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.codegen.ibatis2.IntrospectedTableIbatis2Java2Impl;
import org.mybatis.generator.codegen.ibatis2.IntrospectedTableIbatis2Java5Impl;
import org.mybatis.generator.codegen.mybatis3.IntrospectedTableMyBatis3Impl;
import org.mybatis.generator.config.CommentGeneratorConfiguration;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.JavaTypeResolverConfiguration;
import org.mybatis.generator.config.PluginConfiguration;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.internal.DefaultCommentGenerator;
import org.mybatis.generator.internal.types.JavaTypeResolverDefaultImpl;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFactory {
    private static ClassLoader externalClassLoader;

    private ObjectFactory() {
    }

    private static ClassLoader getClassLoader() {
        if (externalClassLoader != null) {
            return externalClassLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public static synchronized void setExternalClassLoader(ClassLoader classLoader) {
        externalClassLoader = classLoader;
    }

    public static Class<?> externalClassForName(String type) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = ObjectFactory.getClassLoader().loadClass(type);
        }
        catch (Throwable e) {
            clazz = null;
        }
        if (clazz == null) {
            clazz = Class.forName(type);
        }
        return clazz;
    }

    public static Object createExternalObject(String type) {
        Object answer;
        try {
            Class<?> clazz = ObjectFactory.externalClassForName(type);
            answer = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.getString("RuntimeError.6", type), e);
        }
        return answer;
    }

    public static Class<?> internalClassForName(String type) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            clazz = cl.loadClass(type);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = Class.forName(type);
        }
        return clazz;
    }

    public static Object createInternalObject(String type) {
        Object answer;
        try {
            Class<?> clazz = ObjectFactory.internalClassForName(type);
            answer = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.getString("RuntimeError.6", type), e);
        }
        return answer;
    }

    public static JavaTypeResolver createJavaTypeResolver(Context context, List<String> warnings) {
        String type;
        JavaTypeResolverConfiguration config = context.getJavaTypeResolverConfiguration();
        if (config != null && config.getConfigurationType() != null) {
            type = config.getConfigurationType();
            if ("DEFAULT".equalsIgnoreCase(type)) {
                type = JavaTypeResolverDefaultImpl.class.getName();
            }
        } else {
            type = JavaTypeResolverDefaultImpl.class.getName();
        }
        JavaTypeResolver answer = (JavaTypeResolver)ObjectFactory.createInternalObject(type);
        answer.setWarnings(warnings);
        if (config != null) {
            answer.addConfigurationProperties(config.getProperties());
        }
        answer.setContext(context);
        return answer;
    }

    public static Plugin createPlugin(Context context, PluginConfiguration pluginConfiguration) {
        Plugin plugin = (Plugin)ObjectFactory.createInternalObject(pluginConfiguration.getConfigurationType());
        plugin.setContext(context);
        plugin.setProperties(pluginConfiguration.getProperties());
        return plugin;
    }

    public static CommentGenerator createCommentGenerator(Context context) {
        CommentGeneratorConfiguration config = context.getCommentGeneratorConfiguration();
        String type = config == null || config.getConfigurationType() == null ? DefaultCommentGenerator.class.getName() : config.getConfigurationType();
        CommentGenerator answer = (CommentGenerator)ObjectFactory.createInternalObject(type);
        if (config != null) {
            answer.addConfigurationProperties(config.getProperties());
        }
        return answer;
    }

    public static IntrospectedTable createIntrospectedTable(TableConfiguration tableConfiguration, FullyQualifiedTable table, Context context) {
        String type = context.getTargetRuntime();
        if (!StringUtility.stringHasValue(type)) {
            type = IntrospectedTableMyBatis3Impl.class.getName();
        } else if ("Ibatis2Java2".equalsIgnoreCase(type)) {
            type = IntrospectedTableIbatis2Java2Impl.class.getName();
        } else if ("Ibatis2Java5".equalsIgnoreCase(type)) {
            type = IntrospectedTableIbatis2Java5Impl.class.getName();
        } else if ("Ibatis3".equalsIgnoreCase(type)) {
            type = IntrospectedTableMyBatis3Impl.class.getName();
        } else if ("MyBatis3".equalsIgnoreCase(type)) {
            type = IntrospectedTableMyBatis3Impl.class.getName();
        }
        IntrospectedTable answer = (IntrospectedTable)ObjectFactory.createInternalObject(type);
        answer.setFullyQualifiedTable(table);
        answer.setContext(context);
        answer.setTableConfiguration(tableConfiguration);
        return answer;
    }

    public static IntrospectedColumn createIntrospectedColumn(Context context) {
        String type = context.getIntrospectedColumnImpl();
        if (!StringUtility.stringHasValue(type)) {
            type = IntrospectedColumn.class.getName();
        }
        IntrospectedColumn answer = (IntrospectedColumn)ObjectFactory.createInternalObject(type);
        answer.setContext(context);
        return answer;
    }
}

