/*
 * Decompiled with CFR 0.152.
 */
package com.crack.me.active;

import com.crack.me.active.ActivationCode;
import com.crack.me.active.Crackable;
import com.crack.me.active.DataSet;
import com.crack.me.active.LicenceCode;
import com.crack.me.active.RSAKey;
import com.crack.me.active.SystemIdFactory;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Crack
implements Crackable {
    @Override
    public String getSystemId() throws Exception {
        return new SystemIdFactory().generateSystemId();
    }

    public List<DataSet<String, String>> crackme(String uid) throws Exception {
        return this.crackme(uid, 1, 0, null);
    }

    public List<DataSet<String, String>> crackme(String uid, int licenceType) throws Exception {
        return this.crackme(uid, licenceType, 0, null);
    }

    public List<DataSet<String, String>> crackme(String uid, String systemId) throws Exception {
        return this.crackme(uid, 1, 0, systemId);
    }

    public List<DataSet<String, String>> crackme(String uid, int licenceType, String systemId) throws Exception {
        return this.crackme(uid, licenceType, 0, systemId);
    }

    @Override
    public List<DataSet<String, String>> crackme(String uid, int licenceType, int licenceNumber, String systemId) throws Exception {
        if (systemId == null || "".equals(systemId)) {
            systemId = this.getSystemId();
        }
        LicenceCode lc = new LicenceCode();
        String licenceCode = lc.generateLicenceCode(uid, licenceNumber, licenceType);
        String dateString = lc.getExpirationDate(licenceCode);
        ActivationCode ac2 = ActivationCode.fromCode(systemId, licenceCode, dateString);
        String perpareCode = ac2.generateActivationCode();
        String activeCode = new RSAKey().encryption(perpareCode);
        ArrayList<DataSet<String, String>> crackData = new ArrayList<DataSet<String, String>>(10);
        crackData.add(new DataSet<String, String>("LICENSEE", uid));
        crackData.add(new DataSet<String, String>("LICENSE_KEY", licenceCode));
        crackData.add(new DataSet<String, String>("ACTIVATION_CODE", perpareCode));
        crackData.add(new DataSet<String, String>("ACTIVATION_KEY", activeCode));
        return crackData;
    }
}

