/*
 * Decompiled with CFR 0.152.
 */
package com.crack.me.active;

import java.util.Random;

public class SystemId {
    public static final int NODE_LOCKED = 1;
    public static final int NODE_UNLOCKED = 2;
    public static final String NO_HOST = "00";
    public static final String NO_SYSINFO = "0000000";
    public static final String NO_MAC = "0000";
    public static final String NO_HD = "0000";
    public static final int FORMAT_TYPE_FIELD_LENGTH = 1;
    public static final int FORMAT_FIELD_LENGTH = 1;
    public static final int HOST_FIELD_LENGTH = "00".length();
    public static final int SYSINFO_FIELD_LENGTH = "0000000".length();
    public static final int MAC_FIELD_LENGTH = "0000".length();
    public static final int HD_FIELD_LENGTH = "0000".length();
    public static final int SYSTEM_ID_LENGTH = 2 + HOST_FIELD_LENGTH + SYSINFO_FIELD_LENGTH + MAC_FIELD_LENGTH + HD_FIELD_LENGTH;
    private int field = 0;
    private String hostInfo = "00";
    private String systemInfo = "0000000";
    private String macAddress = "0000";
    private String HDSerial = "0000";

    public static SystemId fromCode(String systemId) throws Exception {
        if (SystemId.isNullOrEmpty(systemId) || systemId.length() < SYSTEM_ID_LENGTH) {
            throw new Exception("InvalidLicenseDataException!{systemId is null or length not right!}");
        }
        int typeField = Integer.parseInt(systemId.substring(0, 1), 16);
        if (typeField != 1 && typeField != 2) {
            throw new Exception("InvalidLicenseDataException!{systemId first letter must be 1 or 2 !}");
        }
        int field = Integer.parseInt(systemId.substring(1, 2), 16);
        String host = NO_HOST;
        String systemInfo = NO_SYSINFO;
        String macAddress = "0000";
        String hdSerial = "0000";
        if ((field & 1) == 1) {
            host = systemId.substring(2, 2 + HOST_FIELD_LENGTH);
        }
        if ((field & 2) == 2) {
            systemInfo = systemId.substring(4, 4 + SYSINFO_FIELD_LENGTH);
        }
        if ((field & 4) == 4) {
            macAddress = systemId.substring(11, 11 + MAC_FIELD_LENGTH);
        }
        if ((field & 8) == 8) {
            hdSerial = systemId.substring(15, 15 + HD_FIELD_LENGTH);
        }
        return new SystemId(field, host, systemInfo, macAddress, hdSerial);
    }

    public SystemId(int field, String hostInfo, String systemInfo, String macAddress, String HDSerial) {
        this.field = field;
        this.hostInfo = SystemId.isNullOrEmpty(hostInfo) || !SystemId.isIdLegal(hostInfo) ? NO_HOST : hostInfo;
        this.systemInfo = SystemId.isNullOrEmpty(systemInfo) || !SystemId.isIdLegal(systemInfo) ? NO_SYSINFO : systemInfo;
        this.macAddress = SystemId.isNullOrEmpty(macAddress) || !SystemId.isIdLegal(macAddress) ? "0000" : macAddress;
        this.HDSerial = SystemId.isNullOrEmpty(HDSerial) || !SystemId.isIdLegal(HDSerial) ? "0000" : HDSerial;
    }

    public boolean isNodeLocked() {
        return true;
    }

    public int getField() {
        return this.field;
    }

    public String getHostInfo() {
        return this.hostInfo;
    }

    public boolean hasHostInfo() {
        return !NO_HOST.equals(this.hostInfo);
    }

    public String getSystemInfo() {
        return this.systemInfo;
    }

    public boolean hasSystemInfo() {
        return !NO_SYSINFO.equals(this.systemInfo);
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public boolean hasMacAddress() {
        return !"0000".equals(this.macAddress);
    }

    public String getHDSerial() {
        return this.HDSerial;
    }

    public boolean hasHDSerial() {
        return !"0000".equals(this.HDSerial);
    }

    public boolean matches(SystemId other) {
        if (other == null) {
            return false;
        }
        if (this.hasHDSerial() && other.hasHDSerial() && this.getHDSerial().equals(other.getHDSerial())) {
            return true;
        }
        if (this.hasMacAddress() && other.hasMacAddress() && this.getMacAddress().equals(other.getMacAddress())) {
            return true;
        }
        if (this.hasHostInfo() && other.hasHostInfo() && this.getHostInfo().equals(other.getHostInfo())) {
            return true;
        }
        return this.hasSystemInfo() && other.hasSystemInfo() && this.getSystemInfo().equals(other.getSystemInfo());
    }

    public String getCode() {
        int typeField = this.isNodeLocked() ? 1 : 2;
        int field = 0;
        field += this.hasHostInfo() ? 1 : 0;
        field += this.hasSystemInfo() ? 2 : 0;
        field += this.hasMacAddress() ? 4 : 0;
        return String.valueOf(Integer.toString(typeField, 16)) + Integer.toString(field += this.hasHDSerial() ? 8 : 0, 16) + (this.hasHostInfo() ? this.getHostInfo() : this.randomId(HOST_FIELD_LENGTH)) + (this.hasSystemInfo() ? this.getSystemInfo() : this.randomId(SYSINFO_FIELD_LENGTH)) + (this.hasMacAddress() ? this.getMacAddress() : this.randomId(MAC_FIELD_LENGTH)) + (this.hasHDSerial() ? this.getHDSerial() : this.randomId(HD_FIELD_LENGTH));
    }

    private String randomId(int idLength) {
        StringBuffer localStringBuffer = new StringBuffer(idLength);
        Random localRandom = new Random();
        int i2 = 0;
        while (i2 < idLength) {
            localStringBuffer.append(Integer.toHexString(localRandom.nextInt(16)));
            ++i2;
        }
        return localStringBuffer.toString();
    }

    private static boolean isIdLegal(String id) {
        if (SystemId.isNullOrEmpty(id)) {
            return false;
        }
        int i2 = 0;
        while (i2 < id.length()) {
            String str = id.substring(i2, i2 + 1);
            try {
                Byte.parseByte(str, 16);
            }
            catch (NumberFormatException e2) {
                e2.printStackTrace();
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || "".equals(value);
    }

    public String toString() {
        return "TypeField:\t" + (this.isNodeLocked() ? 1 : 2) + "\nField:    \t" + this.field + "\nHostInfo:\t" + this.hostInfo + "\nSystemInfo:\t" + this.systemInfo + "\nMacAddress:\t" + this.macAddress + "\nHDSerial:\t" + this.HDSerial;
    }
}

