/*
 * Decompiled with CFR 0.152.
 */
package com.crack.me.active.ui.replace;

import com.crack.me.active.ui.Loggable;
import com.crack.me.active.ui.replace.stream.ReplaceStream;
import com.crack.me.active.ui.replace.stream.ReplaceStreamType;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JarReplacer {
    protected static final FileFilter jarFileFilter = new FileFilter(){

        public boolean accept(File paramFile) {
            return paramFile.isDirectory() || paramFile.getName().endsWith(".jar") || paramFile.getName().endsWith(".zip");
        }
    };
    protected Loggable logger = null;
    protected List<File> jarFiles = null;
    private Map<String, ReplaceStream> needReplaceFileStreams = new HashMap<String, ReplaceStream>();
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");

    public JarReplacer(Loggable logger) {
        this.logger = logger;
    }

    public boolean replace() {
        if (!this.checkReplaceCondition()) {
            return false;
        }
        boolean isReplaceSuccess = true;
        for (File file : this.jarFiles) {
            if (!this.isFileLegal(file)) continue;
            isReplaceSuccess &= this.replaceJar(file);
        }
        return isReplaceSuccess;
    }

    protected boolean checkReplaceCondition() {
        if (this.jarFiles == null || this.jarFiles.isEmpty()) {
            this.logger.log("please use [setFileFolder|setJarFileList] first.");
            return false;
        }
        return true;
    }

    protected abstract boolean isFileLegal(File var1);

    public abstract String getProcessInfo();

    public void setFileFolder(File fileFolder) {
        this.setJarFileList(this.getJarFiles(fileFolder));
    }

    public void setJarFileList(List<File> jarFiles) {
        this.jarFiles = jarFiles;
    }

    public static FileFilter getFileFilter() {
        return jarFileFilter;
    }

    public void addReplaceStream(String entryName, ReplaceStream stream) {
        this.needReplaceFileStreams.put(entryName, stream);
    }

    public Map<String, ReplaceStream> getReplaceFileStreams() {
        return this.needReplaceFileStreams;
    }

    public boolean isInReplaceFileStreams(String fileName) {
        return this.needReplaceFileStreams.containsKey(fileName);
    }

    public List<File> findLegalFiles() {
        return this.findLegalFiles(this.jarFiles);
    }

    public List<File> findLegalFiles(List<File> files) {
        if (files == null) {
            return null;
        }
        ArrayList<File> needFiles = new ArrayList<File>();
        for (File file : files) {
            if (!this.isFileLegal(file)) continue;
            needFiles.add(file);
        }
        return needFiles;
    }

    public List<File> getJarFiles(File file) {
        return this.getAllFiles(file, jarFileFilter);
    }

    public List<File> getAllFiles(File FileTemp, FileFilter fileFilter) {
        ArrayList<File> allFiles = new ArrayList<File>();
        if (FileTemp != null) {
            if (!FileTemp.isDirectory()) {
                allFiles.add(FileTemp);
            } else {
                File[] files = FileTemp.listFiles(fileFilter);
                if (files != null && files.length != 0) {
                    File[] fileArray = files;
                    int n2 = files.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        File file = fileArray[n3];
                        if (file != null) {
                            if (file.isDirectory()) {
                                List<File> tmpFiles = this.getAllFiles(file, fileFilter);
                                if (tmpFiles != null) {
                                    allFiles.addAll(tmpFiles);
                                }
                            } else {
                                allFiles.add(file);
                            }
                        }
                        ++n3;
                    }
                }
            }
        }
        return allFiles;
    }

    public File createBakFile(File file) {
        String lastName = ".bak" + sdf.format(new Date());
        String bakFileName = file.getAbsoluteFile() + lastName;
        File newFile = new File(bakFileName);
        FileInputStream in = null;
        OutputStream out = null;
        try {
            try {
                in = new FileInputStream(file);
                out = new FileOutputStream(newFile);
                this.writeStream(in, out);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return null;
            }
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e4) {
                e4.printStackTrace();
            }
        }
        return newFile;
    }

    public boolean replaceJar(File file) {
        return this.replaceJar(file, this.needReplaceFileStreams);
    }

    public boolean replaceJar(File file, Map<String, ReplaceStream> streams) {
        File bakFile;
        if (file != null && (bakFile = this.createBakFile(file)) != null) {
            this.logger.log("\treplacing file [" + file.getAbsolutePath() + "] and create bakFile [" + bakFile.getAbsolutePath() + "]");
            ZipOutputStream out = null;
            JarFile bakJar = null;
            try {
                bakJar = new JarFile(bakFile);
                out = new JarOutputStream(new FileOutputStream(file));
                Enumeration<JarEntry> jarEnties = bakJar.entries();
                while (jarEnties.hasMoreElements()) {
                    JarEntry jarEntry = jarEnties.nextElement();
                    String entryName = jarEntry.getName();
                    ReplaceStream replaceStream = streams != null ? streams.get(entryName) : null;
                    InputStream in = null;
                    if (replaceStream != null) {
                        if (replaceStream.getReplaceStreamType() == ReplaceStreamType.DELETE) {
                            this.logger.log("\t    delete [" + entryName + "]");
                            continue;
                        }
                        if (replaceStream.getReplaceStreamType() == ReplaceStreamType.UPDATE) {
                            this.logger.log("\t    update [" + entryName + "]");
                            jarEntry = new JarEntry(entryName);
                            in = replaceStream.getInputStream();
                        } else if (replaceStream.getReplaceStreamType() == ReplaceStreamType.NONE) {
                            in = bakJar.getInputStream(jarEntry);
                        }
                    } else {
                        in = bakJar.getInputStream(jarEntry);
                    }
                    ((JarOutputStream)out).putNextEntry(jarEntry);
                    this.writeJarEntry(in, (JarOutputStream)out);
                }
                return true;
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (bakJar != null) {
                        bakJar.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        return false;
    }

    public void writeJarEntry(InputStream in, JarOutputStream out) throws IOException {
        this.writeStream(in, out);
        in.close();
        out.flush();
        out.closeEntry();
    }

    public void writeStream(InputStream in, OutputStream out) throws IOException {
        byte[] data = new byte[1024];
        int len = -1;
        while ((len = in.read(data)) != -1) {
            out.write(data, 0, len);
        }
        out.flush();
    }
}

