/*
 * Decompiled with CFR 0.152.
 */
package com.crack.me.active.ui.replace;

import com.crack.me.active.ui.Loggable;
import com.crack.me.active.ui.replace.JarReplacer;
import com.crack.me.active.ui.replace.stream.ReplaceStreamType;
import com.crack.me.active.ui.replace.stream.SystemResourceReplaceStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecialSignatureVerifierReplacer
extends JarReplacer {
    private static final String[] FOR_INDEXS = new String[]{"com.genuitec.eclipse.core", "com.genuitec.eclipse.easie.core", "com.genuitec.eclipse.j2eedt", "com.genuitec.myeclipse.product"};
    private ClassLoader classLoader = null;
    private static final String METHOD_NAME = "verifyJarSignatures";
    private static final String SERVER_VALIDATE_ACTION_CLASS = "com/genuitec/eclipse/easie/core/ui/action/ServerValidateAction.class";
    private static final String MECP_LIST_CONTENT_PROVIDER_CLASS = "com/genuitec/eclipse/core/ui/preference/MECPListContentProvider.class";
    private static final String TAGLIB_READER_CLASS = "com/genuitec/eclipse/j2eedt/taglib/TagLibReader.class";
    private static final String PRODUCT_VIEWER_CLASS = "com/genuitec/myeclipse/product/ProductViewer.class";

    public SpecialSignatureVerifierReplacer(Loggable logger) {
        super(logger);
        this.addReplaceStream(SERVER_VALIDATE_ACTION_CLASS, new SystemResourceReplaceStream(SERVER_VALIDATE_ACTION_CLASS, ReplaceStreamType.UPDATE));
        this.addReplaceStream(MECP_LIST_CONTENT_PROVIDER_CLASS, new SystemResourceReplaceStream(MECP_LIST_CONTENT_PROVIDER_CLASS, ReplaceStreamType.UPDATE));
        this.addReplaceStream(TAGLIB_READER_CLASS, new SystemResourceReplaceStream(TAGLIB_READER_CLASS, ReplaceStreamType.UPDATE));
        this.addReplaceStream(PRODUCT_VIEWER_CLASS, new SystemResourceReplaceStream(PRODUCT_VIEWER_CLASS, ReplaceStreamType.UPDATE));
    }

    @Override
    public boolean isFileLegal(File file) {
        return this.isAllowedCheckedFile(file) ? this.isSignatureVerifierFile(this.classLoader, file) : false;
    }

    @Override
    public boolean checkReplaceCondition() {
        if (this.classLoader == null) {
            this.logger.log("classloader was not load");
            return false;
        }
        return super.checkReplaceCondition();
    }

    @Override
    public void setJarFileList(List<File> jarFiles) {
        super.setJarFileList(jarFiles);
        this.classLoader = this.getClassLoader(jarFiles);
    }

    private boolean isSignatureVerifierFile(ClassLoader classLoader, File file) {
        boolean isSignatureVerifierFile;
        block14: {
            isSignatureVerifierFile = false;
            if (file != null && classLoader != null) {
                JarFile jarFile = null;
                try {
                    try {
                        jarFile = new JarFile(file);
                        Enumeration<JarEntry> jarEntries = jarFile.entries();
                        while (jarEntries.hasMoreElements()) {
                            JarEntry jarEntry = jarEntries.nextElement();
                            if (!this.isClassFile(jarEntry)) continue;
                            String jarEntryName = jarEntry.getName();
                            String className = this.getClassName(jarEntry);
                            if (!this.isAllowedCheckedClass(className) || !this.isSignatureVerifierClass(classLoader, className)) continue;
                            isSignatureVerifierFile = true;
                            if (this.isInReplaceFileStreams(jarEntryName)) continue;
                            this.logger.log("found SignatureVerifier.File [" + jarEntryName + "],but was not in list.can't replace it.");
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        if (jarFile == null) break block14;
                        try {
                            jarFile.close();
                        }
                        catch (Exception e3) {
                            e3.printStackTrace();
                        }
                    }
                }
                finally {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Exception e4) {
                            e4.printStackTrace();
                        }
                    }
                }
            }
        }
        return isSignatureVerifierFile;
    }

    private boolean isAllowedChecked(String name) {
        String[] stringArray = FOR_INDEXS;
        int n2 = FOR_INDEXS.length;
        int n3 = 0;
        while (n3 < n2) {
            String forIndex = stringArray[n3];
            if (name.indexOf(forIndex) != -1) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private boolean isAllowedCheckedClass(String className) {
        return this.isAllowedChecked(className);
    }

    private boolean isAllowedCheckedFile(File file) {
        if (file != null) {
            return this.isAllowedChecked(file.getAbsolutePath());
        }
        return false;
    }

    private boolean isSignatureVerifierClass(ClassLoader classLoader, String className) {
        boolean isSignatureVerifierClass = false;
        try {
            Class<?> clazz = classLoader.loadClass(className);
            isSignatureVerifierClass |= this.isSignatureVerifierMethods(clazz);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return isSignatureVerifierClass;
    }

    private boolean isClassFile(JarEntry jarEntry) {
        return jarEntry != null ? jarEntry.getName().endsWith(".class") : false;
    }

    private String getClassName(JarEntry jarEntry) {
        if (jarEntry != null) {
            String name = jarEntry.getName();
            name = name.substring(0, name.indexOf(".class"));
            name = name.replaceAll("/", ".");
            return name;
        }
        return null;
    }

    private boolean isSignatureVerifierMethods(Class<?> clazz) {
        try {
            clazz.getDeclaredMethod(METHOD_NAME, String.class, String.class);
            clazz.getDeclaredMethod(METHOD_NAME, String[].class);
            clazz.getDeclaredMethod(METHOD_NAME, new Class[0]);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private ClassLoader getClassLoader(List<File> jarFiles) {
        if (jarFiles != null && jarFiles.size() != 0) {
            URL[] urls = new URL[jarFiles.size()];
            int i2 = 0;
            while (i2 < urls.length) {
                try {
                    urls[i2] = jarFiles.get(i2).toURI().toURL();
                }
                catch (MalformedURLException e2) {
                    e2.printStackTrace();
                }
                ++i2;
            }
            return new URLClassLoader(urls, this.getClass().getClassLoader());
        }
        return null;
    }

    @Override
    public String getProcessInfo() {
        return "Replacing [SpecialSignatureVerifier<for MyEclipse.10.1>].";
    }
}

