/*
 * Decompiled with CFR 0.152.
 */
package com.crack.me.active;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LicenceCode {
    private static final String LICENCE_KEY = "Decompiling this copyrighted software is a violation of both your license agreement and the Digital Millenium Copyright Act of 1998 (http://www.loc.gov/copyright/legislation/dmca.pdf). Under section 1204 of the DMCA, penalties range up to a $500,000 fine or up to five years imprisonment for a first offense. Think about it; pay for a license, avoid prosecution, and feel better about yourself.";
    private Map<Integer, String> licenceTypes = null;
    public static final int STANDARD_TYPE = 0;
    public static final int PROFESSIONAL_TYPE = 1;
    public static final int BLUE_TYPE = 2;
    public static final int SPRING_TYPE = 3;
    public static final int DEFAULT_LICENCE_TYPE = 1;
    public static final int UNLIMITED_LICENCE_NUMBER = 0;

    public LicenceCode() {
        this.initLicenceType();
    }

    private void initLicenceType() {
        this.licenceTypes = new HashMap<Integer, String>();
        this.licenceTypes.put(0, "YE2MY");
        this.licenceTypes.put(1, "YE3MP");
        this.licenceTypes.put(2, "YE3MB");
        this.licenceTypes.put(3, "YE3MS");
    }

    private String getLicenceTypeCode(int type) {
        String licenceType = this.licenceTypes.get(type);
        if (licenceType == null) {
            licenceType = this.licenceTypes.get(1);
        }
        return licenceType;
    }

    public String generateLicenceCode(String userId, int licenceNum, int licenceType) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, 3);
        calendar.add(6, -1);
        String uid = userId.substring(0, 1);
        String licenceTypeCode = this.getLicenceTypeCode(licenceType);
        String licenceVersion = "300";
        String licenceNumber = new DecimalFormat("000").format((Object)licenceNum);
        String expirationDate = String.valueOf(new SimpleDateFormat("yyMMdd").format(calendar.getTime())) + "0";
        String base = String.valueOf(uid) + licenceTypeCode + "-" + licenceVersion + licenceNumber + "-" + expirationDate;
        String needDecode = String.valueOf(base) + LICENCE_KEY + userId;
        int suf = this.decode(needDecode);
        String code = String.valueOf(base) + String.valueOf(suf);
        return this.transform(code);
    }

    private int decode(String s2) {
        char[] ac2 = s2.toCharArray();
        int sum = 0;
        int i2 = 0;
        while (i2 < ac2.length) {
            sum = 31 * sum + ac2[i2];
            ++i2;
        }
        return Math.abs(sum);
    }

    private String transform(String s2) {
        byte[] bytes = s2.getBytes();
        char[] changed = new char[s2.length()];
        int i2 = 0;
        while (i2 < bytes.length) {
            int value = bytes[i2];
            if (value >= 48 && value <= 57) {
                value = (value - 48 + 5) % 10 + 48;
            } else if (value >= 65 && value <= 90) {
                value = (value - 65 + 13) % 26 + 65;
            } else if (value >= 97 && value <= 122) {
                value = (value - 97 + 13) % 26 + 97;
            }
            changed[i2] = (char)value;
            ++i2;
        }
        return String.valueOf(changed);
    }

    public boolean isLicenceCorrect(String uid, String licenceCode) {
        int desCode;
        if (licenceCode == null || licenceCode.length() < 22) {
            return false;
        }
        String lc = this.transform(licenceCode);
        String base = lc.substring(0, 21);
        int srcCode = Integer.parseInt(lc.substring(21, lc.length()));
        return srcCode == (desCode = this.decode(String.valueOf(base) + LICENCE_KEY + uid));
    }

    public boolean isLicenceDateExpired(String licenceCode) {
        if (licenceCode == null || licenceCode.length() < 22) {
            return true;
        }
        try {
            String lc = this.transform(licenceCode);
            String date = lc.substring(14, 20);
            Date licenceDate = new SimpleDateFormat("yyyyMMdd").parse("20" + date);
            Calendar licenceCalendar = Calendar.getInstance();
            licenceCalendar.setTime(licenceDate);
            int compare = licenceCalendar.compareTo(Calendar.getInstance());
            return compare <= 0;
        }
        catch (ParseException e2) {
            e2.printStackTrace();
            return true;
        }
    }

    public String getExpirationDate(String licenceCode) {
        String lc = this.transform(licenceCode);
        String date = lc.substring(14, 20);
        return date;
    }

    public void showLicence(String licenceCode) {
        licenceCode = this.transform(licenceCode);
    }
}

