/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core;

import com.genuitec.eclipse.core.util.InitException;
import com.genuitec.eclipse.core.util.Util;
import com.genuitec.eclipse.runtime.internal.RuntimeManagerImpl;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public final class GenuitecServerSourcePathComputerDelegate
implements ISourcePathComputerDelegate {
    private static final String EXT_SERVER_SOURCE_PATH_COMPUTERS = "serverSourcePathComputers";
    private static final String EL_SOURCE_PATH_COMPUTER = "source-path-computer";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_PRIORITY = "priority";
    private static final String ATTR_SERVER_TYPE_PATTERN = "server-type-pattern";
    private static List<SourcePathComputer> computers = new ArrayList<SourcePathComputer>();

    static {
        GenuitecServerSourcePathComputerDelegate.loadExtensionPoint();
    }

    private static void loadExtensionPoint() {
        IConfigurationElement[] elements;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.genuitec.eclipse.server.core", EXT_SERVER_SOURCE_PATH_COMPUTERS);
        IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (ce.getName().equals(EL_SOURCE_PATH_COMPUTER)) {
                try {
                    computers.add(new SourcePathComputer(ce));
                }
                catch (InitException initException) {}
            }
            ++n2;
        }
        Collections.sort(computers, new Comparator<SourcePathComputer>(){

            @Override
            public int compare(SourcePathComputer o1, SourcePathComputer o2) {
                if (o1.priority > o2.priority) {
                    return 1;
                }
                if (o1.priority < o2.priority) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        ArrayList<ISourceContainer> res = new ArrayList<ISourceContainer>();
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)(computers.size() * 100));
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        String serverId = server != null ? server.getServerType().getId() : "";
        for (SourcePathComputer computer : computers) {
            if (computer.supports(serverId)) {
                ISourceContainer[] scs = computer.computeSourceContainers(configuration, (IProgressMonitor)m.newChild(100));
                if (scs == null) continue;
                res.addAll(Arrays.asList(scs));
                continue;
            }
            m.worked(100);
        }
        return res.toArray(new ISourceContainer[res.size()]);
    }

    private static final class SourcePathComputer {
        private IConfigurationElement element;
        private ISourcePathComputerDelegate delegate;
        private double priority;
        private Pattern serverIdPattern;

        public SourcePathComputer(IConfigurationElement element) throws InitException {
            this.element = element;
            String priorityStr = element.getAttribute(GenuitecServerSourcePathComputerDelegate.ATTR_PRIORITY);
            if (Util.isNullOrEmpty((String)priorityStr)) {
                RuntimeManagerImpl.reportMissingAttribute((IConfigurationElement)element, (String)GenuitecServerSourcePathComputerDelegate.ATTR_PRIORITY);
                throw new InitException();
            }
            try {
                this.priority = Double.parseDouble(priorityStr);
            }
            catch (NumberFormatException ex) {
                ServerCorePlugin.getDefault().log("Invalid value for <0> attribute for <{1}> element in {2} plugin: {3}", ex, new String[]{GenuitecServerSourcePathComputerDelegate.ATTR_PRIORITY, element.getName(), element.getContributor().getName(), priorityStr});
                throw new InitException();
            }
            String serverTypes = element.getAttribute(GenuitecServerSourcePathComputerDelegate.ATTR_SERVER_TYPE_PATTERN);
            if (Util.isNullOrEmpty((String)serverTypes)) {
                RuntimeManagerImpl.reportMissingAttribute((IConfigurationElement)element, (String)GenuitecServerSourcePathComputerDelegate.ATTR_SERVER_TYPE_PATTERN);
                throw new InitException();
            }
            try {
                this.serverIdPattern = Pattern.compile(serverTypes);
            }
            catch (PatternSyntaxException ex) {
                ServerCorePlugin.getDefault().log("Invalid value for <0> attribute for <{1}> element in {2} plugin: {3}", ex, new String[]{GenuitecServerSourcePathComputerDelegate.ATTR_SERVER_TYPE_PATTERN, element.getName(), element.getContributor().getName(), serverTypes});
                throw new InitException();
            }
            if (Util.isNullOrEmpty((String)element.getAttribute(GenuitecServerSourcePathComputerDelegate.ATTR_CLASS))) {
                RuntimeManagerImpl.reportMissingAttribute((IConfigurationElement)element, (String)GenuitecServerSourcePathComputerDelegate.ATTR_CLASS);
                throw new InitException();
            }
        }

        public boolean supports(String serverId) {
            return this.serverIdPattern.matcher(serverId).matches();
        }

        public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
            if (this.delegate == null) {
                try {
                    this.delegate = (ISourcePathComputerDelegate)this.element.createExecutableExtension(GenuitecServerSourcePathComputerDelegate.ATTR_CLASS);
                }
                catch (CoreException ce) {
                    ServerCorePlugin.getDefault().log(ce);
                    this.delegate = new ISourcePathComputerDelegate(){

                        public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
                            return null;
                        }
                    };
                }
            }
            return this.delegate.computeSourceContainers(configuration, monitor);
        }
    }
}

