/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.migration;

import com.genuitec.eclipse.core.GenuitecCoreException;
import com.genuitec.eclipse.core.JavaVMUtility;
import com.genuitec.eclipse.core.util.Util;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import com.genuitec.eclipse.server.core.migration.AbstractServerMigrationDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jst.server.core.IJavaRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;

public abstract class AbstractServerRuntimeSetupOperation
extends AbstractServerMigrationDelegate {
    protected abstract String getServerLocation();

    protected abstract String getJreName();

    @Override
    public IStatus validate() {
        String location = this.getServerLocation();
        if (location == null) {
            return this.createErrorStatus("Cannot determine location of the server.", new Object[0]);
        }
        Path path = new Path(location);
        if (!path.toFile().isDirectory()) {
            return this.createErrorStatus("\"{0}\" is not an existing directory.", path.toFile().toString());
        }
        IRuntimeWorkingCopy rwc = this.getMigratingServer().getRuntimeWorkingCopy().getOriginal().createWorkingCopy();
        try {
            this.setupRuntime(rwc, SubMonitor.convert(null));
            IStatus status = rwc.validate(null);
            if (status.getSeverity() >= 4) {
                IStatus iStatus = this.createErrorStatus(status.getMessage(), new Object[0]);
                return iStatus;
            }
            IStatus iStatus = status;
            return iStatus;
        }
        catch (GenuitecCoreException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            ((RuntimeWorkingCopy)rwc).dispose();
        }
    }

    public void perform(int stage, SubMonitor monitor) throws CoreException {
        monitor.beginTask("", 40);
        IRuntimeWorkingCopy rwc = this.getMigratingServer().getRuntimeWorkingCopy();
        this.setupRuntime(rwc, monitor);
        IStatus status = rwc.validate((IProgressMonitor)monitor.newChild(10));
        if (status.getSeverity() >= 4) {
            throw new CoreException(status);
        }
        rwc.save(true, (IProgressMonitor)monitor.newChild(10));
    }

    protected void setupRuntime(IRuntimeWorkingCopy rwc, SubMonitor monitor) throws GenuitecCoreException {
        Path path = new Path(this.getServerLocation());
        rwc.setLocation((IPath)path);
        IJavaRuntimeWorkingCopy jrwc = (IJavaRuntimeWorkingCopy)rwc.loadAdapter(IJavaRuntimeWorkingCopy.class, (IProgressMonitor)monitor.newChild(10));
        if (jrwc == null) {
            throw new GenuitecCoreException("Cannot load IJavaRuntimeWorkingCopy adapter for {0}", (Plugin)ServerCorePlugin.getDefault(), new String[]{rwc.toString()});
        }
        String jreName = this.getJreName();
        if (!Util.isNullOrEmpty((String)jreName)) {
            IVMInstall vminstall = JavaVMUtility.getVMInstall((String)jreName);
            jrwc.setVMInstall(vminstall);
        } else {
            jrwc.setVMInstall(null);
        }
    }
}

