/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.sourcelookup;

import com.genuitec.eclipse.core.sourcelookup.UpdatableCompositeSourceContainer;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import com.genuitec.eclipse.server.core.sourcelookup.ModuleProjectSourceContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.server.core.IModuleDeployment;
import org.eclipse.wst.server.core.IRootDeployment;
import org.eclipse.wst.server.core.IServer;

public class ServerModulesSourceContainer
extends UpdatableCompositeSourceContainer {
    public static final String TYPE_ID = "com.genuitec.eclipse.server.core.containerType.serverModules";
    private IServer server;
    private Set<String> cachedModules;
    private IRootDeployment[] deployments;

    public ServerModulesSourceContainer(IServer server) {
        this.server = server;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        ISourceLookupDirector director = this.getDirector();
        if (director != null) {
            return director.getLaunchConfiguration();
        }
        return null;
    }

    public String getName() {
        return "Modules deployed to " + this.server.getName();
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    protected boolean needsUpdate() {
        HashSet<String> modules = new HashSet<String>();
        IRootDeployment[] iRootDeploymentArray = this.deployments = this.server.getDeployments();
        int n = this.deployments.length;
        int n2 = 0;
        while (n2 < n) {
            IRootDeployment rd = iRootDeploymentArray[n2];
            this.visitModules((IModuleDeployment)rd, modules);
            ++n2;
        }
        if (this.cachedModules == null || !modules.equals(this.cachedModules)) {
            this.cachedModules = modules;
            return true;
        }
        return false;
    }

    private void visitModules(IModuleDeployment deployment, Set<String> modules) {
        modules.add(deployment.getModule().getId());
        for (IModuleDeployment md : deployment.getChildDeployments()) {
            this.visitModules(md, modules);
        }
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        ILaunchConfiguration launchConfig = this.getLaunchConfiguration();
        if (launchConfig == null) {
            return new ISourceContainer[0];
        }
        ArrayList<IJavaProject> javaProjectList = new ArrayList<IJavaProject>();
        ArrayList<ModuleProjectSourceContainer> sourceContainers = new ArrayList<ModuleProjectSourceContainer>();
        this.processModules((IModuleDeployment[])this.deployments, javaProjectList);
        ArrayList<IJavaProject> allJavaProjects = new ArrayList<IJavaProject>();
        for (IJavaProject jp : javaProjectList) {
            try {
                this.collectRequiredProjects(jp, allJavaProjects);
            }
            catch (JavaModelException e) {
                ServerCorePlugin.getDefault().log(e.getStatus());
            }
        }
        int i = 0;
        while (i < allJavaProjects.size()) {
            sourceContainers.add(new ModuleProjectSourceContainer((IJavaProject)allJavaProjects.get(i)));
            ++i;
        }
        return sourceContainers.toArray(new ISourceContainer[sourceContainers.size()]);
    }

    protected void collectRequiredProjects(IJavaProject proj, List<IJavaProject> res) throws JavaModelException {
        if (!res.contains(proj)) {
            res.add(proj);
            IJavaModel model = proj.getJavaModel();
            IClasspathEntry[] entries = proj.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IJavaProject ref;
                IClasspathEntry curr = entries[i];
                if (curr.getEntryKind() == 2 && (ref = model.getJavaProject(curr.getPath().segment(0))).exists()) {
                    this.collectRequiredProjects(ref, res);
                }
                ++i;
            }
        }
    }

    private void processModules(IModuleDeployment[] deployments, List<IJavaProject> javaProjectList) {
        IModuleDeployment[] iModuleDeploymentArray = deployments;
        int n = deployments.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project;
            IModuleDeployment deployment = iModuleDeploymentArray[n2];
            List childModules = deployment.getChildDeployments();
            if (childModules != null && childModules.size() > 0) {
                this.processModules(childModules.toArray(new IModuleDeployment[childModules.size()]), javaProjectList);
            }
            if ((project = deployment.getProject()) != null) {
                try {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    if (javaProject.exists() && !javaProjectList.contains(javaProject)) {
                        javaProjectList.add(javaProject);
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }
}

