/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.wizard;

import com.genuitec.eclipse.core.ActivationValidator;
import com.genuitec.eclipse.core.LicenseUtil;
import com.genuitec.eclipse.core.activation.ProductActivator;
import com.genuitec.eclipse.core.portability.wizard.StatusInfo;
import com.genuitec.eclipse.core.ui.wizard.ActivationBaseWizardPage;
import com.genuitec.eclipse.core.util.PlatformUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CodeEntryActivationWizardPage
extends ActivationBaseWizardPage {
    public static final IStatus OK_STATUS = new StatusInfo();
    private static final String W = "LICENSE_WIZARDPAGE";
    private boolean V = false;
    private Text Y;
    private String X = "";

    public CodeEntryActivationWizardPage() {
        super(W);
        this.setTitle("Activation Code Entry");
        this.setDescription("Enter your product activation code");
    }

    public boolean hasValidCode() {
        return !PlatformUtil.isNullOrEmpty((String)this.getCode());
    }

    public String getCode() {
        return this.X;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        GridData gridData = new GridData();
        gridData.verticalIndent = 30;
        gridData.horizontalIndent = 30;
        label.setLayoutData((Object)gridData);
        label.setText("Enter your activation code:");
        this.Y = new Text(composite2, 2370);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 2;
        gridData.horizontalSpan = 2;
        gridData.widthHint = this.convertWidthInCharsToPixels(50);
        gridData.heightHint = this.convertHeightInCharsToPixels(5);
        this.Y.setLayoutData((Object)gridData);
        this.Y.setFont(JFaceResources.getFont((String)"org.eclipse.ui.workbench.texteditor.blockSelectionModeFont"));
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout(2, false);
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 2;
        composite3.setLayoutData((Object)gridData);
        final Button button = new Button(composite3, 8);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        button.setLayoutData((Object)gridData);
        button.setText("Paste From Clipboard");
        final Text text = this.Y;
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TextTransfer textTransfer;
                Clipboard clipboard = new Clipboard(button.getDisplay());
                String string = (String)clipboard.getContents((Transfer)(textTransfer = TextTransfer.getInstance()));
                if (string != null) {
                    text.insert(string);
                }
            }
        });
        Button button2 = new Button(composite3, 8);
        button2.setText("Clear");
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.widthHint = button.computeSize((int)-1, (int)-1, (boolean)true).x;
        button2.setLayoutData((Object)gridData);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CodeEntryActivationWizardPage.this.Y.setText("");
            }
        });
        this.Y.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                CodeEntryActivationWizardPage.this.validate();
            }
        });
        this.setControl((Control)composite2);
        this.setPageComplete(false);
    }

    protected IStatus validate() {
        String string = this.Y.getText();
        if (string == null || string.length() < 150) {
            String string2 = "Please enter a valid activation code";
            this.setErrorMessage(string2);
            this.setPageComplete(false);
            return new StatusInfo(4, string2);
        }
        this.X = string.trim();
        ActivationValidator activationValidator = new ActivationValidator(this.X, LicenseUtil.getCurrentLicenseCode());
        IStatus iStatus = activationValidator.validate();
        if (!iStatus.isOK()) {
            String string3 = String.valueOf(iStatus.getMessage()) + ", please reenter code";
            this.setErrorMessage(string3);
            this.setPageComplete(false);
            return iStatus;
        }
        ProductActivator.getDefault().setManuallyEnteredActivationCode(activationValidator.getActivationCode());
        this.setErrorMessage(null);
        this.setMessage("Press \"Next>\" button to save the activation code");
        this.setPageComplete(true);
        return PlatformUtil.getOKStatus();
    }
}

