/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.property;

import com.genuitec.eclipse.core.CommonUI;
import com.genuitec.eclipse.core.Messages;
import com.genuitec.eclipse.core.property.InfoProjectPropertiesPage;
import com.genuitec.eclipse.core.property.MetricSummary;
import com.genuitec.eclipse.core.ui.util.SWTUtil;
import com.genuitec.eclipse.core.util.JavaMetaUtils;
import com.genuitec.eclipse.core.util.Util;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public class MetricsCalculator
extends Job {
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
    private IJavaProject javaProject;
    private MetricSummary projectMetricSummary;
    private int srcFolderCnt;
    private int pkgCnt;
    private int classCnt;
    private int locCnt;
    private int charCnt;
    private ASTParser parser;
    private InfoProjectPropertiesPage infoPage;
    private WorkingCopyManager wcManager;

    public static MetricsCalculator runTest() {
        IJavaProject javaProject = JavaMetaUtils.getJavaProject((String)"StatisticTest");
        MetricsCalculator calc = new MetricsCalculator(javaProject, null, null);
        calc.schedule();
        System.out.println("done");
        return calc;
    }

    public MetricsCalculator(IJavaProject theJavaProject, InfoProjectPropertiesPage page, WorkingCopyManager manager) {
        super(Messages.MetricsCalculator_taskname_calcuatingMetrics);
        this.setUser(true);
        this.javaProject = theJavaProject;
        this.parser = ASTParser.newParser((int)3);
        this.infoPage = page;
        this.wcManager = manager;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(Messages.MetricsCalculator_taskname_metricCalculation, 2);
        SWTUtil.invokeOnDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MetricsCalculator.this.infoPage.setMetricsRunning(true);
            }
        });
        this.srcFolderCnt = 0;
        this.pkgCnt = 0;
        this.classCnt = 0;
        this.locCnt = 0;
        this.charCnt = 0;
        monitor.setTaskName(Messages.MetricsCalculator_taskname_traversingProjectTree);
        this.projectMetricSummary = this.computeMetrics(this.javaProject);
        monitor.setTaskName(Messages.MetricsCalculator_taskname_computingMetrics);
        this.iterateMetricSummaryTree(this.projectMetricSummary);
        final Date updateDate = new Date();
        Control infoControl = this.infoPage.getControl();
        if (infoControl != null && !infoControl.isDisposed()) {
            SWTUtil.invokeOnDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    MetricsCalculator.this.infoPage.setSrcFolderCount(MetricsCalculator.this.getSourceFolderCount());
                    MetricsCalculator.this.infoPage.setPkgCount(MetricsCalculator.this.getPackageCount());
                    MetricsCalculator.this.infoPage.setClassCount(MetricsCalculator.this.getClassCount());
                    MetricsCalculator.this.infoPage.setLocCount(MetricsCalculator.this.getLinesOfCodeCount());
                    MetricsCalculator.this.infoPage.setUpdateTime(MetricsCalculator.getDateString(updateDate));
                    MetricsCalculator.this.infoPage.setMetricsRunning(false);
                }
            });
        }
        this.saveProjectProperties(updateDate);
        monitor.done();
        return StatusInfo.OK_STATUS;
    }

    private void saveProjectProperties(Date updateDate) {
        ProjectScope projectScope = new ProjectScope(this.javaProject.getProject());
        IEclipsePreferences projectNode = projectScope.getNode("com.genuitec.eclipse.core");
        if ((projectNode = this.wcManager.getWorkingCopy(projectNode)) != null) {
            projectNode.put("srcCnt", Integer.toString(this.srcFolderCnt));
            projectNode.put("pkgCnt", Integer.toString(this.pkgCnt));
            projectNode.put("clsCnt", Integer.toString(this.classCnt));
            projectNode.put("locCnt", Integer.toString(this.locCnt));
            projectNode.put("sTime", MetricsCalculator.getDateString(updateDate));
            try {
                projectNode.flush();
            }
            catch (BackingStoreException e) {
                CommonUI.getDefault().log("Could not save project metrics", e);
            }
        }
    }

    private static String getDateString(Date date) {
        return dateFormat.format(date);
    }

    public int getSourceFolderCount() {
        return this.srcFolderCnt;
    }

    public int getPackageCount() {
        return this.pkgCnt;
    }

    public int getClassCount() {
        return this.classCnt;
    }

    public int getLinesOfCodeCount() {
        return this.locCnt;
    }

    public int getTotalCharsCount() {
        return this.charCnt;
    }

    void iterateMetricSummaryTree(MetricSummary theMetricSummary) {
        this.incStatistics(theMetricSummary);
        if (!theMetricSummary.hasChildren()) {
            return;
        }
        ArrayList metricSummaries = theMetricSummary.getChildren();
        for (MetricSummary metricSummary : metricSummaries) {
            this.iterateMetricSummaryTree(metricSummary);
        }
    }

    void incStatistics(MetricSummary theMetricSummary) {
        switch (theMetricSummary.getType()) {
            case 2: {
                ++this.srcFolderCnt;
                break;
            }
            case 3: {
                IPackageFragment fragment = (IPackageFragment)theMetricSummary.getJavaElement();
                String name = fragment.getElementName();
                if (Util.isNullOrEmpty((String)name)) break;
                ++this.pkgCnt;
                break;
            }
            case 4: {
                ++this.classCnt;
                try {
                    ICompilationUnit icompUnit = (ICompilationUnit)theMetricSummary.getJavaElement();
                    this.parser.setSource(icompUnit);
                    ASTNode node = this.parser.createAST(null);
                    if (!(node instanceof CompilationUnit)) break;
                    CompilationUnit compUnit = (CompilationUnit)node;
                    int len = compUnit.getLength();
                    this.charCnt += len;
                    int loc = compUnit.getLineNumber(len - 1);
                    this.locCnt += loc;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    MetricSummary computeMetrics(IJavaProject theJavaProject) {
        MetricSummary metricSummary = new MetricSummary(theJavaProject);
        try {
            IPackageFragmentRoot[] fragmentRoots = theJavaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < fragmentRoots.length) {
                MetricSummary childMetricSummary = null;
                IPackageFragmentRoot root = fragmentRoots[i];
                if (root.getKind() == 1) {
                    childMetricSummary = this.computeMetrics(root);
                    metricSummary.addChild(childMetricSummary);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return metricSummary;
    }

    MetricSummary computeMetrics(IPackageFragmentRoot thePkgFragmentRoot) throws JavaModelException {
        MetricSummary metricSummary = new MetricSummary(thePkgFragmentRoot);
        IJavaElement[] elements = thePkgFragmentRoot.getChildren();
        int i = 0;
        while (i < elements.length) {
            MetricSummary childMetricSummary = null;
            IJavaElement element = elements[i];
            switch (element.getElementType()) {
                case 4: {
                    childMetricSummary = this.computeMetrics((IPackageFragment)element);
                    break;
                }
                case 5: {
                    childMetricSummary = this.computeMetrics((ICompilationUnit)element);
                }
            }
            if (childMetricSummary != null) {
                metricSummary.addChild(childMetricSummary);
            }
            ++i;
        }
        return metricSummary;
    }

    MetricSummary computeMetrics(IPackageFragment thePkgFragment) throws JavaModelException {
        MetricSummary metricSummary = new MetricSummary(thePkgFragment);
        IJavaElement[] elements = thePkgFragment.getChildren();
        int i = 0;
        while (i < elements.length) {
            MetricSummary childMetricSummary = null;
            IJavaElement element = elements[i];
            switch (element.getElementType()) {
                case 4: {
                    childMetricSummary = this.computeMetrics((IPackageFragment)element);
                    break;
                }
                case 5: {
                    childMetricSummary = this.computeMetrics((ICompilationUnit)element);
                }
            }
            if (childMetricSummary != null) {
                metricSummary.addChild(childMetricSummary);
            }
            ++i;
        }
        return metricSummary;
    }

    MetricSummary computeMetrics(ICompilationUnit theCompilationUnit) throws JavaModelException {
        MetricSummary metricSummary = new MetricSummary(theCompilationUnit);
        return metricSummary;
    }
}

