/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.dialog;

import com.genuitec.eclipse.core.util.PlatformUIUtil;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.part.FileEditorInput;

public class MERefactoringSaveHelper
extends RefactoringSaveHelper {
    public MERefactoringSaveHelper(int saveMode) {
        super(saveMode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveEditors(Shell shell) {
        final HashSet<IEditorPart> dirtySet = new HashSet<IEditorPart>();
        IEditorPart[] dirty = EditorUtility.getDirtyEditors((boolean)false);
        int i = 0;
        while (i < dirty.length) {
            IEditorPart part = dirty[i];
            if (part.getEditorInput() instanceof FileEditorInput) {
                dirtySet.add(part);
            }
            ++i;
        }
        if (dirtySet.isEmpty()) {
            return true;
        }
        if (!this.askSaveAllDirtyEditors(shell, dirtySet.toArray(new IEditorPart[dirtySet.size()]))) {
            return false;
        }
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription description = workspace.getDescription();
            boolean autoBuild = description.isAutoBuilding();
            description.setAutoBuilding(false);
            workspace.setDescription(description);
            try {
                IWorkbenchWindow ww = PlatformUIUtil.getActiveWorkbenchWindow();
                if (!JavaPlugin.getActiveWorkbenchWindow().getWorkbench().saveAll((IShellProvider)ww, (IRunnableContext)ww, new ISaveableFilter(){

                    public boolean select(Saveable saveable, IWorkbenchPart[] containingParts) {
                        return dirtySet.contains(containingParts[0]);
                    }
                }, false)) {
                    return false;
                }
            }
            finally {
                description.setAutoBuilding(autoBuild);
                workspace.setDescription(description);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle((CoreException)e, (Shell)shell, (String)RefactoringMessages.RefactoringStarter_saving, (String)RefactoringMessages.RefactoringStarter_unexpected_exception);
            return false;
        }
    }

    private boolean askSaveAllDirtyEditors(Shell shell, IEditorPart[] dirtyEditors) {
        ListDialog dialog = new ListDialog(shell){
            {
                this.setShellStyle(this.getShellStyle() | 0x10000);
            }

            protected Control createDialogArea(Composite parent) {
                Composite result = (Composite)super.createDialogArea(parent);
                return result;
            }
        };
        dialog.setTitle(RefactoringMessages.RefactoringStarter_save_all_resources);
        dialog.setAddCancelButton(true);
        dialog.setLabelProvider(this.createDialogLabelProvider());
        dialog.setMessage(RefactoringMessages.RefactoringStarter_must_save);
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setInput(Arrays.asList(dirtyEditors));
        return dialog.open() == 0;
    }

    private ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        };
    }
}

