/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.editors;

import com.genuitec.eclipse.core.util.EditorUtil;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.ide.FileStoreEditorInput;

public final class TemporaryFileEditorInput
extends FileStoreEditorInput {
    private static long count = 1L;
    private long instanceCount = 1L;
    private final String fileName;
    private boolean hidePath;
    private IPath fPath;

    public TemporaryFileEditorInput(IFileStore store, String fileName) {
        super(store);
        this.fileName = fileName;
        this.instanceCount = count++;
    }

    public long getInstanceCount() {
        return this.instanceCount;
    }

    public boolean exists() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return String.valueOf(this.fileName) + '.' + this.basicGetPath().getFileExtension();
    }

    public IPath getPath() {
        if (!this.hidePath) {
            return this.basicGetPath();
        }
        String property = System.getProperty("user.home");
        return new Path(property).append(this.getName());
    }

    public static IPath getPath(Object element) {
        if (element instanceof FileStoreEditorInput) {
            return new Path(((FileStoreEditorInput)element).getURI().getPath());
        }
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (o instanceof TemporaryFileEditorInput) {
            TemporaryFileEditorInput tempInput = (TemporaryFileEditorInput)((Object)o);
            return tempInput.instanceCount == this.instanceCount;
        }
        if (o instanceof FileStoreEditorInput) {
            return super.equals(o);
        }
        return false;
    }

    public IContentType getContentType() {
        return EditorUtil.getContentType(this.basicGetPath());
    }

    public void hideRealPath() {
        this.hidePath = true;
    }

    public void showRealPath() {
        this.hidePath = false;
    }

    public IPath basicGetPath() {
        if (this.fPath == null) {
            this.fPath = new Path(this.getURI().getPath());
        }
        return this.fPath;
    }

    public IFileStore getFileStore() {
        IFileStore store = null;
        try {
            store = EFS.getStore((URI)this.getURI());
        }
        catch (CoreException coreException) {}
        return store;
    }
}

