/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public final class ASTUtil {
    public static Map findProperties(IType type) throws JavaModelException {
        PropertyWorker worker = new PropertyWorker(type);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)worker);
        if (worker.getException() != null) {
            throw worker.getException();
        }
        return worker.getProperties();
    }

    private static void getTypeProperties(IType type, Map properties) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            String propertyName;
            IMethod method = methods[i];
            if (ASTUtil.isPropertySetter(method) && (propertyName = method.getElementName().substring(3)).length() > 0 && Character.isUpperCase(propertyName.charAt(0))) {
                String typeToDecode = method.getParameterTypes()[0];
                String typeString = ASTUtil.decodeType(typeToDecode, type);
                String name = String.valueOf(Character.toLowerCase(propertyName.charAt(0))) + propertyName.substring(1);
                properties.put(name, typeString);
            }
            ++i;
        }
    }

    public static String decodeType(String typeToDecode, IType type) throws JavaModelException {
        String propertyType = Signature.toString((String)typeToDecode);
        String[][] fullType = type.resolveType(propertyType);
        String typeString = fullType != null && fullType.length > 0 ? Signature.toQualifiedName((String[])fullType[0]) : propertyType;
        return typeString;
    }

    private static boolean isPropertySetter(IMethod method) throws JavaModelException {
        if (method.getElementName().startsWith("set")) {
            boolean isPublicNonStaticNonAbstract;
            boolean hasSingleArgument = method.getNumberOfParameters() == 1;
            boolean isVoid = method.getReturnType().equals("V");
            int methodFlags = method.getFlags();
            boolean bl = isPublicNonStaticNonAbstract = Flags.isPublic((int)methodFlags) && !Flags.isStatic((int)methodFlags) && !Flags.isAbstract((int)methodFlags);
            if (isVoid && hasSingleArgument && isPublicNonStaticNonAbstract) {
                return true;
            }
        }
        return false;
    }

    public static Collection findConstructorArguments(IType type) throws JavaModelException {
        LinkedList constructors = new LinkedList();
        IJavaElement[] children = type.getChildren();
        int i = 0;
        while (i < children.length) {
            IMethod method;
            IJavaElement element = children[i];
            if (element.getElementType() == 9 && (method = (IMethod)element).isConstructor() && Flags.isPublic((int)method.getFlags())) {
                ArrayList<String> args = new ArrayList<String>(method.getNumberOfParameters());
                String[] parameterTypes = method.getParameterTypes();
                int j = 0;
                while (j < parameterTypes.length) {
                    args.add(ASTUtil.decodeType(parameterTypes[j], type));
                    ++j;
                }
                constructors.add(args);
            }
            ++i;
        }
        return constructors;
    }

    public static TypeDeclaration getTypeDeclarationFromType(IType type) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        ICompilationUnit compilationUnit = type.getCompilationUnit();
        parser.setSource(compilationUnit);
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        return (TypeDeclaration)unit.types().get(0);
    }

    private static final class PropertyWorker
    implements Runnable {
        private JavaModelException exception;
        private final Map properties = new HashMap();
        private final IType type;

        public PropertyWorker(IType type) {
            this.type = type;
        }

        public JavaModelException getException() {
            return this.exception;
        }

        public Map getProperties() {
            return this.properties;
        }

        @Override
        public void run() {
            try {
                if (this.type != null && this.type.exists()) {
                    ITypeHierarchy hierarchy = this.type.newSupertypeHierarchy(null);
                    IType[] allClasses = hierarchy.getAllClasses();
                    int i = 0;
                    while (i < allClasses.length) {
                        IType superType = allClasses[i];
                        ASTUtil.getTypeProperties(superType, this.properties);
                        ++i;
                    }
                }
            }
            catch (JavaModelException e) {
                this.exception = e;
            }
        }
    }
}

