/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.facet.ui;

import com.genuitec.eclipse.j2eedt.facet.ui.FacetsConfigurationGroup;
import java.util.Set;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public abstract class FacetConfigurationControl {
    private String caption;
    private FacetsConfigurationGroup parent;
    private IDataModel model;
    private String dataModelFacetId;
    protected Label label;

    public FacetConfigurationControl(String caption, String dataModelFacetId) {
        this.caption = caption;
        this.dataModelFacetId = dataModelFacetId;
    }

    void initialize(FacetsConfigurationGroup parent, IDataModel model) {
        this.parent = parent;
        this.model = model;
    }

    protected final IDataModel getDataModel() {
        return this.model;
    }

    public String getCaption() {
        return this.caption;
    }

    public void createControl(Composite parent) {
        this.label = new Label(parent, 0);
        this.label.setText(this.getCaption());
        this.label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.createSelectionControl(parent);
    }

    protected void modified() {
        this.updateModel();
        this.parent.refreshFacetConfiguration(this);
    }

    protected void updateModel() {
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map;
        IDataModel facet;
        if (this.dataModelFacetId != null && (facet = (map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP")).getFacetDataModel(this.dataModelFacetId)) != null) {
            facet.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)this.getSelectedFacetVersion());
        }
    }

    public abstract void updateSelectionEnablement(Set<IProjectFacetVersion> var1);

    public abstract IProjectFacetVersion getSelectedFacetVersion();

    protected abstract void createSelectionControl(Composite var1);
}

