/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.facet.ui;

import com.genuitec.eclipse.j2eedt.facet.IInstallTLDsDataModelProperties;
import com.genuitec.eclipse.runtime.tld.TldManager;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.ui.ModifyFacetedProjectWizard;
import org.eclipse.wst.web.ui.internal.wizards.DataModelFacetInstallPage;
import org.eclipse.wst.web.ui.internal.wizards.NewProjectDataModelFacetWizard;

public abstract class MEDataModelFacetInstallPage
extends DataModelFacetInstallPage
implements IInstallTLDsDataModelProperties {
    private IDataModelListener facetVersionListener = null;
    private Button installTLDs;
    private IProjectFacet tldsFacet;

    public MEDataModelFacetInstallPage(String pageName) {
        super(pageName);
    }

    protected IDataModel getMainDataModel() {
        if (this.getDataModelWizard() != null) {
            return this.getDataModelWizard().getDataModel();
        }
        if (this.getWizard() instanceof NewProjectDataModelFacetWizard) {
            return ((NewProjectDataModelFacetWizard)this.getWizard()).getDataModel();
        }
        return null;
    }

    protected IFacetedProjectWorkingCopy getFacetedProjectWorkingCopy() {
        IFacetedProjectWorkingCopy fpwc = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        if (fpwc != null) {
            return fpwc;
        }
        if (this.getDataModelWizard() != null) {
            return (IFacetedProjectWorkingCopy)this.getDataModelWizard().getDataModel().getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        }
        if (this.getWizard() instanceof ModifyFacetedProjectWizard) {
            return ((ModifyFacetedProjectWizard)this.getWizard()).getFacetedProjectWorkingCopy();
        }
        return null;
    }

    protected String getInstallTLDsCaption() {
        return "Copy required TLDs to the project";
    }

    protected void createInstallTLDsGroup(Composite parent, IProjectFacet facet) {
        this.tldsFacet = facet;
        this.installTLDs = new Button(parent, 32);
        this.installTLDs.setLayoutData((Object)new GridData(4, 4, false, false, 100, 1));
        this.installTLDs.setText(this.getInstallTLDsCaption());
        this.registerFacetVersionChangeListener();
        this.refreshTLDsState();
    }

    protected void registerFacetVersionChangeListener() {
        if (this.facetVersionListener != null) {
            return;
        }
        this.facetVersionListener = new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if (event.getFlag() == 1 && event.getPropertyName().equals("IFacetDataModelPropeties.FACET_VERSION")) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            MEDataModelFacetInstallPage.this.handleFacetVersionChangedEvent();
                        }
                    };
                    if (Thread.currentThread() == Display.getDefault().getThread()) {
                        runnable.run();
                    } else {
                        Display.getDefault().asyncExec(runnable);
                    }
                }
            }
        };
        this.model.addListener(this.facetVersionListener);
        this.handleFacetVersionChangedEvent();
    }

    public void dispose() {
        if (this.facetVersionListener != null) {
            this.model.removeListener(this.facetVersionListener);
        }
        super.dispose();
    }

    private void refreshTLDsState() {
        if (this.installTLDs != null && this.getFacetedProjectWorkingCopy() != null) {
            boolean enableTlds = TldManager.hasTlds((IProjectFacetVersion)this.getFacetedProjectWorkingCopy().getProjectFacetVersion(this.tldsFacet)) && this.getFacetedProjectWorkingCopy().hasProjectFacet(IJ2EEFacetConstants.DYNAMIC_WEB_FACET);
            ((GridData)this.installTLDs.getLayoutData()).exclude = !enableTlds;
            this.installTLDs.setVisible(enableTlds);
            this.installTLDs.getShell().layout(new Control[]{this.installTLDs.getParent()});
        }
    }

    protected void handleFacetVersionChangedEvent() {
        this.refreshTLDsState();
    }

    protected void enter() {
        if (this.isFirstTimeToPage() && this.installTLDs != null) {
            this.synchHelper.synchCheckbox(this.installTLDs, "IInstallTLDsDataModelProperties.INSTALL_TLDS", null);
            this.refreshTLDsState();
        }
        super.enter();
    }
}

