/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.ui.taglib;

import com.genuitec.eclipse.j2eedt.core.Messages;
import com.genuitec.eclipse.j2eedt.ui.taglib.DefaultTLDNamespaceSettings;
import com.genuitec.eclipse.j2eedt.ui.taglib.TLDInfo;
import com.genuitec.eclipse.j2eedt.ui.taglib.TLDPrefixEntryDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DefaultTLDInfoBlock {
    private IProject project;
    private Shell shell;
    private ListDialogField listDF;

    public DefaultTLDInfoBlock(IProject theProject) {
        this.project = theProject;
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean hasProject() {
        return this.getProject() != null;
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected void setShell(Shell theShell) {
        this.shell = theShell;
    }

    public Control createContents(Composite parent, int theColumnCnt) {
        this.setShell(parent.getShell());
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, false, theColumnCnt, 1));
        this.createTable(container);
        Dialog.applyDialogFont((Control)parent);
        return container;
    }

    protected void createTable(Composite theParent) {
        Composite composite = new Composite(theParent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.listDF = new ListDialogField((IListAdapter)new ListAdapter(), new String[]{Messages.DefaultTLDInfoBlock_button_edit}, (ILabelProvider)new TableLabelProvider());
        this.listDF.setTableColumns(new ListDialogField.ColumnsDescription(new String[]{Messages.DefaultTLDInfoBlock_column_prefix, Messages.DefaultTLDInfoBlock_column_description}, true));
        this.listDF.doFillIntoGrid(composite, 3);
        this.listDF.enableButton(0, false);
        LayoutUtil.setHeightHint((Control)this.listDF.getListControl(composite), (int)400);
        LayoutUtil.setHorizontalGrabbing((Control)this.listDF.getListControl(composite));
        Control ctrl = this.listDF.getListControl(composite);
        GridData gd = (GridData)ctrl.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.listDF.setElements((Collection)this.createListElements());
    }

    public void performDefaults() {
        DefaultTLDNamespaceSettings.restoreDefaults(this.getProject());
        this.listDF.setElements((Collection)this.createListElements());
    }

    public boolean performOk(boolean enabled) {
        List listElements = this.listDF.getElements();
        for (ListElement listElement : listElements) {
            DefaultTLDNamespaceSettings.setDefaultTLDURIForNamespace(this.getProject(), listElement.tldInfo.uri, listElement.prefix);
        }
        DefaultTLDNamespaceSettings.save(this.getProject());
        this.listDF.refresh();
        return true;
    }

    private ArrayList createListElements() {
        ArrayList<ListElement> listElements = new ArrayList<ListElement>();
        TLDInfo[] tldInfos = TLDInfo.TLDS;
        int i = 0;
        while (i < tldInfos.length) {
            TLDInfo tldInfo = tldInfos[i];
            String prefix = DefaultTLDNamespaceSettings.getDefaultNamespaceForTLDURI(this.getProject(), tldInfo.uri, this.hasProject());
            if (prefix != null) {
                ListElement element = new ListElement(prefix, tldInfo);
                listElements.add(element);
            }
            ++i;
        }
        return listElements;
    }

    protected boolean edit(ListElement theElement) {
        boolean result = false;
        TLDPrefixEntryDialog dialog = new TLDPrefixEntryDialog(this.getShell(), theElement.prefix, theElement.tldInfo);
        int dialogResult = dialog.open();
        if (dialogResult == 0) {
            theElement.tldInfo = dialog.getTLDInfo();
            theElement.prefix = dialog.getPrefix();
            this.listDF.refresh();
            result = true;
        }
        return result;
    }

    private class ListAdapter
    implements IListAdapter {
        private ListAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            this.doubleClicked(field);
        }

        public void selectionChanged(ListDialogField field) {
            List selectedElements = field.getSelectedElements();
            field.enableButton(0, selectedElements.size() == 1);
        }

        public void doubleClicked(ListDialogField field) {
            List selectedElements = field.getSelectedElements();
            if (selectedElements.size() != 1) {
                return;
            }
            ListElement listElement = (ListElement)selectedElements.get(0);
            if (DefaultTLDInfoBlock.this.edit(listElement)) {
                field.refresh();
            }
        }
    }

    private class ListElement {
        public String prefix;
        public TLDInfo tldInfo;

        ListElement(String thePrefix, TLDInfo theTldInfo) {
            this.prefix = thePrefix;
            this.tldInfo = theTldInfo;
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            ListElement listElement = (ListElement)element;
            switch (columnIndex) {
                case 0: {
                    result = listElement.prefix;
                    break;
                }
                case 1: {
                    result = listElement.tldInfo.description;
                }
            }
            return result;
        }
    }
}

