/*
 * Copyright (c) 2015, 2018, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2.0, as
 * published by the Free Software Foundation.
 *
 * This program is also distributed with certain software (including
 * but not limited to OpenSSL) that is licensed under separate terms,
 * as designated in a particular file or component or in included license
 * documentation.  The authors of MySQL hereby grant you an
 * additional permission to link the program and your derivative works
 * with the separately licensed software that they have included with
 * MySQL.
 *
 * Without limiting anything contained in the foregoing, this file,
 * which is part of MySQL Connector/Node.js, is also subject to the
 * Universal FOSS Exception, version 1.0, a copy of which can be found at
 * http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

'use strict';

const BaseHandler = require('./BaseHandler');
const ServerMessages = require('../Protobuf/Stubs/mysqlx_pb').ServerMessages;
const Session = require('../Protobuf/Adapters/Session');
const util = require('util');

function AuthenticationHandler (auth, protocol) {
    BaseHandler.call(this);
    this._auth = auth;
    this._client = protocol;
}

util.inherits(AuthenticationHandler, BaseHandler);

AuthenticationHandler.prototype[ServerMessages.Type.SESS_AUTHENTICATE_CONTINUE] = function (payload, queueDone) {
    const stuff = Session.decodeAuthenticateContinue(payload);

    /* eslint-disable node/no-deprecated-api */
    const data = new Buffer(stuff.authData, 'base64');
    /* eslint-enable node/no-deprecated-api */

    try {
        this._client.authenticateContinue(this._auth.getNextAuthData(data), this);
    } catch (err) {
        queueDone();
        this._fail(err);
    }
};

AuthenticationHandler.prototype[ServerMessages.Type.SESS_AUTHENTICATE_OK] = function (payload, queueDone) {
    queueDone();
    this._resolve();
};

module.exports = AuthenticationHandler;
