'use strict';

/* eslint-env node, mocha */

// npm `test` script was updated to use NODE_PATH=.
const expect = require('chai').expect;
const result = require('lib/DevAPI/Result');

describe('Result', () => {
    context('getAffectedItemsCount()', () => {
        it('should return the same result as getAffectedRowsCount()', () => {
            const res = result({ rowsAffected: 3 });

            expect(res.getAffectedItemsCount()).to.equal(res.getAffectedRowsCount());
        });
    });

    context('getAffectedRowsCount()', () => {
        it('should return the number of rows affected by an operation', () => {
            expect(result({ rowsAffected: 3 }).getAffectedRowsCount()).to.equal(3);
        });
    });

    context('getAutoIncrementValue()', () => {
        it('should return the first value generated by "AUTO INCREMENT" for a given operation', () => {
            expect(result({ generatedInsertId: 1 }).getAutoIncrementValue()).to.equal(1);
        });
    });

    context('getGeneratedIds()', () => {
        it('should return the list of document ids generated by the server for a given operation', () => {
            const generatedDocumentIds = ['foo', 'bar'];

            expect(result({ generatedDocumentIds }).getGeneratedIds()).to.deep.equal(generatedDocumentIds);
        });
    });

    context('getWarnings()', () => {
        it('should return the list of warnings generated by the server for a given operation', () => {
            const warnings = ['foo', 'bar'];

            expect(result({ warnings }).getWarnings()).to.deep.equal(warnings);
        });
    });

    context('getWarningsCount()', () => {
        it('should return the number of warnings generated by the server for a given operation', () => {
            const warnings = ['foo', 'bar', 'baz'];

            expect(result({ warnings }).getWarningsCount()).to.deep.equal(3);
        });
    });
});
