/***************************************************************************
                          askcontinuenewt.cpp  -  description
                             -------------------
    begin                : Thu May 9 2002
    copyright            : (C) 2002 by Argo Vessmann (ARTEC Design)
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "askcontinuenewt.h"
#include "newt.h"

#include <qstring.h>
#include <iostream.h>

#include "../config.h"

AskContinueNewt::AskContinueNewt()
{
	newtInit();
	newtCls();
}

AskContinueNewt::~AskContinueNewt()
{
	newtCls();
	newtFinished();
}

int AskContinueNewt::exec()
{
	QString str;

	char message[] = "Graphical environment cannot be connected to.\n\n"
		"Possible reason: You have su-d to root, and don't have enough "
		"permission to write on display\n"
		"\nSolution: Open new terminal window. Give command "
		"'xhost +' and close the new terminal window. "
		"Then rerun the application as super user. After NetMos has "
		"been configured, you can give command 'xhost -' to disable "
		"everyone's access to display.\n\n"
		"Press \"Continue\" to run this application in text mode.";

	str.sprintf( "Version %s", VERSION );
	newtDrawRootText( -str.length(), 0, (const char *)str );

	int maxcols, maxrows;

	newtGetScreenSize( &maxcols, &maxrows );
	int mwsize = maxcols-16;
	newtCenteredWindow( mwsize, maxrows-5, "X11 or console" );

	newtComponent myForm;

	myForm = newtForm( NULL, NULL, NEWT_FLAG_NOF12 );

	newtComponent b1, b2, te;

	int tmps = (mwsize-23)/3;
	b1 = newtButton( tmps, maxrows-10, "Continue" );
	b2 = newtButton( tmps*3, maxrows-10, "Cancel" );
	te = newtTextbox( 1, 1, mwsize-4, maxrows-12, NEWT_FLAG_WRAP|NEWT_FLAG_SCROLL );
	newtTextboxSetText( te, message );

	newtFormAddComponents( myForm, te, b1, b2, NULL );

//	newtFormSetCurrent( myForm, b2 );
	newtComponent tmp = newtRunForm( myForm );
	int retval = 1;
	if ( tmp == b2 )
		retval = 0;
	newtFormDestroy( myForm );
	return( retval );
}
